/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.startstoprules.defaultplugin;

import com.biglybt.core.config.COConfigurationListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManagerStateAttributeListener;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagFeatureProperties;
import com.biglybt.core.tag.TagFeatureRateLimit;
import com.biglybt.core.tag.TagListener;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagTypeAdapter;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.LightHashSet;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.average.Average;
import com.biglybt.core.util.average.AverageFactory;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginConfig;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginListener;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadActivationEvent;
import com.biglybt.pif.download.DownloadActivationListener;
import com.biglybt.pif.download.DownloadAnnounceResult;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.download.DownloadListener;
import com.biglybt.pif.download.DownloadManager;
import com.biglybt.pif.download.DownloadManagerListener;
import com.biglybt.pif.download.DownloadManagerStats;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.download.DownloadTrackerListener;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIManagerListener;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.pif.ui.tables.TableManager;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.startstoprules.defaultplugin.DefaultRankCalculator;
import com.biglybt.plugin.startstoprules.defaultplugin.DownloadingRankColumnListener;
import com.biglybt.plugin.startstoprules.defaultplugin.RankCalculatorReal;
import com.biglybt.plugin.startstoprules.defaultplugin.RankCalculatorSlotReserver;
import com.biglybt.plugin.startstoprules.defaultplugin.SeedingRankColumnListener;
import com.biglybt.plugin.startstoprules.defaultplugin.StartStopConfigModel;
import com.biglybt.plugin.startstoprules.defaultplugin.StartStopRulesFPListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StartStopRulesDefaultPlugin
implements Plugin,
COConfigurationListener,
AEDiagnosticsEvidenceGenerator {
    private static final String sStates = " WPRDS.XEQ";
    public static final int RANK_NONE = 0;
    public static final int RANK_SPRATIO = 1;
    public static final int RANK_SEEDCOUNT = 2;
    public static final int RANK_TIMED = 3;
    public static final int RANK_PEERCOUNT = 4;
    private static final int FORCE_CHECK_PERIOD = 60000;
    private static final int CHECK_FOR_GROSS_CHANGE_PERIOD = 30000;
    private static final int PROCESS_CHECK_PERIOD = 1500;
    private static final int MIN_SEEDING_STARTUP_WAIT = 20000;
    private static final int MIN_FIRST_SCRAPE_WAIT = 90000;
    private static final float IGNORE_SLOT_THRESHOLD_FACTOR = 0.9f;
    private static final int MIN_DOWNLOADING_STARTUP_WAIT = 30000;
    private static final int SMOOTHING_PERIOD_SECS = 15;
    private static final int SMOOTHING_PERIOD = 15000;
    private TagManager tag_manager;
    private volatile boolean tagsHaveDLorCDLimits;
    private Average globalDownloadSpeedAverage = AverageFactory.MovingImmediateAverage(10);
    private AEMonitor this_mon = new AEMonitor("StartStopRules");
    private PluginInterface pi;
    protected PluginConfig plugin_config;
    private DownloadManager download_manager;
    protected LoggerChannel log;
    private final boolean ENABLE_DLOG = false;
    protected LoggerChannel dlog;
    private RecalcSeedingRanksTask recalcSeedingRanksTask;
    private static Map<Object, DefaultRankCalculator> rankCalculatorMap = Collections.synchronizedMap(new HashMap());
    private volatile DefaultRankCalculator[] sortedArrayCache;
    private volatile boolean closingDown;
    private volatile boolean somethingChanged;
    private Set<DefaultRankCalculator> ranksToRecalc = new LightHashSet();
    private AEMonitor ranksToRecalc_mon = new AEMonitor("ranksToRecalc");
    private long monoStartedOn;
    protected boolean bDebugLog;
    private int iRankType = -1;
    private int minSpeedForActiveSeeding;
    private int maxStalledSeeding;
    private int maxOverLimitSeeding;
    private boolean stalledSeedingIgnoreZP;
    private int _maxActive;
    private boolean _maxActiveWhenSeedingEnabled;
    private int _maxActiveWhenSeeding;
    private int globalDownloadLimit;
    private int globalUploadLimit;
    private int globalUploadWhenSeedingLimit;
    private int maxConfiguredDownloads;
    private boolean bMaxDownloadIgnoreChecking;
    private int minDownloads;
    private boolean bAutoReposition;
    private long minTimeAlive;
    private boolean bAutoStart0Peers;
    private boolean bStopOnceBandwidthMet = false;
    private boolean bStartNoMoreSeedsWhenUpLimitMet = false;
    private boolean bStartNoMoreSeedsWhenUpLimitMetPercent = true;
    private int bStartNoMoreSeedsWhenUpLimitMetSlack = 95;
    private int iDownloadSortType;
    private int iDownloadTestTimeMillis;
    private int iDownloadReTestMillis;
    private boolean bDownloadTestActive;
    private boolean bTagFirstPriority;
    private static boolean bAlreadyInitialized = false;
    private TableContextMenuItem debugMenuItem = null;
    private UIAdapter swt_ui;
    private CopyOnWriteList listenersFP = new CopyOnWriteList();
    public static boolean pauseChangeFlagChecker = false;
    private Tag fp_tag;
    private volatile int numReservedSeedingSlots = 0;
    private LinkedList<RankCalculatorSlotReserver> reservedSlots = new LinkedList();
    private Set<DefaultRankCalculator> reservedSlotsAllocated = new IdentityHashSet<DefaultRankCalculator>();
    private String slotStatus = "";
    private volatile boolean immediateProcessingScheduled = false;
    private long changeCheckCount = 0L;
    private long changeCheckTotalMS = 0L;
    private long changeCheckMaxMS = 0L;
    private long processCount = 0L;
    private long processTotalMS = 0L;
    private long processMaxMS = 0L;
    private long processLastComplete = 0L;
    private long processTotalGap = 0L;
    private long processTotalRecalcs = 0L;
    private long processTotalZeroRecalcs = 0L;
    private DefaultRankCalculator dlr_current_active;
    private long dlr_max_rate_time;
    private long processMergeCount = 0L;

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", "Start/Stop Rules");
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        if (bAlreadyInitialized) {
            System.err.println("StartStopRulesDefaultPlugin Already initialized!!");
        } else {
            bAlreadyInitialized = true;
        }
        AEDiagnostics.addWeakEvidenceGenerator(this);
        this.monoStartedOn = SystemTime.getMonotonousTime();
        this.pi = _plugin_interface;
        this.plugin_config = this.pi.getPluginconfig();
        this.plugin_config.setPluginConfigKeyPrefix("");
        this.download_manager = this.pi.getDownloadManager();
        this.tag_manager = TagManagerFactory.getTagManager();
        if (this.tag_manager != null && this.tag_manager.isEnabled()) {
            final IdentityHashMap tags_with_limit = new IdentityHashMap();
            TagType tt = this.tag_manager.getTagType(3);
            final TagListener tag_listener = new TagListener(){

                @Override
                public void taggableAdded(Tag tag, Taggable tagged) {
                    StartStopRulesDefaultPlugin.this.requestProcessCycle(null);
                }

                @Override
                public void taggableSync(Tag tag) {
                }

                @Override
                public void taggableRemoved(Tag tag, Taggable tagged) {
                    StartStopRulesDefaultPlugin.this.requestProcessCycle(null);
                }
            };
            tt.addTagTypeListener(new TagTypeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void tagAdded(Tag tag) {
                    TagFeatureRateLimit t;
                    int max;
                    if (tag instanceof TagFeatureRateLimit && (max = (t = (TagFeatureRateLimit)((Object)tag)).getMaxActiveDownloads() + t.getMaxActiveSeeds()) > 0) {
                        Map map = tags_with_limit;
                        synchronized (map) {
                            tags_with_limit.put(t, max);
                            tag.addTagListener(tag_listener, false);
                            StartStopRulesDefaultPlugin.this.tagsHaveDLorCDLimits = true;
                        }
                        StartStopRulesDefaultPlugin.this.requestProcessCycle(null);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void tagChanged(Tag tag) {
                    if (tag instanceof TagFeatureRateLimit) {
                        TagFeatureRateLimit t = (TagFeatureRateLimit)((Object)tag);
                        int max = t.getMaxActiveDownloads() + t.getMaxActiveSeeds();
                        if (max > 0) {
                            boolean changed = false;
                            Map map = tags_with_limit;
                            synchronized (map) {
                                Integer old = (Integer)tags_with_limit.get(t);
                                if (old == null) {
                                    tags_with_limit.put(t, max);
                                    tag.addTagListener(tag_listener, false);
                                    StartStopRulesDefaultPlugin.this.tagsHaveDLorCDLimits = true;
                                } else if (old != max) {
                                    tags_with_limit.put(t, max);
                                }
                            }
                            if (changed) {
                                StartStopRulesDefaultPlugin.this.requestProcessCycle(null);
                            }
                        } else {
                            boolean removed = false;
                            Map map = tags_with_limit;
                            synchronized (map) {
                                if (tags_with_limit.remove(t) != null) {
                                    tag.removeTagListener(tag_listener);
                                    if (tags_with_limit.isEmpty()) {
                                        StartStopRulesDefaultPlugin.this.tagsHaveDLorCDLimits = false;
                                    }
                                    removed = true;
                                }
                            }
                            if (removed) {
                                StartStopRulesDefaultPlugin.this.requestProcessCycle(null);
                            }
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void tagRemoved(Tag tag) {
                    if (tag instanceof TagFeatureRateLimit) {
                        boolean removed = false;
                        Map map = tags_with_limit;
                        synchronized (map) {
                            if (tags_with_limit.remove((TagFeatureRateLimit)((Object)tag)) != null) {
                                tag.removeTagListener(tag_listener);
                                if (tags_with_limit.isEmpty()) {
                                    StartStopRulesDefaultPlugin.this.tagsHaveDLorCDLimits = false;
                                }
                                removed = true;
                            }
                        }
                        if (removed) {
                            StartStopRulesDefaultPlugin.this.requestProcessCycle(null);
                        }
                    }
                }
            }, true);
        }
        new StartStopConfigModel(this.pi);
        this.pi.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
            }

            @Override
            public void closedownInitiated() {
                StartStopRulesDefaultPlugin.this.closingDown = true;
                COConfigurationManager.removeListener(StartStopRulesDefaultPlugin.this);
            }

            @Override
            public void closedownComplete() {
            }
        });
        Runnable r = new Runnable(){

            @Override
            public void run() {
                StartStopRulesDefaultPlugin.this.download_manager.addListener(new StartStopDMListener());
                SimpleTimer.addPeriodicEvent("StartStop:gross", 30000L, new ChangeCheckerTimerTask());
                SimpleTimer.addPeriodicEvent("StartStop:check", 1500L, new ChangeFlagCheckerTask());
            }
        };
        this.pi.getUtilities().createDelayedTask(r).queue();
        this.log = this.pi.getLogger().getTimeStampedChannel("StartStopRules");
        this.log.log(1, "Default StartStopRules Plugin Initialisation");
        COConfigurationManager.addListener(this);
        try {
            this.pi.getUIManager().createLoggingViewModel(this.log, true);
            this.pi.getUIManager().addUIListener(new UIManagerListener(){

                @Override
                public void UIAttached(UIInstance instance) {
                    String[] tables2;
                    String[] tables1;
                    TableManager tm = StartStopRulesDefaultPlugin.this.pi.getUIManager().getTableManager();
                    String[] stringArray = tables1 = new String[]{"MySeeders", "MyLibrary.small"};
                    int n = tables1.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String table = stringArray[n2];
                        TableColumn seedingRankColumn = tm.createColumn(table, "SeedingRank");
                        seedingRankColumn.initialize(2, -2, 80, -2);
                        SeedingRankColumnListener columnListener = new SeedingRankColumnListener();
                        seedingRankColumn.addCellRefreshListener(columnListener);
                        tm.addColumn(seedingRankColumn);
                        ++n2;
                    }
                    String[] stringArray2 = tables2 = new String[]{"MyTorrents", "MyLibrary.small"};
                    int n3 = tables2.length;
                    n = 0;
                    while (n < n3) {
                        String table = stringArray2[n];
                        TableColumn downloadingRankColumn = tm.createColumn(table, "DownloadingRank");
                        downloadingRankColumn.setMinimumRequiredUserMode(1);
                        downloadingRankColumn.initialize(2, -1, 80, -2);
                        DownloadingRankColumnListener columnListener = new DownloadingRankColumnListener(StartStopRulesDefaultPlugin.this);
                        downloadingRankColumn.addCellRefreshListener(columnListener);
                        tm.addColumn(downloadingRankColumn);
                        ++n;
                    }
                    if (instance.getUIType().equals("swt")) {
                        try {
                            StartStopRulesDefaultPlugin.this.swt_ui = (UIAdapter)Class.forName("com.biglybt.plugin.startstoprules.defaultplugin.ui.swt.StartStopRulesDefaultPluginSWTUI").newInstance();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }

                @Override
                public void UIDetached(UIInstance instance) {
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        this.reloadConfigParams();
    }

    public static DefaultRankCalculator getRankCalculator(Download dl) {
        return rankCalculatorMap.get(dl);
    }

    public TagManager getTagManager() {
        return this.tag_manager;
    }

    public boolean hasTagDLorCDLimits() {
        return this.tagsHaveDLorCDLimits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalcAllSeedingRanks() {
        if (this.closingDown) {
            return;
        }
        try {
            DefaultRankCalculator[] dlDataArray;
            this.this_mon.enter();
            Map<Object, DefaultRankCalculator> map = rankCalculatorMap;
            synchronized (map) {
                dlDataArray = rankCalculatorMap.values().toArray(new DefaultRankCalculator[0]);
            }
            int i = 0;
            while (i < dlDataArray.length) {
                dlDataArray[i].recalcSeedingRank();
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void configurationSaved() {
        new AEThread2("reloadConfigParams", true){

            @Override
            public void run() {
                StartStopRulesDefaultPlugin.this.reloadConfigParams();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadConfigParams() {
        block42: {
            try {
                Map<Object, DefaultRankCalculator> map;
                Object slot;
                TagManager tag_manager;
                this.this_mon.enter();
                int iNewRankType = this.plugin_config.getUnsafeIntParameter("StartStopManager_iRankType");
                this.minSpeedForActiveSeeding = this.plugin_config.getUnsafeIntParameter("StartStopManager_iMinSpeedForActiveSeeding");
                if (this.minSpeedForActiveSeeding == 0) {
                    this.maxStalledSeeding = 0;
                    this.stalledSeedingIgnoreZP = false;
                } else {
                    this.maxStalledSeeding = this.plugin_config.getUnsafeIntParameter("StartStopManager_iMaxStalledSeeding");
                    if (this.maxStalledSeeding <= 0) {
                        this.maxStalledSeeding = 999;
                    }
                    this.stalledSeedingIgnoreZP = this.plugin_config.getUnsafeBooleanParameter("StartStopManager_bMaxStalledSeedingIgnoreZP");
                }
                this._maxActive = this.plugin_config.getUnsafeIntParameter("max active torrents");
                this._maxActiveWhenSeedingEnabled = this.plugin_config.getUnsafeBooleanParameter("StartStopManager_bMaxActiveTorrentsWhenSeedingEnabled");
                this._maxActiveWhenSeeding = this.plugin_config.getUnsafeIntParameter("StartStopManager_iMaxActiveTorrentsWhenSeeding");
                this.maxConfiguredDownloads = this.plugin_config.getUnsafeIntParameter("max downloads");
                boolean min_eq_max = this.plugin_config.getUnsafeBooleanParameter("StartStopManager_bMaxMinDLLinked");
                this.minDownloads = min_eq_max ? this.maxConfiguredDownloads : this.plugin_config.getUnsafeIntParameter("min downloads");
                this.bMaxDownloadIgnoreChecking = this.plugin_config.getUnsafeBooleanParameter("StartStopManager_bMaxDownloadIgnoreChecking");
                this.bAutoReposition = this.plugin_config.getUnsafeBooleanParameter("StartStopManager_bAutoReposition");
                this.minTimeAlive = this.plugin_config.getUnsafeIntParameter("StartStopManager_iMinSeedingTime") * 1000;
                this.bDebugLog = this.plugin_config.getUnsafeBooleanParameter("StartStopManager_bDebugLog");
                this.bAutoStart0Peers = this.plugin_config.getUnsafeBooleanParameter("StartStopManager_bAutoStart0Peers");
                this.globalDownloadLimit = this.plugin_config.getUnsafeIntParameter("Max Download Speed KBs", 0);
                this.globalUploadLimit = this.plugin_config.getUnsafeIntParameter("Max Upload Speed KBs", 0);
                this.globalUploadWhenSeedingLimit = this.plugin_config.getUnsafeBooleanParameter("enable.seedingonly.upload.rate") ? this.plugin_config.getUnsafeIntParameter("Max Upload Speed Seeding KBs", 0) : this.globalUploadLimit;
                this.bStopOnceBandwidthMet = this.plugin_config.getUnsafeBooleanParameter("StartStopManager_bStopOnceBandwidthMet");
                this.bStartNoMoreSeedsWhenUpLimitMet = this.plugin_config.getUnsafeBooleanParameter("StartStopManager_bStartNoMoreSeedsWhenUpLimitMet");
                this.bStartNoMoreSeedsWhenUpLimitMetPercent = this.plugin_config.getUnsafeBooleanParameter("StartStopManager_bStartNoMoreSeedsWhenUpLimitMetPercent");
                this.bStartNoMoreSeedsWhenUpLimitMetSlack = this.plugin_config.getUnsafeIntParameter("StartStopManager_bStartNoMoreSeedsWhenUpLimitMetSlack");
                boolean move_top = this.plugin_config.getUnsafeBooleanParameter("StartStopManager_bNewSeedsMoveTop");
                this.plugin_config.setCoreBooleanParameter("Newly Seeding Torrents Get First Priority", move_top);
                if (iNewRankType != this.iRankType) {
                    this.iRankType = iNewRankType;
                    if (this.iRankType == 3) {
                        if (this.recalcSeedingRanksTask == null) {
                            this.recalcAllSeedingRanks();
                            this.recalcSeedingRanksTask = new RecalcSeedingRanksTask();
                            SimpleTimer.addPeriodicEvent("StartStop:recalcSR", 1000L, this.recalcSeedingRanksTask);
                        }
                    } else if (this.recalcSeedingRanksTask != null) {
                        this.recalcSeedingRanksTask.cancel();
                        this.recalcSeedingRanksTask = null;
                    }
                }
                this.iDownloadSortType = this.plugin_config.getUnsafeIntParameter("StartStopManager_Downloading_iSortType", -1);
                if (this.iDownloadSortType == -1) {
                    boolean bDownloadAutoReposition = this.plugin_config.getUnsafeBooleanParameter("StartStopManager_Downloading_bAutoReposition");
                    this.iDownloadSortType = bDownloadAutoReposition ? 2 : 0;
                    this.plugin_config.setCoreIntParameter("StartStopManager_Downloading_iSortType", this.iDownloadSortType);
                }
                this.iDownloadTestTimeMillis = this.plugin_config.getUnsafeIntParameter("StartStopManager_Downloading_iTestTimeSecs") * 1000;
                this.iDownloadReTestMillis = this.plugin_config.getUnsafeIntParameter("StartStopManager_Downloading_iRetestTimeMins") * 60 * 1000;
                this.bDownloadTestActive = this.plugin_config.getUnsafeBooleanParameter("StartStopManager_Downloading_bTestActive");
                this.bTagFirstPriority = this.plugin_config.getUnsafeBooleanParameter("StartStopManager_bTagFirstPriority");
                if (this.bTagFirstPriority && (tag_manager = TagManagerFactory.getTagManager()) != null && tag_manager.isEnabled()) {
                    Tag not_fp_tag;
                    TagType tt = tag_manager.getTagType(3);
                    if (this.fp_tag == null) {
                        this.fp_tag = tt.getTag("First Priority", true);
                        if (this.fp_tag == null) {
                            try {
                                this.fp_tag = tt.createTag("First Priority", true);
                                this.fp_tag.setPublic(false);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                    if ((not_fp_tag = tt.getTag("Not First Priority", true)) == null) {
                        try {
                            not_fp_tag = tt.createTag("Not First Priority", true);
                            not_fp_tag.setPublic(false);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    if (not_fp_tag != null) {
                        TagFeatureProperties.TagProperty constraint = ((TagFeatureProperties)((Object)not_fp_tag)).getProperty("constraint");
                        constraint.setStringList(new String[]{"isComplete() && !hasTag( \"First Priority\" )"});
                    }
                }
                this.maxOverLimitSeeding = this.plugin_config.getUnsafeIntParameter("Flexible Seed Slots");
                int numslots = this.plugin_config.getUnsafeIntParameter("Light Seed Slots Reserved");
                int diff = numslots - this.numReservedSeedingSlots;
                this.numReservedSeedingSlots = numslots;
                if (diff > 0) {
                    int i = 0;
                    while (i < diff) {
                        slot = new RankCalculatorSlotReserver();
                        this.reservedSlots.add((RankCalculatorSlotReserver)slot);
                        map = rankCalculatorMap;
                        synchronized (map) {
                            rankCalculatorMap.put(slot, (DefaultRankCalculator)slot);
                            this.sortedArrayCache = null;
                        }
                        ++i;
                    }
                } else if (diff < 0) {
                    int i = -diff;
                    while (i > 0 && !this.reservedSlots.isEmpty()) {
                        slot = this.reservedSlots.removeFirst();
                        map = rankCalculatorMap;
                        synchronized (map) {
                            rankCalculatorMap.remove(slot);
                            this.sortedArrayCache = null;
                        }
                        --i;
                    }
                }
                Collection<DefaultRankCalculator> allDownloads = rankCalculatorMap.values();
                try {
                    this.ranksToRecalc_mon.enter();
                    slot = rankCalculatorMap;
                    synchronized (slot) {
                        this.ranksToRecalc.addAll(allDownloads);
                    }
                }
                finally {
                    this.ranksToRecalc_mon.exit();
                }
                this.requestProcessCycle(null);
                if (!this.bDebugLog) break block42;
                this.log.log(1, "somethingChanged: config reload");
                try {
                    if (this.debugMenuItem == null) {
                        String DEBUG_MENU_ID = "StartStopRules.menu.viewDebug";
                        MenuItemListener menuListener = new MenuItemListener(){

                            @Override
                            public void selected(MenuItem menu, Object target) {
                                if (!(target instanceof TableRow)) {
                                    return;
                                }
                                TableRow tr = (TableRow)target;
                                Object ds = tr.getDataSource();
                                if (!(ds instanceof Download)) {
                                    return;
                                }
                                DefaultRankCalculator dlData = (DefaultRankCalculator)rankCalculatorMap.get(ds);
                                if (dlData != null) {
                                    if (StartStopRulesDefaultPlugin.this.swt_ui != null) {
                                        StartStopRulesDefaultPlugin.this.swt_ui.openDebugWindow(dlData);
                                    } else {
                                        StartStopRulesDefaultPlugin.this.pi.getUIManager().showTextMessage(null, null, "FP:\n" + dlData.getExplainFP() + "\n" + "SR:" + dlData.getExplainSR() + "\n" + "TRACE:\n" + dlData.getTrace());
                                    }
                                }
                            }
                        };
                        TableManager tm = this.pi.getUIManager().getTableManager();
                        this.debugMenuItem = tm.addContextMenuItem("MySeeders", "StartStopRules.menu.viewDebug");
                        this.debugMenuItem.setHeaderCategory("Control");
                        this.debugMenuItem.addListener(menuListener);
                        this.debugMenuItem = tm.addContextMenuItem("MyTorrents", "StartStopRules.menu.viewDebug");
                        this.debugMenuItem.setHeaderCategory("Control");
                        this.debugMenuItem.addListener(menuListener);
                    }
                }
                catch (Throwable t) {
                    Debug.printStackTrace(t);
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    private int calcMaxSeeders(int iDLs) {
        int maxActive = this.getMaxActive();
        if (maxActive == 0) {
            return 999999;
        }
        return maxActive - iDLs + this.numReservedSeedingSlots;
    }

    protected int getMaxActive() {
        if (!this._maxActiveWhenSeedingEnabled) {
            return this._maxActive;
        }
        if (this.download_manager.isSeedingOnly()) {
            if (this._maxActiveWhenSeeding <= this._maxActive) {
                return this._maxActiveWhenSeeding;
            }
            Download[] downloads = this.download_manager.getDownloads();
            boolean danger = false;
            int i = 0;
            while (i < downloads.length && !danger) {
                Download download = downloads[i];
                int state = download.getState();
                if (state != 4 && state != 5 && state != 7 && state != 6 && state != 8) {
                    DiskManagerFileInfo[] files = download.getDiskManagerFileInfo();
                    int j = 0;
                    while (j < files.length) {
                        DiskManagerFileInfo file = files[j];
                        if (!file.isSkipped() && file.getDownloaded() != file.getLength()) {
                            danger = true;
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (!danger) {
                return this._maxActiveWhenSeeding;
            }
        }
        return this._maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void process() {
        long now = 0L;
        try {
            Object[] dlDataArray;
            Object s;
            Object[] recalcArray;
            this.this_mon.enter();
            now = SystemTime.getCurrentTime();
            this.somethingChanged = false;
            try {
                this.ranksToRecalc_mon.enter();
                recalcArray = this.ranksToRecalc.toArray();
                this.ranksToRecalc.clear();
            }
            finally {
                this.ranksToRecalc_mon.exit();
            }
            int i = 0;
            while (i < recalcArray.length) {
                DefaultRankCalculator rankObj = (DefaultRankCalculator)recalcArray[i];
                if (this.bDebugLog) {
                    long oldSR = rankObj.getSeedingRank();
                    rankObj.recalcSeedingRank();
                    s = "recalc seeding rank.  old/new=" + oldSR + "/" + rankObj.getSeedingRank();
                    this.log.log(rankObj.getRelatedTo(), 1, (String)s);
                } else {
                    rankObj.recalcSeedingRank();
                }
                ++i;
            }
            this.processTotalRecalcs += (long)recalcArray.length;
            if (recalcArray.length == 0) {
                ++this.processTotalZeroRecalcs;
            }
            Iterator<DefaultRankCalculator> it = this.reservedSlotsAllocated.iterator();
            while (it.hasNext()) {
                DefaultRankCalculator dlData = it.next();
                int state = dlData.getState();
                if (state == 5 || state == 2 || state == 3 || state == 1) continue;
                RankCalculatorSlotReserver reservedSlot = dlData.getReservedSlot();
                if (reservedSlot != null) {
                    dlData.setReservedSlot(null);
                    it.remove();
                    if (this.reservedSlots.size() + this.reservedSlotsAllocated.size() < this.numReservedSeedingSlots) {
                        this.reservedSlots.add(reservedSlot);
                        continue;
                    }
                    s = rankCalculatorMap;
                    synchronized (s) {
                        rankCalculatorMap.remove(reservedSlot);
                        this.sortedArrayCache = null;
                        continue;
                    }
                }
                Debug.out("eh?");
            }
            Map<Object, DefaultRankCalculator> state = rankCalculatorMap;
            synchronized (state) {
                dlDataArray = this.sortedArrayCache;
                if (dlDataArray == null) {
                    this.sortedArrayCache = rankCalculatorMap.values().toArray(new DefaultRankCalculator[rankCalculatorMap.size()]);
                    dlDataArray = this.sortedArrayCache;
                }
            }
            TotalsStats totals = new TotalsStats((DefaultRankCalculator[])dlDataArray);
            String[] mainDebugEntries = null;
            if (this.bDebugLog) {
                this.log.log(1, ">>process()");
                mainDebugEntries = new String[]{"ok2Start=" + this.boolDebug(totals.bOkToStartSeeding), "tFrcdCding=" + totals.forcedSeeding, "actvCDs=" + totals.activelyCDing, "tW8tingToCd=" + totals.waitingToSeed, "tDLing=" + totals.downloading, "actvDLs=" + totals.activelyDLing, "tW8tingToDL=" + totals.waitingToDL, "tCom=" + totals.complete, "tIncQd=" + totals.incompleteQueued, "mxCdrs=" + totals.maxSeeders, "tFP=" + totals.firstPriority, "maxT=" + totals.maxTorrents, "maxA=" + totals.maxActive};
            }
            int i2 = 0;
            while (i2 < 10) {
                try {
                    Arrays.sort(dlDataArray);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ++i2;
                }
            }
            ProcessVars vars = new ProcessVars();
            ProcessVarsComplete cvars = vars.comp;
            IdentityHashMap<TagFeatureRateLimit, Object> tvarsIncompleteMap = new IdentityHashMap<TagFeatureRateLimit, Object>();
            IdentityHashMap<TagFeatureRateLimit, Object> tvarsCompleteMap = new IdentityHashMap<TagFeatureRateLimit, Object>();
            cvars.numWaitingOrSeeding = totals.forcedSeeding;
            int posComplete = 0;
            ArrayList<DefaultRankCalculator> incompleteDownloads = new ArrayList<DefaultRankCalculator>(dlDataArray.length);
            ArrayList<Object> completeDownloads = new ArrayList<Object>(dlDataArray.length);
            int i3 = 0;
            while (i3 < dlDataArray.length) {
                int n;
                Object dlData = dlDataArray[i3];
                dlData.resetTrace();
                if (dlData.getState() == 1) {
                    try {
                        dlData.initialize();
                        if (this.bDebugLog) {
                            String string = "initialize: state is waiting";
                            this.log.log(dlData.getRelatedTo(), 1, string);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.bDebugLog && dlData.getState() == 1) {
                        dlData.appendTrace("still in waiting state after initialize!\n");
                    }
                }
                if (this.bAutoReposition && this.iRankType != 0 && dlData.isComplete() && dlData.supportsPosition() && (totals.bOkToStartSeeding || totals.firstPriority > 0)) {
                    dlData.setPosition(++posComplete);
                }
                if ((n = dlData.getState()) != 6 && n != 7 && n != 8) {
                    Object t;
                    TagFeatureRateLimit tag;
                    int n2;
                    int n3;
                    TagFeatureRateLimit[] tagFeatureRateLimitArray;
                    ArrayList<Object> temp;
                    Object[] tvars;
                    TagFeatureRateLimit[] tagLimits;
                    if (dlData.isForceStart()) {
                        int n4;
                        if (n == 7 || n == 9) {
                            try {
                                dlData.restart();
                                if (this.bDebugLog) {
                                    String s32 = "restart: isForceStart";
                                    this.log.log(dlData.getRelatedTo(), 1, s32);
                                    dlData.appendTrace(String.valueOf(s32) + "\n");
                                }
                            }
                            catch (DownloadException s32) {
                                // empty catch block
                            }
                            n4 = dlData.getState();
                        }
                        if (n4 == 3) {
                            try {
                                dlData.start();
                                if (this.bDebugLog) {
                                    String s4 = "Start: isForceStart";
                                    this.log.log(dlData.getRelatedTo(), 1, s4);
                                    dlData.appendTrace(String.valueOf(s4) + "\n");
                                }
                            }
                            catch (DownloadException s4) {
                                // empty catch block
                            }
                        }
                    }
                    if (!dlData.isComplete()) {
                        incompleteDownloads.add((DefaultRankCalculator)dlData);
                        tagLimits = dlData.getTagsWithDLLimits();
                        if (tagLimits.length == 0) {
                            tvars = new ProcessTagVarsIncomplete[]{};
                        } else {
                            temp = new ArrayList<Object>(tagLimits.length);
                            tagFeatureRateLimitArray = tagLimits;
                            n3 = tagLimits.length;
                            n2 = 0;
                            while (n2 < n3) {
                                tag = tagFeatureRateLimitArray[n2];
                                t = (ProcessTagVarsIncomplete)tvarsIncompleteMap.get(tag);
                                if (t == null) {
                                    int maxDLs = tag.getMaxActiveDownloads();
                                    if (maxDLs > 0) {
                                        t = new ProcessTagVarsIncomplete(maxDLs, tag.getStrictActivityLimits());
                                        tvarsIncompleteMap.put(tag, t);
                                        temp.add(t);
                                    }
                                } else {
                                    temp.add(t);
                                }
                                ++n2;
                            }
                            tvars = temp.toArray(new ProcessTagVarsIncomplete[temp.size()]);
                        }
                        this.handleInCompleteDownload((DefaultRankCalculator)dlData, vars, (ProcessTagVarsIncomplete[])tvars, totals);
                    } else {
                        completeDownloads.add(dlData);
                        tagLimits = dlData.getTagsWithCDLimits();
                        if (tagLimits.length == 0) {
                            tvars = new ProcessTagVarsComplete[]{};
                        } else {
                            temp = new ArrayList(tagLimits.length);
                            tagFeatureRateLimitArray = tagLimits;
                            n3 = tagLimits.length;
                            n2 = 0;
                            while (n2 < n3) {
                                tag = tagFeatureRateLimitArray[n2];
                                t = (ProcessTagVarsComplete)tvarsCompleteMap.get(tag);
                                if (t == null) {
                                    int maxCDs = tag.getMaxActiveSeeds();
                                    if (maxCDs > 0) {
                                        t = new ProcessTagVarsComplete(maxCDs, tag.getStrictActivityLimits());
                                        tvarsCompleteMap.put(tag, t);
                                        temp.add(t);
                                    }
                                } else {
                                    temp.add(t);
                                }
                                ++n2;
                            }
                            tvars = temp.toArray(new ProcessTagVarsComplete[temp.size()]);
                        }
                        this.handleCompletedDownload((DefaultRankCalculator)dlData, vars, (ProcessTagVarsComplete[])tvars, totals);
                    }
                }
                ++i3;
            }
            int lightSeedingSlots = this.reservedSlots.size();
            if (!completeDownloads.isEmpty()) {
                boolean hasFreeSeedingSlots;
                boolean bl = hasFreeSeedingSlots = lightSeedingSlots > 0;
                if (hasFreeSeedingSlots) {
                    void var17_30;
                    boolean bl2 = true;
                    int numComp = completeDownloads.size();
                    int pos = RandomUtils.nextInt(numComp);
                    int i4 = 0;
                    while (i4 < numComp && var17_30 > 0) {
                        DefaultRankCalculator data = (DefaultRankCalculator)completeDownloads.get(pos);
                        if (++pos >= numComp) {
                            pos = 0;
                        }
                        if (data.updateLightSeedEligibility(true)) {
                            --var17_30;
                        }
                        ++i4;
                    }
                } else {
                    for (DefaultRankCalculator defaultRankCalculator : completeDownloads) {
                        defaultRankCalculator.updateLightSeedEligibility(false);
                    }
                }
            }
            if (this.bDebugLog) {
                if (totals.maxActive == 0) {
                    this.slotStatus = "Unlimited";
                } else {
                    int currFree = totals.maxSeeders + this.maxStalledSeeding - (cvars.numWaitingOrSeeding + cvars.stalledSeeders);
                    int n = totals.maxSeeders + this.maxStalledSeeding + this.maxOverLimitSeeding - (totals.activelyCDing + totals.waitingToSeed + totals.stalledSeeders);
                    this.slotStatus = "Seed=" + Math.max(Math.min(currFree, n), 0) + ", " + "Light=" + Math.min(this.reservedSlots.size(), this.numReservedSeedingSlots);
                }
            } else {
                this.slotStatus = "";
            }
            this.processDownloadingRules(incompleteDownloads);
            if (this.bDebugLog) {
                String[] mainDebugEntries2 = new String[]{"ok2Start=" + this.boolDebug(totals.bOkToStartSeeding), "tFrcdCding=" + totals.forcedSeeding, "actvCDs=" + totals.activelyCDing, "tW8tingToCd=" + totals.waitingToSeed, "tDLing=" + totals.downloading, "actvDLs=" + totals.activelyDLing, "tW8tingToDL=" + totals.waitingToDL, "tCom=" + totals.complete, "tIncQd=" + totals.incompleteQueued, "mxCdrs=" + totals.maxSeeders, "tFP=" + totals.firstPriority, "maxT=" + totals.maxTorrents, "maxA=" + totals.maxActive};
                this.printDebugChanges("<<process() ", mainDebugEntries, mainDebugEntries2, "freeS=" + lightSeedingSlots, "", true, null);
            }
        }
        finally {
            if (now > 0L) {
                ++this.processCount;
                long timeTaken = SystemTime.getCurrentTime() - now;
                if (this.bDebugLog) {
                    this.log.log(1, "process() took " + timeTaken);
                }
                this.processTotalMS += timeTaken;
                if (timeTaken > this.processMaxMS) {
                    this.processMaxMS = timeTaken;
                }
                if (this.processLastComplete > 0L) {
                    this.processTotalGap += now - this.processLastComplete;
                }
                this.processLastComplete = now;
            }
            this.immediateProcessingScheduled = false;
            this.this_mon.exit();
        }
    }

    private void processDownloadingRules(List<DefaultRankCalculator> downloads) {
        long mono_now = SystemTime.getMonotonousTime();
        if (mono_now - this.monoStartedOn < 30000L) {
            return;
        }
        if (this.iDownloadSortType != 2 && this.iDownloadSortType != 6 && this.dlr_current_active != null) {
            this.dlr_current_active.setDLRInactive();
            this.dlr_current_active = null;
        }
        if (this.iDownloadSortType == 0) {
            return;
        }
        if (this.iDownloadSortType == 1 || this.iDownloadSortType == 3) {
            Collections.sort(downloads, new Comparator<DefaultRankCalculator>(){

                @Override
                public int compare(DefaultRankCalculator d1, DefaultRankCalculator d2) {
                    DownloadScrapeResult s1 = d1.getAggregatedScrapeResult(true);
                    DownloadScrapeResult s2 = d2.getAggregatedScrapeResult(true);
                    int result = s2.getSeedCount() - s1.getSeedCount();
                    if (result == 0) {
                        result = s2.getNonSeedCount() - s1.getNonSeedCount();
                    }
                    if (StartStopRulesDefaultPlugin.this.iDownloadSortType == 1) {
                        return result;
                    }
                    return -result;
                }
            });
            int i = 0;
            while (i < downloads.size()) {
                DefaultRankCalculator drc = downloads.get(i);
                if (drc.supportsPosition() && drc.getPosition() != i + 1) {
                    drc.moveTo(i + 1);
                }
                ++i;
            }
        } else if (this.iDownloadSortType == 4 || this.iDownloadSortType == 5 || this.iDownloadSortType == 8) {
            Collections.sort(downloads, new Comparator<DefaultRankCalculator>(){

                @Override
                public int compare(DefaultRankCalculator d1, DefaultRankCalculator d2) {
                    if (StartStopRulesDefaultPlugin.this.iDownloadSortType == 8) {
                        long l1 = d1.getRemainingExcludingDND();
                        long l2 = d2.getRemainingExcludingDND();
                        int result = Long.compare(l1, l2);
                        return result;
                    }
                    long l1 = d1.getSizeExcludingDND();
                    long l2 = d2.getSizeExcludingDND();
                    int result = Long.compare(l2, l1);
                    if (StartStopRulesDefaultPlugin.this.iDownloadSortType == 4) {
                        return result;
                    }
                    return -result;
                }
            });
            int i = 0;
            while (i < downloads.size()) {
                DefaultRankCalculator drc = downloads.get(i);
                if (drc.getPosition() != i + 1) {
                    drc.moveTo(i + 1);
                }
                ++i;
            }
        } else if (this.iDownloadSortType == 7) {
            Collections.sort(downloads, new Comparator<DefaultRankCalculator>(){

                @Override
                public int compare(DefaultRankCalculator d1, DefaultRankCalculator d2) {
                    int[] p1 = d1.getFilePriorityStats();
                    int[] p2 = d2.getFilePriorityStats();
                    int result = Integer.compare(p2[1], p1[1]);
                    if (result == 0) {
                        result = Integer.compare(p2[3], p1[3]);
                    }
                    return result;
                }
            });
            int i = 0;
            while (i < downloads.size()) {
                DefaultRankCalculator drc = downloads.get(i);
                if (drc.getPosition() != i + 1) {
                    drc.moveTo(i + 1);
                }
                ++i;
            }
        } else {
            boolean is_rate;
            if (this.dlr_current_active != null && !downloads.contains(this.dlr_current_active)) {
                this.dlr_current_active.setDLRInactive();
                this.dlr_current_active = null;
            }
            if (downloads.size() < 2) {
                return;
            }
            if (this.globalDownloadLimit > 0) {
                int downloadKBSec = (int)(this.globalDownloadSpeedAverage.getAverage() * 1000.0 / 1500.0 / 1024.0);
                if (this.globalDownloadLimit - downloadKBSec < 5) {
                    if (this.dlr_max_rate_time == 0L) {
                        this.dlr_max_rate_time = mono_now;
                    } else if (mono_now - this.dlr_max_rate_time >= 60000L) {
                        if (this.dlr_current_active != null) {
                            this.dlr_current_active.setDLRInactive();
                            this.dlr_current_active = null;
                        }
                        return;
                    }
                } else {
                    this.dlr_max_rate_time = 0L;
                }
            } else {
                this.dlr_max_rate_time = 0L;
            }
            if (this.dlr_current_active != null) {
                long last_test = this.dlr_current_active.getDLRLastTestTime();
                long tested_ago = mono_now - last_test;
                if (tested_ago < (long)this.iDownloadTestTimeMillis) {
                    return;
                }
                this.dlr_current_active.setDLRComplete(mono_now);
                this.dlr_current_active = null;
            }
            boolean bl = is_rate = this.iDownloadSortType == 2;
            if (this.dlr_current_active == null) {
                long tested_ago;
                long last_test;
                DefaultRankCalculator to_test = null;
                long oldest_test = 0L;
                long adjustedReTest = this.iDownloadReTestMillis + this.iDownloadTestTimeMillis * downloads.size();
                for (DefaultRankCalculator drc : downloads) {
                    if (!drc.isQueued()) continue;
                    last_test = drc.getDLRLastTestTime();
                    if (last_test == 0L) {
                        to_test = drc;
                        break;
                    }
                    if (this.iDownloadReTestMillis <= 0 || (tested_ago = mono_now - last_test) < adjustedReTest || tested_ago <= oldest_test) continue;
                    oldest_test = tested_ago;
                    to_test = drc;
                }
                if (to_test == null && this.bDownloadTestActive) {
                    for (DefaultRankCalculator drc : downloads) {
                        if (!drc.isDownloading()) continue;
                        last_test = drc.getDLRLastTestTime();
                        if (last_test == 0L) {
                            to_test = drc;
                            break;
                        }
                        if (this.iDownloadReTestMillis <= 0 || (tested_ago = mono_now - last_test) < adjustedReTest || tested_ago <= oldest_test) continue;
                        oldest_test = tested_ago;
                        to_test = drc;
                    }
                }
                if (to_test != null) {
                    this.dlr_current_active = to_test;
                    to_test.setDLRActive(mono_now);
                }
            }
            Collections.sort(downloads, new Comparator<DefaultRankCalculator>(){
                private Map<DefaultRankCalculator, Long> eta_map = new HashMap<DefaultRankCalculator, Long>();

                @Override
                public int compare(DefaultRankCalculator o1, DefaultRankCalculator o2) {
                    int res;
                    if (o1 == StartStopRulesDefaultPlugin.this.dlr_current_active) {
                        return -1;
                    }
                    if (o2 == StartStopRulesDefaultPlugin.this.dlr_current_active) {
                        return 1;
                    }
                    if (is_rate) {
                        int speed1 = o1.getDLRLastTestSpeed();
                        int speed2 = o2.getDLRLastTestSpeed();
                        res = speed2 - speed1;
                    } else {
                        long eta1 = this.getETA(o1);
                        long eta2 = this.getETA(o2);
                        res = Long.compare(eta1, eta2);
                    }
                    if (res == 0) {
                        res = o1.getPosition() - o2.getPosition();
                    }
                    return res;
                }

                private long getETA(DefaultRankCalculator o) {
                    Long l = this.eta_map.get(o);
                    if (l == null) {
                        l = o.getDLRLastTestETA();
                        this.eta_map.put(o, l);
                    }
                    return l;
                }
            });
            int i = 0;
            while (i < downloads.size()) {
                DefaultRankCalculator drc = downloads.get(i);
                if ((is_rate ? drc.getDLRLastTestSpeed() > 0 : drc.getDLRLastTestETA() > 0L) && drc.getPosition() != i + 1) {
                    drc.moveTo(i + 1);
                }
                ++i;
            }
        }
    }

    private int getMaxDownloads() {
        if (this.dlr_current_active == null) {
            return this.maxConfiguredDownloads;
        }
        return this.maxConfiguredDownloads + 1;
    }

    private void handleInCompleteDownload(DefaultRankCalculator dlData, ProcessVars vars, ProcessTagVarsIncomplete[] tagVars, TotalsStats totals) {
        int oldState;
        int n;
        int n2;
        ProcessTagVarsIncomplete[] processTagVarsIncompleteArray;
        boolean fakedActively;
        boolean globalRateAdjustedActivelyDownloading;
        boolean globalDownLimitReached;
        int tagMaxDLs;
        int state = dlData.getState();
        if (dlData.isForceStart()) {
            if (this.bDebugLog) {
                String s = "isForceStart.. rules skipped";
                this.log.log(dlData.getRelatedTo(), 1, s);
                dlData.appendTrace(String.valueOf(s) + "\n");
            }
            return;
        }
        if (this.bMaxDownloadIgnoreChecking && dlData.getCoreState() == 30) {
            if (this.bDebugLog) {
                String s = "isChecking.. rules skipped";
                this.log.log(dlData.getRelatedTo(), 1, s);
                dlData.appendTrace(String.valueOf(s) + "\n");
            }
            return;
        }
        ProcessVarsIncomplete ivars = vars.incomp;
        if (state == 2) {
            ++ivars.numWaitingOrDLing;
            ProcessTagVarsIncomplete[] processTagVarsIncompleteArray2 = tagVars;
            int n3 = tagVars.length;
            int n4 = 0;
            while (n4 < n3) {
                ProcessTagVarsIncomplete tvars = processTagVarsIncompleteArray2[n4];
                ++tvars.numWaitingOrDLing;
                ++n4;
            }
            if (this.bDebugLog) {
                String s = "ST_PREPARING.. rules skipped. numW8tngorDLing=" + ivars.numWaitingOrDLing;
                this.log.log(dlData.getRelatedTo(), 1, s);
                dlData.appendTrace(String.valueOf(s) + "\n");
            }
            return;
        }
        int maxDLs = 0;
        int maxDownloads = this.getMaxDownloads();
        if (totals.maxActive == 0) {
            maxDLs = maxDownloads;
        } else {
            int DLmax = 0;
            DLmax = totals.stalledFPSeeders + totals.forcedActive + totals.maxActive - totals.firstPriority - totals.forcedSeedingNonFP;
            int n5 = DLmax <= 0 ? 0 : (maxDLs = maxDownloads - DLmax <= 0 ? maxDownloads : DLmax);
        }
        if (maxDLs < this.minDownloads) {
            maxDLs = this.minDownloads;
        }
        if (tagVars.length == 0) {
            tagMaxDLs = 0;
        } else {
            tagMaxDLs = Integer.MAX_VALUE;
            ProcessTagVarsIncomplete[] processTagVarsIncompleteArray3 = tagVars;
            int n6 = tagVars.length;
            int n7 = 0;
            while (n7 < n6) {
                ProcessTagVarsIncomplete tvars = processTagVarsIncompleteArray3[n7];
                tagMaxDLs = Math.min(tagMaxDLs, tvars.maxDLs);
                ++n7;
            }
        }
        boolean bActivelyDownloading = dlData.getActivelyDownloading();
        if (this.bStopOnceBandwidthMet) {
            boolean isRunning = dlData.getState() == 4;
            globalDownLimitReached = this.globalDownloadLimit > 0 && (double)vars.accumulatedDownloadSpeed / 1024.0 > (double)((float)this.globalDownloadLimit * 0.9f);
            globalRateAdjustedActivelyDownloading = bActivelyDownloading || isRunning && globalDownLimitReached;
            boolean bl = fakedActively = globalRateAdjustedActivelyDownloading && !bActivelyDownloading;
            if (fakedActively) {
                ++totals.activelyDLing;
                totals.maxSeeders = this.calcMaxSeeders(totals.activelyDLing + totals.waitingToDL);
            }
        } else {
            globalDownLimitReached = false;
            globalRateAdjustedActivelyDownloading = bActivelyDownloading;
            fakedActively = false;
        }
        if (this.bDebugLog) {
            String s = ">> DL state=" + sStates.charAt(dlData.getState()) + ";shareRatio=" + dlData.getShareRatio() + ";numW8tngorDLing=" + ivars.numWaitingOrDLing + ";maxCDrs=" + totals.maxSeeders + ";forced=" + this.boolDebug(dlData.isForceStart()) + ";actvDLs=" + totals.activelyDLing + ";maxDLs=" + maxDLs + ";tagMaxDLs=" + tagMaxDLs + ";ActDLing=" + this.boolDebug(bActivelyDownloading) + ";globDwnRchd=" + this.boolDebug(globalDownLimitReached) + ";hgherQd=" + this.boolDebug(ivars.higherDLtoStart) + ";isCmplt=" + this.boolDebug(dlData.isComplete());
            this.log.log(dlData.getRelatedTo(), 1, s);
            dlData.appendTrace(String.valueOf(s) + "\n");
        }
        if (state == 4 && globalRateAdjustedActivelyDownloading || state == 3 || state == 1 || state == 2) {
            ++ivars.numWaitingOrDLing;
            processTagVarsIncompleteArray = tagVars;
            n2 = tagVars.length;
            n = 0;
            while (n < n2) {
                ProcessTagVarsIncomplete tvars = processTagVarsIncompleteArray[n];
                ++tvars.numWaitingOrDLing;
                ++n;
            }
        } else if (state == 4) {
            processTagVarsIncompleteArray = tagVars;
            n2 = tagVars.length;
            n = 0;
            while (n < n2) {
                ProcessTagVarsIncomplete tvars = processTagVarsIncompleteArray[n];
                ++tvars.stalledDownloaders;
                ++n;
            }
        }
        if (state == 3 || state == 4 || state == 1) {
            boolean bDownloading;
            boolean bOverLimit = ivars.numWaitingOrDLing > maxDLs || ivars.numWaitingOrDLing >= maxDLs && ivars.higherDLtoStart;
            ProcessTagVarsIncomplete[] processTagVarsIncompleteArray4 = tagVars;
            int n8 = tagVars.length;
            n2 = 0;
            while (n2 < n8) {
                ProcessTagVarsIncomplete tvars = processTagVarsIncompleteArray4[n2];
                int active = tvars.numWaitingOrDLing + (tvars.isStrictLimit ? tvars.stalledDownloaders : 0);
                if (active > tvars.maxDLs || active == tvars.maxDLs && tvars.higherDLtoStart) {
                    bOverLimit = true;
                    break;
                }
                ++n2;
            }
            boolean bl = bDownloading = state == 4;
            if (maxDownloads != 0 && bOverLimit && !dlData.isChecking() && !dlData.isMoving() && (globalRateAdjustedActivelyDownloading || !bDownloading || bDownloading && totals.maxActive != 0 && !globalRateAdjustedActivelyDownloading && totals.activelyCDing + totals.activelyDLing >= totals.maxActive)) {
                try {
                    if (this.bDebugLog) {
                        String s = "   stopAndQueue: " + ivars.numWaitingOrDLing + " waiting or downloading, when limit is " + maxDLs + "(" + maxDownloads + ")";
                        if (ivars.higherDLtoStart) {
                            s = String.valueOf(s) + " and higher DL is starting";
                        }
                        this.log.log(dlData.getRelatedTo(), 1, s);
                        dlData.appendTrace(String.valueOf(s) + "\n");
                    }
                    dlData.stopAndQueue();
                    --ivars.numWaitingOrDLing;
                    ProcessTagVarsIncomplete[] processTagVarsIncompleteArray5 = tagVars;
                    int n9 = tagVars.length;
                    n8 = 0;
                    while (n8 < n9) {
                        ProcessTagVarsIncomplete tvars = processTagVarsIncompleteArray5[n8];
                        --tvars.numWaitingOrDLing;
                        ++n8;
                    }
                    if (state == 4) {
                        --totals.downloading;
                        if (bActivelyDownloading || fakedActively) {
                            --totals.activelyDLing;
                        }
                    } else {
                        --totals.waitingToDL;
                    }
                    totals.maxSeeders = this.calcMaxSeeders(totals.activelyDLing + totals.waitingToDL);
                }
                catch (Exception tvars) {
                    // empty catch block
                }
                state = dlData.getState();
            } else if (this.bDebugLog) {
                String s = "NOT queuing: ";
                s = maxDownloads == 0 ? String.valueOf(s) + "maxDownloads = " + maxDownloads : (!bOverLimit ? String.valueOf(s) + "not over limit.  numWaitingOrDLing(" + ivars.numWaitingOrDLing + ") <= maxDLs(" + maxDLs + ")" : (!bActivelyDownloading || bDownloading ? String.valueOf(s) + "not actively downloading" : (totals.maxActive == 0 ? String.valueOf(s) + "unlimited active allowed (set)" : String.valueOf(s) + "# active(" + (totals.activelyCDing + totals.activelyDLing) + ") < maxActive(" + totals.maxActive + ")")));
                this.log.log(dlData.getRelatedTo(), 1, s);
                dlData.appendTrace(String.valueOf(s) + "\n");
            }
        }
        if (state == 3 && (maxDownloads == 0 || totals.activelyDLing < maxDLs)) {
            try {
                if (this.bDebugLog) {
                    String s = "   start: READY && activelyDLing (" + totals.activelyDLing + ") < maxDLs (" + maxDownloads + ")";
                    this.log.log(dlData.getRelatedTo(), 1, s);
                    dlData.appendTrace(String.valueOf(s) + "\n");
                }
                dlData.start();
                --totals.waitingToDL;
                ++totals.activelyDLing;
                totals.maxSeeders = this.calcMaxSeeders(totals.activelyDLing + totals.waitingToDL);
            }
            catch (Exception e) {
                Debug.out(e);
            }
            state = dlData.getState();
        }
        boolean tvarsMaxDLsExceeded = false;
        if (state == 9 && (maxDownloads == 0 || ivars.numWaitingOrDLing < maxDLs)) {
            ProcessTagVarsIncomplete[] processTagVarsIncompleteArray6 = tagVars;
            int n10 = tagVars.length;
            int s = 0;
            while (s < n10) {
                ProcessTagVarsIncomplete tvars = processTagVarsIncompleteArray6[s];
                if (tvars.numWaitingOrDLing + (tvars.isStrictLimit ? tvars.stalledDownloaders : 0) >= tvars.maxDLs) {
                    tvarsMaxDLsExceeded = true;
                    break;
                }
                ++s;
            }
            if (!tvarsMaxDLsExceeded) {
                try {
                    if (this.bDebugLog) {
                        String s2 = "   restart: QUEUED && numWaitingOrDLing (" + ivars.numWaitingOrDLing + ") < maxDLS (" + maxDLs + ")";
                        this.log.log(1, s2);
                        dlData.appendTrace(String.valueOf(s2) + "\n");
                    }
                    dlData.restart();
                    ++ivars.numWaitingOrDLing;
                    processTagVarsIncompleteArray6 = tagVars;
                    n10 = tagVars.length;
                    s = 0;
                    while (s < n10) {
                        ProcessTagVarsIncomplete tvars = processTagVarsIncompleteArray6[s];
                        ++tvars.numWaitingOrDLing;
                        ++s;
                    }
                    ++totals.waitingToDL;
                    totals.maxSeeders = this.calcMaxSeeders(totals.activelyDLing + totals.waitingToDL);
                }
                catch (Exception tvars) {
                    // empty catch block
                }
                state = dlData.getState();
            } else if (this.bDebugLog) {
                String s3 = "Not starting, tag max exceeded";
                this.log.log(dlData.getRelatedTo(), 1, s3);
                dlData.appendTrace(String.valueOf(s3) + "\n");
            }
        }
        if ((oldState = state) != (state = dlData.getState())) {
            if (this.bDebugLog) {
                this.log.log(1, ">> somethingChanged: state");
            }
            this.somethingChanged = true;
        }
        if (dlData.getSeedingRank() >= 0 && (state == 9 || state == 3 || state == 1 || state == 2)) {
            if (tvarsMaxDLsExceeded) {
                ProcessTagVarsIncomplete[] processTagVarsIncompleteArray7 = tagVars;
                int n11 = tagVars.length;
                int n12 = 0;
                while (n12 < n11) {
                    ProcessTagVarsIncomplete tvars = processTagVarsIncompleteArray7[n12];
                    if (tvars.numWaitingOrDLing + (tvars.isStrictLimit ? tvars.stalledDownloaders : 0) >= tvars.maxDLs) {
                        tvars.higherDLtoStart = true;
                    }
                    ++n12;
                }
            } else {
                ivars.higherDLtoStart = true;
            }
        }
        if (this.bDebugLog) {
            String s = "<< DL state=" + sStates.charAt(dlData.getState()) + ";shareRatio=" + dlData.getShareRatio() + ";numW8tngorDLing=" + ivars.numWaitingOrDLing + ";maxCDrs=" + totals.maxSeeders + ";forced=" + this.boolDebug(dlData.isForceStart()) + ";actvDLs=" + totals.activelyDLing + ";hgherQd=" + this.boolDebug(ivars.higherDLtoStart) + ";ActDLing=" + this.boolDebug(dlData.getActivelyDownloading());
            this.log.log(dlData.getRelatedTo(), 1, s);
            dlData.appendTrace(String.valueOf(s) + "\n");
        }
        if (this.bStopOnceBandwidthMet) {
            vars.accumulatedDownloadSpeed += dlData.getDownloadAverage();
            vars.accumulatedUploadSpeed += dlData.getUploadAverage();
        }
    }

    private void handleCompletedDownload(DefaultRankCalculator dlData, ProcessVars vars, ProcessTagVarsComplete[] tagVars, TotalsStats totals) {
        int rank;
        boolean bScrapeOk;
        ProcessVarsComplete cvars;
        boolean isFP;
        int numPeers;
        String sDebugLine;
        String[] debugEntries;
        boolean stateReadyOrSeeding;
        int state;
        block106: {
            block107: {
                block104: {
                    block105: {
                        ProcessTagVarsComplete tv2;
                        int n;
                        int n2;
                        ProcessTagVarsComplete[] processTagVarsCompleteArray;
                        if (!totals.bOkToStartSeeding) {
                            return;
                        }
                        state = dlData.getState();
                        stateReadyOrSeeding = state == 3 || state == 5;
                        debugEntries = null;
                        sDebugLine = "";
                        numPeers = dlData.getLastModifiedScrapeResultPeers();
                        isFP = false;
                        cvars = vars.comp;
                        if (this.bDebugLog) {
                            isFP = dlData.isFirstPriority();
                            if (dlData.isControllable()) {
                                debugEntries = new String[]{"CD state=" + sStates.charAt(state), "shareR=" + dlData.getShareRatio(), "nWorCDing=" + cvars.numWaitingOrSeeding, "sr=" + dlData.getSeedingRank(), "hgherQd=" + this.boolDebug(cvars.higherCDtoStart), "maxCDrs=" + totals.maxSeeders, "FP=" + this.boolDebug(isFP), "nActCDing=" + totals.activelyCDing, "ActCDing=" + this.boolDebug(dlData.getActivelySeeding()), "nSeeds=" + dlData.getLastModifiedScrapeResultSeeds(), "nPeers=" + dlData.getLastModifiedScrapeResultPeers()};
                            }
                        }
                        bScrapeOk = dlData.getLastScrapeResultOk();
                        if (!this.bAutoStart0Peers || numPeers != 0 || !bScrapeOk) break block104;
                        if (state == 9) {
                            try {
                                if (this.bDebugLog) {
                                    sDebugLine = String.valueOf(sDebugLine) + "\nrestart() 0Peers";
                                }
                                dlData.restart();
                                ++totals.waitingToSeed;
                                ++cvars.numWaitingOrSeeding;
                                processTagVarsCompleteArray = tagVars;
                                n2 = tagVars.length;
                                n = 0;
                                while (n < n2) {
                                    tv2 = processTagVarsCompleteArray[n];
                                    ++tv2.numWaitingOrSeeding;
                                    ++n;
                                }
                                state = dlData.getState();
                                if (state == 3) {
                                    if (this.bDebugLog) {
                                        sDebugLine = String.valueOf(sDebugLine) + "\nstart(); 0Peers";
                                    }
                                    dlData.start();
                                    ++totals.activelyCDing;
                                }
                            }
                            catch (Exception tv2) {
                                // empty catch block
                            }
                        }
                        if (state == 3) {
                            try {
                                if (this.bDebugLog) {
                                    sDebugLine = String.valueOf(sDebugLine) + "\nstart(); 0Peers";
                                }
                                dlData.start();
                                ++totals.activelyCDing;
                                ++cvars.numWaitingOrSeeding;
                                processTagVarsCompleteArray = tagVars;
                                n2 = tagVars.length;
                                n = 0;
                                while (n < n2) {
                                    tv2 = processTagVarsCompleteArray[n];
                                    ++tv2.numWaitingOrSeeding;
                                    ++n;
                                }
                            }
                            catch (Exception tv3) {
                                // empty catch block
                            }
                        }
                        if (!this.bDebugLog || !dlData.isControllable()) break block105;
                        String[] debugEntries2 = new String[]{"CD state=" + sStates.charAt(dlData.getState()), "shareR=" + dlData.getShareRatio(), "nWorCDing=" + cvars.numWaitingOrSeeding, "sr=" + dlData.getSeedingRank(), "hgherQd=" + this.boolDebug(cvars.higherCDtoStart), "maxCDrs=" + totals.maxSeeders, "FP=" + this.boolDebug(isFP), "nActCDing=" + totals.activelyCDing, "ActCDing=" + this.boolDebug(dlData.getActivelySeeding()), "nSeeds=" + dlData.getLastModifiedScrapeResultSeeds(), "nPeers=" + dlData.getLastModifiedScrapeResultPeers()};
                        this.printDebugChanges("", debugEntries, debugEntries2, sDebugLine, "  ", true, dlData);
                    }
                    return;
                }
                rank = dlData.getSeedingRank();
                if (rank >= -1 || dlData.isForceStart() || stateReadyOrSeeding || this.bAutoStart0Peers) break block106;
                if (this.bDebugLog) {
                    sDebugLine = String.valueOf(sDebugLine) + "\n  Skip !forceStart";
                    int idx = rank * -1;
                    if (idx < DefaultRankCalculator.SR_NEGATIVE_DEBUG.length) {
                        sDebugLine = String.valueOf(sDebugLine) + " && " + DefaultRankCalculator.SR_NEGATIVE_DEBUG[idx];
                    }
                }
                if (!this.bDebugLog || !dlData.isControllable()) break block107;
                String[] debugEntries2 = new String[]{"CD state=" + sStates.charAt(dlData.getState()), "shareR=" + dlData.getShareRatio(), "nWorCDing=" + cvars.numWaitingOrSeeding, "sr=" + dlData.getSeedingRank(), "hgherQd=" + this.boolDebug(cvars.higherCDtoStart), "maxCDrs=" + totals.maxSeeders, "FP=" + this.boolDebug(isFP), "nActCDing=" + totals.activelyCDing, "ActCDing=" + this.boolDebug(dlData.getActivelySeeding()), "nSeeds=" + dlData.getLastModifiedScrapeResultSeeds(), "nPeers=" + dlData.getLastModifiedScrapeResultPeers()};
                this.printDebugChanges("", debugEntries, debugEntries2, sDebugLine, "  ", true, dlData);
            }
            return;
        }
        try {
            int n;
            boolean okToQueue;
            boolean controllable;
            boolean increasedStalledSeeders;
            boolean fakedActively;
            boolean globalRateAdjustedActivelySeeding;
            boolean bActivelySeeding;
            block108: {
                boolean globalDownLimitReached;
                boolean globalUpLimitReached;
                if (cvars.higherCDtoStart && !dlData.isForceStart() && !this.bAutoStart0Peers && !stateReadyOrSeeding) {
                    sDebugLine = String.valueOf(sDebugLine) + " a torrent with a higher rank is queued or starting";
                }
                if (this.bDebugLog && this.bAutoStart0Peers && numPeers == 0 && !bScrapeOk && (state == 9 || state == 3)) {
                    sDebugLine = String.valueOf(sDebugLine) + "\n  NOT starting 0 Peer torrent because scrape isn't ok";
                }
                if (!this.bDebugLog) {
                    isFP = dlData.isFirstPriority();
                }
                bActivelySeeding = dlData.getActivelySeeding();
                if (this.bStopOnceBandwidthMet) {
                    boolean isRunning = dlData.getState() == 5;
                    globalUpLimitReached = totals.maxUploadSpeed() > 0 && (double)vars.accumulatedUploadSpeed / 1024.0 > (double)((float)totals.maxUploadSpeed() * 0.9f);
                    globalDownLimitReached = this.globalDownloadLimit > 0 && (double)vars.accumulatedDownloadSpeed / 1024.0 > (double)((float)this.globalDownloadLimit * 0.9f);
                    globalRateAdjustedActivelySeeding = bActivelySeeding || isRunning && (globalUpLimitReached || globalDownLimitReached);
                    boolean bl = fakedActively = globalRateAdjustedActivelySeeding && !bActivelySeeding;
                    if (fakedActively) {
                        ++totals.activelyCDing;
                    }
                } else {
                    globalUpLimitReached = false;
                    globalRateAdjustedActivelySeeding = bActivelySeeding;
                    globalDownLimitReached = false;
                    fakedActively = false;
                }
                increasedStalledSeeders = false;
                if (state != 9) {
                    ProcessTagVarsComplete tv;
                    int n3;
                    int n4;
                    ProcessTagVarsComplete[] processTagVarsCompleteArray;
                    if (!(state != 5 || bActivelySeeding || this.stalledSeedingIgnoreZP && numPeers == 0 && bScrapeOk)) {
                        ++cvars.stalledSeeders;
                        processTagVarsCompleteArray = tagVars;
                        n4 = tagVars.length;
                        n3 = 0;
                        while (n3 < n4) {
                            tv = processTagVarsCompleteArray[n3];
                            ++tv.stalledSeeders;
                            ++n3;
                        }
                        increasedStalledSeeders = true;
                    }
                    if (state == 3 || state == 1 || state == 2 || state == 5 && globalRateAdjustedActivelySeeding && !dlData.isForceStart()) {
                        ++cvars.numWaitingOrSeeding;
                        processTagVarsCompleteArray = tagVars;
                        n4 = tagVars.length;
                        n3 = 0;
                        while (n3 < n4) {
                            tv = processTagVarsCompleteArray[n3];
                            ++tv.numWaitingOrSeeding;
                            ++n3;
                        }
                        if (this.bDebugLog) {
                            sDebugLine = String.valueOf(sDebugLine) + "\n  Torrent is waiting or seeding";
                        }
                    } else if (!(increasedStalledSeeders || tagVars.length <= 0 || state != 3 && state != 1 && state != 2 && state != 5)) {
                        processTagVarsCompleteArray = tagVars;
                        n4 = tagVars.length;
                        n3 = 0;
                        while (n3 < n4) {
                            tv = processTagVarsCompleteArray[n3];
                            ++tv.numWaitingOrSeeding;
                            ++n3;
                        }
                    }
                    if (this.bDebugLog && dlData.getReservedSlot() != null) {
                        sDebugLine = String.valueOf(sDebugLine) + "\n  Has reserved slot";
                    }
                }
                boolean underCurrentLimit = totals.maxActive == 0 || cvars.numWaitingOrSeeding + cvars.stalledSeeders < totals.maxSeeders + this.maxStalledSeeding;
                ProcessTagVarsComplete tagLimitExceeded = null;
                if (tagVars.length > 0) {
                    ProcessTagVarsComplete[] processTagVarsCompleteArray = tagVars;
                    int n5 = tagVars.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ProcessTagVarsComplete tv = processTagVarsCompleteArray[n6];
                        if (tv.numWaitingOrSeeding + tv.stalledSeeders >= tv.maxCDs + (tv.isStrictLimit ? 0 : this.maxStalledSeeding)) {
                            underCurrentLimit = false;
                            tagLimitExceeded = tv;
                            break;
                        }
                        ++n6;
                    }
                }
                boolean underGlobalLimit = totals.maxActive == 0 || totals.activelyCDing + totals.waitingToSeed + totals.stalledSeeders < totals.maxSeeders + this.maxStalledSeeding + this.maxOverLimitSeeding;
                boolean atLimit = !underCurrentLimit || !underGlobalLimit;
                controllable = dlData.isControllable();
                boolean forceStart = dlData.isForceStart();
                boolean bl = okToQueue = controllable && stateReadyOrSeeding && (!isFP || isFP && atLimit) && !forceStart;
                if (okToQueue && state == 5) {
                    long timeAlive = SystemTime.getCurrentTime() - dlData.getTimeStarted();
                    boolean bl2 = okToQueue = timeAlive >= this.minTimeAlive;
                    if (!okToQueue && this.bDebugLog) {
                        sDebugLine = String.valueOf(sDebugLine) + "\n  Torrent can't be stopped yet, timeAlive(" + timeAlive + ") < minTimeAlive(" + this.minTimeAlive + ")";
                    }
                }
                boolean up_limit_prohibits = false;
                if (controllable && !okToQueue && !forceStart && totals.upLimitProhibitsNewSeeds) {
                    okToQueue = true;
                    up_limit_prohibits = true;
                }
                boolean okToStart = controllable && !okToQueue && tagLimitExceeded == null && state == 9 && rank >= -1;
                boolean higherCDPrevents = cvars.higherCDtoStart;
                boolean slotAvailable = underCurrentLimit && underGlobalLimit;
                RankCalculatorSlotReserver reservedSlot = null;
                if (okToStart && (higherCDPrevents || !slotAvailable) && dlData.getLightSeedEligibility() < 30000L && dlData.getReservedSlot() == null && !this.reservedSlots.isEmpty()) {
                    reservedSlot = this.reservedSlots.removeFirst();
                    slotAvailable = true;
                    higherCDPrevents = false;
                }
                try {
                    if (okToStart && slotAvailable && !higherCDPrevents) {
                        try {
                            if (this.bDebugLog) {
                                sDebugLine = String.valueOf(sDebugLine) + "\n  restart: ok2Q=" + okToQueue + "; QUEUED && numWaitingOrSeeding( " + cvars.numWaitingOrSeeding + ") < maxSeeders (" + totals.maxSeeders + ")";
                            }
                            dlData.restart();
                            okToQueue = false;
                            if (reservedSlot != null) {
                                dlData.setReservedSlot(reservedSlot);
                                this.reservedSlotsAllocated.add(dlData);
                                reservedSlot = null;
                            } else {
                                ++totals.waitingToSeed;
                                ++cvars.numWaitingOrSeeding;
                                ProcessTagVarsComplete[] processTagVarsCompleteArray = tagVars;
                                n = tagVars.length;
                                int n7 = 0;
                                while (n7 < n) {
                                    ProcessTagVarsComplete tv = processTagVarsCompleteArray[n7];
                                    ++tv.numWaitingOrSeeding;
                                    ++n7;
                                }
                            }
                            if (this.iRankType == 3) {
                                dlData.recalcSeedingRank();
                            }
                        }
                        catch (Exception tv) {
                            // empty catch block
                        }
                        state = dlData.getState();
                        break block108;
                    }
                    if (this.bDebugLog && state == 9) {
                        sDebugLine = String.valueOf(sDebugLine) + "\n  NOT restarting:";
                        if (rank < -1) {
                            sDebugLine = String.valueOf(sDebugLine) + " torrent is being ignored";
                            int idx = rank * -1;
                            if (idx < DefaultRankCalculator.SR_NEGATIVE_DEBUG.length) {
                                sDebugLine = String.valueOf(sDebugLine) + ": " + DefaultRankCalculator.SR_NEGATIVE_DEBUG[idx];
                            }
                        } else if (cvars.higherCDtoStart) {
                            sDebugLine = String.valueOf(sDebugLine) + " a torrent with a higher rank is queued or starting";
                        } else {
                            if (okToQueue) {
                                sDebugLine = String.valueOf(sDebugLine) + " no starting of okToQueue'd;";
                            }
                            sDebugLine = tagLimitExceeded != null ? String.valueOf(sDebugLine) + " at tag limit, numWaitingOrSeeding + stalledSeeders(" + tagLimitExceeded.numWaitingOrSeeding + "+" + tagLimitExceeded.stalledSeeders + ") >= maxSeeders(" + tagLimitExceeded.maxCDs + ")" : (cvars.numWaitingOrSeeding + cvars.stalledSeeders >= totals.maxSeeders + this.maxStalledSeeding ? String.valueOf(sDebugLine) + " at current limit, numWaitingOrSeeding + stalledSeeders(" + cvars.numWaitingOrSeeding + "+" + cvars.stalledSeeders + ") >= maxSeeders + maxStalledSeeding(" + totals.maxSeeders + "+" + this.maxStalledSeeding + ")" : (totals.activelyCDing + totals.waitingToSeed + totals.stalledSeeders >= totals.maxSeeders + this.maxStalledSeeding + this.maxOverLimitSeeding ? String.valueOf(sDebugLine) + " at global limit, activelyCDing + waitingToSeed + stalledSeeders(" + (totals.activelyCDing + totals.waitingToSeed + totals.stalledSeeders) + ") >= maxSeeders + maxStalledSeeding + maxOverLimitSeeding(" + (totals.maxSeeders + this.maxStalledSeeding + this.maxOverLimitSeeding) + ")" : (up_limit_prohibits ? String.valueOf(sDebugLine) + " upload rate prohibits starting new seeds" : String.valueOf(sDebugLine) + "huh? qd=" + (state == 9) + "; " + totals.maxActive + ";" + (cvars.numWaitingOrSeeding < totals.maxSeeders) + ";" + (cvars.stalledSeeders <= this.maxStalledSeeding) + ";ignore?" + (rank >= -1))));
                        }
                    }
                }
                finally {
                    if (reservedSlot != null) {
                        this.reservedSlots.add(reservedSlot);
                    }
                }
            }
            boolean bForceStop = false;
            if (state == 3 && controllable) {
                if (rank >= -1 || dlData.isForceStart()) {
                    try {
                        if (this.bDebugLog) {
                            sDebugLine = String.valueOf(sDebugLine) + "\n  start: READY && total activelyCDing(" + totals.activelyCDing + ") < maxSeeders(" + totals.maxSeeders + ")";
                        }
                        dlData.start();
                        okToQueue = false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    state = dlData.getState();
                    ++totals.activelyCDing;
                    bActivelySeeding = true;
                    globalRateAdjustedActivelySeeding = true;
                    ++cvars.numWaitingOrSeeding;
                    ProcessTagVarsComplete[] processTagVarsCompleteArray = tagVars;
                    int n8 = tagVars.length;
                    n = 0;
                    while (n < n8) {
                        ProcessTagVarsComplete tv = processTagVarsCompleteArray[n];
                        ++tv.numWaitingOrSeeding;
                        ++n;
                    }
                } else if (okToQueue) {
                    bForceStop = true;
                }
            }
            if (okToQueue || bForceStop) {
                boolean okToStop = bForceStop;
                if (!okToStop) {
                    boolean overCurrentLimit;
                    boolean bl = overCurrentLimit = totals.maxActive != 0 && cvars.numWaitingOrSeeding + cvars.stalledSeeders > totals.maxSeeders + this.maxStalledSeeding;
                    if (!overCurrentLimit && tagVars.length > 0) {
                        ProcessTagVarsComplete[] processTagVarsCompleteArray = tagVars;
                        int n9 = tagVars.length;
                        int n10 = 0;
                        while (n10 < n9) {
                            ProcessTagVarsComplete tv = processTagVarsCompleteArray[n10];
                            if (tv.numWaitingOrSeeding + tv.stalledSeeders > tv.maxCDs) {
                                overCurrentLimit = true;
                                break;
                            }
                            ++n10;
                        }
                    }
                    boolean overGlobalLimit = totals.maxActive != 0 && totals.activelyCDing + totals.waitingToSeed + totals.stalledSeeders > totals.maxSeeders + this.maxStalledSeeding + this.maxOverLimitSeeding;
                    boolean overLimit = overCurrentLimit || overGlobalLimit;
                    boolean bSeeding = state == 5;
                    boolean bl3 = okToStop = !dlData.isChecking() && !dlData.isMoving() && ((overLimit |= !bActivelySeeding && cvars.stalledSeeders > this.maxStalledSeeding || (cvars.numWaitingOrSeeding >= totals.maxSeeders || totals.upLimitProhibitsNewSeeds) && cvars.higherCDtoStart) || rank < -1);
                    if (this.bDebugLog) {
                        if (okToStop) {
                            sDebugLine = String.valueOf(sDebugLine) + "\n  stopAndQueue: ";
                            if (overLimit) {
                                sDebugLine = cvars.higherCDtoStart ? String.valueOf(sDebugLine) + "higherQueued (it should be seeding instead of this one)" : (!bActivelySeeding && cvars.stalledSeeders > totals.maxSeeders ? String.valueOf(sDebugLine) + "over stale seeds limit" : String.valueOf(sDebugLine) + "over limit");
                            } else if (rank < -1) {
                                sDebugLine = String.valueOf(sDebugLine) + "ignoreRule met";
                            }
                            sDebugLine = String.valueOf(sDebugLine) + " && ";
                            if (bActivelySeeding) {
                                sDebugLine = String.valueOf(sDebugLine) + "activelySeeding";
                            } else if (!bSeeding) {
                                sDebugLine = String.valueOf(sDebugLine) + "not SEEDING";
                            } else if (!bActivelySeeding && bSeeding) {
                                sDebugLine = String.valueOf(sDebugLine) + "SEEDING, but not actively";
                            }
                        }
                    } else {
                        sDebugLine = String.valueOf(sDebugLine) + "\n  NOT queuing: ";
                        sDebugLine = dlData.isChecking() ? String.valueOf(sDebugLine) + "can't auto-queue a checking torrent" : (dlData.isMoving() ? String.valueOf(sDebugLine) + "can't auto-queue a moving torrent" : (!overLimit ? String.valueOf(sDebugLine) + "not over limit.  numWaitingOrSeeding(" + cvars.numWaitingOrSeeding + ") <= maxSeeders(" + totals.maxSeeders + ")" : String.valueOf(sDebugLine) + "bActivelySeeding=" + bActivelySeeding + ";bSeeding" + bSeeding));
                    }
                } else if (this.bDebugLog) {
                    sDebugLine = String.valueOf(sDebugLine) + "\n  Forcing a stop..";
                }
                if (okToStop) {
                    try {
                        if (state == 3) {
                            --totals.waitingToSeed;
                        }
                        dlData.stopAndQueue();
                        if (bActivelySeeding || fakedActively) {
                            --totals.activelyCDing;
                            bActivelySeeding = false;
                        }
                        if (globalRateAdjustedActivelySeeding) {
                            --cvars.numWaitingOrSeeding;
                            ProcessTagVarsComplete[] processTagVarsCompleteArray = tagVars;
                            int n11 = tagVars.length;
                            int n12 = 0;
                            while (n12 < n11) {
                                ProcessTagVarsComplete tv = processTagVarsCompleteArray[n12];
                                --tv.numWaitingOrSeeding;
                                ++n12;
                            }
                            globalRateAdjustedActivelySeeding = false;
                        } else if (increasedStalledSeeders) {
                            --cvars.stalledSeeders;
                            ProcessTagVarsComplete[] processTagVarsCompleteArray = tagVars;
                            int n13 = tagVars.length;
                            int n14 = 0;
                            while (n14 < n13) {
                                ProcessTagVarsComplete tv = processTagVarsCompleteArray[n14];
                                --tv.stalledSeeders;
                                ++n14;
                            }
                        }
                        if (state == 3) {
                            --totals.waitingToSeed;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    state = dlData.getState();
                }
            }
            state = dlData.getState();
            if (rank >= 0 && (state == 9 || state == 3 || state == 1 || state == 2)) {
                cvars.higherCDtoStart = true;
            }
        }
        catch (Throwable throwable) {
            if (this.bDebugLog && dlData.isControllable()) {
                String[] debugEntries2 = new String[]{"CD state=" + sStates.charAt(dlData.getState()), "shareR=" + dlData.getShareRatio(), "nWorCDing=" + cvars.numWaitingOrSeeding, "sr=" + dlData.getSeedingRank(), "hgherQd=" + this.boolDebug(cvars.higherCDtoStart), "maxCDrs=" + totals.maxSeeders, "FP=" + this.boolDebug(isFP), "nActCDing=" + totals.activelyCDing, "ActCDing=" + this.boolDebug(dlData.getActivelySeeding()), "nSeeds=" + dlData.getLastModifiedScrapeResultSeeds(), "nPeers=" + dlData.getLastModifiedScrapeResultPeers()};
                this.printDebugChanges("", debugEntries, debugEntries2, sDebugLine, "  ", true, dlData);
            }
            throw throwable;
        }
        if (this.bDebugLog && dlData.isControllable()) {
            String[] debugEntries2 = new String[]{"CD state=" + sStates.charAt(dlData.getState()), "shareR=" + dlData.getShareRatio(), "nWorCDing=" + cvars.numWaitingOrSeeding, "sr=" + dlData.getSeedingRank(), "hgherQd=" + this.boolDebug(cvars.higherCDtoStart), "maxCDrs=" + totals.maxSeeders, "FP=" + this.boolDebug(isFP), "nActCDing=" + totals.activelyCDing, "ActCDing=" + this.boolDebug(dlData.getActivelySeeding()), "nSeeds=" + dlData.getLastModifiedScrapeResultSeeds(), "nPeers=" + dlData.getLastModifiedScrapeResultPeers()};
            this.printDebugChanges("", debugEntries, debugEntries2, sDebugLine, "  ", true, dlData);
        }
        if (this.bStopOnceBandwidthMet) {
            vars.accumulatedUploadSpeed += dlData.getUploadAverage();
        }
    }

    private String boolDebug(boolean b) {
        return b ? "Y" : "N";
    }

    private void printDebugChanges(String sPrefixFirstLine, String[] oldEntries, String[] newEntries, String sDebugLine, String sPrefix, boolean bAlwaysPrintNoChangeLine, DefaultRankCalculator dlData) {
        boolean bAnyChanged = false;
        String sDebugLineNoChange = sPrefixFirstLine;
        StringBuilder sDebugLineOld = new StringBuilder(120);
        StringBuilder sDebugLineNew = new StringBuilder(120);
        int j = 0;
        while (j < oldEntries.length) {
            if (oldEntries[j].equals(newEntries[j])) {
                sDebugLineNoChange = String.valueOf(sDebugLineNoChange) + oldEntries[j] + ";";
            } else {
                sDebugLineOld.append(oldEntries[j]);
                sDebugLineOld.append(";");
                sDebugLineNew.append(newEntries[j]);
                sDebugLineNew.append(";");
                bAnyChanged = true;
            }
            ++j;
        }
        String sDebugLineOut = String.valueOf(bAlwaysPrintNoChangeLine || bAnyChanged ? sDebugLineNoChange : "") + (bAnyChanged ? "\nOld:" + sDebugLineOld + "\nNew:" + sDebugLineNew : "") + sDebugLine;
        if (!sDebugLineOut.equals("")) {
            String[] lines = sDebugLineOut.split("\n");
            int i = 0;
            while (i < lines.length) {
                String s = String.valueOf(sPrefix) + (i > 0 ? "  " : "") + lines[i];
                if (dlData == null) {
                    this.log.log(1, s);
                } else {
                    this.log.log(dlData.getRelatedTo(), 1, s);
                    dlData.appendTrace(String.valueOf(s) + "\n");
                }
                ++i;
            }
        }
    }

    public void requestProcessCycle(DefaultRankCalculator rankToRecalc) {
        if (rankToRecalc != null) {
            try {
                this.ranksToRecalc_mon.enter();
                this.ranksToRecalc.add(rankToRecalc);
            }
            finally {
                this.ranksToRecalc_mon.exit();
            }
        }
        if (this.somethingChanged) {
            ++this.processMergeCount;
        } else {
            this.somethingChanged = true;
        }
    }

    protected boolean getTagFP() {
        return this.bTagFirstPriority;
    }

    protected void setFPTagStatus(com.biglybt.core.download.DownloadManager dm, boolean is_fp) {
        if (this.fp_tag != null && this.bTagFirstPriority) {
            if (is_fp) {
                if (!this.fp_tag.hasTaggable(dm)) {
                    this.fp_tag.addTaggable(dm);
                }
            } else if (this.fp_tag.hasTaggable(dm)) {
                this.fp_tag.removeTaggable(dm);
            }
        }
    }

    protected String getSlotStatus() {
        return this.slotStatus;
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println("StartStopRules Manager");
        try {
            try {
                writer.indent();
                writer.println("Started " + TimeFormatter.format100ths(SystemTime.getMonotonousTime() - this.monoStartedOn) + " ago");
                writer.println("debugging = " + this.bDebugLog);
                writer.println("downloadDataMap size = " + rankCalculatorMap.size());
                if (this.changeCheckCount > 0L) {
                    writer.println("changeCheck CPU ms: avg=" + this.changeCheckTotalMS / this.changeCheckCount + "; max = " + this.changeCheckMaxMS);
                }
                if (this.processCount > 0L) {
                    writer.println("# process cycles: " + this.processCount);
                    writer.println("process CPU ms: avg=" + this.processTotalMS / this.processCount + "; max = " + this.processMaxMS);
                    if (this.processCount > 1L) {
                        writer.println("process avg gap: " + this.processTotalGap / (this.processCount - 1L) + "ms");
                    }
                    writer.println("Avg # recalcs per process cycle: " + this.processTotalRecalcs / this.processCount);
                    if (this.processTotalZeroRecalcs > 0L) {
                        writer.println("# process cycle with 0 recalcs: " + this.processTotalZeroRecalcs);
                    }
                }
            }
            catch (Exception exception) {
                writer.exdent();
            }
        }
        finally {
            writer.exdent();
        }
    }

    public void addListener(StartStopRulesFPListener listener) {
        this.listenersFP.add(listener);
    }

    public void removeListener(StartStopRulesFPListener listener) {
        this.listenersFP.remove(listener);
    }

    public List getFPListeners() {
        return this.listenersFP.getList();
    }

    private class ChangeCheckerTimerTask
    implements TimerEventPerformer {
        long lLastRunTime = 0L;

        private ChangeCheckerTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void perform(TimerEvent event2) {
            long now = 0L;
            try {
                DefaultRankCalculator[] dlDataArray;
                StartStopRulesDefaultPlugin.this.this_mon.enter();
                now = SystemTime.getCurrentTime();
                if (now > this.lLastRunTime && now - this.lLastRunTime < 1000L) {
                    return;
                }
                this.lLastRunTime = now;
                Map map = rankCalculatorMap;
                synchronized (map) {
                    dlDataArray = rankCalculatorMap.values().toArray(new DefaultRankCalculator[0]);
                }
                int iNumDLing = 0;
                int iNumCDing = 0;
                int i = 0;
                while (i < dlDataArray.length) {
                    if (dlDataArray[i].changeChecker()) {
                        StartStopRulesDefaultPlugin.this.requestProcessCycle(dlDataArray[i]);
                    }
                    if (dlDataArray[i].getActivelyDownloading()) {
                        ++iNumDLing;
                    }
                    if (dlDataArray[i].getActivelySeeding()) {
                        ++iNumCDing;
                    }
                    ++i;
                }
                int iMaxSeeders = StartStopRulesDefaultPlugin.this.calcMaxSeeders(iNumDLing);
                if (iNumCDing > iMaxSeeders) {
                    StartStopRulesDefaultPlugin.this.requestProcessCycle(null);
                    if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                        StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: More Seeding than limit");
                    }
                }
            }
            finally {
                if (now > 0L) {
                    StartStopRulesDefaultPlugin startStopRulesDefaultPlugin = StartStopRulesDefaultPlugin.this;
                    startStopRulesDefaultPlugin.changeCheckCount = startStopRulesDefaultPlugin.changeCheckCount + 1L;
                    long timeTaken = SystemTime.getCurrentTime() - now;
                    StartStopRulesDefaultPlugin startStopRulesDefaultPlugin2 = StartStopRulesDefaultPlugin.this;
                    startStopRulesDefaultPlugin2.changeCheckTotalMS = startStopRulesDefaultPlugin2.changeCheckTotalMS + timeTaken;
                    if (timeTaken > StartStopRulesDefaultPlugin.this.changeCheckMaxMS) {
                        StartStopRulesDefaultPlugin.this.changeCheckMaxMS = timeTaken;
                    }
                }
                StartStopRulesDefaultPlugin.this.this_mon.exit();
            }
        }
    }

    private class ChangeFlagCheckerTask
    implements TimerEventPerformer {
        final long FORCE_CHECK_CYCLES = 40L;
        final DownloadManagerStats dmStats;
        long prevReceived;
        long cycleNo;

        private ChangeFlagCheckerTask() {
            this.dmStats = StartStopRulesDefaultPlugin.this.download_manager.getStats();
            this.prevReceived = -1L;
            this.cycleNo = 0L;
        }

        @Override
        public void perform(TimerEvent event2) {
            long recv = this.dmStats.getDataBytesReceived() + this.dmStats.getProtocolBytesReceived();
            if (this.prevReceived != -1L) {
                StartStopRulesDefaultPlugin.this.globalDownloadSpeedAverage.update(recv - this.prevReceived);
            }
            this.prevReceived = recv;
            if (StartStopRulesDefaultPlugin.this.closingDown || pauseChangeFlagChecker) {
                return;
            }
            ++this.cycleNo;
            if (this.cycleNo > 40L) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log(1, ">>force process");
                }
                StartStopRulesDefaultPlugin.this.somethingChanged = true;
            }
            if (StartStopRulesDefaultPlugin.this.somethingChanged) {
                try {
                    this.cycleNo = 0L;
                    StartStopRulesDefaultPlugin.this.process();
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    private static class ProcessTagVarsComplete {
        final int maxCDs;
        final boolean isStrictLimit;
        int numWaitingOrSeeding;
        int stalledSeeders;

        ProcessTagVarsComplete(int max, boolean strict) {
            this.maxCDs = max;
            this.isStrictLimit = strict;
        }
    }

    private static class ProcessTagVarsIncomplete {
        final int maxDLs;
        final boolean isStrictLimit;
        int numWaitingOrDLing;
        int stalledDownloaders;
        boolean higherDLtoStart;

        ProcessTagVarsIncomplete(int max, boolean strict) {
            this.maxDLs = max;
            this.isStrictLimit = strict;
        }
    }

    private static class ProcessVars {
        long accumulatedDownloadSpeed;
        long accumulatedUploadSpeed;
        final ProcessVarsIncomplete incomp = new ProcessVarsIncomplete();
        final ProcessVarsComplete comp = new ProcessVarsComplete();

        private ProcessVars() {
        }
    }

    private static class ProcessVarsComplete {
        int numWaitingOrSeeding;
        boolean higherCDtoStart;
        int stalledSeeders;

        private ProcessVarsComplete() {
        }
    }

    private static class ProcessVarsIncomplete {
        int numWaitingOrDLing;
        boolean higherDLtoStart;

        private ProcessVarsIncomplete() {
        }
    }

    private class RecalcSeedingRanksTask
    implements TimerEventPerformer {
        boolean bCancel = false;

        private RecalcSeedingRanksTask() {
        }

        @Override
        public void perform(TimerEvent event2) {
            if (this.bCancel) {
                event2.cancel();
                return;
            }
            StartStopRulesDefaultPlugin.this.recalcAllSeedingRanks();
        }

        public void cancel() {
            this.bCancel = true;
        }
    }

    private class StartStopDMListener
    implements DownloadManagerListener {
        private DownloadTrackerListener download_tracker_listener;
        private DownloadListener download_listener;
        private DownloadActivationListener download_activation_listener;
        private StartStopDownloadStateAttributeListener download_state_attribute_listener;

        public StartStopDMListener() {
            this.download_tracker_listener = new StartStopDMTrackerListener();
            this.download_listener = new StartStopDownloadListener();
            this.download_activation_listener = new StartStopDownloadActivationListener();
            this.download_state_attribute_listener = new StartStopDownloadStateAttributeListener();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void downloadAdded(Download download) {
            DefaultRankCalculator dlData = null;
            if (rankCalculatorMap.containsKey(download)) {
                dlData = (DefaultRankCalculator)rankCalculatorMap.get(download);
            } else {
                dlData = new RankCalculatorReal(StartStopRulesDefaultPlugin.this, download);
                Map map = rankCalculatorMap;
                synchronized (map) {
                    rankCalculatorMap.put(download, dlData);
                    StartStopRulesDefaultPlugin.this.sortedArrayCache = null;
                }
                download.addListener(this.download_listener);
                download.addTrackerListener(this.download_tracker_listener, false);
                download.addActivationListener(this.download_activation_listener);
                dlData.addStateAttributeListener(this.download_state_attribute_listener, "t_flags", 1);
            }
            if (dlData != null) {
                StartStopRulesDefaultPlugin.this.requestProcessCycle(dlData);
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)download.getTorrent(), 1, "somethingChanged: downloadAdded, state: " + StartStopRulesDefaultPlugin.sStates.charAt(download.getState()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void downloadRemoved(Download download) {
            DefaultRankCalculator dlData;
            download.removeListener(this.download_listener);
            download.removeTrackerListener(this.download_tracker_listener);
            download.removeActivationListener(this.download_activation_listener);
            Map map = rankCalculatorMap;
            synchronized (map) {
                dlData = (DefaultRankCalculator)rankCalculatorMap.remove(download);
                StartStopRulesDefaultPlugin.this.sortedArrayCache = null;
            }
            if (dlData != null) {
                block12: {
                    dlData.removeStateAttributeListener(this.download_state_attribute_listener, "t_flags", 1);
                    try {
                        StartStopRulesDefaultPlugin.this.this_mon.enter();
                        RankCalculatorSlotReserver reservedSlot = dlData.getReservedSlot();
                        if (reservedSlot == null) break block12;
                        StartStopRulesDefaultPlugin.this.reservedSlotsAllocated.remove(dlData);
                        if (StartStopRulesDefaultPlugin.this.reservedSlots.size() + StartStopRulesDefaultPlugin.this.reservedSlotsAllocated.size() < StartStopRulesDefaultPlugin.this.numReservedSeedingSlots) {
                            StartStopRulesDefaultPlugin.this.reservedSlots.add(reservedSlot);
                            break block12;
                        }
                        Map map2 = rankCalculatorMap;
                        synchronized (map2) {
                            rankCalculatorMap.remove(reservedSlot);
                            StartStopRulesDefaultPlugin.this.sortedArrayCache = null;
                        }
                    }
                    finally {
                        StartStopRulesDefaultPlugin.this.this_mon.exit();
                    }
                }
                dlData.destroy();
            }
            StartStopRulesDefaultPlugin.this.requestProcessCycle(null);
            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                StartStopRulesDefaultPlugin.this.log.log((Object)download.getTorrent(), 1, "somethingChanged: downloadRemoved");
            }
        }
    }

    private class StartStopDMTrackerListener
    implements DownloadTrackerListener {
        private StartStopDMTrackerListener() {
        }

        @Override
        public void scrapeResult(DownloadScrapeResult result) {
            Download dl = result.getDownload();
            if (dl == null) {
                return;
            }
            DefaultRankCalculator dlData = (DefaultRankCalculator)rankCalculatorMap.get(dl);
            if (result.getResponseType() == 2) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)dl.getTorrent(), 1, "Ignored somethingChanged: new scrapeResult (RT_ERROR)");
                }
                if (dlData != null) {
                    dlData.scrapeReceived(result);
                }
                return;
            }
            if (dlData != null) {
                dlData.scrapeReceived(result);
                StartStopRulesDefaultPlugin.this.requestProcessCycle(dlData);
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)dl.getTorrent(), 1, "somethingChanged: new scrapeResult S:" + result.getSeedCount() + ";P:" + result.getNonSeedCount());
                }
            }
        }

        @Override
        public void announceResult(DownloadAnnounceResult result) {
        }
    }

    private class StartStopDownloadActivationListener
    implements DownloadActivationListener {
        private StartStopDownloadActivationListener() {
        }

        @Override
        public boolean activationRequested(DownloadActivationEvent event2) {
            Download download = event2.getDownload();
            DefaultRankCalculator dlData = (DefaultRankCalculator)rankCalculatorMap.get(download);
            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                StartStopRulesDefaultPlugin.this.log.log((Object)download, 1, ">> somethingChanged: ActivationRequest");
            }
            if (dlData != null && dlData.activationRequest(() -> StartStopRulesDefaultPlugin.this.requestProcessCycle(dlData))) {
                StartStopRulesDefaultPlugin.this.requestProcessCycle(dlData);
                return true;
            }
            return false;
        }
    }

    private class StartStopDownloadListener
    implements DownloadListener {
        private StartStopDownloadListener() {
        }

        @Override
        public void stateChanged(Download download, int old_state, int new_state) {
            DefaultRankCalculator dlData = (DefaultRankCalculator)rankCalculatorMap.get(download);
            if (dlData != null) {
                StartStopRulesDefaultPlugin.this.requestProcessCycle(dlData);
                if (new_state == 3 || new_state == 1) {
                    if (StartStopRulesDefaultPlugin.this.immediateProcessingScheduled) {
                        StartStopRulesDefaultPlugin.this.requestProcessCycle(dlData);
                    } else {
                        StartStopRulesDefaultPlugin.this.immediateProcessingScheduled = true;
                        new AEThread2("processReady", true){

                            @Override
                            public void run() {
                                StartStopRulesDefaultPlugin.this.process();
                            }
                        }.start();
                    }
                }
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log(dlData.getRelatedTo(), 1, "somethingChanged: stateChange from " + StartStopRulesDefaultPlugin.sStates.charAt(old_state) + " (" + old_state + ") to " + StartStopRulesDefaultPlugin.sStates.charAt(new_state) + " (" + new_state + ")");
                }
            }
        }

        @Override
        public void positionChanged(Download download, int oldPosition, int newPosition) {
            DefaultRankCalculator dlData = (DefaultRankCalculator)rankCalculatorMap.get(download);
            if (dlData != null) {
                StartStopRulesDefaultPlugin.this.requestProcessCycle(dlData);
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log(dlData.getRelatedTo(), 1, "somethingChanged: positionChanged from " + oldPosition + " to " + newPosition);
                }
            }
        }
    }

    private class StartStopDownloadStateAttributeListener
    implements DownloadManagerStateAttributeListener {
        private StartStopDownloadStateAttributeListener() {
        }

        @Override
        public void attributeEventOccurred(com.biglybt.core.download.DownloadManager download, String attribute, int event_type) {
            DefaultRankCalculator dlData = (DefaultRankCalculator)rankCalculatorMap.get(PluginCoreUtils.wrap(download));
            if (dlData != null) {
                StartStopRulesDefaultPlugin.this.requestProcessCycle(dlData);
            }
        }
    }

    private class TotalsStats {
        int forcedSeeding = 0;
        int forcedSeedingNonFP = 0;
        int waitingToSeed = 0;
        int waitingToDL = 0;
        int downloading = 0;
        int activelyDLing = 0;
        int activelyCDing = 0;
        int complete = 0;
        int incompleteQueued = 0;
        int firstPriority = 0;
        int stalledSeeders = 0;
        int stalledFPSeeders = 0;
        int forcedActive = 0;
        boolean bOkToStartSeeding;
        int maxSeeders;
        int maxActive;
        int maxTorrents;
        boolean upLimitProhibitsNewSeeds;

        public int maxUploadSpeed() {
            return this.downloading == 0 ? StartStopRulesDefaultPlugin.this.globalUploadWhenSeedingLimit : StartStopRulesDefaultPlugin.this.globalUploadLimit;
        }

        public TotalsStats(DefaultRankCalculator[] dlDataArray) {
            long target;
            long current_up_kbps;
            this.bOkToStartSeeding = StartStopRulesDefaultPlugin.this.iRankType == 0 || StartStopRulesDefaultPlugin.this.iRankType == 3 || SystemTime.getMonotonousTime() - StartStopRulesDefaultPlugin.this.monoStartedOn > 90000L;
            int totalOKScrapes = 0;
            int i = 0;
            while (i < dlDataArray.length) {
                int state;
                DefaultRankCalculator dlData = dlDataArray[i];
                if (dlData != null && (state = dlData.getState()) != 8 && state != 7) {
                    boolean completed = dlData.isComplete();
                    boolean bIsFirstP = false;
                    if (completed || !dlData.isForceStart()) {
                        if (completed) {
                            boolean bScrapeOk = true;
                            if (!this.bOkToStartSeeding) {
                                bScrapeOk = dlData.scrapeResultOk();
                                if (dlData.calcSeedsNoUs() == 0 && bScrapeOk) {
                                    this.bOkToStartSeeding = true;
                                } else if (dlData.getSeedingRank() > 0 && (state == 9 || state == 3) && SystemTime.getMonotonousTime() - StartStopRulesDefaultPlugin.this.monoStartedOn > 20000L) {
                                    this.bOkToStartSeeding = true;
                                }
                            }
                            ++this.complete;
                            if (!this.bOkToStartSeeding && bScrapeOk) {
                                ++totalOKScrapes;
                            }
                            if (dlData.isFirstPriority()) {
                                if (!this.bOkToStartSeeding) {
                                    this.bOkToStartSeeding = true;
                                }
                                ++this.firstPriority;
                                bIsFirstP = true;
                            }
                            if (dlData.getActivelySeeding()) {
                                if (dlData.isForceActive()) {
                                    ++this.forcedActive;
                                }
                                ++this.activelyCDing;
                                if (dlData.isForceStart()) {
                                    ++this.forcedSeeding;
                                    if (!bIsFirstP) {
                                        ++this.forcedSeedingNonFP;
                                    }
                                }
                            } else if (state == 5) {
                                if (bIsFirstP) {
                                    ++this.stalledFPSeeders;
                                }
                                if (!StartStopRulesDefaultPlugin.this.stalledSeedingIgnoreZP || dlData.getLastModifiedScrapeResultPeers() != 0 || !dlData.getLastScrapeResultOk()) {
                                    ++this.stalledSeeders;
                                }
                            }
                            if (state == 3 || state == 1 || state == 2) {
                                ++this.waitingToSeed;
                            }
                        } else {
                            if (state == 4) {
                                ++this.downloading;
                                if (dlData.getActivelyDownloading()) {
                                    ++this.activelyDLing;
                                }
                            }
                            if (state == 3 || state == 1 || state == 2) {
                                ++this.waitingToDL;
                            } else if (state == 9) {
                                ++this.incompleteQueued;
                            }
                        }
                    }
                }
                ++i;
            }
            if (!this.bOkToStartSeeding && totalOKScrapes == this.complete) {
                this.bOkToStartSeeding = true;
            }
            this.maxSeeders = StartStopRulesDefaultPlugin.this.calcMaxSeeders(this.activelyDLing + this.waitingToDL);
            this.maxActive = StartStopRulesDefaultPlugin.this.getMaxActive();
            if (this.maxActive == 0) {
                this.maxTorrents = 9999;
            } else if (this.maxUploadSpeed() == 0) {
                this.maxTorrents = this.maxActive + 4;
            } else {
                int minSpeedPerActive = StartStopRulesDefaultPlugin.this.minSpeedForActiveSeeding * 2 / 1024;
                if (minSpeedPerActive < 3) {
                    minSpeedPerActive = 3;
                }
                this.maxTorrents = this.maxUploadSpeed() / minSpeedPerActive;
                if (this.maxTorrents < this.maxActive) {
                    this.maxTorrents = this.maxActive;
                }
            }
            long up_limit = this.maxUploadSpeed();
            if (StartStopRulesDefaultPlugin.this.bStartNoMoreSeedsWhenUpLimitMet && up_limit > 0L && (current_up_kbps = StartStopRulesDefaultPlugin.this.download_manager.getStats().getSmoothedSendRate() / 1024L) > (target = StartStopRulesDefaultPlugin.this.bStartNoMoreSeedsWhenUpLimitMetPercent ? up_limit * (long)StartStopRulesDefaultPlugin.this.bStartNoMoreSeedsWhenUpLimitMetSlack / 100L : up_limit - (long)StartStopRulesDefaultPlugin.this.bStartNoMoreSeedsWhenUpLimitMetSlack)) {
                this.upLimitProhibitsNewSeeds = true;
            }
        }
    }

    public static interface UIAdapter {
        public void openDebugWindow(DefaultRankCalculator var1);
    }
}

