/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.common.util;

import java.util.regex.Pattern;

public class StringPattern {
    private Pattern p;
    private boolean hasWildcard;

    public StringPattern(String sp) {
        this.hasWildcard = sp.contains("*") || sp.contains("?");
        sp = sp.replaceAll("\\?", "\\.");
        sp = sp.replaceAll("\\*", "\\.\\*");
        this.p = Pattern.compile(sp);
    }

    public boolean hasWildcard() {
        return this.hasWildcard;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.p = Pattern.compile(this.p.pattern(), ignoreCase ? 66 : 0);
    }

    public boolean matches(String probe) {
        return this.p.matcher(probe).matches();
    }

    public static void main(String[] argv) {
        StringPattern sp = new StringPattern(argv[0]);
        System.out.println("hasWildcard: " + sp.hasWildcard());
        sp.setIgnoreCase(true);
        System.out.println("matches:" + sp.matches(argv[1]));
    }
}

