/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.common.viewtitleinfo;

import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo2;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoListener;
import com.biglybt.ui.mdi.MdiEntry;

public class ViewTitleInfoManager {
    public static CopyOnWriteList<ViewTitleInfoListener> listeners = new CopyOnWriteList();

    public static void addListener(ViewTitleInfoListener l) {
        listeners.addIfNotPresent(l);
    }

    public static void removeListener(ViewTitleInfoListener l) {
        listeners.remove(l);
    }

    public static void refreshTitleInfo(ViewTitleInfo titleinfo) {
        MdiEntry entry;
        if (titleinfo == null) {
            return;
        }
        for (ViewTitleInfoListener l : listeners) {
            try {
                l.viewTitleInfoRefresh(titleinfo);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (titleinfo instanceof ViewTitleInfo2 && (entry = ((ViewTitleInfo2)titleinfo).getLinkedMdiEntry()) != null) {
            entry.redraw();
        }
    }
}

