/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.torrent.impl.TorrentOpenOptions;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.DirectoryParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntListParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.util.ArrayList;
import java.util.List;

public class ConfigSectionFileTorrents
extends ConfigSectionImpl {
    public static final String SECTION_ID = "torrents";
    protected boolean skipTidy = false;

    public ConfigSectionFileTorrents() {
        super(SECTION_ID, "files");
    }

    protected String getImportFolder(int i) {
        return COConfigurationManager.getStringParameter("Watch Torrent Folder Path" + (i == 0 ? "" : " " + i));
    }

    protected void setImportFolder(int i, String str) {
        COConfigurationManager.setParameter("Watch Torrent Folder Path" + (i == 0 ? "" : " " + i), str);
    }

    protected String getImportTag(int i) {
        return COConfigurationManager.getStringParameter("Watch Torrent Folder Tag" + (i == 0 ? "" : " " + i), null);
    }

    protected void setImportTag(int i, String str) {
        COConfigurationManager.setParameter("Watch Torrent Folder Tag" + (i == 0 ? "" : " " + i), str);
    }

    @Override
    public void build() {
        int i;
        ArrayList listSaveTorrents = new ArrayList();
        BooleanParameterImpl saveTorrents = new BooleanParameterImpl("Save Torrent Files", "ConfigView.label.savetorrents");
        this.add(saveTorrents, new List[0]);
        DirectoryParameterImpl torrentPathParameter = new DirectoryParameterImpl("General_sDefaultTorrent_Directory", "ConfigView.label.savedirectory");
        this.add(torrentPathParameter, listSaveTorrents);
        torrentPathParameter.setDialogTitleKey("ConfigView.dialog.choosedefaulttorrentpath");
        this.add(new BooleanParameterImpl("Save Torrent Backup", "ConfigView.label.savetorrentbackup"), listSaveTorrents);
        this.add(new BooleanParameterImpl("Delete Saved Torrent Files", "ConfigView.label.deletesavedtorrents"), 2, listSaveTorrents);
        ParameterGroupImpl pgSaveTorrents = new ParameterGroupImpl(null, listSaveTorrents);
        this.add("pgSaveTorrents", pgSaveTorrents, new List[0]);
        pgSaveTorrents.setIndent(1, false);
        saveTorrents.addEnabledOnSelection((Parameter)pgSaveTorrents);
        this.add(new BooleanParameterImpl("Delete Original Torrent Files", "ConfigView.label.deletetorrents"), new List[0]);
        this.add(new BooleanParameterImpl("Default Start Torrents Stopped", "ConfigView.label.defaultstarttorrentsstopped"), new List[0]);
        this.add(new BooleanParameterImpl("Default Start Torrents Stopped Auto Pause", "ConfigView.label.defaultstarttorrentsstoppedandpause"), new List[0]);
        BooleanParameterImpl watchFolder = new BooleanParameterImpl("Watch Torrent Folder", "ConfigView.label.watchtorrentfolder");
        this.add(watchFolder, new List[0]);
        ArrayList<Parameter> listWatchDirs = new ArrayList<Parameter>();
        ArrayList listWatch = new ArrayList();
        int num_folders = COConfigurationManager.getIntParameter("Watch Torrent Folder Path Count", 1);
        boolean tidied = false;
        if (this.skipTidy) {
            this.skipTidy = false;
        } else {
            i = num_folders - 1;
            while (i >= 1) {
                String folder_path = this.getImportFolder(i);
                String tag = this.getImportTag(i);
                if (folder_path != null && !folder_path.isEmpty() || tag != null && !tag.isEmpty()) break;
                --num_folders;
                tidied = true;
                --i;
            }
            if (tidied) {
                COConfigurationManager.setParameter("Watch Torrent Folder Path Count", ++num_folders);
            }
        }
        i = 0;
        while (i < num_folders) {
            this.addImportLine(listWatchDirs, i);
            ++i;
        }
        ParameterGroupImpl pgWatchDirs = new ParameterGroupImpl(null, listWatchDirs);
        this.add("pgWatchDirs", pgWatchDirs, new List[0]);
        pgWatchDirs.setNumberOfColumns(this.isSWT() ? 4 : 2);
        pgWatchDirs.setIndent(1, false);
        ActionParameterImpl addButton = new ActionParameterImpl("ConfigView.label.addanotherfolder", "Button.add");
        this.add("addFolder", addButton, listWatch);
        addButton.addListener(param -> {
            int num = COConfigurationManager.getIntParameter("Watch Torrent Folder Path Count", 1);
            COConfigurationManager.setParameter("Watch Torrent Folder Path Count", num + 1);
            this.skipTidy = true;
            this.requestRebuild();
        });
        String sec = " " + MessageText.getString("ConfigView.section.stats.seconds");
        String min = " " + MessageText.getString("ConfigView.section.stats.minutes");
        String hr = " " + MessageText.getString("ConfigView.section.stats.hours");
        int[] watchTorrentFolderIntervalValues = new int[]{1, 2, 3, 4, 5, 10, 30, 60, 120, 180, 240, 300, 600, 900, 1800, 3600, 7200, 14400, 21600, 28800, 43200, 57600, 72000, 86400};
        String[] watchTorrentFolderIntervalLabels = new String[watchTorrentFolderIntervalValues.length];
        int i2 = 0;
        while (i2 < watchTorrentFolderIntervalValues.length) {
            int secs = watchTorrentFolderIntervalValues[i2];
            int mins = secs / 60;
            int hrs = mins / 60;
            watchTorrentFolderIntervalLabels[i2] = " " + (secs < 60 ? String.valueOf(secs) + sec : (hrs == 0 ? String.valueOf(mins) + min : String.valueOf(hrs) + hr));
            ++i2;
        }
        this.add(new IntListParameterImpl("Watch Torrent Folder Interval Secs", "ConfigView.label.watchtorrentfolderinterval", watchTorrentFolderIntervalValues, watchTorrentFolderIntervalLabels), listWatch);
        String[] addModeLabels = new String[TorrentOpenOptions.STARTMODE_KEYS.length];
        int i3 = 0;
        while (i3 < addModeLabels.length) {
            addModeLabels[i3] = MessageText.getString(TorrentOpenOptions.STARTMODE_KEYS[i3]);
            ++i3;
        }
        this.add(new IntListParameterImpl("Watch Torrents Add Mode", "OpenTorrentWindow.startMode", TorrentOpenOptions.STARTMODE_VALUES, addModeLabels), listWatch);
        this.add(new BooleanParameterImpl("Watch Torrent Always Rename", "ConfigView.label.watchtorrentrename"), listWatch);
        ParameterGroupImpl pgWatch = new ParameterGroupImpl(null, listWatch);
        this.add("pgWatch", pgWatch, new List[0]);
        pgWatch.setIndent(1, false);
        watchFolder.addEnabledOnSelection(pgWatch, pgWatchDirs);
        BooleanParameterImpl paramMonClip = new BooleanParameterImpl("Monitor Clipboard For Torrents", "label.monitor.clipboard");
        paramMonClip.setAllowedUiTypes("swt");
        this.add(paramMonClip, new List[0]);
    }

    protected boolean isSWT() {
        return false;
    }

    protected void addImportLine(List<Parameter> listWatchDirs, int index) {
        DirectoryParameterImpl watchFolderPathParameter = new DirectoryParameterImpl("Watch Torrent Folder Path" + (index == 0 ? "" : " " + index), "ConfigView.label.importdirectory");
        this.add(watchFolderPathParameter, listWatchDirs);
        watchFolderPathParameter.setDialogTitleKey("ConfigView.dialog.choosewatchtorrentfolderpath");
        StringParameterImpl tagParam = new StringParameterImpl("Watch Torrent Folder Tag" + (index == 0 ? "" : " " + index), "label.assign.to.tag");
        this.add(tagParam, listWatchDirs);
        tagParam.setWidthInCharacters(12);
    }
}

