/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.pif.ui.config.IntListParameter;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.HyperlinkParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntListParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UIFunctionsUserPrompter;
import com.biglybt.ui.common.RememberedDecisionsManager;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.util.HashMap;
import java.util.List;

public class ConfigSectionMode
extends ConfigSectionImpl {
    public static final String SECTION_ID = "mode";

    public ConfigSectionMode() {
        super(SECTION_ID, "root");
    }

    @Override
    public void build() {
        String[] links = new String[]{"https://wiki.biglybt.com/w/Mode#Beginner", "https://wiki.biglybt.com/w/Mode#Intermediate", "https://wiki.biglybt.com/w/Mode#Advanced"};
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] values = nArray;
        String[] labels = new String[]{MessageText.getString("ConfigView.section.mode.beginner"), MessageText.getString("ConfigView.section.mode.intermediate"), MessageText.getString("ConfigView.section.mode.advanced")};
        HashMap<Integer, String> mapInfos = new HashMap<Integer, String>();
        mapInfos.put(0, "ConfigView.section.mode.beginner.text");
        mapInfos.put(1, "ConfigView.section.mode.intermediate.text");
        mapInfos.put(2, "ConfigView.section.mode.advanced.text");
        IntListParameterImpl paramUserMode = new IntListParameterImpl("User Mode", null, values, labels);
        paramUserMode.setListType(1);
        this.add(paramUserMode, new List[0]);
        LabelParameterImpl paramInfo = new LabelParameterImpl("");
        this.add("mode.info", paramInfo, new List[0]);
        HyperlinkParameterImpl paramInfoLink = new HyperlinkParameterImpl("ConfigView.label.please.visit.here", links[userMode]);
        this.add(paramInfoLink, new List[0]);
        paramUserMode.addListener(param -> {
            int newUserMode = ((IntListParameter)param).getValue();
            paramInfoLink.setHyperlink(links[newUserMode]);
            String key = (String)mapInfos.get(newUserMode);
            if (MessageText.keyExists(String.valueOf(key) + "1")) {
                key = String.valueOf(key) + "1";
            }
            paramInfo.setLabelText("-> " + MessageText.getString(key));
        });
        paramUserMode.fireParameterChanged();
        ParameterGroupImpl pgRadio = new ParameterGroupImpl("ConfigView.section.mode.title", paramUserMode, paramInfo, paramInfoLink);
        this.add("pgRadio", pgRadio, new List[0]);
        this.add("gap1", new LabelParameterImpl(""), new List[0]);
        this.add("gap2", new LabelParameterImpl(""), new List[0]);
        this.add("gap3", new LabelParameterImpl(""), new List[0]);
        ActionParameterImpl reset_button = new ActionParameterImpl("ConfigView.section.mode.resetdefaults", "Button.reset");
        this.add(reset_button, new List[0]);
        reset_button.addListener(param -> {
            UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
            if (uiFunctions == null) {
                ConfigSectionMode.resetAll();
                return;
            }
            UIFunctionsUserPrompter prompter = uiFunctions.getUserPrompter(MessageText.getString("resetconfig.warn.title"), MessageText.getString("resetconfig.warn"), new String[]{MessageText.getString("Button.ok"), MessageText.getString("Button.cancel")}, 1);
            if (prompter == null) {
                ConfigSectionMode.resetAll();
                return;
            }
            prompter.open(result -> {
                if (result != 0) {
                    return;
                }
                ConfigSectionMode.resetAll();
            });
        });
    }

    private static void resetAll() {
        RememberedDecisionsManager.ensureLoaded();
        COConfigurationManager.resetToDefaults();
    }
}

