/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.security.CryptoHandler;
import com.biglybt.core.security.CryptoManager;
import com.biglybt.core.security.CryptoManagerFactory;
import com.biglybt.core.security.CryptoManagerKeyListener;
import com.biglybt.core.security.CryptoManagerPasswordException;
import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.DirectoryParameterImpl;
import com.biglybt.pifimpl.local.ui.config.HyperlinkParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UIFunctionsUserPrompter;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.util.ArrayList;
import java.util.List;

public class ConfigSectionSecurity
extends ConfigSectionImpl {
    public static final String SECTION_ID = "security";
    private ConfigSectionImpl.ConfigDetailsCallback cbCreateCert;
    private ConfigSectionImpl.ConfigDetailsCallback cbBackupKeys;
    private ConfigSectionImpl.ConfigDetailsCallback cbRestoreKeys;
    private CryptoManagerKeyListener cryptoManagerKeyListener;

    public ConfigSectionSecurity() {
        super(SECTION_ID, "root");
    }

    public void init(ConfigSectionImpl.ConfigDetailsCallback cbCreateCert, ConfigSectionImpl.ConfigDetailsCallback cbBackupKeys, ConfigSectionImpl.ConfigDetailsCallback cbRestoreKeys) {
        this.cbCreateCert = cbCreateCert;
        this.cbBackupKeys = cbBackupKeys;
        this.cbRestoreKeys = cbRestoreKeys;
    }

    @Override
    public void deleteConfigSection() {
        super.deleteConfigSection();
        if (this.cryptoManagerKeyListener != null) {
            CryptoManagerFactory.getSingleton().removeKeyListener(this.cryptoManagerKeyListener);
            this.cryptoManagerKeyListener = null;
        }
    }

    @Override
    public void build() {
        if (this.cbCreateCert != null) {
            ActionParameterImpl cert_button = new ActionParameterImpl("ConfigView.section.tracker.createcert", "ConfigView.section.tracker.createbutton");
            this.add(cert_button, new List[0]);
            cert_button.addListener(param -> this.cbCreateCert.run(this.mapPluginParams));
        }
        ActionParameterImpl reset_certs_button = new ActionParameterImpl("ConfigView.section.security.resetcerts", "Button.reset");
        this.add(reset_certs_button, new List[0]);
        reset_certs_button.addListener(param -> {
            UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
            if (uiFunctions == null) {
                SESecurityManager.resetTrustStore(false);
                return;
            }
            UIFunctionsUserPrompter prompter = uiFunctions.getUserPrompter(MessageText.getString("ConfigView.section.security.resetcerts.warning.title"), MessageText.getString("ConfigView.section.security.resetcerts.warning.msg"), new String[]{MessageText.getString("Button.ok"), MessageText.getString("Button.cancel")}, 1);
            if (prompter == null) {
                SESecurityManager.resetTrustStore(false);
                return;
            }
            prompter.setIconResource("warning");
            prompter.open(returnVal -> {
                if (returnVal != 0) {
                    return;
                }
                if (SESecurityManager.resetTrustStore(false)) {
                    UIFunctionsUserPrompter promptComplete = uiFunctions.getUserPrompter(MessageText.getString("ConfigView.section.security.restart.title"), MessageText.getString("ConfigView.section.security.restart.msg"), new String[]{MessageText.getString("Button.ok")}, 0);
                    if (promptComplete != null) {
                        promptComplete.open(null);
                    }
                    uiFunctions.dispose(true);
                } else {
                    UIFunctionsUserPrompter promptErr = uiFunctions.getUserPrompter(MessageText.getString("ConfigView.section.security.resetcerts.error.title"), MessageText.getString("ConfigView.section.security.resetcerts.error.msg"), new String[]{MessageText.getString("Button.ok")}, 0);
                    if (promptErr != null) {
                        promptErr.setIconResource("error");
                        promptErr.open(null);
                    }
                }
            });
        });
        reset_certs_button.setEnabled(SESecurityManager.resetTrustStore(true));
        BooleanParameterImpl auto_install = this.add(new BooleanParameterImpl("security.cert.auto.install", "security.cert.auto.install"), new List[0]);
        BooleanParameterImpl auto_decline = this.add(new BooleanParameterImpl("security.cert.auto.decline", "security.cert.auto.decline"), new List[0]);
        ParameterListener pl = n -> {
            if (auto_install.getValue() && auto_decline.getValue()) {
                auto_decline.setValue(false);
            }
            if (auto_install.getValue()) {
                auto_decline.setEnabled(false);
            } else {
                auto_decline.setEnabled(true);
            }
            if (auto_decline.getValue()) {
                auto_install.setEnabled(false);
            } else {
                auto_install.setEnabled(true);
            }
        };
        pl.parameterChanged(null);
        auto_install.addListener(pl);
        auto_decline.addListener(pl);
        this.add(new LabelParameterImpl("ConfigView.section.security.toolsinfo"), new List[0]);
        DirectoryParameterImpl pathParameter = new DirectoryParameterImpl("Security.JAR.tools.dir", "ConfigView.section.security.toolsdir");
        this.add(pathParameter, new List[0]);
        pathParameter.setDialogTitleKey("ConfigView.section.security.choosetoolssavedir");
        ActionParameterImpl pw_button = new ActionParameterImpl("ConfigView.section.security.clearpasswords", "ConfigView.section.security.clearpasswords.button");
        this.add(pw_button, new List[0]);
        pw_button.addListener(param -> {
            SESecurityManager.clearPasswords();
            CryptoManagerFactory.getSingleton().clearPasswords();
        });
        CryptoManager crypt_man = CryptoManagerFactory.getSingleton();
        ArrayList listCrypto = new ArrayList();
        this.add(new HyperlinkParameterImpl("ConfigView.label.please.visit.here", "https://wiki.biglybt.com/w/Public_Private_Keys"), listCrypto);
        byte[] public_key = crypt_man.getECCHandler().peekPublicKey();
        String key = public_key == null ? MessageText.getString("ConfigView.section.security.publickey.undef") : Base32.encode(public_key);
        final ActionParameterImpl paramPublicKey = new ActionParameterImpl("ConfigView.section.security.publickey", "!" + key + "!");
        this.add(paramPublicKey, listCrypto);
        paramPublicKey.setStyle(2);
        paramPublicKey.addListener(param -> {
            UIFunctions uif = UIFunctionsManager.getUIFunctions();
            if (uif == null) {
                return;
            }
            uif.copyToClipboard(key);
        });
        this.cryptoManagerKeyListener = new CryptoManagerKeyListener(){

            @Override
            public void keyChanged(CryptoHandler handler) {
                if (handler.getType() == 1) {
                    byte[] public_key = handler.peekPublicKey();
                    String key = public_key == null ? MessageText.getString("ConfigView.section.security.publickey.undef") : Base32.encode(public_key);
                    paramPublicKey.setActionResource("!" + key + "!");
                }
            }

            @Override
            public void keyLockStatusChanged(CryptoHandler handler) {
            }
        };
        crypt_man.addKeyListener(this.cryptoManagerKeyListener);
        ActionParameterImpl reset_key_button = new ActionParameterImpl("ConfigView.section.security.resetkey", "ConfigView.section.security.clearpasswords.button");
        this.add(reset_key_button, listCrypto);
        reset_key_button.addListener(param -> {
            UIFunctions uif = UIFunctionsManager.getUIFunctions();
            if (uif != null) {
                UIFunctionsUserPrompter prompter = uif.getUserPrompter(MessageText.getString("ConfigView.section.security.resetkey.warning.title"), MessageText.getString("ConfigView.section.security.resetkey.warning"), new String[]{MessageText.getString("Button.ok"), MessageText.getString("Button.cancel")}, 1);
                if (prompter != null) {
                    prompter.setIconResource("warning");
                    prompter.open(returnVal -> {
                        block3: {
                            if (returnVal != 0) {
                                return;
                            }
                            try {
                                crypt_man.getECCHandler().resetKeys("Manual key reset");
                            }
                            catch (Throwable e) {
                                UIFunctionsUserPrompter warningPrompt = uif.getUserPrompter(MessageText.getString("ConfigView.section.security.resetkey.error.title"), ConfigSectionSecurity.getError(e), new String[]{MessageText.getString("Button.ok")}, 0);
                                if (warningPrompt == null) break block3;
                                warningPrompt.setIconResource("error");
                                warningPrompt.open(null);
                            }
                        }
                    });
                }
                return;
            }
            try {
                crypt_man.getECCHandler().resetKeys("Manual key reset (no prompt)");
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        });
        ActionParameterImpl priv_key_button = new ActionParameterImpl("ConfigView.section.security.unlockkey", "ConfigView.section.security.unlockkey.button");
        this.add(priv_key_button, listCrypto);
        priv_key_button.addListener(param -> {
            block3: {
                try {
                    crypt_man.getECCHandler().getEncryptedPrivateKey("Manual unlock");
                }
                catch (Throwable e) {
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif == null) {
                        Debug.out(e);
                    }
                    UIFunctionsUserPrompter warningPrompt = uif.getUserPrompter(MessageText.getString("ConfigView.section.security.resetkey.error.title"), ConfigSectionSecurity.getError(e), new String[]{MessageText.getString("Button.ok")}, 0);
                    if (warningPrompt == null) break block3;
                    warningPrompt.setIconResource("error");
                    warningPrompt.open(null);
                }
            }
        });
        if (this.cbBackupKeys != null) {
            ActionParameterImpl backup_keys_button = new ActionParameterImpl("ConfigView.section.security.backupkeys", "ConfigView.section.security.backupkeys.button");
            this.add(backup_keys_button, listCrypto);
            backup_keys_button.addListener(param -> this.cbBackupKeys.run(this.mapPluginParams));
        }
        if (this.cbRestoreKeys != null) {
            ActionParameterImpl restore_keys_button = new ActionParameterImpl("ConfigView.section.security.restorekeys", "ConfigView.section.security.restorekeys.button");
            this.add(restore_keys_button, listCrypto);
            reset_certs_button.addListener(param -> this.cbRestoreKeys.run(this.mapPluginParams));
        }
        this.add("pgCrypto", new ParameterGroupImpl("ConfigView.section.security.group.crypto", listCrypto), new List[0]);
    }

    public static String getError(Throwable e) {
        String error;
        if (e instanceof CryptoManagerPasswordException) {
            if (((CryptoManagerPasswordException)e).wasIncorrect()) {
                error = MessageText.getString("ConfigView.section.security.unlockkey.error");
            } else {
                CryptoManager crypto_man = CryptoManagerFactory.getSingleton();
                CryptoHandler ecc_handler = crypto_man.getECCHandler();
                error = MessageText.getString("ConfigView.section.security.nopw");
            }
        } else {
            error = String.valueOf(MessageText.getString("ConfigView.section.security.resetkey.error")) + ": " + Debug.getNestedExceptionMessage(e);
        }
        return error;
    }
}

