/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.stats.transfer.OverallStats;
import com.biglybt.core.stats.transfer.StatsFactory;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.DirectoryParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntListParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UIFunctionsUserPrompter;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

public class ConfigSectionStats
extends ConfigSectionImpl {
    public static final String SECTION_ID = "stats";
    private static final int[] statsPeriods = new int[]{1, 2, 3, 4, 5, 10, 15, 20, 25, 30, 40, 50, 60, 120, 180, 240, 300, 360, 420, 480, 540, 600, 900, 1200, 1800, 2400, 3000, 3600, 7200, 10800, 14400, 21600, 43200, 86400};

    public ConfigSectionStats() {
        super(SECTION_ID, "root");
    }

    @Override
    public void build() {
        IntParameterImpl paramStatsSmoothingSecs = new IntParameterImpl("Stats Smoothing Secs", "stats.general.smooth_secs", 30, 1800);
        this.add(paramStatsSmoothingSecs, new List[0]);
        this.add("pgGeneralStats", new ParameterGroupImpl("ConfigView.section.general", paramStatsSmoothingSecs), new List[0]);
        BooleanParameterImpl paramGraphDividers = new BooleanParameterImpl("Stats Graph Dividers", "ConfigView.section.stats.graph_update_dividers");
        this.add(paramGraphDividers, new List[0]);
        paramGraphDividers.setAllowedUiTypes("swt");
        this.add("pgStatsDisplay", new ParameterGroupImpl("stats.display.group", paramGraphDividers), new List[0]);
        BooleanParameterImpl enableStats = new BooleanParameterImpl("Stats Enable", "ConfigView.section.stats.enable");
        this.add(enableStats, new List[0]);
        ArrayList<BooleanParameterImpl> listSnapShot = new ArrayList<BooleanParameterImpl>();
        DirectoryParameterImpl pathParameter = new DirectoryParameterImpl("Stats Dir", "ConfigView.section.stats.defaultsavepath");
        this.add(pathParameter, listSnapShot);
        pathParameter.setDialogTitleKey("ConfigView.section.stats.choosedefaultsavepath");
        StringParameterImpl fileParameter = new StringParameterImpl("BiglyBT_Stats.xml", "ConfigView.section.stats.savefile");
        this.add(fileParameter, listSnapShot);
        fileParameter.setWidthInCharacters(15);
        StringParameterImpl xslParameter = new StringParameterImpl("Stats XSL File", "ConfigView.section.stats.xslfile");
        this.add(xslParameter, listSnapShot);
        xslParameter.setWidthInCharacters(15);
        xslParameter.setSuffixLabelKey("ConfigView.section.stats.xslfiledetails");
        String[] spLabels = new String[statsPeriods.length];
        int[] spValues = new int[statsPeriods.length];
        int i = 0;
        while (i < statsPeriods.length) {
            int num = statsPeriods[i];
            spLabels[i] = num % 3600 == 0 ? " " + statsPeriods[i] / 3600 + " " + MessageText.getString("ConfigView.section.stats.hours") : (num % 60 == 0 ? " " + statsPeriods[i] / 60 + " " + MessageText.getString("ConfigView.section.stats.minutes") : " " + statsPeriods[i] + " " + MessageText.getString("ConfigView.section.stats.seconds"));
            spValues[i] = statsPeriods[i];
            ++i;
        }
        IntListParameterImpl statsPeriod = new IntListParameterImpl("Stats Period", "ConfigView.section.stats.savefreq", spValues, spLabels);
        this.add(statsPeriod, listSnapShot);
        BooleanParameterImpl exportPeers = new BooleanParameterImpl("Stats Export Peer Details", "ConfigView.section.stats.exportpeers");
        this.add(exportPeers, listSnapShot);
        BooleanParameterImpl exportFiles = new BooleanParameterImpl("Stats Export File Details", "ConfigView.section.stats.exportfiles");
        this.add(exportFiles, listSnapShot);
        enableStats.addEnabledOnSelection(listSnapShot.toArray(new Parameter[0]));
        listSnapShot.add(0, enableStats);
        this.add("pgStatsSnapshot", new ParameterGroupImpl("stats.snapshot.group", listSnapShot), new List[0]);
        LabelParameterImpl paramSetMarkLabel = new LabelParameterImpl("ConfigView.section.transfer.setmark");
        this.add(paramSetMarkLabel, new List[0]);
        ActionParameterImpl set_mark_button = new ActionParameterImpl(null, "Button.set");
        this.add(set_mark_button, new List[0]);
        set_mark_button.addListener(param -> {
            OverallStats stats2 = StatsFactory.getStats();
            if (stats2 != null) {
                stats2.setMark();
            }
        });
        ActionParameterImpl clear_mark_button = new ActionParameterImpl(null, "Button.clear");
        this.add(clear_mark_button, new List[0]);
        clear_mark_button.addListener(param -> {
            OverallStats stats2 = StatsFactory.getStats();
            if (stats2 != null) {
                stats2.clearMark();
            }
        });
        ParameterGroupImpl pgXferButtons = new ParameterGroupImpl(null, set_mark_button, clear_mark_button);
        this.add("Stats.pgXferButtons", pgXferButtons, new List[0]);
        ParameterGroupImpl pgXfer = new ParameterGroupImpl("ConfigView.section.transfer", paramSetMarkLabel, pgXferButtons);
        this.add("Stats.pgXfer", pgXfer, new List[0]);
        ArrayList<BooleanParameterImpl> listLong = new ArrayList<BooleanParameterImpl>();
        BooleanParameterImpl enableLongStats = new BooleanParameterImpl("long.term.stats.enable", "ConfigView.section.stats.enable");
        this.add(enableLongStats, new List[0]);
        String[] wsLabels = new String[7];
        int[] wsValues = new int[7];
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat format = new SimpleDateFormat("E");
        int i2 = 0;
        while (i2 < 7) {
            int dow = i2 + 1;
            cal.set(7, dow);
            wsLabels[i2] = format.format(cal.getTime());
            wsValues[i2] = i2 + 1;
            ++i2;
        }
        IntListParameterImpl week_start = new IntListParameterImpl("long.term.stats.weekstart", "stats.long.weekstart", wsValues, wsLabels);
        this.add(week_start, listLong);
        IntParameterImpl month_start = new IntParameterImpl("long.term.stats.monthstart", "stats.long.monthstart", 1, 28);
        this.add(month_start, listLong);
        enableLongStats.addEnabledOnSelection(listLong.toArray(new Parameter[0]));
        ActionParameterImpl lt_reset_button = new ActionParameterImpl("ConfigView.section.transfer.lts.reset", "Button.clear");
        this.add(lt_reset_button, listLong);
        lt_reset_button.addListener(param -> {
            UIFunctions uif = UIFunctionsManager.getUIFunctions();
            if (uif == null) {
                StatsFactory.clearLongTermStats();
                return;
            }
            UIFunctionsUserPrompter userPrompter = uif.getUserPrompter(MessageText.getString("ConfigView.section.security.resetcerts.warning.title"), MessageText.getString("ConfigView.section.transfer.ltsreset.warning.msg"), new String[]{MessageText.getString("Button.ok"), MessageText.getString("Button.cancel")}, 1);
            if (userPrompter == null) {
                StatsFactory.clearLongTermStats();
                return;
            }
            userPrompter.setIconResource("warning");
            userPrompter.open(returnVal -> {
                if (returnVal != 0) {
                    return;
                }
                StatsFactory.clearLongTermStats();
            });
        });
        listLong.add(0, enableLongStats);
        this.add("Stats.pgLong", new ParameterGroupImpl("stats.longterm.group", listLong), new List[0]);
    }
}

