/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterValidator;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.util.ArrayList;
import java.util.List;

public class ConfigSectionTrackerClient
extends ConfigSectionImpl {
    public static final String SECTION_ID = "tracker.client";

    public ConfigSectionTrackerClient() {
        super(SECTION_ID, "tracker");
    }

    @Override
    public void build() {
        ArrayList listScrape = new ArrayList();
        this.add(new LabelParameterImpl("ConfigView.section.tracker.client.scrapeinfo"), listScrape);
        BooleanParameterImpl scrape = new BooleanParameterImpl("Tracker Client Scrape Enable", "ConfigView.section.tracker.client.scrapeenable");
        this.add(scrape, listScrape);
        BooleanParameterImpl scrape_stopped = new BooleanParameterImpl("Tracker Client Scrape Stopped Enable", "ConfigView.section.tracker.client.scrapestoppedenable");
        this.add(scrape_stopped, listScrape);
        BooleanParameterImpl dont_scrape_never_Started = new BooleanParameterImpl("Tracker Client Scrape Never Started Disable", "ConfigView.section.tracker.client.scrapesneverstarteddisable");
        this.add(dont_scrape_never_Started, listScrape);
        dont_scrape_never_Started.setIndent(1, true);
        BooleanParameterImpl aggregate = new BooleanParameterImpl("Tracker Client Scrape Single Only", "ConfigView.section.tracker.client.scrapesingleonly");
        this.add(aggregate, listScrape);
        scrape.addEnabledOnSelection(scrape_stopped, dont_scrape_never_Started, aggregate);
        scrape_stopped.addEnabledOnSelection((Parameter)dont_scrape_never_Started);
        ParameterGroupImpl pgScrape = new ParameterGroupImpl("ConfigView.group.scrape", listScrape);
        this.add("TC.pgScrape", pgScrape, new List[0]);
        ArrayList listInfo = new ArrayList();
        this.add(new BooleanParameterImpl("Tracker Client Send OS and Java Version", "ConfigView.section.tracker.sendjavaversionandos"), listInfo);
        this.add(new BooleanParameterImpl("Tracker Client Show Warnings", "ConfigView.section.tracker.client.showwarnings"), listInfo);
        this.add(new BooleanParameterImpl("Tracker Client Exclude LAN", "ConfigView.section.tracker.client.exclude_lan"), listInfo);
        this.add("TC.pgInfo", new ParameterGroupImpl("label.information", listInfo), new List[0]);
        ArrayList listProtocol = new ArrayList();
        this.add(new BooleanParameterImpl("Tracker Client Enable TCP", "ConfigView.section.tracker.client.enabletcp"), listProtocol);
        BooleanParameterImpl enableUDP = new BooleanParameterImpl("Server Enable UDP", "ConfigView.section.server.enableudp");
        this.add(enableUDP, listProtocol);
        BooleanParameterImpl enableUDPProbe = new BooleanParameterImpl("Tracker UDP Probe Enable", "ConfigView.section.server.enableudpprobe");
        this.add(enableUDPProbe, listProtocol);
        enableUDP.addEnabledOnSelection((Parameter)enableUDPProbe);
        this.add(new BooleanParameterImpl("Tracker DNS Records Enable", "ConfigView.section.server.enablednsrecords"), 2, listProtocol);
        this.add(new ParameterGroupImpl("label.protocol", listProtocol), new List[0]);
        ArrayList listOverride = new ArrayList();
        StringParameterImpl overrideip = new StringParameterImpl("Override Ip", "ConfigView.label.overrideip");
        this.add(overrideip, 1, listOverride);
        StringParameterImpl tcpOverride = new StringParameterImpl("TCP.Listen.Port.Override", "ConfigView.label.announceport");
        this.add(tcpOverride, 1, listOverride);
        tcpOverride.setWidthInCharacters(9);
        tcpOverride.setValidChars("0123456789", false);
        tcpOverride.addStringValidator((p, toValue) -> {
            if (toValue.isEmpty()) {
                return new ParameterValidator.ValidationInfo(true);
            }
            try {
                int portVal = Integer.parseInt(toValue);
                if (portVal >= 0 && portVal <= 65535) {
                    return new ParameterValidator.ValidationInfo(true);
                }
                return new ParameterValidator.ValidationInfo(false, "Must be between 0 and 65535");
            }
            catch (NumberFormatException e) {
                return new ParameterValidator.ValidationInfo(false, e.getMessage());
            }
        });
        this.add(new BooleanParameterImpl("Tracker Client No Port Announce", "ConfigView.label.noportannounce"), 1, listOverride);
        this.add(new IntParameterImpl("Tracker Client Numwant Limit", "ConfigView.label.maxnumwant", 0, 100), 1, listOverride);
        this.add(new IntParameterImpl("Tracker Client Min Announce Interval", "ConfigView.label.minannounce"), 1, listOverride);
        this.add(new BooleanParameterImpl("Tracker Client Smart Activation", "ConfigView.label.trackersmartactivate"), 2, listOverride);
        ParameterGroupImpl pgProtocol = new ParameterGroupImpl("ConfigView.group.override", listOverride);
        this.add("TC.pgProtocol", pgProtocol, new List[0]);
        pgProtocol.setMinimumRequiredUserMode(1);
        this.add(new IntParameterImpl("Tracker Client Connect Timeout", "ConfigView.section.tracker.client.connecttimeout"), 2, new List[0]);
        this.add(new IntParameterImpl("Tracker Client Read Timeout", "ConfigView.section.tracker.client.readtimeout"), 2, new List[0]);
        this.add(new IntParameterImpl("Tracker Client Closedown Timeout", "ConfigView.section.tracker.client.closetimeout"), 2, new List[0]);
        this.add(new IntParameterImpl("Tracker Client Concurrent Announce", "ConfigView.section.tracker.client.conc.announce", 8, 1024), 2, new List[0]);
        this.add(new BooleanParameterImpl("Tracker Key Enable Client", "ConfigView.section.tracker.enablekey"), 2, new List[0]);
        this.add(new BooleanParameterImpl("Tracker Separate Peer IDs", "ConfigView.section.tracker.separatepeerids"), 2, new List[0]);
        LabelParameterImpl paramSepPeerIDInfo = new LabelParameterImpl("ConfigView.section.tracker.separatepeerids.info");
        this.add(paramSepPeerIDInfo, 2, new List[0]);
        paramSepPeerIDInfo.setIndent(1, false);
    }
}

