/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.HyperlinkParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.PasswordParameterImpl;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.util.ArrayList;
import java.util.List;

public class ConfigSectionTrackerServer
extends ConfigSectionImpl {
    public static final String SECTION_ID = "tracker.server";
    private static final int REQUIRED_MODE = 1;
    private ConfigSectionImpl.ConfigDetailsCallback cbIPChecker;
    private ConfigSectionImpl.ConfigDetailsCallback cbCreateCert;
    private ParameterListener trackerI2PHostPortListener;
    private ParameterListener trackerTorHostPortListener;

    public ConfigSectionTrackerServer() {
        super(SECTION_ID, "tracker", 1);
    }

    public void init(ConfigSectionImpl.ConfigDetailsCallback cbIPChecker, ConfigSectionImpl.ConfigDetailsCallback cbCreateCert) {
        this.cbIPChecker = cbIPChecker;
        this.cbCreateCert = cbCreateCert;
    }

    @Override
    public void deleteConfigSection() {
        super.deleteConfigSection();
        if (this.trackerI2PHostPortListener != null) {
            COConfigurationManager.removeParameterListener("Tracker I2P Host Port", this.trackerI2PHostPortListener);
            this.trackerI2PHostPortListener = null;
        }
        if (this.trackerTorHostPortListener != null) {
            COConfigurationManager.removeParameterListener("Tracker Tor Host Port", this.trackerTorHostPortListener);
            this.trackerTorHostPortListener = null;
        }
    }

    @Override
    public void build() {
        this.setDefaultUserModeForAdd(1);
        StringParameterImpl tracker_ip = new StringParameterImpl("Tracker IP", "ConfigView.section.tracker.ip");
        this.add(tracker_ip, new List[0]);
        tracker_ip.setWidthInCharacters(12);
        if (this.cbIPChecker != null) {
            ActionParameterImpl check_button = new ActionParameterImpl(null, "ConfigView.section.tracker.checkip");
            this.add(check_button, new List[0]);
            check_button.addListener(param -> this.cbIPChecker.run(this.mapPluginParams));
            ParameterGroupImpl pgIP = new ParameterGroupImpl(null, tracker_ip, check_button);
            pgIP.setNumberOfColumns(2);
            pgIP.setMinimumRequiredUserMode(1);
            this.add("TS.pgIP", pgIP, new List[0]);
        }
        ArrayList listEnableOnNonSSL = new ArrayList();
        BooleanParameterImpl nonsslEnable = new BooleanParameterImpl("Tracker Port Enable", "ConfigView.section.tracker.port");
        this.add(nonsslEnable, new List[0]);
        IntParameterImpl tracker_port = new IntParameterImpl("Tracker Port", null, 0, 65535);
        this.add(tracker_port, listEnableOnNonSSL);
        StringParameterImpl tracker_port_backup = new StringParameterImpl("Tracker Port Backups", "ConfigView.section.tracker.portbackup");
        this.add(tracker_port_backup, listEnableOnNonSSL);
        tracker_port_backup.setWidthInCharacters(15);
        ArrayList listEnableOnSSL = new ArrayList();
        BooleanParameterImpl sslEnable = new BooleanParameterImpl("Tracker Port SSL Enable", "ConfigView.section.tracker.sslport");
        this.add(sslEnable, new List[0]);
        IntParameterImpl tracker_port_ssl = new IntParameterImpl("Tracker Port SSL", null, 0, 65535);
        this.add(tracker_port_ssl, listEnableOnSSL);
        StringParameterImpl tracker_port_ssl_backup = new StringParameterImpl("Tracker Port SSL Backups", "ConfigView.section.tracker.portbackup");
        this.add(tracker_port_ssl_backup, listEnableOnSSL);
        tracker_port_ssl_backup.setWidthInCharacters(15);
        ParameterGroupImpl pgPorts = new ParameterGroupImpl(null, nonsslEnable, tracker_port, tracker_port_backup, sslEnable, tracker_port_ssl, tracker_port_ssl_backup);
        this.add("TS.pgPorts", pgPorts, new List[0]);
        pgPorts.setMinimumRequiredUserMode(1);
        pgPorts.setNumberOfColumns(3);
        if (this.cbCreateCert != null) {
            ActionParameterImpl cert_button = new ActionParameterImpl("ConfigView.section.tracker.createcert", "ConfigView.section.tracker.createbutton");
            this.add(cert_button, listEnableOnSSL);
            cert_button.addListener(param -> this.cbCreateCert.run(this.mapPluginParams));
            String linkFAQ = "https://plugins.biglybt.com/faq.php#19";
            HyperlinkParameterImpl cert_button_info = new HyperlinkParameterImpl("ConfigView.section.tracker.sslport.info", "https://plugins.biglybt.com/faq.php#19");
            this.add(cert_button_info, listEnableOnSSL);
            ParameterGroupImpl pgCertButton = new ParameterGroupImpl(null, cert_button, cert_button_info);
            this.add("TS.pgCertButton", pgCertButton, new List[0]);
            pgCertButton.setMinimumRequiredUserMode(1);
            pgCertButton.setNumberOfColumns(2);
        }
        sslEnable.addEnabledOnSelection(listEnableOnSSL.toArray(new Parameter[0]));
        BooleanParameterImpl i2p_enable = new BooleanParameterImpl("Tracker I2P Enable", "label.enable.i2p");
        this.add(i2p_enable, listEnableOnNonSSL);
        this.trackerI2PHostPortListener = parameterName -> {
            String val = "http://" + COConfigurationManager.getStringParameter(parameterName) + "/announce";
            i2p_enable.setSuffixLabelText(val);
        };
        COConfigurationManager.addAndFireParameterListener("Tracker I2P Host Port", this.trackerI2PHostPortListener);
        BooleanParameterImpl tor_enable = new BooleanParameterImpl("Tracker Tor Enable", "label.enable.tor");
        this.add(tor_enable, listEnableOnNonSSL);
        this.trackerTorHostPortListener = parameterName -> {
            String val = "http://" + COConfigurationManager.getStringParameter(parameterName) + "/announce";
            tor_enable.setSuffixLabelText(val);
        };
        COConfigurationManager.addAndFireParameterListener("Tracker Tor Host Port", this.trackerTorHostPortListener);
        nonsslEnable.addEnabledOnSelection(listEnableOnNonSSL.toArray(new Parameter[0]));
        BooleanParameterImpl tracker_public_enable = new BooleanParameterImpl("Tracker Public Enable", "ConfigView.section.tracker.publicenable");
        this.add(tracker_public_enable, new List[0]);
        tracker_public_enable.setSuffixLabelText(MessageText.getString("ConfigView.section.tracker.publicenable.info").replaceAll("\n", " "));
        BooleanParameterImpl tracker_public_enable_known_only = new BooleanParameterImpl("Tracker Public Enable Known Only", "ConfigView.section.tracker.publicenableknownonly");
        tracker_public_enable_known_only.setIndent(1, true);
        this.add(tracker_public_enable_known_only, new List[0]);
        tracker_public_enable.addEnabledOnSelection((Parameter)tracker_public_enable_known_only);
        BooleanParameterImpl forcePortDetails = new BooleanParameterImpl("Tracker Port Force External", "ConfigView.section.tracker.forceport");
        this.add(forcePortDetails, new List[0]);
        com.biglybt.pif.ui.config.ParameterListener plForcePortDetails = param -> forcePortDetails.setEnabled(nonsslEnable.getValue() || sslEnable.getValue());
        nonsslEnable.addListener(plForcePortDetails);
        sslEnable.addListener(plForcePortDetails);
        plForcePortDetails.parameterChanged(null);
        this.add(new BooleanParameterImpl("Tracker Host Add Our Announce URLs", "ConfigView.section.tracker.host.addurls"), new List[0]);
        BooleanParameterImpl passwordEnableWeb = new BooleanParameterImpl("Tracker Password Enable Web", "ConfigView.section.tracker.passwordenableweb");
        this.add(passwordEnableWeb, new List[0]);
        BooleanParameterImpl passwordWebHTTPSOnly = new BooleanParameterImpl("Tracker Password Web HTTPS Only", "ConfigView.section.tracker.passwordwebhttpsonly");
        this.add(passwordWebHTTPSOnly, new List[0]);
        passwordWebHTTPSOnly.setIndent(1, true);
        com.biglybt.pif.ui.config.ParameterListener psPasswordWebHTTPSOnly = param -> passwordWebHTTPSOnly.setEnabled(passwordEnableWeb.getValue() && sslEnable.getValue());
        passwordEnableWeb.addListener(psPasswordWebHTTPSOnly);
        sslEnable.addListener(psPasswordWebHTTPSOnly);
        psPasswordWebHTTPSOnly.parameterChanged(null);
        BooleanParameterImpl passwordEnableTorrent = new BooleanParameterImpl("Tracker Password Enable Torrent", "ConfigView.section.tracker.passwordenabletorrent");
        this.add(passwordEnableTorrent, new List[0]);
        passwordEnableTorrent.setSuffixLabelKey("ConfigView.section.tracker.passwordenabletorrent.info");
        StringParameterImpl tracker_username = new StringParameterImpl("Tracker Username", "ConfigView.section.tracker.username");
        this.add(tracker_username, new List[0]);
        tracker_username.setWidthInCharacters(12);
        PasswordParameterImpl tracker_password = new PasswordParameterImpl("Tracker Password", "ConfigView.section.tracker.password", 2);
        this.add(tracker_password, new List[0]);
        tracker_password.setWidthInCharacters(20);
        com.biglybt.pif.ui.config.ParameterListener plEnableNamePW = param -> {
            boolean selected = passwordEnableWeb.getValue() || passwordEnableTorrent.getValue();
            tracker_username.setEnabled(selected);
            tracker_password.setEnabled(selected);
        };
        passwordEnableWeb.addListener(plEnableNamePW);
        passwordEnableTorrent.addListener(plEnableNamePW);
        plEnableNamePW.parameterChanged(null);
        ArrayList listPoll = new ArrayList();
        this.add(new IntParameterImpl("Tracker Poll Interval Min", "ConfigView.section.tracker.pollintervalmin"), listPoll);
        this.add(new IntParameterImpl("Tracker Poll Interval Max", "ConfigView.section.tracker.pollintervalmax"), listPoll);
        this.add(new IntParameterImpl("Tracker Poll Inc By", "ConfigView.section.tracker.pollintervalincby"), listPoll);
        this.add(new IntParameterImpl("Tracker Poll Inc Per", "ConfigView.section.tracker.pollintervalincper"), listPoll);
        ParameterGroupImpl pgPoll = new ParameterGroupImpl("ConfigView.section.tracker.pollinterval", listPoll);
        this.add("TS.pgPoll", pgPoll, new List[0]);
        pgPoll.setNumberOfColumns(2);
        ArrayList listScrapeCache = new ArrayList();
        this.add(new IntParameterImpl("Tracker Scrape Retry Percentage", "ConfigView.section.tracker.announcescrapepercentage"), listScrapeCache);
        this.add(new IntParameterImpl("Tracker Scrape Cache", "ConfigView.section.tracker.scrapecacheperiod"), listScrapeCache);
        this.add(new IntParameterImpl("Tracker Announce Cache Min Peers", "ConfigView.section.tracker.announcecacheminpeers"), listScrapeCache);
        this.add(new IntParameterImpl("Tracker Announce Cache", "ConfigView.section.tracker.announcecacheperiod"), listScrapeCache);
        ParameterGroupImpl pgScrapeCache = new ParameterGroupImpl("ConfigView.section.tracker.scrapeandcache", listScrapeCache);
        this.add("TS.pgScrapeCache", pgScrapeCache, new List[0]);
        pgScrapeCache.setNumberOfColumns(2);
        this.add(new IntParameterImpl("Tracker Max Peers Returned", "ConfigView.section.tracker.maxpeersreturned"), new List[0]);
        IntParameterImpl tracker_max_seeds_retained = new IntParameterImpl("Tracker Max Seeds Retained", "ConfigView.section.tracker.seedretention");
        this.add(tracker_max_seeds_retained, new List[0]);
        tracker_max_seeds_retained.setSuffixLabelKey("ConfigView.section.tracker.seedretention.info");
        this.add(new BooleanParameterImpl("Tracker NAT Check Enable", "ConfigView.section.tracker.natcheckenable"), new List[0]);
        IntParameterImpl tracker_nat_check_timeout = new IntParameterImpl("Tracker NAT Check Timeout", "ConfigView.section.tracker.natchecktimeout");
        this.add(tracker_nat_check_timeout, new List[0]);
        tracker_nat_check_timeout.setMinValue(1);
        tracker_nat_check_timeout.setIndent(1, false);
        this.add(new BooleanParameterImpl("Tracker Send Peer IDs", "ConfigView.section.tracker.sendpeerids"), new List[0]);
        BooleanParameterImpl enable_udp = new BooleanParameterImpl("Tracker Port UDP Enable", "ConfigView.section.tracker.enableudp");
        this.add(enable_udp, new List[0]);
        IntParameterImpl udp_version = new IntParameterImpl("Tracker Port UDP Version", "ConfigView.section.tracker.udpversion");
        this.add(udp_version, new List[0]);
        udp_version.setIndent(1, true);
        enable_udp.addEnabledOnSelection((Parameter)udp_version);
        this.add(new BooleanParameterImpl("Tracker Compact Enable", "ConfigView.section.tracker.enablecompact"), new List[0]);
        BooleanParameterImpl log_enable = new BooleanParameterImpl("Tracker Log Enable", "ConfigView.section.tracker.logenable");
        this.add(log_enable, new List[0]);
        this.add(new BooleanParameterImpl("Tracker Key Enable Server", "ConfigView.section.tracker.enablekey"), 2, new List[0]);
        this.add(new StringParameterImpl("Tracker Banned Clients", "ConfigView.section.tracker.banned.clients"), 2, new List[0]);
        ArrayList listNetworks = new ArrayList();
        this.add(new LabelParameterImpl("ConfigView.section.tracker.server.group.networks.info"), 2, new List[0]);
        int i = 0;
        while (i < AENetworkClassifier.AT_NETWORKS.length) {
            String nn = AENetworkClassifier.AT_NETWORKS[i];
            String config_name = "Tracker Network Selection Default." + nn;
            String msg_text = "ConfigView.section.connection.networks." + nn;
            this.add(new BooleanParameterImpl(config_name, msg_text), 2, listNetworks);
            ++i;
        }
        this.add(new ParameterGroupImpl("ConfigView.section.tracker.server.group.networks", listNetworks), 2, new List[0]);
        ArrayList listProcessing = new ArrayList();
        IntParameterImpl tracker_max_get_time = new IntParameterImpl("Tracker Max GET Time", "ConfigView.section.tracker.maxgettime");
        this.add(tracker_max_get_time, 2, listProcessing);
        tracker_max_get_time.setSuffixLabelKey("ConfigView.section.tracker.maxgettime.info");
        IntParameterImpl tracker_max_post_time_multiplier = new IntParameterImpl("Tracker Max POST Time Multiplier", "ConfigView.section.tracker.maxposttimemultiplier");
        this.add(tracker_max_post_time_multiplier, 2, listProcessing);
        tracker_max_post_time_multiplier.setSuffixLabelKey("ConfigView.section.tracker.maxposttimemultiplier.info");
        this.add(new IntParameterImpl("Tracker Max Threads", "ConfigView.section.tracker.maxthreads", 1, 4096), 2, listProcessing);
        this.add(new ParameterGroupImpl("ConfigView.section.tracker.processinglimits", listProcessing), 2, new List[0]);
        BooleanParameterImpl nb_enable = new BooleanParameterImpl("Tracker TCP NonBlocking", "ConfigView.section.tracker.tcpnonblocking");
        this.add(nb_enable, 2, new List[0]);
        IntParameterImpl maxConcConn = new IntParameterImpl("Tracker TCP NonBlocking Conc Max", "ConfigView.section.tracker.nonblockingconcmax");
        this.add(maxConcConn, 2, new List[0]);
        nb_enable.addEnabledOnSelection((Parameter)maxConcConn);
        this.add(new ParameterGroupImpl("ConfigView.section.tracker.nonblocking", nb_enable, maxConcConn), 2, new List[0]);
    }
}

