/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.speedmanager.LimitToTextHelper;
import com.biglybt.core.speedmanager.SpeedManager;
import com.biglybt.core.speedmanager.SpeedManagerLimitEstimate;
import com.biglybt.core.speedmanager.SpeedManagerListener;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.HyperlinkParameterImpl;
import com.biglybt.pifimpl.local.ui.config.InfoParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntListParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.StringListParameterImpl;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.util.ArrayList;
import java.util.List;

public class ConfigSectionTransferAutoSpeedSelect
extends ConfigSectionImpl {
    public static final String SECTION_ID = "transfer.select";
    private SpeedManager sm;
    private SpeedManagerListener smListener;

    public ConfigSectionTransferAutoSpeedSelect() {
        super(SECTION_ID, "transfer");
    }

    @Override
    public void deleteConfigSection() {
        super.deleteConfigSection();
        if (this.sm != null && this.smListener != null) {
            this.sm.removeListener(this.smListener);
            this.smListener = null;
            this.sm = null;
        }
    }

    @Override
    public void build() {
        this.sm = CoreFactory.getSingleton().getSpeedManager();
        if (this.sm == null) {
            return;
        }
        String AutoSpeedClassic = MessageText.getString("ConfigTransferAutoSpeed.auto.speed.classic");
        String AutoSpeedBeta = MessageText.getString("ConfigTransferAutoSpeed.auto.speed.beta");
        String[] modeNames = new String[]{AutoSpeedClassic, AutoSpeedBeta};
        int[] modes = new int[]{1, 2};
        IntListParameterImpl versionList = new IntListParameterImpl("Auto Upload Speed Version", "ConfigTransferAutoSpeed.algorithm", modes, modeNames);
        this.add(versionList, new List[0]);
        BooleanParameterImpl enableAutoSpeed = new BooleanParameterImpl("Auto Upload Speed Enabled", "ConfigView.section.transfer.autospeed.enableauto");
        this.add(enableAutoSpeed, new List[0]);
        BooleanParameterImpl enableAutoSpeedWhileSeeding = new BooleanParameterImpl("Auto Upload Speed Seeding Enabled", "ConfigView.section.transfer.autospeed.enableautoseeding");
        this.add(enableAutoSpeedWhileSeeding, new List[0]);
        enableAutoSpeed.addDisabledOnSelection((Parameter)enableAutoSpeedWhileSeeding);
        this.add("TASS.pgSelector", new ParameterGroupImpl("ConfigTransferAutoSpeed.algorithm.selector", enableAutoSpeed, enableAutoSpeedWhileSeeding, versionList), new List[0]);
        ArrayList listNetwork = new ArrayList();
        LimitToTextHelper limit_to_text = new LimitToTextHelper();
        InfoParameterImpl paramASN = new InfoParameterImpl(null, "SpeedView.stats.asn", this.sm.getASN());
        this.add(paramASN, listNetwork);
        InfoParameterImpl paramEstUp = new InfoParameterImpl(null, "SpeedView.stats.estupcap", limit_to_text.getLimitText(this.sm.getEstimatedUploadCapacityBytesPerSec()));
        this.add(paramEstUp, listNetwork);
        InfoParameterImpl paramEstDown = new InfoParameterImpl(null, "SpeedView.stats.estdowncap", limit_to_text.getLimitText(this.sm.getEstimatedDownloadCapacityBytesPerSec()));
        this.add(paramEstDown, listNetwork);
        this.add("s0", new LabelParameterImpl(""), listNetwork);
        LabelParameterImpl info_label = new LabelParameterImpl("");
        this.add("tass.info", info_label, listNetwork);
        info_label.setLabelText(MessageText.getString("ConfigView.section.transfer.autospeed.network.info", new String[]{DisplayFormatters.getRateUnit(1)}));
        String co_up = "AutoSpeed Network Upload Speed (temp)";
        String co_up_type = "AutoSpeed Network Upload Speed Type (temp)";
        int kinb = DisplayFormatters.getKinB();
        SpeedManagerLimitEstimate up_lim = this.sm.getEstimatedUploadCapacityBytesPerSec();
        COConfigurationManager.setParameter(co_up, up_lim.getBytesPerSec() / kinb);
        COConfigurationManager.setParameter(co_up_type, limit_to_text.getSettableType(up_lim));
        IntParameterImpl max_upload = new IntParameterImpl(co_up, "SpeedView.stats.estupcap");
        this.add(max_upload, new List[0]);
        StringListParameterImpl max_upload_type = new StringListParameterImpl(co_up_type, null, limit_to_text.getSettableTypes(), limit_to_text.getSettableTypes());
        this.add(max_upload_type, new List[0]);
        max_upload_type.setLabelText(this.getMBitLimit(limit_to_text, up_lim.getBytesPerSec() / kinb * kinb));
        max_upload_type.addListener(p -> {
            float type = limit_to_text.textToType(max_upload_type.getValue());
            SpeedManagerLimitEstimate existing = this.sm.getEstimatedUploadCapacityBytesPerSec();
            if (existing.getEstimateType() != type) {
                this.sm.setEstimatedUploadCapacityBytesPerSec(existing.getBytesPerSec(), type);
            }
        });
        max_upload.addListener(p -> {
            int value = max_upload.getValue() * kinb;
            SpeedManagerLimitEstimate existing = this.sm.getEstimatedUploadCapacityBytesPerSec();
            if (existing.getBytesPerSec() != value) {
                this.sm.setEstimatedUploadCapacityBytesPerSec(value, existing.getEstimateType());
            }
        });
        SpeedManagerLimitEstimate down_lim = this.sm.getEstimatedDownloadCapacityBytesPerSec();
        String co_down = "AutoSpeed Network Download Speed (temp)";
        String co_down_type = "AutoSpeed Network Download Speed Type (temp)";
        COConfigurationManager.setParameter(co_down, down_lim.getBytesPerSec() / kinb);
        COConfigurationManager.setParameter(co_down_type, limit_to_text.getSettableType(down_lim));
        IntParameterImpl max_download = new IntParameterImpl(co_down, "SpeedView.stats.estdowncap");
        this.add(max_download, new List[0]);
        StringListParameterImpl max_download_type = new StringListParameterImpl(co_down_type, null, limit_to_text.getSettableTypes(), limit_to_text.getSettableTypes());
        this.add(max_download_type, new List[0]);
        max_download_type.setLabelText(this.getMBitLimit(limit_to_text, down_lim.getBytesPerSec() / kinb * kinb));
        max_download_type.addListener(p -> {
            float type = limit_to_text.textToType(max_download_type.getValue());
            SpeedManagerLimitEstimate existing = this.sm.getEstimatedDownloadCapacityBytesPerSec();
            if (existing.getEstimateType() != type) {
                this.sm.setEstimatedDownloadCapacityBytesPerSec(existing.getBytesPerSec(), type);
            }
        });
        max_download.addListener(p -> {
            int value = max_download.getValue() * kinb;
            SpeedManagerLimitEstimate existing = this.sm.getEstimatedDownloadCapacityBytesPerSec();
            if (existing.getBytesPerSec() != value) {
                this.sm.setEstimatedDownloadCapacityBytesPerSec(value, existing.getEstimateType());
            }
        });
        ParameterGroupImpl pgNetworkLimits = new ParameterGroupImpl(null, max_download, max_download_type, max_upload, max_upload_type).setNumberOfColumns2(2);
        this.add("TASS.pgNetworkLimits", pgNetworkLimits, listNetwork);
        pgNetworkLimits.setIndent(1, false);
        ActionParameterImpl reset_button = new ActionParameterImpl("ConfigView.section.transfer.autospeed.resetnetwork", "ConfigView.section.transfer.autospeed.reset.button");
        this.add(reset_button, listNetwork);
        reset_button.addListener(param -> this.sm.reset());
        this.smListener = property -> {
            if (property == 1) {
                paramASN.setValue(this.sm.getASN());
            } else if (property == 2) {
                SpeedManagerLimitEstimate limit = this.sm.getEstimatedUploadCapacityBytesPerSec();
                paramEstUp.setValue(limit_to_text.getLimitText(limit));
                max_upload_type.setLabelText(this.getMBitLimit(limit_to_text, limit.getBytesPerSec()));
                max_upload.setValue(limit.getBytesPerSec() / kinb);
                max_upload_type.setValue(limit_to_text.getSettableType(limit));
            } else if (property == 3) {
                SpeedManagerLimitEstimate limit = this.sm.getEstimatedDownloadCapacityBytesPerSec();
                paramEstDown.setValue(limit_to_text.getLimitText(limit));
                max_download_type.setLabelText(this.getMBitLimit(limit_to_text, limit.getBytesPerSec()));
                max_download.setValue(limit.getBytesPerSec() / kinb);
                max_download_type.setValue(limit_to_text.getSettableType(limit));
            }
        };
        this.sm.addListener(this.smListener);
        ParameterGroupImpl pgNetworks = new ParameterGroupImpl("ConfigView.section.transfer.autospeed.networks", listNetwork);
        this.add("TASS.pgNetworks", pgNetworks, new List[0]);
        BooleanParameterImpl debug_au = new BooleanParameterImpl("Auto Upload Speed Debug Enabled", "ConfigView.section.transfer.autospeed.enabledebug");
        this.add(debug_au, new List[0]);
        this.add("s1", new LabelParameterImpl(""), new List[0]);
        this.add(new HyperlinkParameterImpl("!" + Constants.APP_NAME + " Wiki AutoSpeed (beta)!", "Utils.link.visit", "https://wiki.biglybt.com/w/Auto_Speed"), new List[0]);
    }

    protected String getMBitLimit(LimitToTextHelper helper, long value) {
        return "(" + (value == 0L ? helper.getUnlimited() : DisplayFormatters.formatByteCountToBitsPerSec2(value)) + ")";
    }
}

