/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console;

import com.biglybt.core.Core;
import com.biglybt.core.CoreComponent;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.logging.ILogAlertListener;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.torrentdownloader.TorrentDownloader;
import com.biglybt.core.torrentdownloader.TorrentDownloaderFactory;
import com.biglybt.core.torrentdownloader.impl.TorrentDownloaderManager;
import com.biglybt.core.util.AEDiagnosticsLogger;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManager;
import com.biglybt.pif.installer.InstallablePlugin;
import com.biglybt.pif.installer.PluginInstallerListener;
import com.biglybt.pif.update.Update;
import com.biglybt.pif.update.UpdateCheckInstance;
import com.biglybt.pif.update.UpdateCheckInstanceListener;
import com.biglybt.pif.update.UpdateManager;
import com.biglybt.ui.common.UIConst;
import com.biglybt.ui.console.CommandReader;
import com.biglybt.ui.console.UserProfile;
import com.biglybt.ui.console.commands.AddFind;
import com.biglybt.ui.console.commands.Alias;
import com.biglybt.ui.console.commands.Archive;
import com.biglybt.ui.console.commands.Config;
import com.biglybt.ui.console.commands.Create;
import com.biglybt.ui.console.commands.Hack;
import com.biglybt.ui.console.commands.IConsoleCommand;
import com.biglybt.ui.console.commands.Move;
import com.biglybt.ui.console.commands.Pairing;
import com.biglybt.ui.console.commands.Plugin;
import com.biglybt.ui.console.commands.Priority;
import com.biglybt.ui.console.commands.RunState;
import com.biglybt.ui.console.commands.Set;
import com.biglybt.ui.console.commands.Share;
import com.biglybt.ui.console.commands.Show;
import com.biglybt.ui.console.commands.Subscriptions;
import com.biglybt.ui.console.commands.Tags;
import com.biglybt.ui.console.commands.TorrentArchive;
import com.biglybt.ui.console.commands.TorrentCheck;
import com.biglybt.ui.console.commands.TorrentForceStart;
import com.biglybt.ui.console.commands.TorrentHost;
import com.biglybt.ui.console.commands.TorrentLog;
import com.biglybt.ui.console.commands.TorrentPublish;
import com.biglybt.ui.console.commands.TorrentQueue;
import com.biglybt.ui.console.commands.TorrentRemove;
import com.biglybt.ui.console.commands.TorrentStart;
import com.biglybt.ui.console.commands.TorrentStop;
import com.biglybt.ui.console.commands.XML;
import com.biglybt.ui.console.util.TextWrap;
import com.biglybt.update.CorePatchChecker;
import com.biglybt.update.UpdaterUpdateChecker;
import com.biglybt.util.InitialisationFunctions;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class ConsoleInput
extends Thread {
    private static final String ALIASES_CONFIG_FILE = "console.aliases.properties";
    public final Core core;
    public volatile PrintStream out;
    private RedirectOutputStream current_ros;
    public final List torrents = new ArrayList();
    public File[] adds = null;
    private final CommandReader br;
    private final boolean controlling;
    protected boolean running;
    private final Vector oldcommand = new Vector();
    private static final List pluginCommands = new ArrayList();
    public final Properties aliases = new Properties();
    private final Map commands = new LinkedHashMap();
    private final List helpItems = new ArrayList();
    private final UserProfile userProfile;
    private final List<LogEvent> errorLogEvents = new ArrayList<LogEvent>();
    private int numNewErrorLogEvents = 0;
    private boolean waitingForInput = false;

    public static void registerPluginCommand(Class clazz) {
        if (!IConsoleCommand.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class must implement IConsoleCommand");
        }
        pluginCommands.add(clazz);
    }

    public static void unregisterPluginCommand(Class clazz) {
        pluginCommands.remove(clazz);
    }

    public ConsoleInput(String con, Core _core, Reader _in, PrintStream _out, Boolean _controlling) {
        this(con, _core, _in, _out, _controlling, UserProfile.DEFAULT_USER_PROFILE);
    }

    public ConsoleInput(String con, Core _core, Reader _in, PrintStream _out, Boolean _controlling, UserProfile profile) {
        super("Console Input: " + con);
        this.out = _out;
        this.core = _core;
        this.userProfile = profile;
        this.controlling = _controlling;
        this.br = new CommandReader(_in);
        Logger.addListener(event2 -> {
            if (event2.entryType == 3) {
                this.errorLogEvents.add(event2);
                if (this.waitingForInput && this.numNewErrorLogEvents == 0) {
                    System.out.println("New error(s) logged. Use `show errors` to view.");
                }
                ++this.numNewErrorLogEvents;
            }
        });
        this.initialise();
        this.start();
    }

    public ConsoleInput(Core core, PrintStream _out) {
        super("");
        this.out = _out;
        this.core = core;
        this.userProfile = UserProfile.DEFAULT_USER_PROFILE;
        this.controlling = false;
        this.br = new CommandReader(new InputStreamReader(new ByteArrayInputStream(new byte[0])));
        this.initialise();
    }

    protected void initialise() {
        this.registerAlertHandler();
        this.registerCommands();
        this.registerPluginCommands();
        if (this.controlling) {
            this.setDaemon(true);
        }
        if (this.core != null) {
            if (this.controlling) {
                this.core.addLifecycleListener(new CoreLifecycleAdapter(){

                    @Override
                    public void componentCreated(Core core, CoreComponent component) {
                        if (component instanceof GlobalManager) {
                            InitialisationFunctions.earlyInitialisation(core);
                        }
                    }

                    @Override
                    public void started(Core core) {
                        ConsoleInput.this.registerUpdateChecker();
                        InitialisationFunctions.lateInitialisation(core);
                    }
                });
            }
            try {
                this.loadAliases();
            }
            catch (IOException e) {
                this.out.println("Error while loading aliases: " + e.getMessage());
            }
        }
        this.oldcommand.add("sh");
        this.oldcommand.add("t");
    }

    public void downloadTorrent(String filename, String outputDir) {
        DownloadManager manager = this.core.getGlobalManager().addDownloadManager(filename, outputDir);
        manager.getDownloadState().setAttribute("user", this.getUserProfile().getUsername());
    }

    public void downloadRemoteTorrent(String url, final String outputDir) {
        TorrentDownloaderManager torrentDownloaderManager = TorrentDownloaderManager.getInstance();
        torrentDownloaderManager.getClass();
        TorrentDownloader downloader = TorrentDownloaderFactory.create(new TorrentDownloaderManager.Callback(torrentDownloaderManager){

            @Override
            public void TorrentDownloaderEvent(int state, TorrentDownloader inf) {
                if (state == 3) {
                    ConsoleInput.this.out.println("Torrent file download complete. Starting torrent");
                    TorrentDownloaderManager.getInstance().remove(inf);
                    ConsoleInput.this.downloadTorrent(inf.getFile().getAbsolutePath(), outputDir);
                } else {
                    if (state == 4) {
                        ConsoleInput.this.out.println("Torrent file download failed: " + inf.getError());
                    }
                    super.TorrentDownloaderEvent(state, inf);
                }
            }
        }, url, null, null, null);
        TorrentDownloaderManager.getInstance().add(downloader);
    }

    public void downloadTorrent(String fileName) {
        this.downloadTorrent(fileName, this.getDefaultSaveDirectory());
    }

    public void downloadRemoteTorrent(String url) {
        this.downloadRemoteTorrent(url, this.getDefaultSaveDirectory());
    }

    private void registerPluginCommands() {
        for (Class clazz : pluginCommands) {
            try {
                IConsoleCommand command = (IConsoleCommand)clazz.newInstance();
                this.registerCommand(command);
            }
            catch (InstantiationException e) {
                this.out.println("Error while registering plugin command: " + clazz.getName() + ":" + e.getMessage());
            }
            catch (IllegalAccessException e) {
                this.out.println("Error while registering plugin command: " + clazz.getName() + ":" + e.getMessage());
            }
        }
    }

    protected void registerAlertHandler() {
        Logger.addListener(new ILogAlertListener(){
            private java.util.Set history = Collections.synchronizedSet(new HashSet());

            @Override
            public void alertRaised(LogAlert alert) {
                if (!alert.repeatable) {
                    if (this.history.contains(alert.text)) {
                        return;
                    }
                    this.history.add(alert.text);
                }
                ConsoleInput.this.out.println(alert.text);
                if (alert.err != null) {
                    alert.err.printStackTrace(ConsoleInput.this.out);
                }
            }
        });
    }

    protected void registerCommands() {
        this.registerCommand(new XML());
        this.registerCommand(new Hack());
        this.registerCommand(new AddFind());
        this.registerCommand(new Create());
        this.registerCommand(new TorrentCheck());
        this.registerCommand(new TorrentQueue());
        this.registerCommand(new TorrentRemove());
        this.registerCommand(new TorrentArchive());
        this.registerCommand(new TorrentStart());
        this.registerCommand(new TorrentStop());
        this.registerCommand(new TorrentHost());
        this.registerCommand(new TorrentPublish());
        this.registerCommand(new TorrentForceStart());
        this.registerCommand(new TorrentLog());
        this.registerCommand(new Move());
        this.registerCommand(new RunState());
        this.registerCommand(new Share());
        this.registerCommand(new Set());
        this.registerCommand(new Show());
        this.registerCommand(new CommandUI());
        this.registerCommand(new CommandLogout());
        this.registerCommand(new CommandQuit());
        this.registerCommand(new CommandHelp());
        this.registerCommand(new CommandEcho());
        this.registerCommand(new CommandLogging());
        this.registerCommand(new Alias());
        this.registerCommand(new Priority());
        this.registerCommand(new Plugin());
        this.registerCommand(new Pairing());
        this.registerCommand(new Archive());
        this.registerCommand(new Config());
        try {
            this.registerCommand(new Subscriptions());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.registerCommand(new Tags());
    }

    protected void registerCommand(IConsoleCommand command) {
        for (String cmdName : command.getCommandNames()) {
            this.commands.put(cmdName, command);
        }
        this.helpItems.add(command);
    }

    protected void unregisterCommand(IConsoleCommand command) {
        for (String cmdName : command.getCommandNames()) {
            if (!command.equals(this.commands.get(cmdName))) continue;
            this.commands.remove(cmdName);
        }
        this.helpItems.remove(command);
    }

    protected void unregisterCommand(String commandName) {
        IConsoleCommand cmd = (IConsoleCommand)this.commands.get(commandName);
        if (cmd == null) {
            return;
        }
        int numCommands = 0;
        for (Map.Entry entry : this.commands.entrySet()) {
            if (!cmd.equals(entry.getValue())) continue;
            ++numCommands;
        }
        if (numCommands == 1) {
            this.unregisterCommand(cmd);
        } else {
            this.commands.remove(commandName);
        }
    }

    public ConsoleInput(String con, Core _core, InputStream _in, PrintStream _out, Boolean _controlling) {
        this(con, _core, new InputStreamReader(_in), _out, _controlling);
    }

    private void quit(boolean finish) {
        if (finish && this.core != null) {
            this.core.stop();
        }
    }

    public void printwelcome() {
        this.out.println("Running " + Constants.APP_NAME + " " + "3.4.0.0" + "...");
        this.out.println("Using configuration settings from:");
        this.out.println("  " + SystemProperties.getUserPath());
    }

    public void printconsolehelp() {
        this.printconsolehelp(this.out);
    }

    private void printconsolehelp(PrintStream os) {
        os.println("> -----");
        os.println("Available console commands (use help <command> for more details):");
        os.println();
        ArrayList<String> cmd_lines = new ArrayList<String>();
        Iterator itr = this.helpItems.iterator();
        while (itr.hasNext()) {
            StringBuilder line_so_far = new StringBuilder("[");
            IConsoleCommand cmd = (IConsoleCommand)itr.next();
            String short_name = cmd.getShortCommandName();
            if (short_name != null) {
                line_so_far.append(short_name);
            }
            line_so_far.append("] ");
            line_so_far.append(cmd.getCommandName());
            cmd_lines.add(line_so_far.toString());
        }
        TextWrap.printList(cmd_lines.iterator(), os, "   ");
        os.println("> -----");
    }

    public boolean invokeCommand(String command, List cargs) {
        if (command.startsWith("\\")) {
            command = command.substring(1);
        } else if (this.aliases.containsKey(command)) {
            List list = this.br.parseCommandLine(this.aliases.getProperty(command));
            String newCommand = list.remove(0).toString().toLowerCase();
            list.addAll(cargs);
            return this.invokeCommand(newCommand, list);
        }
        if (this.commands.containsKey(command)) {
            IConsoleCommand cmd = (IConsoleCommand)this.commands.get(command);
            try {
                if (cargs == null) {
                    cargs = new ArrayList<String>();
                }
                cmd.execute(command, this, cargs);
                return true;
            }
            catch (Exception e) {
                this.out.println("> Invoking Command '" + command + "' failed. Exception: " + Debug.getNestedExceptionMessage(e) + "; " + Debug.getCompressedStackTrace(e, 0, 5, false));
                return false;
            }
        }
        return false;
    }

    @Override
    public void run() {
        this.running = true;
        PrintStream originalOutputStream = this.out;
        PrintStream redirectOutputStream = null;
        while (this.running) {
            PrintStream temp;
            String command;
            Object temp2;
            List comargs;
            if (this.numNewErrorLogEvents > 0) {
                System.out.println(String.valueOf(this.numNewErrorLogEvents) + " new errors logged. Use `show errors` to view.");
                this.numNewErrorLogEvents = 0;
            }
            try {
                this.out.flush();
                this.waitingForInput = true;
                String line = this.br.readLine();
                this.waitingForInput = false;
                if (redirectOutputStream != null) {
                    redirectOutputStream.println("> " + line);
                }
                comargs = this.br.parseCommandLine(line);
            }
            catch (Exception e) {
                this.out.println("> Stopping console input reader because of exception: " + e.getMessage());
                this.running = false;
                this.waitingForInput = false;
                break;
            }
            if (!comargs.isEmpty()) {
                RedirectOutputStream ros = this.current_ros;
                if (ros != null) {
                    ros.requestTimeStamp();
                }
                if (comargs.size() > 0 && ((String)comargs.get(0)).equalsIgnoreCase("logging")) {
                    comargs.remove(0);
                    if (comargs.isEmpty()) {
                        this.out.println("> Missing subcommand for 'logging'");
                    }
                }
            }
            if (comargs.isEmpty()) continue;
            int argNum = comargs.size();
            File thisCommandoutputFile = null;
            boolean thisCommandoutputFileAppend = false;
            if (argNum == 1 && ((String)comargs.get(0)).equals(">$")) {
                if (redirectOutputStream != null) {
                    redirectOutputStream.close();
                    this.out = originalOutputStream;
                    this.out.println("> Output is no longer being copied to file");
                    continue;
                }
                this.out.println("> '>$' used when not copying output");
                continue;
            }
            if (argNum >= 2) {
                File outputFile = null;
                boolean outputFileAppend = false;
                temp2 = (String)comargs.get(argNum - 2);
                if (((String)temp2).equals(">") || ((String)temp2).equals(">>")) {
                    File file = new File((String)comargs.get(argNum - 1));
                    if (!file.getParentFile().canWrite()) {
                        this.out.println("> Invalid output file '" + file + "'");
                        continue;
                    }
                    outputFile = file;
                    outputFileAppend = ((String)temp2).equals(">>");
                    comargs = comargs.subList(0, argNum - 2);
                }
                if (comargs.isEmpty()) {
                    if (redirectOutputStream != null) {
                        redirectOutputStream.close();
                        redirectOutputStream = null;
                        this.out = originalOutputStream;
                    }
                    try {
                        PrintStream redirect;
                        RedirectOutputStream ros = new RedirectOutputStream(new FileOutputStream(outputFile, outputFileAppend), this.out);
                        redirectOutputStream = redirect = new PrintStream(new BufferedOutputStream(ros, 128));
                        this.current_ros = ros;
                        this.out = redirectOutputStream;
                        this.out.println("> Copying output to " + outputFile + ". Use '>$' to stop");
                        continue;
                    }
                    catch (Throwable e) {
                        this.out.println("Exception occurred when opening output file");
                    }
                } else {
                    thisCommandoutputFile = outputFile;
                    thisCommandoutputFileAppend = outputFileAppend;
                }
            }
            if (".".equals(command = ((String)comargs.get(0)).toLowerCase())) {
                if (this.oldcommand.size() > 0) {
                    comargs.clear();
                    comargs.addAll(this.oldcommand);
                    command = ((String)comargs.get(0)).toLowerCase();
                } else {
                    this.out.println("> No old command. Remove commands are not repeated to prevent errors");
                }
            }
            this.oldcommand.clear();
            this.oldcommand.addAll(comargs);
            comargs.remove(0);
            PrintStream base_os = null;
            try {
                try {
                    if (thisCommandoutputFile != null) {
                        temp2 = new PrintStream(new BufferedOutputStream(new FileOutputStream(thisCommandoutputFile, thisCommandoutputFileAppend), 128));
                        base_os = this.out;
                        this.out = temp2;
                    }
                    if (!this.invokeCommand(command, comargs)) {
                        this.out.println("> Command '" + command + "' unknown (or . used without prior command)");
                    }
                    this.out.flush();
                }
                catch (Throwable e) {
                    this.out.println("Exception occurred when executing command: '" + command + "'");
                    e.printStackTrace(this.out);
                    if (base_os == null) continue;
                    try {
                        temp = this.out;
                        this.out = base_os;
                        temp.close();
                    }
                    catch (Throwable e2) {
                        this.out.println("Exception occurred when closing output file");
                        e2.printStackTrace(this.out);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (base_os != null) {
                    try {
                        temp = this.out;
                        this.out = base_os;
                        temp.close();
                    }
                    catch (Throwable e) {
                        this.out.println("Exception occurred when closing output file");
                        e.printStackTrace(this.out);
                    }
                }
                throw throwable;
            }
            if (base_os == null) continue;
            try {
                temp = this.out;
                this.out = base_os;
                temp.close();
            }
            catch (Throwable e) {
                this.out.println("Exception occurred when closing output file");
                e.printStackTrace(this.out);
            }
        }
    }

    private File getAliasesFile() {
        PluginInterface pi = this.core.getPluginManager().getDefaultPluginInterface();
        String userDir = pi.getUtilities().getUserDir();
        return new File(userDir, ALIASES_CONFIG_FILE);
    }

    private void loadAliases() throws IOException {
        File aliasesFile = this.getAliasesFile();
        this.out.println("Attempting to load aliases from: " + aliasesFile.getCanonicalPath());
        if (aliasesFile.exists()) {
            this.aliases.clear();
            try (FileInputStream fr = new FileInputStream(aliasesFile);){
                this.aliases.load(fr);
            }
        }
    }

    public void saveAliases() {
        File aliasesFile = this.getAliasesFile();
        try {
            this.out.println("Saving aliases to: " + aliasesFile.getCanonicalPath());
            try (FileOutputStream fo = new FileOutputStream(aliasesFile);){
                this.aliases.store(fo, "This aliases file was automatically written by BiglyBT");
            }
        }
        catch (IOException e) {
            this.out.println("> Error saving aliases to " + aliasesFile.getPath() + ":" + e.getMessage());
        }
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public String getDefaultSaveDirectory() {
        try {
            String saveDir = this.getUserProfile().getDefaultSaveDirectory();
            if (saveDir == null && ((saveDir = COConfigurationManager.getDirectoryParameter("Default save path")) == null || saveDir.length() == 0)) {
                saveDir = ".";
            }
            return saveDir;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ".";
        }
    }

    protected void registerUpdateChecker() {
        boolean check_at_start = COConfigurationManager.getBooleanParameter("update.start", true);
        if (!check_at_start) {
            return;
        }
        PluginManager pm = this.core.getPluginManager();
        pm.getPluginInstaller().addListener(new PluginInstallerListener(){

            @Override
            public boolean installRequest(String reason, InstallablePlugin plugin) throws PluginException {
                ConsoleInput.this.out.println("Plugin installation request for '" + plugin.getName() + "' - " + reason);
                String desc = plugin.getDescription();
                String[] bits = desc.split("\n");
                int i = 0;
                while (i < bits.length) {
                    ConsoleInput.this.out.println("\t" + bits[i]);
                    ++i;
                }
                return true;
            }
        });
        PluginInterface pi = pm.getPluginInterfaceByClass(CorePatchChecker.class);
        if (pi != null) {
            pi.getPluginState().setDisabled(true);
        }
        if ((pi = pm.getPluginInterfaceByClass(UpdaterUpdateChecker.class)) != null) {
            pi.getPluginState().setDisabled(true);
        }
        UpdateManager update_manager = this.core.getPluginManager().getDefaultPluginInterface().getUpdateManager();
        final UpdateCheckInstance checker = update_manager.createUpdateCheckInstance();
        checker.addListener(new UpdateCheckInstanceListener(){

            @Override
            public void cancelled(UpdateCheckInstance instance) {
            }

            @Override
            public void complete(UpdateCheckInstance instance) {
                int num_updates = 0;
                Update[] updates = instance.getUpdates();
                int i = 0;
                while (i < updates.length) {
                    Update update = updates[i];
                    ++num_updates;
                    ConsoleInput.this.out.println("Update available for '" + update.getName() + "', new version = " + update.getNewVersion());
                    String[] descs = update.getDescription();
                    int j = 0;
                    while (j < descs.length) {
                        ConsoleInput.this.out.println("\t" + descs[j]);
                        ++j;
                    }
                    if (update.isMandatory()) {
                        ConsoleInput.this.out.println("**** This is a mandatory update, other updates can not proceed until this is performed ****");
                    }
                    ++i;
                }
                checker.cancel();
                if (num_updates > 0) {
                    ConsoleInput.this.out.println("Apply these updates with the 'plugin update' command");
                }
            }
        });
        checker.start();
    }

    public Core getCore() {
        return this.core;
    }

    public GlobalManager getGlobalManager() {
        return this.core.getGlobalManager();
    }

    public List<LogEvent> getErrorLogEvents() {
        ArrayList<LogEvent> logEvents = new ArrayList<LogEvent>(this.errorLogEvents);
        this.errorLogEvents.clear();
        this.numNewErrorLogEvents = 0;
        return logEvents;
    }

    private class CommandEcho
    extends IConsoleCommand {
        public CommandEcho() {
            super("echo");
        }

        @Override
        public String getCommandDescriptions() {
            return "echo [args]\t\t\t?\tEchos its arguments";
        }

        @Override
        public void execute(String commandName, ConsoleInput ci, List<String> args) {
            String str = "";
            for (String arg : args) {
                str = String.valueOf(str) + (str.isEmpty() ? "" : " ") + args;
            }
            ci.out.println(str);
        }
    }

    private class CommandHelp
    extends IConsoleCommand {
        public CommandHelp() {
            super("help", "?");
        }

        @Override
        public String getCommandDescriptions() {
            return "help [torrents]\t\t\t?\tShow this help. 'torrents' shows info about the show torrents display.";
        }

        public void execute(String commandName, ConsoleInput ci, List args) {
            if (args.isEmpty()) {
                ConsoleInput.this.printconsolehelp(ci.out);
            } else {
                String subcommand = (String)args.get(0);
                IConsoleCommand cmd = (IConsoleCommand)ConsoleInput.this.commands.get(subcommand);
                if (cmd != null) {
                    ArrayList<String> newargs = new ArrayList<String>(args);
                    newargs.remove(0);
                    cmd.printHelp(ci.out, newargs);
                } else if (subcommand.equalsIgnoreCase("torrents") || subcommand.equalsIgnoreCase("t")) {
                    ci.out.println("> -----");
                    ci.out.println("# [state] PercentDone Name (Filesize) ETA\r\n\tDownSpeed / UpSpeed\tDownloaded/Uploaded\tConnectedSeeds(total) / ConnectedPeers(total)");
                    ci.out.println();
                    ci.out.println("States:");
                    ci.out.println(" > Downloading");
                    ci.out.println(" * Seeding");
                    ci.out.println(" ! Stopped");
                    ci.out.println(" . Waiting (for allocation/checking)");
                    ci.out.println(" : Ready");
                    ci.out.println(" - Queued");
                    ci.out.println(" A Allocating");
                    ci.out.println(" C Checking");
                    ci.out.println(" E Error");
                    ci.out.println(" I Initializing");
                    ci.out.println(" ? Unknown");
                    ci.out.println("> -----");
                } else {
                    ConsoleInput.this.printconsolehelp(ci.out);
                }
            }
        }
    }

    private class CommandLogging
    extends IConsoleCommand {
        public CommandLogging() {
            super("logging");
        }

        @Override
        public String getCommandDescriptions() {
            return "logging [options]";
        }

        public void printHelpExtra(PrintStream out, List args) {
            out.println("> -----");
            out.println("Subcommands:");
            out.println("    > <file_name>    Log all console input/output to <file_name>");
            out.println("    >> <file_name>   Append all console input/output to <file_name>");
            out.println("    >$               Stop logging");
            out.println("Note:");
            out.println("    Any command can have its output sent to a file by using a suffix of '> <file_name>' or '>> <file_name>'");
            out.println("> -----");
        }

        @Override
        public void execute(String commandName, ConsoleInput ci, List<String> args) {
        }
    }

    private static class CommandLogout
    extends IConsoleCommand {
        public CommandLogout() {
            super("logout");
        }

        @Override
        public String getCommandDescriptions() {
            return "logout\t\t\t\t\tLog out of the CLI";
        }

        public void execute(String commandName, ConsoleInput ci, List args) {
            try {
                try {
                    if (!ci.controlling) {
                        if (ci.out != System.out) {
                            ci.out.println("Logged out");
                            ci.out.close();
                        }
                        ci.br.close();
                    }
                }
                catch (IOException iOException) {
                    ci.running = false;
                }
            }
            finally {
                ci.running = false;
            }
        }
    }

    private static class CommandQuit
    extends IConsoleCommand {
        public CommandQuit() {
            super("quit");
        }

        @Override
        public String getCommandDescriptions() {
            return "quit\t\t\t\t\tShutdown " + Constants.APP_NAME;
        }

        public void execute(String commandName, ConsoleInput ci, List args) {
            if (ci.controlling) {
                ci.running = false;
                ci.out.print("Exiting.....");
                ci.quit(true);
                ci.out.println("OK");
            } else if (args.isEmpty() || !args.get(0).toString().equalsIgnoreCase("IAMSURE")) {
                ci.out.println("> The 'quit' command exits " + Constants.APP_NAME + ". Since this is a non-controlling shell thats probably not what you wanted. Use 'logout' to quit it or 'quit iamsure' to really exit " + Constants.APP_NAME + ".");
            } else {
                ci.out.print("Exiting.....");
                ci.quit(true);
                ci.out.println("OK");
            }
        }
    }

    private static class CommandUI
    extends IConsoleCommand {
        public CommandUI() {
            super("ui", "u");
        }

        @Override
        public String getCommandDescriptions() {
            return "ui <interface>\t\t\tu\tStart additional user interface.";
        }

        public void execute(String commandName, ConsoleInput ci, List args) {
            if (!args.isEmpty()) {
                ci.out.println("> Start ui " + args.get(0));
                UIConst.startUI(args.get(0).toString());
            } else {
                ci.out.println("> Missing subcommand for 'ui'\r\n> ui syntax: ui <interface>");
            }
        }
    }

    private class RedirectOutputStream
    extends OutputStream {
        private final OutputStream dest1;
        private final PrintStream dest2;
        boolean ts;

        private RedirectOutputStream(OutputStream _dest1, PrintStream _dest2) {
            this.dest1 = _dest1;
            this.dest2 = _dest2;
        }

        private void requestTimeStamp() {
            this.ts = true;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.ts) {
                this.dest1.write(AEDiagnosticsLogger.getTimestamp().getBytes());
                this.ts = false;
            }
            this.dest2.write(b);
            this.dest1.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.dest2.flush();
            this.dest1.flush();
        }

        @Override
        public void close() throws IOException {
            this.dest1.close();
        }
    }
}

