/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console;

import com.biglybt.core.Core;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.torrentdownloader.TorrentDownloaderFactory;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIException;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIInstanceFactory;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.UIManagerEvent;
import com.biglybt.pif.ui.UIManagerEventListener;
import com.biglybt.pif.ui.UIMessage;
import com.biglybt.pif.ui.UIMessageListener;
import com.biglybt.pif.ui.model.BasicPluginViewModel;
import com.biglybt.pif.ui.toolbar.UIToolBarManager;
import com.biglybt.ui.common.IUserInterface;
import com.biglybt.ui.common.UIConst;
import com.biglybt.ui.common.UIInstanceBase;
import com.biglybt.ui.common.UITemplateHeadless;
import com.biglybt.ui.console.ConsoleInput;
import com.biglybt.ui.console.multiuser.UserManager;
import com.biglybt.ui.console.multiuser.commands.UserCommand;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class UI
extends UITemplateHeadless
implements IUserInterface,
UIInstanceFactory,
UIInstanceBase,
UIManagerEventListener {
    private ConsoleInput console = null;

    @Override
    public void init(boolean first, boolean others) {
        super.init(first, others);
        System.setProperty("java.awt.headless", "true");
    }

    @Override
    public void buildCommandLine(Options options) {
        Option.Builder builder = Option.builder("e").longOpt("exec").hasArg().argName("file").desc("Execute script file. The file should end with 'logout', otherwise the parser thread doesn't stop.");
        options.addOption(builder.build());
        builder = Option.builder("c").longOpt("command").hasArg().argName("command").desc("Execute single script command. Try '-c help' for help on commands.");
        options.addOption(builder.build());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] processArgs(CommandLine commands, String[] args) {
        block25: {
            if (commands == null || args.length <= 0 && this.core == null) break block25;
            conConsoleInput = null;
            try {
                clConsoleInput = Class.forName("com.biglybt.ui.console.ConsoleInput");
                params = new Class[]{String.class, Core.class, Reader.class, PrintStream.class, Boolean.class};
                conConsoleInput = clConsoleInput.getConstructor((Class<?>[])params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (commands.hasOption('e')) {
                if (conConsoleInput != null) {
                    try {
                        params = new Object[]{commands.getOptionValue('e'), this.core, new FileReader(commands.getOptionValue('e')), System.out, Boolean.FALSE};
                        o = (ConsoleInput)conConsoleInput.newInstance(params);
                        Thread.sleep(5L);
                        wait = 3;
                        while (o.running && wait-- > 0) {
                            Thread.sleep(10L);
                        }
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("Script file not found: " + e.toString());
                    }
                    catch (Exception e) {
                        System.err.println("Error invocating the script processor: " + e.toString());
                    }
                } else {
                    System.err.println("ConsoleInput class not found. You need the console ui package to use '-e'");
                }
            }
            if (commands.hasOption('c')) {
                if (conConsoleInput != null) {
                    comm = commands.getOptionValue('c');
                    comm = String.valueOf(comm) + "\nlogout\n";
                    params = new Object[]{commands.getOptionValue('c'), this.core, new StringReader(comm), System.out, Boolean.FALSE};
                    try {
                        o = (ConsoleInput)conConsoleInput.newInstance(params);
                        Thread.sleep(5L);
                        wait = 3;
                        while (o.running && wait-- > 0) {
                            Thread.sleep(10L);
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Error invocating the script processor: " + e.toString());
                    }
                } else {
                    System.err.println("ConsoleInput class not found. You need the console ui package to use '-e'");
                }
            }
            if ((commands.hasOption("closedown") || commands.hasOption("shutdown")) && this.core != null) {
                this.core.stop();
                return null;
            }
            save_path = null;
            if (commands.hasOption("savepath")) {
                save_path = commands.getOptionValue("savepath");
                f = new File(save_path);
                if (f.exists()) {
                    if (f.isFile()) {
                        System.err.println("--savepath value '" + f.getAbsolutePath() + "' is a file, ignoring ");
                        save_path = null;
                    }
                } else {
                    f.mkdirs();
                    if (!f.exists()) {
                        System.err.println("--savepath value '" + f.getAbsolutePath() + "' can't be created, ignoring ");
                        save_path = null;
                    }
                }
                if (save_path != null) {
                    save_path = f.getAbsolutePath();
                }
            }
            var10_15 = rest = commands.getArgs();
            var9_16 = rest.length;
            var8_14 = 0;
            if (true) ** GOTO lbl77
        }
        System.err.println("No commands to process");
        return args;
        do {
            arg = var10_15[var8_14];
            this.openTorrent(arg, save_path);
            ++var8_14;
lbl77:
            // 2 sources

        } while (var8_14 < var9_16);
        return args;
    }

    @Override
    public String getUIType() {
        return "console";
    }

    @Override
    public void coreCreated(Core core) {
        super.coreCreated(core);
        SimpleDateFormat temp = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        UIConst.startTime = new Date();
        System.out.println();
        if (!"on".equals(System.getProperty(SystemProperties.SYSPROP_CONSOLE_NOISY)) && this.isFirst()) {
            Logger.allowLoggingToStdErr(false);
        }
        System.out.println(String.valueOf(Constants.APP_NAME) + " started at " + temp.format(UIConst.startTime));
        core.addLifecycleListener(new CoreLifecycleAdapter(){

            @Override
            public void started(Core core) {
                UI.this.startUI();
            }

            @Override
            public void stopped(Core core) {
                super.stopped(core);
                SimpleDateFormat temp = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                System.out.println(String.valueOf(Constants.APP_NAME) + " stopped at " + temp.format(new Date()));
            }
        });
    }

    private void startUI() {
        boolean created_console = false;
        if (this.console == null || !this.console.isAlive()) {
            this.console = new ConsoleInput("Main", this.core, System.in, System.out, Boolean.TRUE);
            this.console.printwelcome();
            this.console.printconsolehelp();
            created_console = true;
        }
        PluginInterface pi = this.core.getPluginManager().getDefaultPluginInterface();
        UIManager ui_manager = pi.getUIManager();
        ui_manager.addUIEventListener(this);
        try {
            ui_manager.attachUI(this);
        }
        catch (UIException e) {
            e.printStackTrace();
        }
        TorrentDownloaderFactory.initManager(this.core.getGlobalManager(), true);
        if (created_console && System.getProperty(SystemProperties.SYSPROP_CONSOLE_MULTIUSER) != null) {
            UserManager manager = UserManager.getInstance(pi);
            this.console.registerCommand(new UserCommand(manager));
        }
    }

    public void openRemoteTorrent(String url) {
        if (this.console != null) {
            this.console.downloadRemoteTorrent(url);
            return;
        }
        if (this.console != null) {
            this.console.out.println("Downloading torrent from url: " + url);
        }
        TorrentDownloaderFactory.downloadManaged(url);
    }

    public void openTorrent(String fileName, String save_path) {
        boolean is_remote;
        String uc_filename = fileName.toUpperCase(Locale.US);
        boolean bl = is_remote = uc_filename.startsWith("HTTP://") || uc_filename.startsWith("HTTPS://") || uc_filename.startsWith("MAGNET:");
        if (this.console != null) {
            if (is_remote) {
                this.console.out.println("Downloading torrent from url: " + fileName);
                if (save_path == null) {
                    this.console.downloadRemoteTorrent(fileName);
                } else {
                    this.console.downloadRemoteTorrent(fileName, save_path);
                }
            } else {
                this.console.out.println("Open Torrent " + fileName);
                if (save_path == null) {
                    this.console.downloadTorrent(fileName);
                } else {
                    this.console.downloadTorrent(fileName, save_path);
                }
            }
            return;
        }
        if (is_remote) {
            if (this.console != null) {
                this.console.out.println("Downloading torrent from url: " + fileName);
            }
            if (save_path == null) {
                TorrentDownloaderFactory.downloadManaged(fileName);
            } else {
                TorrentDownloaderFactory.downloadToLocationManaged(fileName, save_path);
            }
            return;
        }
        try {
            if (!TorrentUtils.isTorrentFile(fileName)) {
                System.err.println(String.valueOf(fileName) + " doesn't seem to be a torrent file. Not added.");
                return;
            }
        }
        catch (Exception e) {
            System.err.println("Something is wrong with " + fileName + ". Not added. (Reason: " + e.getMessage() + ")");
            return;
        }
        if (this.core.getGlobalManager() != null) {
            try {
                String downloadDir;
                String string = downloadDir = save_path != null ? save_path : COConfigurationManager.getDirectoryParameter("Default save path");
                if (this.console != null) {
                    this.console.out.println("Adding torrent: " + fileName + " and saving to " + downloadDir);
                }
                this.core.getGlobalManager().addDownloadManager(fileName, downloadDir);
            }
            catch (Exception e) {
                System.err.println("The torrent " + fileName + " could not be added. " + e);
            }
        }
    }

    @Override
    public UIInstance getInstance(PluginInterface plugin_interface) {
        return this;
    }

    @Override
    public void detach() throws UIException {
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean eventOccurred(UIManagerEvent event2) {
        Object data = event2.getData();
        switch (event2.getType()) {
            case 1: {
                String[] bits = (String[])data;
                int i = 0;
                while (i < bits.length) {
                    this.console.out.println(bits[i]);
                    ++i;
                }
                break;
            }
            case 2: {
                this.openTorrent(((File)data).toString(), null);
                break;
            }
            case 3: {
                this.openRemoteTorrent(((URL)((Object[])data)[0]).toExternalForm());
                break;
            }
            case 4: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 9: {
                break;
            }
            case 13: {
                event2.setResult(Boolean.FALSE);
            }
        }
        return true;
    }

    @Override
    public int promptUser(String title, String text, String[] options, int defaultOption) {
        this.console.out.println("Prompt: " + title);
        this.console.out.println(text);
        String sOptions = "Options: ";
        int i = 0;
        while (i < options.length) {
            if (i != 0) {
                sOptions = String.valueOf(sOptions) + ", ";
            }
            sOptions = String.valueOf(sOptions) + "[" + i + "]" + options[i];
            ++i;
        }
        this.console.out.println(sOptions);
        this.console.out.println("WARNING: Option [" + defaultOption + "] automatically selected. " + "Console UI devs need to implement this function!");
        return defaultOption;
    }

    @Override
    public void promptUser(String title, String text, String[] options, int defaultOption, UIMessageListener listener) {
        this.console.out.println("Prompt: " + title);
        this.console.out.println(text);
        String sOptions = "Options: ";
        int i = 0;
        while (i < options.length) {
            if (i != 0) {
                sOptions = String.valueOf(sOptions) + ", ";
            }
            sOptions = String.valueOf(sOptions) + "[" + i + "]" + options[i];
            ++i;
        }
        this.console.out.println(sOptions);
        this.console.out.println("WARNING: Option [" + defaultOption + "] automatically selected. " + "Console UI devs need to implement this function!");
        listener.UIMessageClosed(defaultOption);
    }

    @Override
    public boolean openView(BasicPluginViewModel model) {
        return false;
    }

    @Override
    public UIInputReceiver getInputReceiver() {
        return null;
    }

    @Override
    public UIMessage createMessage() {
        return null;
    }

    @Override
    public UIToolBarManager getToolBarManager() {
        return null;
    }

    @Override
    public void unload(PluginInterface pi) {
    }
}

