/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console.commands;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.host.TRHost;
import com.biglybt.core.tracker.host.TRHostException;
import com.biglybt.core.tracker.host.TRHostTorrent;
import com.biglybt.ui.console.ConsoleInput;
import com.biglybt.ui.console.commands.TorrentCommand;
import java.util.List;

public class TorrentHost
extends TorrentCommand {
    public TorrentHost() {
        super("host", null, "Hosting");
    }

    protected boolean performCommand(ConsoleInput ci, DownloadManager dm, List args) {
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null) {
            try {
                TRHost host = ci.core.getTrackerHost();
                TRHostTorrent existing = host.getHostTorrent(torrent);
                if (existing == null) {
                    ci.core.getTrackerHost().hostTorrent(torrent, true, false);
                } else {
                    try {
                        existing.remove();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (TRHostException e) {
                e.printStackTrace(ci.out);
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean performCommand(ConsoleInput ci, TRHostTorrent torrent, List args) {
        try {
            torrent.remove();
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getCommandDescriptions() {
        return "host (<torrentoptions>)\t\t\tHost or stop hosting torrent(s).";
    }
}

