/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console.commands;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManagerAdapter;
import com.biglybt.core.logging.ILogEventListener;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogRelation;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.ui.console.ConsoleInput;
import com.biglybt.ui.console.commands.TorrentCommand;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TorrentLog
extends TorrentCommand
implements ILogEventListener {
    private static int MODE_OFF = 0;
    private static int MODE_ON = 1;
    private static int MODE_FLIP = 2;
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("[h:mm:ss.SSS] ");
    private static FieldPosition formatPos = new FieldPosition(0);
    private int mode = 0;
    private AEMonitor dms_mon = new AEMonitor("TorrentLog");
    private ArrayList dms = new ArrayList();
    private boolean gm_listener_added;

    public TorrentLog() {
        super("tlog", "tl", "Torrent Logging");
    }

    @Override
    public void execute(String commandName, ConsoleInput ci, List<String> args) {
        this.mode = MODE_ON;
        Vector<String> newargs = new Vector<String>(args);
        if (newargs.isEmpty()) {
            this.mode = MODE_FLIP;
        } else if (newargs.contains("off")) {
            newargs.removeElement("off");
            this.mode = MODE_OFF;
        } else if (!newargs.contains("on")) {
            this.mode = MODE_FLIP;
        }
        super.execute(commandName, ci, args);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean performCommand(ConsoleInput ci, DownloadManager dm, List args) {
        block12: {
            try {
                this.dms_mon.enter();
                if (!this.gm_listener_added) {
                    this.gm_listener_added = true;
                    gm = CoreFactory.getSingleton().getGlobalManager();
                    gm.addListener(new GlobalManagerAdapter(){

                        @Override
                        public void downloadManagerRemoved(DownloadManager dm) {
                            TorrentLog.this.dms.remove(dm);
                        }
                    }, false);
                }
                if (this.mode == TorrentLog.MODE_FLIP) {
                    turnOn = this.dms.contains(dm) == false;
                } else {
                    v0 = turnOn = this.mode == TorrentLog.MODE_ON;
                }
                if (!turnOn) ** GOTO lbl21
                ci.out.print("->on] ");
                if (this.dms.contains(dm)) {
                    return true;
                }
                try {
                    this.dms.add(dm);
                    if (this.dms.size() == 1) {
                        Logger.addListener(this);
                    }
                    break block12;
lbl21:
                    // 1 sources

                    ci.out.print("->off] ");
                    this.dms.remove(dm);
                    if (this.dms.size() == 0) {
                        Logger.removeListener(this);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(ci.out);
                    return false;
                }
            }
            finally {
                this.dms_mon.exit();
            }
        }
        return true;
    }

    @Override
    public String getCommandDescriptions() {
        return "tl [on|off]\tTorrentLogging";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void log(LogEvent event2) {
        boolean bMatch = false;
        if (event2.relatedTo == null) {
            return;
        }
        try {
            this.dms_mon.enter();
            int i = 0;
            while (!bMatch && i < event2.relatedTo.length) {
                Object obj = event2.relatedTo[i];
                if (obj != null) {
                    int j = 0;
                    while (!bMatch && j < this.dms.size()) {
                        Object newObj;
                        if (obj instanceof LogRelation && (newObj = ((LogRelation)obj).queryForClass(DownloadManager.class)) != null) {
                            obj = newObj;
                        }
                        if (obj == this.dms.get(j)) {
                            bMatch = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        finally {
            this.dms_mon.exit();
        }
        if (bMatch) {
            StringBuffer buf = new StringBuffer();
            dateFormatter.format(event2.timeStamp, buf, formatPos);
            buf.append("{").append(event2.logID).append("} ");
            buf.append(event2.text);
            if (event2.relatedTo != null) {
                buf.append("; \t| ");
                int j = 0;
                while (j < event2.relatedTo.length) {
                    Object obj = event2.relatedTo[j];
                    if (j > 0) {
                        buf.append("; ");
                    }
                    if (obj instanceof LogRelation) {
                        buf.append(((LogRelation)obj).getRelationText());
                    } else if (obj != null) {
                        buf.append(obj.getClass().getName()).append(": '").append(obj.toString()).append("'");
                    }
                    ++j;
                }
            }
            System.out.println(buf.toString());
        }
    }
}

