/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console.commands;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManagerDownloadRemovalVetoException;
import com.biglybt.ui.console.ConsoleInput;
import com.biglybt.ui.console.commands.TorrentCommand;
import java.util.List;

public class TorrentRemove
extends TorrentCommand {
    public TorrentRemove() {
        super("remove", "r", "Removing");
    }

    protected boolean performCommand(ConsoleInput ci, DownloadManager dm, List args) {
        try {
            ci.getGlobalManager().removeDownloadManager(dm);
        }
        catch (GlobalManagerDownloadRemovalVetoException e) {
            ci.out.println("> Veto when removing torrent (" + e.getMessage() + ")");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace(ci.out);
            return false;
        }
        return true;
    }

    @Override
    public String getCommandDescriptions() {
        return "remove (<torrentoptions>)\tr\tRemove torrent(s).";
    }
}

