/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console.multiuser;

import com.biglybt.core.CoreException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.ui.console.UserProfile;
import com.biglybt.ui.console.multiuser.UserManagerPersister;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserManager {
    private static final String USER_DB_CONFIG_FILE = "console.users.properties";
    private static UserManager instance;
    private Map usersMap = new HashMap();
    private final String fileName;

    public UserManager(String fileName) {
        this.fileName = fileName;
    }

    public UserProfile authenticate(String username, String password) {
        UserProfile profile = this.getUser(username);
        if (profile != null && profile.authenticate(password)) {
            return profile;
        }
        return null;
    }

    public UserProfile getUser(String username) {
        return (UserProfile)this.usersMap.get(username.toLowerCase());
    }

    public void addUser(UserProfile user) {
        this.usersMap.put(user.getUsername().toLowerCase(), user);
    }

    public Collection getUsers() {
        return Collections.unmodifiableCollection(this.usersMap.values());
    }

    public void load() throws FileNotFoundException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.fileName));
        this.doLoad(bis);
    }

    protected void doLoad(InputStream in) {
        try {
            Class<?> cla = Class.forName("com.biglybt.ui.console.multiuser.persist.UserManagerXMLPersist");
            UserManagerPersister persister = (UserManagerPersister)cla.newInstance();
            persister.doLoad(in, this.usersMap);
        }
        catch (ClassNotFoundException e) {
            System.err.println("No persistence service for user config, load not performed");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void save() throws FileNotFoundException {
        FileOutputStream out = new FileOutputStream(this.fileName);
        this.doSave(out);
    }

    protected void doSave(OutputStream out) {
        try {
            Class<?> cla = Class.forName("com.biglybt.ui.console.multiuser.persist.UserManagerXMLPersist");
            UserManagerPersister persister = (UserManagerPersister)cla.newInstance();
            persister.doSave(out, this.usersMap);
        }
        catch (ClassNotFoundException e) {
            System.err.println("No persistence service for user config, save not performed");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserManager getInstance(PluginInterface pi) {
        Class<UserManager> clazz = UserManager.class;
        synchronized (UserManager.class) {
            if (instance == null) {
                String userDir = pi.getUtilities().getUserDir();
                File dbFile = new File(userDir, USER_DB_CONFIG_FILE);
                try {
                    instance = new UserManager(dbFile.getCanonicalPath());
                    if (dbFile.exists()) {
                        System.out.println("loading user configuration from: " + dbFile.getCanonicalPath());
                        instance.load();
                    } else {
                        System.out.println("file: " + dbFile.getCanonicalPath() + " does not exist. using 'null' user manager");
                    }
                }
                catch (IOException e) {
                    throw new CoreException("Unable to instantiate default user manager");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void deleteUser(String userName) {
        this.usersMap.remove(userName.toLowerCase());
    }

    public static final class UserManagerConfig {
        private List users = new ArrayList();

        public List getUsers() {
            return this.users;
        }

        public void setUsers(List users) {
            this.users = users;
        }

        public void addUser(UserProfile user) {
            this.users.add(user);
        }

        public void clear() {
            this.users.clear();
        }
    }
}

