/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;

public class AZProgressBar
extends Composite {
    private ProgressBar incrementalProgressBar = new ProgressBar((Composite)this, 256);
    private ProgressBar indeterminateProgressBar = new ProgressBar((Composite)this, 258);
    private boolean isIndeterminate = false;
    private StackLayout stack = new StackLayout();
    private boolean visible;

    public AZProgressBar(Composite parent) {
        this(parent, false);
    }

    public AZProgressBar(Composite parent, boolean isIndeterminate) {
        super(parent, 0);
        this.setLayout((Layout)this.stack);
        this.pack();
        this.visible = super.isVisible();
        this.setIndeterminate(isIndeterminate);
    }

    public void setIndeterminate(boolean isIndeterminate) {
        if (this.isIndeterminate != isIndeterminate || this.stack.topControl == null) {
            this.isIndeterminate = isIndeterminate;
            if (isIndeterminate) {
                this.stack.topControl = this.indeterminateProgressBar;
            } else {
                this.incrementalProgressBar.setMinimum(0);
                this.incrementalProgressBar.setMaximum(100);
                this.incrementalProgressBar.setSelection(0);
                this.stack.topControl = this.incrementalProgressBar;
            }
            this.layout();
        }
    }

    public void done() {
        this.incrementalProgressBar.setSelection(this.incrementalProgressBar.getMaximum());
        this.stack.topControl = null;
        this.layout();
    }

    public void setSelection(int value) {
        if (this.incrementalProgressBar.getMaximum() < value) {
            this.done();
        } else {
            this.incrementalProgressBar.setSelection(value);
        }
    }

    public void setPercentage(int percentage) {
        if (percentage > 0 && percentage < 101) {
            int range = this.incrementalProgressBar.getMaximum() - this.incrementalProgressBar.getMinimum();
            this.setSelection(this.incrementalProgressBar.getMinimum() + range * percentage / 100);
        }
    }

    public void setVisible(boolean b) {
        this.visible = b;
        super.setVisible(b);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getMaximum() {
        return this.incrementalProgressBar.getMaximum();
    }

    public int getMinimum() {
        return this.incrementalProgressBar.getMinimum();
    }

    public int getSelection() {
        return this.incrementalProgressBar.getSelection();
    }

    public void setMaximum(int value) {
        this.incrementalProgressBar.setMaximum(value);
    }

    public void setMinimum(int value) {
        this.incrementalProgressBar.setMinimum(value);
    }

    public boolean isIndeterminate() {
        return this.isIndeterminate;
    }
}

