/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.torrent.impl.TorrentOpenOptions;
import com.biglybt.core.torrentdownloader.TorrentDownloader;
import com.biglybt.core.torrentdownloader.TorrentDownloaderCallBackInterface;
import com.biglybt.core.torrentdownloader.TorrentDownloaderFactory;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.util.protocol.AzURLStreamHandlerFactory;
import com.biglybt.core.util.protocol.AzURLStreamHandlerSkipConnection;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.progress.IProgressReport;
import com.biglybt.ui.swt.progress.IProgressReportConstants;
import com.biglybt.ui.swt.progress.IProgressReporter;
import com.biglybt.ui.swt.progress.IProgressReporterListener;
import com.biglybt.ui.swt.progress.ProgressReporterWindow;
import com.biglybt.ui.swt.progress.ProgressReportingManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class FileDownloadWindow
implements TorrentDownloaderCallBackInterface,
IProgressReportConstants {
    TorrentDownloader downloader;
    TorrentDownloaderCallBackInterface listener;
    boolean force_dialog;
    private final Runnable callOnError;
    IProgressReporter pReporter;
    Shell parent;
    String original_url;
    String decoded_url;
    String referrer;
    Map request_properties;
    String dirName = null;
    String shortURL = null;
    TorrentOpenOptions torrentOptions;
    private int lastState = -1;

    public FileDownloadWindow(Shell parent, String url, String referrer, Map request_properties, Runnable runOnError) {
        this(parent, url, referrer, request_properties, null, null, runOnError);
    }

    public FileDownloadWindow(Shell parent, String url, String referrer, Map request_properties, TorrentOpenOptions torrentOptions, TorrentDownloaderCallBackInterface listener) {
        this(parent, url, referrer, request_properties, torrentOptions, listener, null);
    }

    private FileDownloadWindow(Shell parent, String url, String referrer, Map request_properties, TorrentOpenOptions torrentOptions, TorrentDownloaderCallBackInterface listener, Runnable callOnError) {
        this.parent = parent;
        this.original_url = url;
        this.referrer = referrer;
        this.torrentOptions = torrentOptions;
        this.listener = listener;
        this.request_properties = request_properties;
        this.callOnError = callOnError;
        this.decoded_url = UrlUtils.decodeIfNeeded(this.original_url);
        if (this.handleByProtocol()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                FileDownloadWindow.this.init();
            }
        });
    }

    public FileDownloadWindow(Shell parent, String url, String referrer, Map request_properties, boolean force_dialog) {
        this.parent = parent;
        this.original_url = url;
        this.referrer = referrer;
        this.force_dialog = force_dialog;
        this.request_properties = request_properties;
        this.callOnError = null;
        this.decoded_url = UrlUtils.decodeIfNeeded(this.original_url);
        if (this.handleByProtocol()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                FileDownloadWindow.this.init();
            }
        });
    }

    private boolean handleByProtocol() {
        AzURLStreamHandlerFactory instance;
        URL checkURL;
        block4: {
            checkURL = new URL(this.decoded_url);
            instance = AzURLStreamHandlerFactory.getInstance();
            if (instance != null) break block4;
            return false;
        }
        try {
            URLStreamHandler handler = instance.createURLStreamHandler(checkURL.getProtocol());
            if (handler instanceof AzURLStreamHandlerSkipConnection && ((AzURLStreamHandlerSkipConnection)((Object)handler)).canProcessWithoutConnection(checkURL, true)) {
                return true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return false;
    }

    private void init() {
        if (COConfigurationManager.getBooleanParameter("Save Torrent Files")) {
            try {
                this.dirName = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
                if (this.dirName != null) {
                    File f = new File(this.dirName);
                    if (f.isDirectory()) {
                        if (!FileUtil.canWriteToDirectory(f)) {
                            this.dirName = null;
                        }
                    } else if (f.exists()) {
                        this.dirName = null;
                    } else if (!f.mkdirs()) {
                        this.dirName = null;
                    }
                }
            }
            catch (Exception f) {
                // empty catch block
            }
        }
        if (this.dirName == null) {
            DirectoryDialog dd = new DirectoryDialog(this.parent == null ? Utils.findAnyShell() : this.parent, 0);
            dd.setText(MessageText.getString("fileDownloadWindow.saveTorrentIn"));
            this.dirName = dd.open();
            if (this.dirName != null) {
                COConfigurationManager.setParameter("General_sDefaultTorrent_Directory", new File(this.dirName).getAbsolutePath());
            }
        }
        if (this.dirName == null) {
            return;
        }
        this.pReporter = ProgressReportingManager.getInstance().addReporter();
        this.setupAndShowDialog();
        this.downloader = TorrentDownloaderFactory.create(this, this.original_url, this.referrer, this.request_properties, this.dirName);
        this.downloader.setIgnoreReponseCode(true);
        this.downloader.start();
    }

    private void setupAndShowDialog() {
        if (this.pReporter != null) {
            this.pReporter.setName(String.valueOf(MessageText.getString("fileDownloadWindow.state_downloading")) + ": " + this.getFileName(this.decoded_url));
            this.pReporter.appendDetailMessage(String.valueOf(MessageText.getString("fileDownloadWindow.downloading")) + this.getShortURL(this.decoded_url));
            this.pReporter.setTitle(MessageText.getString("fileDownloadWindow.title"));
            this.pReporter.setIndeterminate(true);
            this.pReporter.setCancelAllowed(true);
            this.pReporter.setRetryAllowed(true);
            this.pReporter.addListener(new IProgressReporterListener(){

                @Override
                public int report(IProgressReport pReport) {
                    switch (pReport.getReportType()) {
                        case 1: {
                            if (FileDownloadWindow.this.downloader == null) break;
                            FileDownloadWindow.this.downloader.cancel();
                            Logger.log(new LogEvent(LogIDs.LOGGER, MessageText.getString("FileDownload.canceled", new String[]{FileDownloadWindow.this.getShortURL(FileDownloadWindow.this.decoded_url)})));
                            break;
                        }
                        case 2: {
                            return 1;
                        }
                        case 5: {
                            if (!pReport.isRetryAllowed()) break;
                            FileDownloadWindow.this.downloader.cancel();
                            FileDownloadWindow.this.lastState = -1;
                            FileDownloadWindow.this.downloader = TorrentDownloaderFactory.create(FileDownloadWindow.this, FileDownloadWindow.this.original_url, FileDownloadWindow.this.referrer, FileDownloadWindow.this.request_properties, FileDownloadWindow.this.dirName);
                            FileDownloadWindow.this.downloader.setIgnoreReponseCode(true);
                            FileDownloadWindow.this.downloader.start();
                            break;
                        }
                    }
                    return 0;
                }
            });
            if (!COConfigurationManager.getBooleanParameter("suppress_file_download_dialog")) {
                ProgressReporterWindow.open(this.pReporter, 2);
            }
        }
    }

    @Override
    public void TorrentDownloaderEvent(int state, TorrentDownloader inf) {
        if (this.listener != null) {
            this.listener.TorrentDownloaderEvent(state, inf);
        }
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        int state;
        int localLastState;
        FileDownloadWindow fileDownloadWindow = this;
        synchronized (fileDownloadWindow) {
            localLastState = this.lastState;
            if (localLastState == 3 || localLastState == 4 || localLastState == 5 || localLastState == 6) {
                return;
            }
            this.lastState = state = this.downloader.getDownloadState();
        }
        int percentDone = this.downloader.getPercentDone();
        IProgressReport pReport = this.pReporter.getProgressReport();
        switch (state) {
            case 6: {
                if (localLastState == state) {
                    return;
                }
                if (!pReport.isCanceled()) {
                    this.pReporter.cancel();
                }
                return;
            }
            case 2: {
                this.pReporter.setPercentage(percentDone, this.downloader.getStatus());
                break;
            }
            case 4: {
                boolean not_error;
                if (localLastState == state) {
                    return;
                }
                if (pReport.isCanceled()) {
                    return;
                }
                String message = this.downloader.getError();
                boolean bl = not_error = message != null && message.toLowerCase(Locale.US).contains("manually");
                if (not_error || this.torrentOptions != null && this.torrentOptions.getHideErrors()) {
                    this.pReporter.setCancelCloses(true);
                    this.pReporter.cancel();
                } else {
                    this.pReporter.setErrorMessage(String.valueOf(MessageText.getString("fileDownloadWindow.state_error")) + message);
                }
                if (this.callOnError != null) {
                    this.callOnError.run();
                }
                return;
            }
            case 3: {
                if (localLastState == state) {
                    return;
                }
                this.pReporter.setDone();
                if (this.listener == null) {
                    if (this.torrentOptions == null) {
                        this.torrentOptions = new TorrentOpenOptions(null);
                    }
                    if (TorrentOpener.mergeFileIntoTorrentInfo(this.downloader.getFile().getAbsolutePath(), this.original_url, this.torrentOptions)) {
                        UIFunctionsManager.getUIFunctions().addTorrentWithOptions(this.force_dialog, this.torrentOptions);
                    }
                }
                return;
            }
        }
    }

    private String getShortURL(String url) {
        if (this.shortURL == null) {
            this.shortURL = url;
            int trunc_pos = this.shortURL.indexOf(38);
            if (trunc_pos == -1 && (trunc_pos = this.shortURL.indexOf(63)) > 0 && this.shortURL.charAt(trunc_pos - 1) == ':') {
                trunc_pos = -1;
            }
            if (trunc_pos != -1) {
                this.shortURL = String.valueOf(this.shortURL.substring(0, trunc_pos + 1)) + "...";
            }
            this.shortURL = this.shortURL.replaceAll("&", "&&");
        }
        return this.shortURL;
    }

    private String getFileName(String url) {
        try {
            String[] titles;
            String[] stringArray = titles = new String[]{"title", "dn"};
            int n = titles.length;
            int n2 = 0;
            while (n2 < n) {
                String toMatch = stringArray[n2];
                Matcher matcher = Pattern.compile("[?&]" + toMatch + "=([^&]*)", 2).matcher(url);
                if (matcher.find()) {
                    String file_name = matcher.group(1);
                    file_name = UrlUtils.decode(file_name);
                    return file_name;
                }
                ++n2;
            }
            String lc_url = (url = this.getShortURL(url)).toLowerCase(MessageText.LOCALE_ENGLISH);
            if (lc_url.startsWith("magnet:") || lc_url.startsWith("maggot:") || lc_url.startsWith("dht:") || lc_url.startsWith("bc:") || lc_url.startsWith("bctp:")) {
                return url;
            }
            String tmp = url.substring(url.lastIndexOf(47) + 1);
            int pos = tmp.toLowerCase(MessageText.LOCALE_ENGLISH).lastIndexOf(".vuze");
            if (pos > 0) {
                return tmp.substring(0, pos + 5);
            }
            pos = tmp.toLowerCase(MessageText.LOCALE_ENGLISH).lastIndexOf(".biglybt");
            if (pos > 0) {
                return tmp.substring(0, pos + 8);
            }
            pos = tmp.toLowerCase(MessageText.LOCALE_ENGLISH).lastIndexOf(".torrent");
            if (pos > 0) {
                tmp = tmp.substring(0, pos);
            }
            return String.valueOf(tmp) + ".torrent";
        }
        catch (Exception exception) {
            return url;
        }
    }
}

