/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.KeyBindings;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.DoubleBufferedLabel;
import com.biglybt.util.StringCompareUtils;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class Messages {
    private static final boolean DARK_MODE = Utils.isDarkAppearanceNative();
    private static final String THEME_SUFFIX = DARK_MODE ? "._dark" : null;
    private static final String MESSAGE_KEY = "com.biglybt.ui.swt.Messages:msg";
    private static final String RESOURCE_KEY = "com.biglybt.ui.swt.Messages:res";
    private static final String RESOURCE_TT_KEY = "com.biglybt.ui.swt.Messages:ttres";
    private static final Pattern HIG_ELLIP_EXP = Pattern.compile("([\\.]{3})");
    private static Listener hoverListener = new Listener(){

        public void handleEvent(Event event2) {
            Messages.updateToolTipFromData(event2.widget, (event2.stateMask & 0x40000) > 0);
        }
    };

    private Messages() {
    }

    public static void updateLanguageForControl(Widget widget) {
        block15: {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block14: {
                                        if (widget == null || widget.isDisposed()) {
                                            return;
                                        }
                                        Messages.updateLanguageFromData(widget, new String[0]);
                                        widget.removeListener(32, hoverListener);
                                        widget.addListener(32, hoverListener);
                                        if (!(widget instanceof CTabFolder)) break block14;
                                        CTabFolder folder = (CTabFolder)widget;
                                        CTabItem[] items = folder.getItems();
                                        int i = 0;
                                        while (i < items.length) {
                                            Messages.updateLanguageForControl((Widget)items[i]);
                                            Messages.updateLanguageForControl((Widget)items[i].getControl());
                                            ++i;
                                        }
                                        break block15;
                                    }
                                    if (!(widget instanceof TabFolder)) break block16;
                                    TabFolder folder = (TabFolder)widget;
                                    TabItem[] items = folder.getItems();
                                    int i = 0;
                                    while (i < items.length) {
                                        Messages.updateLanguageForControl((Widget)items[i]);
                                        Messages.updateLanguageForControl((Widget)items[i].getControl());
                                        ++i;
                                    }
                                    break block15;
                                }
                                if (!(widget instanceof CoolBar)) break block17;
                                CoolItem[] items = ((CoolBar)widget).getItems();
                                int i = 0;
                                while (i < items.length) {
                                    Control control = items[i].getControl();
                                    Messages.updateLanguageForControl((Widget)control);
                                    ++i;
                                }
                                break block15;
                            }
                            if (!(widget instanceof ToolBar)) break block18;
                            ToolItem[] items = ((ToolBar)widget).getItems();
                            int i = 0;
                            while (i < items.length) {
                                Messages.updateLanguageForControl((Widget)items[i]);
                                ++i;
                            }
                            break block15;
                        }
                        if (!(widget instanceof Composite)) break block19;
                        Composite group = (Composite)widget;
                        Control[] controls = group.getChildren();
                        int i = 0;
                        while (i < controls.length) {
                            Messages.updateLanguageForControl((Widget)controls[i]);
                            ++i;
                        }
                        if (widget instanceof Table) {
                            Table table = (Table)widget;
                            TableColumn[] columns = table.getColumns();
                            int i2 = 0;
                            while (i2 < columns.length) {
                                Messages.updateLanguageFromData((Widget)columns[i2], new String[0]);
                                ++i2;
                            }
                            Messages.updateLanguageForControl((Widget)table.getMenu());
                            Event event2 = new Event();
                            event2.type = 39;
                            event2.widget = widget;
                            widget.notifyListeners(39, event2);
                        } else if (widget instanceof Tree) {
                            Tree tree = (Tree)widget;
                            TreeItem[] treeitems = tree.getItems();
                            int i3 = 0;
                            while (i3 < treeitems.length) {
                                Messages.updateLanguageForControl((Widget)treeitems[i3]);
                                ++i3;
                            }
                        }
                        group.layout();
                        break block15;
                    }
                    if (!(widget instanceof MenuItem)) break block20;
                    MenuItem menuItem = (MenuItem)widget;
                    Messages.updateLanguageForControl((Widget)menuItem.getMenu());
                    break block15;
                }
                if (!(widget instanceof Menu)) break block21;
                Menu menu = (Menu)widget;
                if (menu.getStyle() == 8) {
                    System.out.println("POP_UP");
                }
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    Messages.updateLanguageForControl((Widget)items[i]);
                    ++i;
                }
                break block15;
            }
            if (!(widget instanceof TreeItem)) break block15;
            TreeItem treeitem = (TreeItem)widget;
            TreeItem[] treeitems = treeitem.getItems();
            int i = 0;
            while (i < treeitems.length) {
                Messages.updateLanguageFromData((Widget)treeitems[i], new String[0]);
                Messages.updateLanguageForControl((Widget)treeitems[i]);
                ++i;
            }
        }
    }

    public static void setLanguageText(Widget widget, String key) {
        Messages.setLanguageText(widget, key, false, new String[0]);
    }

    public static void setLanguageText(Widget widget, String key, String ... params) {
        Messages.setLanguageText(widget, key, false, params);
    }

    public static boolean updateLanguageKey(Widget widget, String key, String ... params) {
        if (widget == null || widget.isDisposed()) {
            return false;
        }
        String oldKey = (String)widget.getData(RESOURCE_KEY);
        if (StringCompareUtils.equals(key, oldKey)) {
            return false;
        }
        widget.setData(RESOURCE_KEY, (Object)key);
        Messages.updateLanguageFromData(widget, params);
        return true;
    }

    public static void setLanguageText(Widget widget, String key, boolean setTooltipOnly, String ... params) {
        widget.setData(RESOURCE_KEY, (Object)key);
        if (!setTooltipOnly) {
            Messages.updateLanguageFromData(widget, params);
        }
        widget.removeListener(32, hoverListener);
        widget.addListener(32, hoverListener);
    }

    private static void updateLanguageFromData(Widget widget, String ... params) {
        if (widget == null || widget.isDisposed()) {
            return;
        }
        String key = null;
        try {
            key = (String)widget.getData(RESOURCE_KEY);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (key == null || key.endsWith(".tooltip")) {
            return;
        }
        String message = params == null ? MessageText.getString(key) : MessageText.getString(key, params);
        widget.setData(MESSAGE_KEY, (Object)message);
        if (widget instanceof Label) {
            ((Label)widget).setText(message.replaceAll("& ", "&& "));
        } else if (widget instanceof MenuItem) {
            boolean indent;
            MenuItem menuItem = (MenuItem)widget;
            boolean bl = indent = menuItem.getData("IndentItem") != null;
            if (Constants.isOSX) {
                message = HIG_ELLIP_EXP.matcher(message).replaceAll("\u2026");
            }
            menuItem.setText(indent ? "  " + message : message);
            if (menuItem.getAccelerator() != 0) {
                KeyBindings.setAccelerator(menuItem, (String)menuItem.getData(RESOURCE_KEY));
            }
        } else if (widget instanceof Item) {
            ((Item)widget).setText(message);
        } else if (widget instanceof CLabel) {
            ((CLabel)widget).setText(message.replaceAll("& ", "&& "));
        } else if (widget instanceof Group) {
            ((Group)widget).setText(message);
        } else if (widget instanceof Button) {
            ((Button)widget).setText(message);
        } else if (widget instanceof Decorations) {
            ((Decorations)widget).setText(message);
        } else if (widget instanceof Text) {
            ((Text)widget).setText(message);
        } else if (widget instanceof Link) {
            ((Link)widget).setText(message.replaceAll("& ", "&& "));
        } else if (widget instanceof DoubleBufferedLabel) {
            ((DoubleBufferedLabel)widget).setText(message);
        } else if (!(widget instanceof Canvas)) {
            Debug.out("No cast for " + widget.getClass().getName());
        }
    }

    public static String getLanguageForControl(Widget widget) {
        return (String)widget.getData(MESSAGE_KEY);
    }

    private static void updateToolTipFromData(Widget widget, boolean showKey) {
        String tt_key = (String)widget.getData(RESOURCE_TT_KEY);
        if (tt_key != null) {
            Messages.updateTooltipLanguageFromData(widget);
            return;
        }
        String key = (String)widget.getData(RESOURCE_KEY);
        if (key == null) {
            return;
        }
        if (widget instanceof Control) {
            String toolTip;
            if (showKey) {
                Utils.setTT((Control)widget, key);
                return;
            }
            if (!key.endsWith(".tooltip")) {
                key = String.valueOf(key) + ".tooltip";
            }
            if (!(toolTip = MessageText.getString(key)).equals(String.valueOf('!') + key + '!')) {
                Utils.setTT((Control)widget, toolTip);
            }
        } else if (widget instanceof ToolItem) {
            String toolTip;
            if (!key.endsWith(".tooltip")) {
                key = String.valueOf(key) + ".tooltip";
            }
            if (!(toolTip = MessageText.getString(key)).equals(String.valueOf('!') + key + '!')) {
                Utils.setTT((ToolItem)widget, toolTip.replaceAll("Meta\\+", Constants.isOSX ? "Cmd+" : "Ctrl+"));
            }
        } else if (widget instanceof TableColumn) {
            String toolTip;
            if (!key.endsWith(".info")) {
                key = String.valueOf(key) + ".info";
            }
            if ((toolTip = MessageText.getString(key, null)) == null) {
                toolTip = MessageText.getString(key.substring(0, key.length() - 5), null);
            }
            if (toolTip != null) {
                try {
                    Utils.setTT((TableColumn)widget, toolTip);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
    }

    public static String getLanguageText(String key) {
        String result;
        if (THEME_SUFFIX != null && (result = MessageText.getString(String.valueOf(key) + THEME_SUFFIX)) != null) {
            return result;
        }
        return MessageText.getString(key);
    }

    public static void setLanguageTooltip(Widget widget, String key) {
        if (widget == null || widget.isDisposed()) {
            return;
        }
        widget.setData(RESOURCE_TT_KEY, (Object)key);
        Messages.updateTooltipLanguageFromData(widget);
    }

    private static void updateTooltipLanguageFromData(Widget widget) {
        if (widget == null || widget.isDisposed()) {
            return;
        }
        String tt_key = (String)widget.getData(RESOURCE_TT_KEY);
        if (tt_key != null) {
            String sToolTip = MessageText.getString(tt_key);
            if (widget instanceof CLabel) {
                Utils.setTT((Control)((CLabel)widget), sToolTip);
            } else if (widget instanceof Label) {
                Utils.setTT((Control)((Label)widget), sToolTip);
            } else if (widget instanceof Text) {
                Utils.setTT((Control)((Text)widget), sToolTip);
            } else if (widget instanceof Canvas) {
                Utils.setTT((Control)((Canvas)widget), sToolTip);
            } else if (widget instanceof Composite) {
                Utils.setTT((Control)((Composite)widget), sToolTip);
            } else if (widget instanceof Control) {
                Utils.setTT((Control)widget, sToolTip);
            } else if (widget instanceof ToolItem) {
                Utils.setTT((ToolItem)widget, sToolTip);
            } else {
                System.out.println("No cast for " + widget.getClass().getName());
            }
        }
    }
}

