/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SHA1Hasher;
import com.biglybt.core.util.SystemTime;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PasswordWindow {
    private Shell shell;
    private static boolean bOk;
    private static long lastSuccess;
    private static final long REMEMBER_SUCCESS_MS = 3000L;
    protected static AESemaphore class_sem;
    private static PasswordWindow window;

    static {
        lastSuccess = 0L;
        class_sem = new AESemaphore("PasswordWindow");
        window = null;
    }

    public static boolean showPasswordWindow(final Display display) {
        if (lastSuccess + 3000L >= SystemTime.getCurrentTime()) {
            return true;
        }
        final boolean bSWTThread = display.getThread() == Thread.currentThread();
        display.syncExec((Runnable)new AERunnable(){

            @Override
            public void runSupport() {
                if (window == null) {
                    window = new PasswordWindow(display);
                    window.open();
                } else {
                    window.shell.setVisible(true);
                    window.shell.forceActive();
                }
                if (bSWTThread) {
                    window.run();
                }
            }
        });
        if (!bSWTThread) {
            class_sem.reserve();
        }
        lastSuccess = bOk ? SystemTime.getCurrentTime() : 0L;
        return bOk;
    }

    protected PasswordWindow(Display display) {
    }

    private void open() {
        bOk = false;
        this.shell = ShellFactory.createMainShell(65632);
        this.shell.setText(MessageText.getString("PasswordWindow.title"));
        Utils.setShellIcon(this.shell);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        this.shell.setLayout((Layout)layout);
        Label label = new Label((Composite)this.shell, 0);
        label.setText(MessageText.getString("PasswordWindow.passwordprotected"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        final Text password = new Text((Composite)this.shell, 2048);
        password.setEchoChar('*');
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        password.setLayoutData((Object)gridData);
        Button ok = new Button((Composite)this.shell, 8);
        ok.setText(MessageText.getString("Button.ok"));
        gridData = new GridData(64);
        gridData.widthHint = 70;
        ok.setLayoutData((Object)gridData);
        this.shell.setDefaultButton(ok);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                try {
                    SHA1Hasher hasher = new SHA1Hasher();
                    byte[] passwordText = password.getText().getBytes();
                    byte[] encoded = hasher.calculateHash(passwordText);
                    byte[] correct = COConfigurationManager.getByteParameter("Password", "".getBytes());
                    boolean same = true;
                    int i = 0;
                    while (i < correct.length) {
                        if (correct[i] != encoded[i]) {
                            same = false;
                        }
                        ++i;
                    }
                    if (same) {
                        bOk = same;
                        PasswordWindow.this.shell.dispose();
                    } else {
                        PasswordWindow.this.close();
                    }
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        });
        Button cancel = new Button((Composite)this.shell, 8);
        cancel.setText(MessageText.getString("Button.cancel"));
        gridData = new GridData(64);
        gridData.widthHint = 70;
        cancel.setLayoutData((Object)gridData);
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                PasswordWindow.this.close();
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                window = null;
                class_sem.releaseAllWaiters();
            }
        });
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    PasswordWindow.this.close();
                    e.doit = false;
                }
            }
        });
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event arg0) {
                PasswordWindow.this.close();
            }
        });
        this.shell.pack();
        Utils.centreWindow(this.shell);
        this.shell.open();
    }

    protected void run() {
        Utils.readAndDispatchLoop((Control)this.shell);
    }

    private void close() {
        this.shell.dispose();
    }

    public static void main(String[] args) {
        final Display display = new Display();
        new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("2: " + PasswordWindow.showPasswordWindow(display));
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("3: " + PasswordWindow.showPasswordWindow(display));
                    }
                });
            }
        }).start();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                System.out.println("4: " + PasswordWindow.showPasswordWindow(display));
            }
        });
        System.out.println("1: " + PasswordWindow.showPasswordWindow(display));
    }
}

