/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerInitialisationAdapter;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.ipfilter.IpFilterManagerFactory;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerSource;
import com.biglybt.core.speedmanager.SpeedLimitHandler;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentCreator;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.torrent.TOTorrentProgressListener;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.tracker.util.TRTrackerUtils;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.DNSUtils;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HTTPUtils;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.IPToHostNameResolver;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.UIManagerListener;
import com.biglybt.pif.ui.UIPluginView;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.toolbar.UIToolBarActivationListener;
import com.biglybt.pif.ui.toolbar.UIToolBarItem;
import com.biglybt.pif.ui.toolbar.UIToolBarManager;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.extseed.ExternalSeedPlugin;
import com.biglybt.plugin.net.buddy.BuddyPluginBeta;
import com.biglybt.plugin.net.buddy.BuddyPluginUtils;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.ISelectedVuzeFileContent;
import com.biglybt.ui.selectedcontent.SelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.ListenerDMTask;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.TextViewerWindow;
import com.biglybt.ui.swt.TrackerChangerWindow;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.exporttorrent.wizard.ExportTorrentWizard;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.MenuFactory;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.maketorrent.MultiTrackerEditor;
import com.biglybt.ui.swt.maketorrent.TrackerEditorListener;
import com.biglybt.ui.swt.maketorrent.WebSeedsEditor;
import com.biglybt.ui.swt.maketorrent.WebSeedsEditorListener;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.biglybt.ui.swt.minibar.DownloadBar;
import com.biglybt.ui.swt.sharing.ShareUtils;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.views.FilesViewMenuUtil;
import com.biglybt.ui.swt.views.ViewUtils;
import com.biglybt.ui.swt.views.utils.CategoryUIUtils;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import com.biglybt.ui.swt.views.utils.TagUIUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class TorrentUtil {
    private static final String TU_GROUP = "tu.group";
    private static final String BF_GROUP = "bf.group";
    public static final String TU_ITEM_RECHECK = "tui.recheck";
    public static final String TU_ITEM_CHECK_FILES = "tui.checkfiles";
    public static final String TU_ITEM_SHOW_SIDEBAR = "tui.showsidebar";
    public static final String BF_ITEM_BACK = "bfi.back";
    public static final String BF_ITEM_FORWARD = "bfi.forward";
    private static final String[] TB_ITEMS = new String[]{"tui.recheck", "tui.checkfiles", "tui.showsidebar", "bfi.back", "bfi.forward"};
    private static boolean initialised;

    public static synchronized void init() {
        if (initialised) {
            return;
        }
        initialised = true;
        String[] stringArray = TB_ITEMS;
        int n = TB_ITEMS.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            String key = "IconBar.visible." + id;
            if (!COConfigurationManager.hasParameter(key, false)) {
                COConfigurationManager.setParameter(key, false);
            }
            ++n2;
        }
        UIManager ui_manager = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getUIManager();
        ui_manager.addUIListener(new UIManagerListener(){
            private List<UIToolBarItem> items = new ArrayList<UIToolBarItem>();
            private boolean attached;

            @Override
            public void UIAttached(UIInstance instance) {
                if (instance.getUIType().equals("swt")) {
                    this.attached = true;
                    UIToolBarManager tbm = instance.getToolBarManager();
                    if (tbm != null) {
                        UIToolBarItem back_item = tbm.createToolBarItem(TorrentUtil.BF_ITEM_BACK);
                        back_item.setGroupID(TorrentUtil.BF_GROUP);
                        back_item.setImageID("back");
                        back_item.setToolTipID("label.back");
                        back_item.setDefaultActivationListener(new UIToolBarActivationListener(){

                            @Override
                            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                                TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
                                if (tv != null) {
                                    tv.moveBack();
                                }
                                return true;
                            }
                        });
                        this.addItem(tbm, back_item);
                        UIToolBarItem forward_item = tbm.createToolBarItem(TorrentUtil.BF_ITEM_FORWARD);
                        forward_item.setGroupID(TorrentUtil.BF_GROUP);
                        forward_item.setImageID("forward");
                        forward_item.setToolTipID("label.forward");
                        forward_item.setDefaultActivationListener(new UIToolBarActivationListener(){

                            @Override
                            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                                TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
                                if (tv != null) {
                                    tv.moveForward();
                                }
                                return true;
                            }
                        });
                        this.addItem(tbm, forward_item);
                        UIToolBarItem refresh_item = tbm.createToolBarItem(TorrentUtil.TU_ITEM_RECHECK);
                        refresh_item.setGroupID(TorrentUtil.TU_GROUP);
                        refresh_item.setImageID("recheck");
                        refresh_item.setToolTipID("MyTorrentsView.menu.recheck");
                        refresh_item.setDefaultActivationListener(new UIToolBarActivationListener(){

                            @Override
                            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                                List dms = this.getDMs(datasource);
                                for (DownloadManager dm : dms) {
                                    if (!dm.canForceRecheck()) continue;
                                    dm.forceRecheck();
                                }
                                return true;
                            }
                        });
                        this.addItem(tbm, refresh_item);
                        UIToolBarItem cfe_item = tbm.createToolBarItem(TorrentUtil.TU_ITEM_CHECK_FILES);
                        cfe_item.setGroupID(TorrentUtil.TU_GROUP);
                        cfe_item.setImageID("filesexist");
                        cfe_item.setToolTipID("MyTorrentsView.menu.checkfilesexist");
                        cfe_item.setDefaultActivationListener(new UIToolBarActivationListener(){

                            @Override
                            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                                List dms = this.getDMs(datasource);
                                for (DownloadManager dm : dms) {
                                    dm.filesExist(true);
                                }
                                return true;
                            }
                        });
                        this.addItem(tbm, cfe_item);
                        UIToolBarItem ssb_item = tbm.createToolBarItem(TorrentUtil.TU_ITEM_SHOW_SIDEBAR);
                        ssb_item.setGroupID(TorrentUtil.TU_GROUP);
                        ssb_item.setImageID("sidebar");
                        COConfigurationManager.addAndFireParameterListener("Show Side Bar", new ParameterListener(){

                            @Override
                            public void parameterChanged(String name) {
                                if (attached) {
                                    UIFunctions uiFunctions;
                                    if (COConfigurationManager.getBooleanParameter("IconBar.visible.tui.showsidebar") && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                                        uiFunctions.refreshIconBar();
                                    }
                                } else {
                                    COConfigurationManager.removeParameterListener(name, this);
                                }
                            }
                        });
                        ssb_item.setToolTipID("v3.MainWindow.menu.view.sidebar");
                        ssb_item.setDefaultActivationListener(new UIToolBarActivationListener(){

                            @Override
                            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                                boolean ss = COConfigurationManager.getBooleanParameter("Show Side Bar");
                                COConfigurationManager.setParameter("Show Side Bar", !ss);
                                return true;
                            }
                        });
                        this.addItem(tbm, ssb_item);
                    }
                }
            }

            private List<DownloadManager> getDMs(Object ds) {
                ArrayList<DownloadManager> result = new ArrayList<DownloadManager>();
                if (ds instanceof Download) {
                    result.add(PluginCoreUtils.unwrap((Download)ds));
                } else if (ds instanceof Object[]) {
                    Object[] objs;
                    Object[] objectArray = objs = (Object[])ds;
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj instanceof Download) {
                            result.add(PluginCoreUtils.unwrap((Download)obj));
                        }
                        ++n2;
                    }
                }
                return result;
            }

            private void addItem(UIToolBarManager tbm, UIToolBarItem item) {
                this.items.add(item);
                tbm.addToolBarItem(item);
            }

            @Override
            public void UIDetached(UIInstance instance) {
                if (instance.getUIType().equals("swt")) {
                    this.attached = false;
                    UIToolBarManager tbm = instance.getToolBarManager();
                    if (tbm != null) {
                        for (UIToolBarItem item : this.items) {
                            tbm.removeToolBarItem(item.getID());
                        }
                    }
                    this.items.clear();
                }
            }
        });
    }

    public static void fillTorrentMenu(Menu menu, final DownloadManager[] dms, Core core, boolean include_show_details, int selected_dl_types, final TableView tv) {
        DownloadManagerState dmState;
        List<DownloadManagerState.ResumeHistory> history;
        boolean isSeedingView;
        final Shell shell = Utils.findAnyShell();
        Shell menu_shell = menu.getShell();
        switch (selected_dl_types) {
            case 1: {
                isSeedingView = false;
                break;
            }
            case 2: {
                isSeedingView = true;
                break;
            }
            case 0: {
                if (dms.length == 1) {
                    isSeedingView = dms[0].isDownloadComplete(false);
                    break;
                }
            }
            default: {
                isSeedingView = false;
            }
        }
        boolean hasSelection = dms.length > 0;
        boolean isSingleSelection = dms.length == 1;
        boolean isTrackerOn = TRTrackerUtils.isTrackerEnabled();
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        boolean bChangeDir = hasSelection;
        boolean fileRescan = true;
        boolean fileExport = true;
        boolean canSetMOC = true;
        boolean fileMove = true;
        boolean manualUpdate = true;
        boolean barsOpened = true;
        boolean changeUrl = true;
        boolean canClearMOC = false;
        boolean pause = false;
        boolean stop = false;
        boolean start = false;
        boolean lrrecheck = false;
        boolean recheck = false;
        boolean forceStartEnabled = false;
        boolean forceStart = false;
        boolean canSetSuperSeed = false;
        boolean superSeedAllYes = true;
        boolean superSeedAllNo = true;
        boolean upSpeedDisabled = false;
        long totalUpSpeed = 0L;
        boolean upSpeedUnlimited = false;
        long upSpeedSetMax = 0L;
        boolean downSpeedDisabled = false;
        long totalDownSpeed = 0L;
        boolean downSpeedUnlimited = false;
        long downSpeedSetMax = 0L;
        boolean allScanSelected = true;
        boolean allScanNotSelected = true;
        boolean allStopped = true;
        boolean allAllocatable = true;
        boolean allResumeIncomplete = true;
        boolean hasClearableLinks = false;
        boolean hasRevertableFiles = false;
        boolean globalMask = COConfigurationManager.getBooleanParameter("peercontrol.hide.piece");
        boolean allMaskDC = true;
        if (hasSelection) {
            int i = 0;
            while (i < dms.length) {
                Boolean dmmask;
                TRTrackerAnnouncer trackerClient;
                DownloadManager dm = dms[i];
                try {
                    int maxul = dm.getStats().getUploadRateLimitBytesPerSecond();
                    if (maxul == 0) {
                        upSpeedUnlimited = true;
                    } else if ((long)maxul > upSpeedSetMax) {
                        upSpeedSetMax = maxul;
                    }
                    if (maxul == -1) {
                        maxul = 0;
                        upSpeedDisabled = true;
                    }
                    totalUpSpeed += (long)maxul;
                    int maxdl = dm.getStats().getDownloadRateLimitBytesPerSecond();
                    if (maxdl == 0) {
                        downSpeedUnlimited = true;
                    } else if ((long)maxdl > downSpeedSetMax) {
                        downSpeedSetMax = maxdl;
                    }
                    if (maxdl == -1) {
                        maxdl = 0;
                        downSpeedDisabled = true;
                    }
                    totalDownSpeed += (long)maxdl;
                }
                catch (Exception ex) {
                    Debug.printStackTrace(ex);
                }
                int state = dm.getState();
                if (barsOpened && !DownloadBar.getManager().isOpen(dm)) {
                    barsOpened = false;
                }
                stop = stop || ManagerUtils.isStopable(dm);
                start = start || ManagerUtils.isStartable(dm);
                pause = pause || ManagerUtils.isPauseable(dm);
                recheck = recheck || dm.canForceRecheck();
                lrrecheck = lrrecheck || ManagerUtils.canLowResourceRecheck(dm);
                forceStartEnabled = forceStartEnabled || ManagerUtils.isForceStartable(dm);
                forceStart = forceStart || dm.isForceStart();
                boolean stopped = ManagerUtils.isStopped(dm);
                allStopped &= stopped;
                allAllocatable &= stopped && !dm.isDataAlreadyAllocated() && !dm.isDownloadComplete(false);
                fileMove = fileMove && dm.canMoveDataFiles();
                boolean bl = fileExport = fileExport && dm.canExportDownload();
                if (userMode < 2 && (trackerClient = dm.getTrackerClient()) != null) {
                    boolean update_state = SystemTime.getCurrentTime() / 1000L - (long)trackerClient.getLastUpdateTime() >= 60L;
                    manualUpdate &= update_state;
                }
                if ((bChangeDir &= state == 100 || state == 70 || state == 75) && dms.length == 1) {
                    bChangeDir = dm.isDataAlreadyAllocated();
                    bChangeDir = bChangeDir && state == 100 ? !dm.filesExist(true) : false;
                }
                boolean incomplete = !dm.isDownloadComplete(true);
                DownloadManagerState dm_state = dm.getDownloadState();
                String moc_dir = dm_state.getAttribute("moc.dir");
                canSetMOC &= incomplete;
                canClearMOC |= moc_dir != null && moc_dir.length() > 0;
                boolean scan = dm_state.getFlag(2L);
                allScanSelected = incomplete && allScanSelected && scan;
                allScanNotSelected = incomplete && allScanNotSelected && !scan;
                PEPeerManager pm = dm.getPeerManager();
                if (pm != null) {
                    if (pm.canToggleSuperSeedMode()) {
                        canSetSuperSeed = true;
                    }
                    if (pm.isSuperSeedMode()) {
                        superSeedAllYes = false;
                    } else {
                        superSeedAllNo = false;
                    }
                } else {
                    superSeedAllYes = false;
                    superSeedAllNo = false;
                }
                if (dm_state.isResumeDataComplete()) {
                    allResumeIncomplete = false;
                }
                if (stopped && !hasClearableLinks && dm.getDiskManagerFileInfoSet().nbFiles() > 1 && dm_state.getFileLinks().hasLinks()) {
                    hasClearableLinks = true;
                }
                if (dm_state.getFileLinks().size() > 0) {
                    hasRevertableFiles = true;
                }
                boolean mask = (dmmask = dm_state.getOptionalBooleanAttribute("mdlc")) == null ? globalMask : dmmask;
                allMaskDC = allMaskDC && mask;
                ++i;
            }
            fileRescan = allScanSelected || allScanNotSelected;
        } else {
            barsOpened = false;
            forceStart = false;
            forceStartEnabled = false;
            start = false;
            stop = false;
            fileMove = false;
            fileExport = false;
            fileRescan = false;
            canSetMOC = false;
            upSpeedDisabled = true;
            downSpeedDisabled = true;
            changeUrl = false;
            recheck = false;
            manualUpdate = false;
            allMaskDC = false;
        }
        if (bChangeDir) {
            MenuItem menuItemChangeDir = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)menuItemChangeDir, "MyTorrentsView.menu.changeDirectory");
            menuItemChangeDir.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TorrentUtil.changeDirSelectedTorrents(dms, shell);
                }
            });
        }
        if (include_show_details) {
            MenuItem itemDetails = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemDetails, "MyTorrentsView.menu.showdetails");
            menu.setDefaultItem(itemDetails);
            Utils.setMenuItemImage(itemDetails, "details");
            itemDetails.addListener(13, (Listener)new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager dm) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        uiFunctions.getMDI().showEntryByID("DMDetails", dm);
                    }
                }
            });
            itemDetails.setEnabled(hasSelection);
        }
        MenuItem itemBar = new MenuItem(menu, 32);
        Messages.setLanguageText((Widget)itemBar, "MyTorrentsView.menu.showdownloadbar");
        Utils.setMenuItemImage(itemBar, "downloadBar");
        itemBar.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                if (DownloadBar.getManager().isOpen(dm)) {
                    DownloadBar.close(dm);
                } else {
                    DownloadBar.open(dm, shell);
                }
            }
        });
        itemBar.setEnabled(hasSelection);
        itemBar.setSelection(barsOpened);
        new MenuItem(menu, 2);
        MenuItem itemOpen = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemOpen, "MyTorrentsView.menu.open");
        Utils.setMenuItemImage(itemOpen, "run");
        itemOpen.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager[] dms) {
                TorrentUtil.runDataSources(dms);
            }
        });
        itemOpen.setEnabled(hasSelection);
        final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
        MenuItem itemExplore = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemExplore, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
        itemExplore.addListener(13, (Listener)new ListenerDMTask(dms, false){

            @Override
            public void run(DownloadManager dm) {
                ManagerUtils.open(dm, use_open_containing_folder);
            }
        });
        itemExplore.setEnabled(hasSelection);
        Menu menuBrowse = new Menu((Decorations)menu_shell, 4);
        MenuItem itemBrowse = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemBrowse, "MyTorrentsView.menu.browse");
        itemBrowse.setMenu(menuBrowse);
        MenuItem itemBrowsePublic = new MenuItem(menuBrowse, 8);
        itemBrowsePublic.setText(String.valueOf(MessageText.getString("label.public")) + "...");
        itemBrowsePublic.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                ManagerUtils.browse(dm, false, true);
            }
        });
        MenuItem itemBrowseAnon = new MenuItem(menuBrowse, 8);
        itemBrowseAnon.setText(String.valueOf(MessageText.getString("label.anon")) + "...");
        itemBrowseAnon.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                ManagerUtils.browse(dm, true, true);
            }
        });
        new MenuItem(menuBrowse, 2);
        MenuItem itemBrowseURL = new MenuItem(menuBrowse, 8);
        Messages.setLanguageText((Widget)itemBrowseURL, "label.copy.url.to.clip");
        itemBrowseURL.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Utils.getOffOfSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        String url = ManagerUtils.browse(dms[0], true, false);
                        if (url != null) {
                            ClipboardCopy.copyToClipBoard(url);
                        }
                    }
                });
            }
        });
        itemBrowseURL.setEnabled(isSingleSelection);
        new MenuItem(menuBrowse, 2);
        final MenuItem itemBrowseDir = new MenuItem(menuBrowse, 32);
        Messages.setLanguageText((Widget)itemBrowseDir, "library.launch.web.in.browser.dir.list");
        itemBrowseDir.setSelection(COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowserDirList"));
        itemBrowseDir.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                COConfigurationManager.setParameter("Library.LaunchWebsiteInBrowserDirList", itemBrowseDir.getSelection());
            }
        });
        itemBrowse.setEnabled(hasSelection);
        MenuItem itemAdvanced = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemAdvanced, "MyTorrentsView.menu.advancedmenu");
        itemAdvanced.setEnabled(hasSelection);
        Menu menuAdvanced = new Menu((Decorations)menu_shell, 4);
        itemAdvanced.setMenu(menuAdvanced);
        long kInB = DisplayFormatters.getKinB();
        long maxDownload = (long)COConfigurationManager.getIntParameter("Max Download Speed KBs", 0) * kInB;
        long maxUpload = (long)COConfigurationManager.getIntParameter("Max Upload Speed KBs", 0) * kInB;
        ViewUtils.addSpeedMenu(menu_shell, menuAdvanced, true, true, true, hasSelection, downSpeedDisabled, downSpeedUnlimited, totalDownSpeed, downSpeedSetMax, maxDownload, upSpeedDisabled, upSpeedUnlimited, totalUpSpeed, upSpeedSetMax, maxUpload, dms.length, null, new ViewUtils.SpeedAdapter(){

            @Override
            public void setDownSpeed(final int speed) {
                ListenerDMTask task2 = new ListenerDMTask(dms){

                    @Override
                    public void run(DownloadManager dm) {
                        dm.getStats().setDownloadRateLimitBytesPerSecond(speed);
                    }
                };
                task2.go();
            }

            @Override
            public void setUpSpeed(final int speed) {
                ListenerDMTask task2 = new ListenerDMTask(dms){

                    @Override
                    public void run(DownloadManager dm) {
                        dm.getStats().setUploadRateLimitBytesPerSecond(speed);
                    }
                };
                task2.go();
            }
        });
        final Menu speedLimitsMenu = new Menu((Decorations)menuAdvanced.getShell(), 4);
        MenuItem speedLimitsMenuItem = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)speedLimitsMenuItem, "MainWindow.menu.speed_limits");
        speedLimitsMenuItem.setMenu(speedLimitsMenu);
        MenuBuildUtils.addMaintenanceListenerForMenu(speedLimitsMenu, new MenuBuildUtils.MenuBuilder(){

            @Override
            public void buildMenu(Menu menu, MenuEvent menuEvent) {
                TorrentUtil.addSpeedLimitsMenu(dms, speedLimitsMenu);
            }
        });
        Menu menuTracker = new Menu((Decorations)menu_shell, 4);
        MenuItem itemTracker = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)itemTracker, "MyTorrentsView.menu.tracker");
        itemTracker.setMenu(menuTracker);
        itemExplore.setEnabled(hasSelection);
        TorrentUtil.addTrackerTorrentMenu(menuTracker, dms, changeUrl, manualUpdate, allStopped, use_open_containing_folder, fileMove);
        MenuItem itemFiles = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)itemFiles, "ConfigView.section.files");
        Menu menuFiles = new Menu((Decorations)menu_shell, 4);
        itemFiles.setMenu(menuFiles);
        MenuItem itemFileMoveData = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileMoveData, "MyTorrentsView.menu.movedata");
        itemFileMoveData.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager[] dms) {
                TorrentUtil.moveDataFiles(shell, dms, false);
            }
        });
        itemFileMoveData.setEnabled(fileMove);
        if (userMode > 0) {
            MenuItem itemFileMoveDataBatch = new MenuItem(menuFiles, 8);
            Messages.setLanguageText((Widget)itemFileMoveDataBatch, "MyTorrentsView.menu.movedata.batch");
            itemFileMoveDataBatch.addListener(13, (Listener)new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager[] dms) {
                    TorrentUtil.moveDataFiles(shell, dms, true);
                }
            });
            itemFileMoveData.setEnabled(fileMove);
        }
        MenuItem itemFileMoveTorrent = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileMoveTorrent, "MyTorrentsView.menu.movetorrent");
        itemFileMoveTorrent.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager[] dms) {
                TorrentUtil.moveTorrentFile(shell, dms);
            }
        });
        itemFileMoveTorrent.setEnabled(fileMove);
        Menu moc_menu = new Menu((Decorations)menu_shell, 4);
        MenuItem moc_item = new MenuItem(menuFiles, 64);
        Messages.setLanguageText((Widget)moc_item, "label.move.on.comp");
        moc_item.setMenu(moc_menu);
        MenuItem clear_item = new MenuItem(moc_menu, 8);
        Messages.setLanguageText((Widget)clear_item, "Button.clear");
        clear_item.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager[] dms) {
                TorrentUtil.clearMOC(dms);
            }
        });
        clear_item.setEnabled(canClearMOC);
        MenuItem set_item = new MenuItem(moc_menu, 8);
        Messages.setLanguageText((Widget)set_item, "label.set");
        set_item.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager[] dms) {
                TorrentUtil.setMOC(shell, dms);
            }
        });
        set_item.setEnabled(canSetMOC);
        moc_item.setEnabled(canClearMOC || canSetMOC);
        MenuItem itemFileExport = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileExport, "MyTorrentsView.menu.exportdownload");
        itemFileExport.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager[] dms) {
                TorrentUtil.exportDownloads(shell, dms);
            }
        });
        itemFileExport.setEnabled(fileExport);
        MenuItem itemCheckFilesExist = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemCheckFilesExist, "MyTorrentsView.menu.checkfilesexist");
        itemCheckFilesExist.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                dm.filesExist(true);
            }
        });
        MenuItem itemLocateFiles = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemLocateFiles, "MyTorrentsView.menu.locatefiles");
        itemLocateFiles.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager[] dms) {
                ManagerUtils.locateFiles(dms, shell);
            }
        });
        final MenuItem itemFileRescan = new MenuItem(menuFiles, 32);
        Messages.setLanguageText((Widget)itemFileRescan, "MyTorrentsView.menu.rescanfile");
        itemFileRescan.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                dm.getDownloadState().setFlag(2L, itemFileRescan.getSelection());
            }
        });
        itemFileRescan.setSelection(allScanSelected);
        itemFileRescan.setEnabled(fileRescan);
        MenuItem itemLowResourceRecheck = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemLowResourceRecheck, "MyTorrentsView.menu.lowresourcerecheck");
        itemLowResourceRecheck.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                ManagerUtils.lowResourceRecheck(dm);
            }
        });
        itemLowResourceRecheck.setEnabled(lrrecheck);
        MenuItem itemRevertFiles = new MenuItem(menu, 8);
        itemRevertFiles.setText(String.valueOf(MessageText.getString("MyTorrentsView.menu.revertfiles")) + "...");
        itemRevertFiles.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager[] dms) {
                FilesViewMenuUtil.revertFiles(tv, dms);
            }
        });
        itemRevertFiles.setEnabled(hasRevertableFiles);
        MenuItem itemViewLinks = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemViewLinks, "menu.view.links");
        itemViewLinks.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager[] dms) {
                ManagerUtils.viewLinks(dms);
            }
        });
        MenuItem itemClearLinks = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemClearLinks, "FilesView.menu.clear.links");
        itemClearLinks.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                DiskManagerFileInfoSet fis;
                if (ManagerUtils.isStopped(dm) && dm.getDownloadState().getFileLinks().hasLinks() && (fis = dm.getDiskManagerFileInfoSet()).nbFiles() > 1) {
                    DiskManagerFileInfo[] files;
                    DiskManagerFileInfo[] diskManagerFileInfoArray = files = fis.getFiles();
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DiskManagerFileInfo file_info = diskManagerFileInfoArray[n2];
                        File file_link = file_info.getFile(true);
                        File file_nolink = file_info.getFile(false);
                        if (!file_nolink.getAbsolutePath().equals(file_link.getAbsolutePath())) {
                            file_info.setLink(null, true);
                        }
                        ++n2;
                    }
                }
            }
        });
        itemClearLinks.setEnabled(hasClearableLinks);
        MenuItem itemFileAlloc = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileAlloc, "label.allocate");
        itemFileAlloc.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                dm.getDownloadState().setLongAttribute("fas", 2L);
                dm.getDownloadState().setFlag(16384L, false);
                ManagerUtils.queue(dm, null);
            }
        });
        itemFileAlloc.setEnabled(allAllocatable);
        MenuItem itemFileClearAlloc = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileClearAlloc, "MyTorrentsView.menu.clear_alloc_data");
        itemFileClearAlloc.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                dm.setDataAlreadyAllocated(false);
            }
        });
        itemFileClearAlloc.setEnabled(allStopped);
        MenuItem itemFileClearResume = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileClearResume, "MyTorrentsView.menu.clear_resume_data");
        itemFileClearResume.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                dm.getDownloadState().clearResumeData();
            }
        });
        itemFileClearResume.setEnabled(allStopped);
        MenuItem itemFileSetResumeComplete = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileSetResumeComplete, "MyTorrentsView.menu.set.resume.complete");
        itemFileSetResumeComplete.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                TorrentUtils.setResumeDataCompletelyValid(dm.getDownloadState());
            }
        });
        itemFileSetResumeComplete.setEnabled(allStopped && allResumeIncomplete);
        Menu restore_menu = new Menu((Decorations)menuFiles.getShell(), 4);
        MenuItem itemRestoreResume = new MenuItem(menuFiles, 64);
        Messages.setLanguageText((Widget)itemRestoreResume, "MyTorrentsView.menu.restore.resume.data");
        itemRestoreResume.setMenu(restore_menu);
        boolean restoreEnabled = false;
        if (dms.length == 1 && allStopped && !(history = (dmState = dms[0].getDownloadState()).getResumeDataHistory()).isEmpty()) {
            restoreEnabled = true;
            for (DownloadManagerState.ResumeHistory h : history) {
                MenuItem itemHistory = new MenuItem(restore_menu, 8);
                itemHistory.setText(new SimpleDateFormat().format(new Date(h.getDate())));
                itemHistory.addListener(13, ev -> dmState.restoreResumeData(h));
            }
        }
        itemRestoreResume.setEnabled(restoreEnabled);
        final MenuItem itemMaskDLComp = new MenuItem(menuFiles, 32);
        if (dms.length > 0) {
            itemMaskDLComp.setSelection(allMaskDC);
        }
        Messages.setLanguageText((Widget)itemMaskDLComp, "ConfigView.label.hap");
        itemMaskDLComp.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                dm.getDownloadState().setOptionalBooleanAttribute("mdlc", itemMaskDLComp.getSelection());
            }
        });
        itemMaskDLComp.setEnabled(dms.length > 0);
        final ArrayList<Download> ar_dms = new ArrayList<Download>();
        DownloadManager[] downloadManagerArray = dms;
        int itemHistory = dms.length;
        int n = 0;
        while (n < itemHistory) {
            DownloadManager dm = downloadManagerArray[n];
            Download stub = PluginCoreUtils.wrap(dm);
            if (stub.canStubbify()) {
                ar_dms.add(stub);
            }
            ++n;
        }
        MenuItem itemArchive = new MenuItem(menuAdvanced, 8);
        Messages.setLanguageText((Widget)itemArchive, "MyTorrentsView.menu.archive");
        Utils.setMenuItemImage(itemArchive, "archive");
        itemArchive.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager[] todo) {
                ManagerUtils.moveToArchive(ar_dms, null);
            }
        });
        itemArchive.setEnabled(ar_dms.size() > 0);
        MenuItem itemRename = new MenuItem(menuAdvanced, 4);
        Messages.setLanguageText((Widget)itemRename, "MyTorrentsView.menu.rename");
        itemRename.setEnabled(hasSelection);
        itemRename.addListener(13, event2 -> ManagerUtils.advancedRename(dms));
        if (ManagerUtils.canFindMoreLikeThis()) {
            MenuItem itemFindMore = new MenuItem(menuAdvanced, 8);
            Messages.setLanguageText((Widget)itemFindMore, "MyTorrentsView.menu.findmorelikethis");
            itemFindMore.addListener(13, (Listener)new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager[] dms) {
                    ManagerUtils.findMoreLikeThis(dms[0], shell);
                }
            });
            itemFindMore.setSelection(isSingleSelection);
        }
        Menu quickViewMenu = new Menu((Decorations)menuAdvanced.getShell(), 4);
        MenuItem quickViewMenuItem = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)quickViewMenuItem, "MainWindow.menu.quick_view");
        quickViewMenuItem.setMenu(quickViewMenu);
        MenuBuildUtils.addMaintenanceListenerForMenu(quickViewMenu, new MenuBuildUtils.MenuBuilder(){

            @Override
            public void buildMenu(Menu menu, MenuEvent menuEvent) {
                DownloadManager dm = dms[0];
                DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                int added = 0;
                DiskManagerFileInfo[] diskManagerFileInfoArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    final DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
                    if (Utils.isQuickViewSupported(file)) {
                        final MenuItem addItem = new MenuItem(menu, 32);
                        addItem.setSelection(Utils.isQuickViewActive(file));
                        addItem.setText(file.getTorrentFile().getRelativePath());
                        addItem.addListener(13, new Listener(){

                            public void handleEvent(Event arg) {
                                Utils.setQuickViewActive(file, addItem.getSelection());
                            }
                        });
                        ++added;
                    }
                    ++n2;
                }
                if (added == 0) {
                    MenuItem addItem = new MenuItem(menu, 8);
                    addItem.setText(MessageText.getString("quick.view.no.files"));
                    addItem.setEnabled(false);
                }
            }
        });
        quickViewMenuItem.setEnabled(isSingleSelection);
        MenuFactory.addAlertsMenu(menuAdvanced, true, dms);
        if (userMode > 0) {
            MenuItem itemExport = new MenuItem(menuAdvanced, 64);
            Messages.setLanguageText((Widget)itemExport, "MyTorrentsView.menu.exportmenu");
            Utils.setMenuItemImage(itemExport, "export");
            itemExport.setEnabled(hasSelection);
            Menu menuExport = new Menu((Decorations)menu_shell, 4);
            itemExport.setMenu(menuExport);
            final MenuItem itemExportXML = new MenuItem(menuExport, 8);
            Messages.setLanguageText((Widget)itemExportXML, "MyTorrentsView.menu.export");
            itemExportXML.addListener(13, (Listener)new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager[] dms) {
                    DownloadManager dm = dms[0];
                    if (dm != null) {
                        new ExportTorrentWizard(itemExportXML.getDisplay(), dm);
                    }
                }
            });
            MenuItem itemExportTorrent = new MenuItem(menuExport, 8);
            Messages.setLanguageText((Widget)itemExportTorrent, "MyTorrentsView.menu.exporttorrent");
            itemExportTorrent.addListener(13, (Listener)new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager[] dms) {
                    TorrentUtil.exportTorrent(dms, shell);
                }
            });
            MenuItem itemWebSeed = new MenuItem(menuExport, 8);
            Messages.setLanguageText((Widget)itemWebSeed, "MyTorrentsView.menu.exporthttpseeds");
            itemWebSeed.addListener(13, (Listener)new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager[] dms) {
                    TorrentUtil.exportHTTPSeeds(dms);
                }
            });
        }
        if (userMode > 0) {
            MenuItem itemExportXML = new MenuItem(menuAdvanced, 8);
            Messages.setLanguageText((Widget)itemExportXML, "label.options.and.info");
            itemExportXML.addListener(13, (Listener)new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager[] dms) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        uiFunctions.getMDI().showEntryByID("TorrentOptionsView", dms);
                    }
                }
            });
        }
        if (userMode > 0) {
            MenuItem itemPeerSource = new MenuItem(menuAdvanced, 64);
            Messages.setLanguageText((Widget)itemPeerSource, "MyTorrentsView.menu.peersource");
            Menu menuPeerSource = new Menu((Decorations)menu_shell, 4);
            itemPeerSource.setMenu(menuPeerSource);
            TorrentUtil.addPeerSourceSubMenu(dms, menuPeerSource);
        }
        final MenuItem dl_seq_enable = new MenuItem(menuAdvanced, 32);
        Messages.setLanguageText((Widget)dl_seq_enable, "menu.sequential.download");
        dl_seq_enable.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                dm.getDownloadState().setFlag(8192L, dl_seq_enable.getSelection());
            }
        });
        boolean allSeq = true;
        boolean AllNonSeq = true;
        int j = 0;
        while (j < dms.length) {
            DownloadManager dm = dms[j];
            boolean seq = dm.getDownloadState().getFlag(8192L);
            if (seq) {
                AllNonSeq = false;
            } else {
                allSeq = false;
            }
            ++j;
        }
        boolean bChecked = allSeq ? true : (AllNonSeq ? false : false);
        dl_seq_enable.setSelection(bChecked);
        if (userMode > 0) {
            final MenuItem ipf_enable = new MenuItem(menuAdvanced, 32);
            Messages.setLanguageText((Widget)ipf_enable, "MyTorrentsView.menu.ipf_enable");
            ipf_enable.addListener(13, (Listener)new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager dm) {
                    dm.getDownloadState().setFlag(256L, !ipf_enable.getSelection());
                }
            });
            boolean bEnabled = IpFilterManagerFactory.getSingleton().getIPFilter().isEnabled();
            if (bEnabled) {
                boolean allChecked = true;
                boolean allUnchecked = true;
                int j2 = 0;
                while (j2 < dms.length) {
                    DownloadManager dm = dms[j2];
                    boolean b = dm.getDownloadState().getFlag(256L);
                    if (b) {
                        allUnchecked = false;
                    } else {
                        allChecked = false;
                    }
                    ++j2;
                }
                boolean bChecked2 = allUnchecked ? true : (allChecked ? false : false);
                ipf_enable.setSelection(bChecked2);
            }
            ipf_enable.setEnabled(bEnabled);
        }
        if (userMode > 1) {
            MenuItem itemNetworks = new MenuItem(menuAdvanced, 64);
            Messages.setLanguageText((Widget)itemNetworks, "MyTorrentsView.menu.networks");
            Menu menuNetworks = new Menu((Decorations)menu_shell, 4);
            itemNetworks.setMenu(menuNetworks);
            TorrentUtil.addNetworksSubMenu(dms, menuNetworks);
        }
        if (userMode > 1 && isSeedingView) {
            MenuItem itemSuperSeed = new MenuItem(menuAdvanced, 32);
            Messages.setLanguageText((Widget)itemSuperSeed, "ManagerItem.superseeding");
            boolean enabled = canSetSuperSeed && (superSeedAllNo || superSeedAllYes);
            itemSuperSeed.setEnabled(enabled);
            final boolean selected = superSeedAllNo;
            if (enabled) {
                itemSuperSeed.setSelection(selected);
                itemSuperSeed.addListener(13, (Listener)new ListenerDMTask(dms){

                    @Override
                    public void run(DownloadManager dm) {
                        PEPeerManager pm = dm.getPeerManager();
                        if (pm != null && pm.isSuperSeedMode() == selected && pm.canToggleSuperSeedMode()) {
                            pm.setSuperSeedMode(!selected);
                        }
                    }
                });
            }
        }
        if (userMode > 0) {
            boolean can_pause_for = false;
            int i = 0;
            while (i < dms.length) {
                DownloadManager dm = dms[i];
                if (dm.isPaused() || ManagerUtils.isPauseable(dm)) {
                    can_pause_for = true;
                    break;
                }
                ++i;
            }
            MenuItem itemPauseFor = new MenuItem(menuAdvanced, 8);
            itemPauseFor.setEnabled(can_pause_for);
            Messages.setLanguageText((Widget)itemPauseFor, "MainWindow.menu.transfers.pausetransfersfor");
            itemPauseFor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TorrentUtil.pauseDownloadsFor(dms);
                }
            });
        }
        MenuItem itemPositionManual = new MenuItem(menuAdvanced, 8);
        Messages.setLanguageText((Widget)itemPositionManual, "MyTorrentsView.menu.reposition.manual");
        Utils.setMenuItemImage(itemPositionManual, "move");
        itemPositionManual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TorrentUtil.repositionManual(tv, dms, shell, isSeedingView);
            }
        });
        if (userMode > 0 && isTrackerOn) {
            MenuItem itemHost = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemHost, "MyTorrentsView.menu.host");
            Utils.setMenuItemImage(itemHost, "host");
            itemHost.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    TorrentUtil.hostTorrents(dms);
                }
            });
            MenuItem itemPublish = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemPublish, "MyTorrentsView.menu.publish");
            Utils.setMenuItemImage(itemPublish, "publish");
            itemPublish.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    TorrentUtil.publishTorrents(dms);
                }
            });
            itemHost.setEnabled(hasSelection);
            itemPublish.setEnabled(hasSelection);
        }
        Menu menuCategory = new Menu((Decorations)menu_shell, 4);
        MenuItem itemCategory = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemCategory, "MyTorrentsView.menu.setCategory");
        itemCategory.setMenu(menuCategory);
        itemCategory.setEnabled(hasSelection);
        TorrentUtil.addCategorySubMenu(dms, menuCategory);
        Menu menuTags = new Menu((Decorations)menu_shell, 4);
        MenuItem itemTags = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemTags, "label.tags");
        itemTags.setMenu(menuTags);
        itemTags.setEnabled(hasSelection);
        TagUIUtils.addLibraryViewTagsSubMenu(dms, menuTags);
        if (isSeedingView) {
            MenuItem itemPersonalShare = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemPersonalShare, "MyTorrentsView.menu.create_personal_share");
            itemPersonalShare.addListener(13, (Listener)new ListenerDMTask(dms, false){

                @Override
                public void run(DownloadManager dm) {
                    File file = dm.getSaveLocation();
                    HashMap<String, String> properties = new HashMap<String, String>();
                    if (Utils.setPeronalShare(properties)) {
                        if (file.isFile()) {
                            ShareUtils.shareFile(file.getAbsolutePath(), properties);
                        } else if (file.isDirectory()) {
                            ShareUtils.shareDir(file.getAbsolutePath(), properties);
                        }
                    }
                }
            });
            boolean can_share_pers = dms.length > 0;
            DownloadManager[] downloadManagerArray2 = dms;
            int n2 = dms.length;
            int n3 = 0;
            while (n3 < n2) {
                DownloadManager dm = downloadManagerArray2[n3];
                File file = dm.getSaveLocation();
                if (!file.exists()) {
                    can_share_pers = false;
                    break;
                }
                ++n3;
            }
            itemPersonalShare.setEnabled(can_share_pers);
        }
        new MenuItem(menu, 2);
        MenuItem itemQueue = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemQueue, "MyTorrentsView.menu.queue");
        Utils.setMenuItemImage(itemQueue, "start");
        itemQueue.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Utils.getOffOfSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        TorrentUtil.queueDataSources(dms, false);
                    }
                });
            }
        });
        itemQueue.setEnabled(start);
        if (TorrentUtil.isForceStartVisible(dms)) {
            final MenuItem itemForceStart = new MenuItem(menu, 32);
            Messages.setLanguageText((Widget)itemForceStart, "MyTorrentsView.menu.forceStart");
            Utils.setMenuItemImage(itemForceStart, "forcestart");
            itemForceStart.addListener(13, (Listener)new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager dm) {
                    if (ManagerUtils.isForceStartable(dm)) {
                        dm.setForceStart(itemForceStart.getSelection());
                    }
                }
            });
            itemForceStart.setSelection(forceStart);
            itemForceStart.setEnabled(forceStartEnabled);
        }
        if (userMode > 0) {
            MenuItem itemPause = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemPause, "v3.MainWindow.button.pause");
            Utils.setMenuItemImage(itemPause, "pause");
            itemPause.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    Utils.getOffOfSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            TorrentUtil.pauseDataSources(dms);
                        }
                    });
                }
            });
            itemPause.setEnabled(pause);
        }
        MenuItem itemStop = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemStop, "MyTorrentsView.menu.stop");
        Utils.setMenuItemImage(itemStop, "stop");
        itemStop.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Utils.getOffOfSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        TorrentUtil.stopDataSources(dms);
                    }
                });
            }
        });
        itemStop.setEnabled(stop);
        MenuItem itemRecheck = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRecheck, "MyTorrentsView.menu.recheck");
        Utils.setMenuItemImage(itemRecheck, "recheck");
        itemRecheck.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                if (dm.canForceRecheck()) {
                    dm.forceRecheck();
                }
            }
        });
        itemRecheck.setEnabled(recheck);
        MenuItem itemRemove = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRemove, "menu.delete.options");
        Utils.setMenuItemImage(itemRemove, "delete");
        itemRemove.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TorrentUtil.removeDownloads(dms, null, true);
            }
        });
        itemRemove.setEnabled(hasSelection);
    }

    protected static void addNetworksSubMenu(DownloadManager[] dms, Menu menuNetworks) {
        int i = 0;
        while (i < AENetworkClassifier.AT_NETWORKS.length) {
            boolean bChecked;
            final String nn = AENetworkClassifier.AT_NETWORKS[i];
            String msg_text = "ConfigView.section.connection.networks." + nn;
            final MenuItem itemNetwork = new MenuItem(menuNetworks, 32);
            itemNetwork.setData("network", (Object)nn);
            Messages.setLanguageText((Widget)itemNetwork, msg_text);
            itemNetwork.addListener(13, (Listener)new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager dm) {
                    dm.getDownloadState().setNetworkEnabled(nn, itemNetwork.getSelection());
                }
            });
            boolean bl = bChecked = dms.length > 0;
            if (bChecked) {
                int j = 0;
                while (j < dms.length) {
                    DownloadManager dm = dms[j];
                    if (!dm.getDownloadState().isNetworkEnabled(nn)) {
                        bChecked = false;
                        break;
                    }
                    ++j;
                }
            }
            itemNetwork.setSelection(bChecked);
            ++i;
        }
    }

    protected static void addPeerSourceSubMenu(DownloadManager[] dms, Menu menuPeerSource) {
        boolean hasSelection = dms.length > 0;
        int i = 0;
        while (i < PEPeerSource.PS_SOURCES.length) {
            boolean bEnabled;
            final String p = PEPeerSource.PS_SOURCES[i];
            String msg_text = "ConfigView.section.connection.peersource." + p;
            final MenuItem itemPS = new MenuItem(menuPeerSource, 32);
            itemPS.setData("peerSource", (Object)p);
            Messages.setLanguageText((Widget)itemPS, msg_text);
            itemPS.addListener(13, (Listener)new ListenerDMTask(dms){

                @Override
                public void run(DownloadManager dm) {
                    dm.getDownloadState().setPeerSourceEnabled(p, itemPS.getSelection());
                }
            });
            itemPS.setSelection(true);
            boolean bChecked = hasSelection;
            boolean bl = bEnabled = !hasSelection;
            if (bChecked) {
                bEnabled = true;
                int j = 0;
                while (j < dms.length) {
                    DownloadManager dm = dms[j];
                    if (!dm.getDownloadState().isPeerSourceEnabled(p)) {
                        bChecked = false;
                    }
                    if (!dm.getDownloadState().isPeerSourcePermitted(p)) {
                        bEnabled = false;
                    }
                    ++j;
                }
            }
            itemPS.setSelection(bChecked);
            itemPS.setEnabled(bEnabled);
            ++i;
        }
    }

    protected static void exportHTTPSeeds(DownloadManager[] dms) {
        String port;
        String NL = "\r\n";
        String data = "";
        boolean http_enable = COConfigurationManager.getBooleanParameter("HTTP.Data.Listen.Port.Enable");
        if (http_enable) {
            int p = COConfigurationManager.getIntParameter("HTTP.Data.Listen.Port");
            int o = COConfigurationManager.getIntParameter("HTTP.Data.Listen.Port.Override");
            port = o == 0 ? String.valueOf(p) : String.valueOf(o);
        } else {
            data = "You need to enable the HTTP port or modify the URL(s) appropriately\r\n\r\n";
            port = "<port>";
        }
        String ip = COConfigurationManager.getStringParameter("Tracker IP", "");
        if (ip.length() == 0) {
            data = String.valueOf(data) + "You might need to modify the host address in the URL(s)\r\n\r\n";
            try {
                InetAddress ia = NetworkAdmin.getSingleton().getDefaultPublicAddress();
                if (ia != null) {
                    ip = IPToHostNameResolver.syncResolve(ia.getHostAddress(), 10000);
                }
            }
            catch (Throwable ia) {
                // empty catch block
            }
            if (ip.length() == 0) {
                ip = "<host>";
            }
        }
        String base = "http://" + UrlUtils.convertIPV6Host(ip) + ":" + port + "/";
        int i = 0;
        while (i < dms.length) {
            TOTorrent torrent;
            DownloadManager dm = dms[i];
            if (dm != null && (torrent = dm.getTorrent()) != null) {
                data = String.valueOf(data) + base + "webseed" + "\r\n";
                try {
                    data = String.valueOf(data) + base + "files/" + URLEncoder.encode(new String(torrent.getHash(), "ISO-8859-1"), "ISO-8859-1") + "/" + "\r\n" + "\r\n";
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (data.length() > 0) {
            ClipboardCopy.copyToClipBoard(data);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static void exportTorrent(DownloadManager[] dms, Shell parentShell) {
        destinations = new File[dms.length];
        if (dms.length == 1) {
            fd = new FileDialog(parentShell, 8192);
            fd.setFileName(dms[0].getTorrentFileName());
            path = fd.open();
            if (path == null) {
                return;
            }
            destinations[0] = new File(path);
        } else {
            dd = new DirectoryDialog(parentShell, 8192);
            path = dd.open();
            if (path == null) {
                return;
            }
            i = 0;
            while (i < dms.length) {
                destinations[i] = new File(path, new File(dms[i].getTorrentFileName()).getName());
                ++i;
            }
        }
        i = 0;
        try {
            applyToAll = false;
            applyToAllDecision = 128;
            while (i < dms.length) {
                target = destinations[i];
                if (target.exists()) {
                    if (applyToAll) {
                        result = applyToAllDecision;
                    } else {
                        mb = new MessageBoxShell(192, MessageText.getString("exportTorrentWizard.process.outputfileexists.title"), String.valueOf(dms[i].getDisplayName()) + "\n\n" + MessageText.getString("exportTorrentWizard.process.outputfileexists.message"));
                        if (dms.length > 1) {
                            mb.setApplyToAllEnabled();
                        }
                        mb.open(null);
                        result = mb.waitUntilClosed();
                        applyToAll = mb.getApplyToAll();
                        if (applyToAll) {
                            applyToAllDecision = result;
                        }
                    }
                    if (result != 128) {
                        if (!target.delete()) {
                            throw new Exception("Failed to delete file");
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    TorrentUtils.copyToFile(dms[i].getDownloadState().getTorrent(), target);
                    dest = TOTorrentFactory.deserialiseFromBEncodedFile(target);
                    dest.removeAdditionalProperties();
                    dest.serialiseToBEncodedFile(target);
                }
                ++i;
            }
        }
        catch (Throwable e) {
            Logger.log(new LogAlert((Object)dms[i], false, "Torrent export failed", e));
        }
    }

    public static void exportTorrent(String torrent_name, TOTorrent torrent, Shell parentShell) {
        FileDialog fd = new FileDialog(parentShell, 8192);
        fd.setFileName(torrent_name);
        String path = fd.open();
        if (path == null) {
            return;
        }
        File target = new File(path);
        try {
            if (target.exists()) {
                MessageBoxShell mb = new MessageBoxShell(192, MessageText.getString("exportTorrentWizard.process.outputfileexists.title"), String.valueOf(torrent_name) + "\n\n" + MessageText.getString("exportTorrentWizard.process.outputfileexists.message"));
                mb.open(null);
                int result = mb.waitUntilClosed();
                if (result == 128) {
                    return;
                }
                if (!target.delete()) {
                    throw new Exception("Failed to delete file");
                }
            }
            Map map = torrent.serialiseToMap();
            TOTorrent dest = TOTorrentFactory.deserialiseFromMap(map);
            dest.removeAdditionalProperties();
            dest.serialiseToBEncodedFile(target);
        }
        catch (Throwable e) {
            Logger.log(new LogAlert((Object)torrent_name, false, "Torrent export failed", e));
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void exportTorrents(String[] torrent_names, TOTorrent[] torrents, Shell parentShell) {
        fd = new DirectoryDialog(parentShell, 8192);
        path = fd.open();
        if (path == null) {
            return;
        }
        dir = new File(path);
        i = 0;
        while (i < torrents.length) {
            torrent_name = torrent_names[i];
            target = new File(dir, torrent_name);
            try {
                if (target.exists()) {
                    mb = new MessageBoxShell(192, MessageText.getString("exportTorrentWizard.process.outputfileexists.title"), String.valueOf(torrent_name) + "\n\n" + MessageText.getString("exportTorrentWizard.process.outputfileexists.message"));
                    mb.open(null);
                    result = mb.waitUntilClosed();
                    if (result != 128) {
                        if (!target.delete()) {
                            throw new Exception("Failed to delete file");
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    map = torrents[i].serialiseToMap();
                    dest = TOTorrentFactory.deserialiseFromMap(map);
                    dest.removeAdditionalProperties();
                    dest.serialiseToBEncodedFile(target);
                }
            }
            catch (Throwable e) {
                Logger.log(new LogAlert((Object)torrent_name, false, "Torrent export failed", e));
            }
            ++i;
        }
    }

    protected static void pauseDownloadsFor(DownloadManager[] dms) {
        final ArrayList<DownloadManager> dms_to_pause = new ArrayList<DownloadManager>();
        int i = 0;
        while (i < dms.length) {
            DownloadManager dm = dms[i];
            if (dm.isPaused() || ManagerUtils.isPauseable(dm)) {
                dms_to_pause.add(dm);
            }
            ++i;
        }
        if (dms_to_pause.size() == 0) {
            return;
        }
        String text = MessageText.getString("dialog.pause.for.period.text");
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("dialog.pause.for.period.title", "!" + text + "!");
        int def = COConfigurationManager.getIntParameter("pause.for.period.default", 10);
        entryWindow.setPreenteredText(String.valueOf(def), false);
        entryWindow.prompt(new UIInputReceiverListener(){

            @Override
            public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                if (!entryWindow.hasSubmittedInput()) {
                    return;
                }
                String sReturn = entryWindow.getSubmittedInput();
                if (sReturn == null) {
                    return;
                }
                int mins = -1;
                try {
                    mins = Integer.valueOf(sReturn);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (mins <= 0) {
                    MessageBox mb = new MessageBox(Utils.findAnyShell(), 33);
                    mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                    mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                    mb.open();
                    return;
                }
                COConfigurationManager.setParameter("pause.for.period.default", mins);
                ManagerUtils.asyncPauseForPeriod(dms_to_pause, mins * 60);
            }
        });
    }

    protected static void addSpeedLimitsMenu(DownloadManager[] dms, Menu menu) {
        Core core = CoreFactory.getSingleton();
        Shell menu_shell = menu.getShell();
        final SpeedLimitHandler slh = SpeedLimitHandler.getSingleton(core);
        boolean all_have_limit = true;
        HashSet<String> common_profiles = new HashSet<String>();
        final ArrayList<byte[]> dm_hashes = new ArrayList<byte[]>();
        int i = 0;
        while (i < dms.length) {
            Object t;
            DownloadManager dm = dms[i];
            int maxul = dm.getStats().getUploadRateLimitBytesPerSecond();
            int maxdl = dm.getStats().getDownloadRateLimitBytesPerSecond();
            if (maxul == 0 && maxdl == 0) {
                all_have_limit = false;
            }
            if ((t = dm.getTorrent()) == null) {
                common_profiles.clear();
            } else {
                try {
                    byte[] hash = t.getHash();
                    dm_hashes.add(hash);
                    List<String> profs = slh.getProfilesForDownload(hash);
                    if (i == 0) {
                        common_profiles.addAll(profs);
                    } else {
                        common_profiles.retainAll(profs);
                    }
                }
                catch (TOTorrentException e) {
                    Debug.out(e);
                    common_profiles.clear();
                }
            }
            ++i;
        }
        List<String> profiles = slh.getProfileNames();
        Menu add_to_prof_menu = new Menu((Decorations)menu_shell, 4);
        MenuItem add_to_prof_item = new MenuItem(menu, 64);
        add_to_prof_item.setMenu(add_to_prof_menu);
        Messages.setLanguageText((Widget)add_to_prof_item, "MyTorrentsView.menu.sl_add_to_prof");
        if (!all_have_limit) {
            add_to_prof_item.setEnabled(false);
        } else {
            for (final String p : profiles) {
                MenuItem addItem = new MenuItem(add_to_prof_menu, 8);
                addItem.setText(p);
                addItem.addListener(13, new Listener(){

                    public void handleEvent(Event arg0) {
                        slh.addDownloadsToProfile(p, dm_hashes);
                        Utils.showText("MainWindow.menu.speed_limits.info.title", MessageText.getString("MainWindow.menu.speed_limits.info.prof", new String[]{p}), slh.getProfile(p));
                    }
                });
            }
        }
        Menu remove_from_prof_menu = new Menu((Decorations)menu_shell, 4);
        MenuItem remove_from_prof_item = new MenuItem(menu, 64);
        remove_from_prof_item.setMenu(remove_from_prof_menu);
        Messages.setLanguageText((Widget)remove_from_prof_item, "MyTorrentsView.menu.sl_remove_from_prof");
        if (common_profiles.isEmpty()) {
            remove_from_prof_item.setEnabled(false);
        } else {
            for (final String p : common_profiles) {
                MenuItem addItem = new MenuItem(remove_from_prof_menu, 8);
                addItem.setText(p);
                addItem.addListener(13, new Listener(){

                    public void handleEvent(Event arg0) {
                        slh.removeDownloadsFromProfile(p, dm_hashes);
                        Utils.showText("MainWindow.menu.speed_limits.info.title", MessageText.getString("MainWindow.menu.speed_limits.info.prof", new String[]{p}), slh.getProfile(p));
                    }
                });
            }
        }
    }

    protected static void addTrackerTorrentMenu(Menu menuTracker, final DownloadManager[] dms, boolean changeUrl, boolean manualUpdate, boolean allStopped, final boolean use_open_containing_folder, boolean canMove) {
        final Shell shell = Utils.findAnyShell();
        boolean hasSelection = dms.length > 0;
        MenuItem itemChangeTracker = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemChangeTracker, "MyTorrentsView.menu.changeTracker");
        Utils.setMenuItemImage(itemChangeTracker, "add_tracker");
        itemChangeTracker.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager[] dms) {
                if (dms.length > 0) {
                    new TrackerChangerWindow(dms);
                }
            }
        });
        itemChangeTracker.setEnabled(changeUrl);
        MenuItem itemEditTracker = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemEditTracker, "MyTorrentsView.menu.editTracker");
        Utils.setMenuItemImage(itemEditTracker, "edit_trackers");
        itemEditTracker.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager[] dms) {
                HashMap<String, ArrayList<DownloadManager>> same_map = new HashMap<String, ArrayList<DownloadManager>>();
                DownloadManager[] downloadManagerArray = dms;
                int n = dms.length;
                int n2 = 0;
                while (n2 < n) {
                    DownloadManager dm = downloadManagerArray[n2];
                    TOTorrent torrent = dm.getTorrent();
                    if (torrent != null) {
                        List<List<String>> group = TorrentUtils.announceGroupsToList(torrent);
                        String str = "";
                        for (List<String> l : group) {
                            str = String.valueOf(str) + "[[";
                            for (String s : l) {
                                str = String.valueOf(str) + s + ", ";
                            }
                        }
                        ArrayList<DownloadManager> dl = (ArrayList<DownloadManager>)same_map.get(str);
                        if (dl == null) {
                            dl = new ArrayList<DownloadManager>();
                            same_map.put(str, dl);
                        }
                        dl.add(dm);
                    }
                    ++n2;
                }
                for (final List set : same_map.values()) {
                    TOTorrent torrent = ((DownloadManager)set.get(0)).getTorrent();
                    List<List<String>> group = TorrentUtils.announceGroupsToList(torrent);
                    new MultiTrackerEditor(null, null, group, new TrackerEditorListener(){

                        @Override
                        public void trackersChanged(String str, String str2, List<List<String>> group) {
                            for (DownloadManager dm : set) {
                                TOTorrent torrent = dm.getTorrent();
                                TorrentUtils.listToAnnounceGroups(group, torrent);
                                try {
                                    TorrentUtils.writeToFile(torrent);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                                if (dm.getTrackerClient() == null) continue;
                                dm.getTrackerClient().resetTrackerUrl(true);
                            }
                        }
                    }, true, true);
                }
            }
        });
        itemEditTracker.setEnabled(hasSelection);
        MenuItem itemEditTrackerMerged = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemEditTrackerMerged, "MyTorrentsView.menu.editTrackerMerge");
        itemEditTrackerMerged.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(final DownloadManager[] dms) {
                ArrayList<List<String>> merged_trackers = new ArrayList<List<String>>();
                HashSet<String> added = new HashSet<String>();
                DownloadManager[] downloadManagerArray = dms;
                int n = dms.length;
                int n2 = 0;
                while (n2 < n) {
                    DownloadManager dm = downloadManagerArray[n2];
                    TOTorrent torrent = dm.getTorrent();
                    if (torrent != null) {
                        List<List<String>> group = TorrentUtils.announceGroupsToList(torrent);
                        for (List<String> set : group) {
                            ArrayList<String> rem = new ArrayList<String>();
                            for (String url_str : set) {
                                try {
                                    URL url = new URL(url_str);
                                    if (TorrentUtils.isDecentralised(url) || added.contains(url_str)) continue;
                                    added.add(url_str);
                                    rem.add(url_str);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            if (rem.size() <= 0) continue;
                            merged_trackers.add(rem);
                        }
                    }
                    ++n2;
                }
                new MultiTrackerEditor(null, null, merged_trackers, new TrackerEditorListener(){

                    @Override
                    public void trackersChanged(String str, String str2, List<List<String>> group) {
                        DownloadManager[] downloadManagerArray = dms;
                        int n = dms.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DownloadManager dm = downloadManagerArray[n2];
                            TOTorrent torrent = dm.getTorrent();
                            TorrentUtils.listToAnnounceGroups(group, torrent);
                            try {
                                TorrentUtils.writeToFile(torrent);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                            if (dm.getTrackerClient() != null) {
                                dm.getTrackerClient().resetTrackerUrl(true);
                            }
                            ++n2;
                        }
                    }
                }, true, true);
            }
        });
        itemEditTrackerMerged.setEnabled(dms.length > 1);
        MenuItem itemEditWebSeeds = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemEditWebSeeds, "MyTorrentsView.menu.editWebSeeds");
        itemEditWebSeeds.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(final DownloadManager[] dms) {
                final TOTorrent torrent = dms[0].getTorrent();
                if (torrent == null) {
                    return;
                }
                List getright = this.getURLList(torrent, "url-list");
                List webseeds = this.getURLList(torrent, "httpseeds");
                Map<String, List<Object>> ws = new HashMap<String, List>();
                ws.put("getright", getright);
                ws.put("webseeds", webseeds);
                ws = BDecoder.decodeStrings(ws);
                new WebSeedsEditor(null, ws, new WebSeedsEditorListener(){

                    @Override
                    public void webSeedsChanged(String oldName, String newName, Map ws) {
                        try {
                            ws = BDecoder.decode(BEncoder.encode(ws));
                            List getright = (List)ws.get("getright");
                            if (getright == null || getright.size() == 0) {
                                torrent.removeAdditionalProperty("url-list");
                            } else {
                                torrent.setAdditionalListProperty("url-list", getright);
                            }
                            List webseeds = (List)ws.get("webseeds");
                            if (webseeds == null || webseeds.size() == 0) {
                                torrent.removeAdditionalProperty("httpseeds");
                            } else {
                                torrent.setAdditionalListProperty("httpseeds", webseeds);
                            }
                            PluginInterface pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(ExternalSeedPlugin.class);
                            if (pi != null) {
                                ExternalSeedPlugin ext_seed_plugin = (ExternalSeedPlugin)pi.getPlugin();
                                ext_seed_plugin.downloadChanged(PluginCoreUtils.wrap(dms[0]));
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }, true);
            }

            protected List getURLList(TOTorrent torrent, String key) {
                Object obj = torrent.getAdditionalProperty(key);
                if (obj instanceof byte[]) {
                    ArrayList<Object> l = new ArrayList<Object>();
                    l.add(obj);
                    return l;
                }
                if (obj instanceof List) {
                    return (List)obj;
                }
                return new ArrayList();
            }
        });
        itemEditWebSeeds.setEnabled(dms.length == 1);
        MenuItem itemManualUpdate = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemManualUpdate, "GeneralView.label.trackerurlupdate");
        itemManualUpdate.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager dm) {
                dm.requestTrackerAnnounce(false);
            }
        });
        itemManualUpdate.setEnabled(manualUpdate);
        boolean scrape_enabled = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Enable");
        boolean scrape_stopped = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Stopped Enable");
        boolean manualScrape = !scrape_enabled ? false : (!scrape_stopped ? false : allStopped);
        MenuItem itemManualScrape = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemManualScrape, "GeneralView.label.trackerscrapeupdate");
        itemManualScrape.addListener(13, (Listener)new ListenerDMTask(dms, true, true){

            @Override
            public void run(DownloadManager dm) {
                dm.requestTrackerScrape(true);
            }
        });
        itemManualScrape.setEnabled(manualScrape);
        ArrayList<DownloadManager> can_v2_from_hybrid = new ArrayList<DownloadManager>();
        ArrayList<DownloadManager> can_v1_from_hybrid = new ArrayList<DownloadManager>();
        ArrayList<DownloadManager> can_create_from_v1 = new ArrayList<DownloadManager>();
        DownloadManager[] downloadManagerArray = dms;
        int n = dms.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager dm = downloadManagerArray[n2];
            TOTorrent torrent = dm.getTorrent();
            if (torrent != null) {
                int tt = torrent.getTorrentType();
                if (tt == 1 && !torrent.getPrivate()) {
                    boolean all_complete = true;
                    DiskManagerFileInfo[] diskManagerFileInfoArray = dm.getDiskManagerFileInfoSet().getFiles();
                    int n3 = diskManagerFileInfoArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        DiskManagerFileInfo file = diskManagerFileInfoArray[n4];
                        if (file.isSkipped() || file.getDownloaded() != file.getLength()) {
                            all_complete = false;
                            break;
                        }
                        if (file.getFile(false).length() != file.getTorrentFile().getLength()) {
                            all_complete = false;
                            break;
                        }
                        ++n4;
                    }
                    if (all_complete) {
                        can_create_from_v1.add(dm);
                    }
                } else if (tt == 2) {
                    int ett = torrent.getEffectiveTorrentType();
                    try {
                        byte[] truncated_v_other_hash = torrent.getTruncatedHash(ett == 1 ? 3 : 1);
                        if (dm.getGlobalManager().getDownloadManager(new HashWrapper(truncated_v_other_hash)) == null) {
                            DiskManagerFileInfo[] files;
                            boolean compatible = true;
                            DiskManagerFileInfo[] diskManagerFileInfoArray = files = dm.getDiskManagerFileInfoSet().getFiles();
                            int n5 = files.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                DiskManagerFileInfo dm_file = diskManagerFileInfoArray[n6];
                                if (!dm_file.getTorrentFile().isPadFile() && (dm_file.getStorageType() != 1 || dm_file.isLinked())) {
                                    compatible = false;
                                    break;
                                }
                                ++n6;
                            }
                            if (compatible) {
                                if (ett == 1) {
                                    can_v2_from_hybrid.add(dm);
                                } else {
                                    can_v1_from_hybrid.add(dm);
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
            ++n2;
        }
        int i = 0;
        while (i < 2) {
            int canHybridTo;
            ArrayList<DownloadManager> canHybrid;
            if (i == 0) {
                canHybrid = can_v1_from_hybrid;
                canHybridTo = 1;
            } else {
                canHybrid = can_v2_from_hybrid;
                canHybridTo = 3;
            }
            if (!canHybrid.isEmpty()) {
                MenuItem itemHybridVn = new MenuItem(menuTracker, 8);
                Messages.setLanguageText((Widget)itemHybridVn, i == 0 ? "GeneralView.label.run.hybrid.v1" : "GeneralView.label.run.hybrid.v2");
                itemHybridVn.addListener(13, (Listener)new ListenerDMTask(canHybrid.toArray(new DownloadManager[0]), true, true){

                    @Override
                    public void run(final DownloadManager old_manager) {
                        TOTorrent torrent = old_manager.getTorrent();
                        try {
                            TOTorrent other = torrent.selectHybridHashType(canHybridTo);
                            File temp_file = AETemporaryFileHandler.createTempFile();
                            TorrentUtils.writeToFile(other, temp_file, false);
                            File save_loc = old_manager.getSaveLocation();
                            String save_parent = save_loc.getParentFile().getAbsolutePath();
                            String save_file = save_loc.getName();
                            old_manager.getGlobalManager().addDownloadManager(temp_file.getAbsolutePath(), other.getHash(), save_parent, save_file, 0, true, old_manager.getAssumedComplete(), new DownloadManagerInitialisationAdapter(){

                                @Override
                                public void initialised(DownloadManager new_manager, boolean for_seeding) {
                                    DiskManagerFileInfoSet old_file_info_set = old_manager.getDiskManagerFileInfoSet();
                                    DiskManagerFileInfoSet new_file_info_set = new_manager.getDiskManagerFileInfoSet();
                                    DiskManagerFileInfo[] old_file_infos = old_file_info_set.getFiles();
                                    DownloadManagerState new_dms = new_manager.getDownloadState();
                                    new_dms.setDisplayName(String.valueOf(old_manager.getDisplayName()) + " (" + MessageText.getString("label.hybrid").toLowerCase() + ") (v" + (canHybridTo == 1 ? 1 : 2) + ")");
                                    try {
                                        new_dms.suppressStateSave(true);
                                        boolean[] to_skip = new boolean[old_file_infos.length];
                                        int i = 0;
                                        while (i < old_file_infos.length) {
                                            if (old_file_infos[i].isSkipped()) {
                                                to_skip[i] = true;
                                            }
                                            ++i;
                                        }
                                        new_file_info_set.setSkipped(to_skip, true);
                                    }
                                    finally {
                                        new_dms.suppressStateSave(false);
                                    }
                                }

                                @Override
                                public int getActions() {
                                    return 0;
                                }
                            });
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
            }
            ++i;
        }
        final MenuItem itemV1Hybrid = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemV1Hybrid, "menu.create.hybrid.from.v1");
        MenuItem itemV1V2 = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemV1V2, "menu.create.v2.from.v1");
        ListenerDMTask v1Listener = new ListenerDMTask(can_create_from_v1.toArray(new DownloadManager[0]), true, false){
            boolean create_hybrid;

            @Override
            public void handleEvent(Event event2) {
                this.create_hybrid = event2.widget == itemV1Hybrid;
                super.handleEvent(event2);
            }

            @Override
            public void run(final DownloadManager old_manager) {
                try {
                    final File save_loc = old_manager.getSaveLocation();
                    final TOTorrentCreator creator = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(this.create_hybrid ? 2 : 3, save_loc, TorrentUtils.getDecentralisedEmptyURL(), false);
                    final int[] progress = new int[1];
                    final String[] task2 = new String[]{""};
                    creator.addListener(new TOTorrentProgressListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void reportProgress(int percent_complete) {
                            int[] nArray = progress;
                            synchronized (progress) {
                                progress[0] = percent_complete;
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return;
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void reportCurrentTask(String task_description) {
                            String[] stringArray = task2;
                            synchronized (task2) {
                                task2[0] = task_description;
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return;
                            }
                        }
                    });
                    Core core = CoreFactory.getSingleton();
                    core.executeOperation(3, new CoreOperationTask(){

                        @Override
                        public String getName() {
                            return MessageText.getString("wizard.maketorrent.progresstitle");
                        }

                        @Override
                        public DownloadManager getDownload() {
                            return null;
                        }

                        @Override
                        public String[] getAffectedFileSystems() {
                            return FileUtil.getFileStoreNames(save_loc);
                        }

                        @Override
                        public void run(CoreOperation operation) {
                            try {
                                TOTorrent torrent = creator.create();
                                File temp_file = AETemporaryFileHandler.createTempFile();
                                TorrentUtils.writeToFile(torrent, temp_file, false);
                                File save_loc2 = old_manager.getSaveLocation();
                                String save_parent = save_loc2.getParentFile().getAbsolutePath();
                                String save_file = save_loc2.getName();
                                old_manager.getGlobalManager().addDownloadManager(temp_file.getAbsolutePath(), torrent.getHash(), save_parent, save_file, 0, true, true, new DownloadManagerInitialisationAdapter(){

                                    @Override
                                    public void initialised(DownloadManager new_manager, boolean for_seeding) {
                                        DownloadManagerState new_dms = new_manager.getDownloadState();
                                        String type_str = create_hybrid ? MessageText.getString("label.hybrid").toLowerCase() : "v2";
                                        new_dms.setDisplayName(String.valueOf(old_manager.getDisplayName()) + " (" + type_str + ")");
                                    }

                                    @Override
                                    public int getActions() {
                                        return 0;
                                    }
                                });
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }

                        @Override
                        public CoreOperationTask.ProgressCallback getProgressCallback() {
                            return new CoreOperationTask.ProgressCallbackAdapter(){

                                @Override
                                public int getSupportedTaskStates() {
                                    return 12;
                                }

                                @Override
                                public void setTaskState(int state) {
                                    if ((state & 4) != 0) {
                                        creator.cancel();
                                    }
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public int getProgress() {
                                    int[] nArray = progress;
                                    synchronized (progress) {
                                        // ** MonitorExit[var1_1] (shouldn't be in output)
                                        return progress[0] * 10;
                                    }
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public String getSubTaskName() {
                                    String[] stringArray = task2;
                                    synchronized (task2) {
                                        // ** MonitorExit[var1_1] (shouldn't be in output)
                                        return task2[0];
                                    }
                                }
                            };
                        }
                    });
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        };
        itemV1Hybrid.addListener(13, (Listener)v1Listener);
        itemV1V2.addListener(13, (Listener)v1Listener);
        itemV1Hybrid.setEnabled(!can_create_from_v1.isEmpty());
        itemV1V2.setEnabled(!can_create_from_v1.isEmpty());
        MenuItem itemTorrentDL = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemTorrentDL, "MyTorrentsView.menu.torrent.dl");
        itemTorrentDL.addListener(13, (Listener)new ListenerDMTask(dms, false){

            @Override
            public void run(DownloadManager dm) {
                String content;
                TOTorrent torrent = dm.getTorrent();
                String link = null;
                if (torrent == null) {
                    content = "Torrent not available";
                } else {
                    link = TorrentUtils.getObtainedFrom(torrent);
                    if (link != null) {
                        try {
                            new URL(link);
                        }
                        catch (Throwable e) {
                            link = null;
                        }
                    }
                    if (link != null) {
                        if (link.toLowerCase().startsWith("magnet:")) {
                            link = UrlUtils.getMagnetURI(dm);
                            content = "Torrent's magnet link:\r\n\r\n\t" + link;
                        } else {
                            content = "Torrent was obtained from\r\n\r\n\t" + link;
                        }
                    } else if (TorrentUtils.isReallyPrivate(torrent)) {
                        content = "Origin of torrent unknown and it is private so a magnet URI can't be used - sorry!";
                    } else {
                        link = UrlUtils.getMagnetURI(dm);
                        content = "Origin unavailable but magnet URI may work:\r\n\r\n\t" + link;
                    }
                }
                if (link != null) {
                    ClipboardCopy.copyToClipBoard(link);
                    content = String.valueOf(content) + "\r\n\r\nLink copied to clipboard";
                }
                TextViewerWindow viewer = new TextViewerWindow(String.valueOf(MessageText.getString("MyTorrentsView.menu.torrent.dl")) + ": " + dm.getDisplayName(), null, content, false);
            }
        });
        itemTorrentDL.setEnabled(dms.length == 1);
        MenuItem itemFileMoveTorrent = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemFileMoveTorrent, "MyTorrentsView.menu.movetorrent");
        itemFileMoveTorrent.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(DownloadManager[] dms) {
                TorrentUtil.moveTorrentFile(shell, dms);
            }
        });
        itemFileMoveTorrent.setEnabled(canMove);
        MenuItem itemTorrentSwitch = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemTorrentSwitch, "MyTorrentsView.menu.torrent.switch");
        itemTorrentSwitch.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TOTorrent torrent = dms[0].getTorrent();
                if (torrent == null) {
                    return;
                }
                try {
                    byte[] existing_hash = torrent.getHash();
                    FileDialog dialog = new FileDialog(shell, 4098);
                    dialog.setText(MessageText.getString("dialog.select.torrent.file"));
                    dialog.setFilterExtensions(new String[]{"*.torrent"});
                    dialog.setFilterNames(new String[]{"*.torrent"});
                    String path = dialog.open();
                    if (path == null) {
                        return;
                    }
                    File file = new File(path);
                    byte[] replacement_hash = TOTorrentFactory.deserialiseFromBEncodedFile(file).getHash();
                    if (!Arrays.equals(existing_hash, replacement_hash)) {
                        throw new Exception("Hash mismatch: old=" + ByteFormatter.encodeString(existing_hash) + ", new=" + ByteFormatter.encodeString(replacement_hash));
                    }
                    dms[0].setTorrentFileName(file.getAbsolutePath());
                }
                catch (Throwable e) {
                    MessageBox mb = new MessageBox(shell, 33);
                    mb.setText(MessageText.getString("MyTorrentsView.menu.torrent.switch.fail"));
                    mb.setMessage(MessageText.getString("MyTorrentsView.menu.torrent.switch.fail.text", new String[]{Debug.getNestedExceptionMessage(e)}));
                    mb.open();
                }
            }
        });
        itemTorrentSwitch.setEnabled(dms.length == 1 && dms[0].isPersistent());
        MenuItem itemTorrentSource = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemTorrentSource, "MyTorrentsView.menu.torrent.set.source");
        itemTorrentSource.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                final TOTorrent torrent = dms[0].getTorrent();
                if (torrent == null) {
                    return;
                }
                String msg_key_prefix = "MyTorrentsView.menu.edit_source.";
                SimpleTextEntryWindow text_entry = new SimpleTextEntryWindow();
                text_entry.setParentShell(shell);
                text_entry.setTitle(String.valueOf(msg_key_prefix) + "title");
                text_entry.setMessage(String.valueOf(msg_key_prefix) + "message");
                text_entry.setPreenteredText(TorrentUtils.getObtainedFrom(torrent), false);
                text_entry.setWidthHint(500);
                text_entry.prompt(new UIInputReceiverListener(){

                    @Override
                    public void UIInputReceiverClosed(UIInputReceiver text_entry) {
                        if (text_entry.hasSubmittedInput()) {
                            TorrentUtils.setObtainedFrom(torrent, text_entry.getSubmittedInput());
                            try {
                                TorrentUtils.writeToFile(torrent);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        });
        itemTorrentSource.setEnabled(dms.length == 1);
        MenuItem itemTorrentThumb = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemTorrentThumb, "MyTorrentsView.menu.torrent.set.thumb");
        itemTorrentThumb.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                FileDialog fDialog = new FileDialog(shell, 4098);
                fDialog.setText(MessageText.getString("MainWindow.dialog.choose.thumb"));
                String path = fDialog.open();
                if (path == null) {
                    return;
                }
                File file = new File(path);
                try {
                    byte[] thumbnail = FileUtil.readFileAsByteArray(file);
                    String name = file.getName();
                    int pos = name.lastIndexOf(".");
                    String ext = pos != -1 ? name.substring(pos + 1) : "";
                    String type = HTTPUtils.guessContentTypeFromFileType(ext);
                    DownloadManager[] downloadManagerArray = dms;
                    int n = dms.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DownloadManager dm = downloadManagerArray[n2];
                        try {
                            TOTorrent torrent = dm.getTorrent();
                            PlatformTorrentUtils.setContentThumbnail(torrent, thumbnail, type);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ++n2;
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        });
        itemTorrentThumb.setEnabled(hasSelection);
        MenuItem itemTorrentExplore = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemTorrentExplore, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
        itemTorrentExplore.addListener(13, (Listener)new ListenerDMTask(dms, false){

            @Override
            public void run(DownloadManager dm) {
                ManagerUtils.open(new File(dm.getTorrentFileName()), use_open_containing_folder);
            }
        });
    }

    protected static void moveTorrentFile(Shell shell, DownloadManager[] dms) {
        if (dms != null && dms.length > 0) {
            DirectoryDialog dd = new DirectoryDialog(shell);
            String filter_path = TorrentOpener.getFilterPathTorrent();
            if (filter_path == null || filter_path.trim().length() == 0) {
                filter_path = new File(dms[0].getTorrentFileName()).getParent();
            }
            dd.setFilterPath(filter_path);
            dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
            String path = dd.open();
            if (path != null) {
                File target = new File(path);
                TorrentOpener.setFilterPathTorrent(target.toString());
                int i = 0;
                while (i < dms.length) {
                    try {
                        dms[i].moveTorrentFile(target);
                    }
                    catch (Throwable e) {
                        Logger.log(new LogAlert((Object)dms[i], true, "Download torrent move operation failed", e));
                    }
                    ++i;
                }
            }
        }
    }

    public static void moveDataFiles(Shell shell, DownloadManager[] dms, boolean batch) {
        if (dms != null && dms.length > 0) {
            if (batch) {
                final HashMap<String, DownloadManager> dm_name_map = new HashMap<String, DownloadManager>();
                final StringBuilder details = new StringBuilder(32768);
                DownloadManager[] downloadManagerArray = dms;
                int n = dms.length;
                int n2 = 0;
                while (n2 < n) {
                    DownloadManager dm = downloadManagerArray[n2];
                    dm_name_map.put(dm.getInternalName(), dm);
                    details.append("# " + dm.getInternalName() + " - ");
                    details.append(dm.getDisplayName());
                    details.append("\n\n");
                    details.append("    ");
                    details.append(dm.getSaveLocation().getParentFile().getAbsolutePath());
                    details.append("\n\n");
                    ++n2;
                }
                final TextViewerWindow viewer = new TextViewerWindow(Utils.findAnyShell(), "batch.move.title", "batch.move.text", details.toString(), true, true);
                viewer.setEditable(true);
                viewer.setNonProportionalFont();
                viewer.addListener(new TextViewerWindow.TextViewerWindowListener(){

                    @Override
                    public void closed() {
                        if (!viewer.getOKPressed()) {
                            return;
                        }
                        String text = viewer.getText();
                        if (text.equals(details.toString())) {
                            return;
                        }
                        String[] lines = text.split("\n");
                        final StringBuilder result = new StringBuilder(23552);
                        ArrayList<Object[]> actions = new ArrayList<Object[]>();
                        DownloadManager current_dm = null;
                        String[] stringArray = lines;
                        int n = lines.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String line = stringArray[n2];
                            if (!(line = line.trim()).isEmpty()) {
                                if (line.startsWith("#")) {
                                    try {
                                        String[] bits = line.split("\\s+", 3);
                                        current_dm = (DownloadManager)dm_name_map.get(bits[1].trim());
                                        if (current_dm == null) {
                                            result.append("Invalid line: " + line + ": download not found\n");
                                        }
                                    }
                                    catch (Throwable e) {
                                        result.append("Invalid line: " + line + "\n");
                                    }
                                } else {
                                    try {
                                        String path = line.trim();
                                        if (!current_dm.getSaveLocation().getParentFile().getAbsolutePath().equals(path)) {
                                            actions.add(new Object[]{current_dm, path});
                                        }
                                    }
                                    catch (Throwable e) {
                                        result.append("Invalid line: " + line + "\n");
                                    }
                                }
                            }
                            ++n2;
                        }
                        if (result.length() > 0) {
                            Utils.execSWTThreadLater(1, new Runnable(){

                                @Override
                                public void run() {
                                    TextViewerWindow viewer = new TextViewerWindow(Utils.findAnyShell(), "batch.move.title", "batch.retarget.error.text", result.toString(), true, true);
                                    viewer.setNonProportionalFont();
                                    viewer.goModal();
                                }
                            });
                        } else if (!actions.isEmpty()) {
                            for (Object[] action : actions) {
                                DownloadManager dm = (DownloadManager)action[0];
                                String path = (String)action[1];
                                result.append("# " + dm.getInternalName() + " - ");
                                result.append(dm.getDisplayName());
                                result.append("\n\n");
                                result.append("    " + dm.getSaveLocation().getParentFile().getAbsolutePath() + " -> " + path + "\n\n");
                                AEThread2.createAndStartDaemon("File Mover", () -> Utils.execSWTThread(() -> {
                                    try {
                                        dm.moveDataFilesLive(new File(path));
                                    }
                                    catch (Throwable e) {
                                        Logger.log(new LogAlert((Object)dm, true, "Download data move operation failed", e));
                                    }
                                }));
                            }
                            if (result.length() > 0) {
                                result.append(MessageText.getString("batch.move.progress"));
                                Utils.execSWTThreadLater(1, new Runnable(){

                                    @Override
                                    public void run() {
                                        TextViewerWindow viewer = new TextViewerWindow(Utils.findAnyShell(), "batch.move.title", "batch.retarget.result.text", result.toString(), true, true);
                                        viewer.setNonProportionalFont();
                                        viewer.goModal();
                                    }
                                });
                            }
                        }
                    }
                });
                viewer.goModal();
            } else {
                DirectoryDialog dd = new DirectoryDialog(shell);
                String filter_path = TorrentOpener.getFilterPathData();
                if (filter_path == null || filter_path.trim().length() == 0) {
                    filter_path = new File(dms[0].getTorrentFileName()).getParent();
                }
                dd.setFilterPath(filter_path);
                dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
                String path = dd.open();
                if (path != null) {
                    TorrentOpener.setFilterPathData(path);
                    File target = new File(path);
                    int i = 0;
                    while (i < dms.length) {
                        DownloadManager dm = dms[i];
                        AEThread2.createAndStartDaemon("File Mover", () -> Utils.execSWTThread(() -> {
                            try {
                                dm.moveDataFilesLive(target);
                            }
                            catch (Throwable e) {
                                Logger.log(new LogAlert((Object)dm, true, "Download data move operation failed", e));
                            }
                        }));
                        ++i;
                    }
                }
            }
        }
    }

    protected static void clearMOC(DownloadManager[] dms) {
        if (dms != null && dms.length > 0) {
            int i = 0;
            while (i < dms.length) {
                dms[i].getDownloadState().setAttribute("moc.dir", null);
                ++i;
            }
        }
    }

    protected static void setMOC(Shell shell, DownloadManager[] dms) {
        if (dms != null && dms.length > 0) {
            DirectoryDialog dd = new DirectoryDialog(shell);
            String filter_path = TorrentOpener.getFilterPathData();
            if (filter_path == null || filter_path.trim().length() == 0) {
                filter_path = new File(dms[0].getTorrentFileName()).getParent();
            }
            dd.setFilterPath(filter_path);
            dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
            String path = dd.open();
            if (path != null) {
                TorrentOpener.setFilterPathData(path);
                File target = new File(path);
                int i = 0;
                while (i < dms.length) {
                    dms[i].getDownloadState().setAttribute("moc.dir", target.getAbsolutePath());
                    ++i;
                }
            }
        }
    }

    protected static void exportDownloads(Shell shell, DownloadManager[] dms) {
        if (dms != null && dms.length > 0) {
            DirectoryDialog dd = new DirectoryDialog(shell);
            String filter_path = TorrentOpener.getFilterPathExport();
            if (filter_path == null || filter_path.trim().length() == 0) {
                filter_path = new File(dms[0].getTorrentFileName()).getParent();
            }
            dd.setFilterPath(filter_path);
            dd.setText(MessageText.getString("MyTorrentsView.menu.exportdownload.dialog"));
            String path = dd.open();
            if (path != null) {
                TorrentOpener.setFilterPathExport(path);
                File target = new File(path);
                int i = 0;
                while (i < dms.length) {
                    int f_i = i++;
                    AEThread2.createAndStartDaemon("Exporter", () -> {
                        try {
                            dms[f_i].exportDownload(target);
                        }
                        catch (Throwable e) {
                            Logger.log(new LogAlert((Object)dms[f_i], true, "Download export operation failed", e));
                        }
                    });
                }
            }
        }
    }

    public static void repositionManual(final TableView<DownloadManager> tv, final DownloadManager[] dms, final Shell shell, boolean isSeedingView) {
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("MyTorrentsView.dialog.setPosition.title", "MyTorrentsView.dialog.setPosition.text");
        entryWindow.prompt(new UIInputReceiverListener(){

            @Override
            public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                if (!entryWindow.hasSubmittedInput()) {
                    return;
                }
                String sReturn = entryWindow.getSubmittedInput();
                if (sReturn == null) {
                    return;
                }
                int newPosition = -1;
                try {
                    newPosition = Integer.valueOf(sReturn);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Core core = CoreFactory.getSingleton();
                if (core == null) {
                    return;
                }
                if (newPosition <= 0) {
                    MessageBox mb = new MessageBox(shell, 33);
                    mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                    mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                    mb.open();
                    return;
                }
                TorrentUtil.moveSelectedTorrentsTo(tv, dms, newPosition);
            }
        });
    }

    protected static void addCategorySubMenu(DownloadManager[] dms, Menu menuCategory) {
        boolean allow_category_selection;
        MenuItem[] items = menuCategory.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        MenuItem itemAddCategory = new MenuItem(menuCategory, 8);
        Messages.setLanguageText((Widget)itemAddCategory, "MyTorrentsView.menu.setCategory.add");
        itemAddCategory.addListener(13, (Listener)new ListenerDMTask(dms){

            @Override
            public void run(final DownloadManager[] dms) {
                CategoryUIUtils.showCreateCategoryDialog(new UIFunctions.TagReturner(){

                    @Override
                    public void returnedTags(Tag[] tags) {
                        if (tags.length == 1 && tags[0] instanceof Category) {
                            TorrentUtil.assignToCategory(dms, (Category)tags[0]);
                        }
                    }
                });
            }
        });
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        boolean bl = allow_category_selection = categories.length > 0;
        if (allow_category_selection) {
            boolean user_category_found = false;
            i = 0;
            while (i < categories.length) {
                if (categories[i].getType() == 0) {
                    user_category_found = true;
                    break;
                }
                ++i;
            }
            allow_category_selection = user_category_found;
        }
        if (allow_category_selection) {
            new MenuItem(menuCategory, 2);
            final Category catUncat = CategoryManager.getCategory(2);
            if (catUncat != null) {
                MenuItem itemCategory = new MenuItem(menuCategory, 8);
                Messages.setLanguageText((Widget)itemCategory, catUncat.getName());
                itemCategory.addListener(13, (Listener)new ListenerDMTask(dms){

                    @Override
                    public void run(DownloadManager dm) {
                        dm.getDownloadState().setCategory(catUncat);
                    }
                });
                new MenuItem(menuCategory, 2);
            }
            i = 0;
            while (i < categories.length) {
                Object category = categories[i];
                if (category.getType() == 0) {
                    MenuItem itemCategory = new MenuItem(menuCategory, 8);
                    itemCategory.setText(category.getName());
                    TagUIUtils.setMenuIcon(itemCategory, (Tag)categories[i]);
                    itemCategory.addListener(13, (Listener)new ListenerDMTask(dms, (Category)category){
                        private final /* synthetic */ Category val$category;
                        {
                            this.val$category = category;
                            super($anonymous0);
                        }

                        @Override
                        public void run(DownloadManager dm) {
                            dm.getDownloadState().setCategory(this.val$category);
                        }
                    });
                }
                ++i;
            }
        }
    }

    private static void moveSelectedTorrentsTo(TableView<DownloadManager> tv, DownloadManager[] selected_dms, int iNewPos) {
        TableColumnCore[] sortColumn;
        if (selected_dms == null || selected_dms.length == 0) {
            return;
        }
        GlobalManager gm = selected_dms[0].getGlobalManager();
        ArrayList<DownloadManager> selected_incomplete = new ArrayList<DownloadManager>();
        ArrayList<DownloadManager> selected_complete = new ArrayList<DownloadManager>();
        DownloadManager[] downloadManagerArray = selected_dms;
        int n = selected_dms.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager dm = downloadManagerArray[n2];
            if (dm.isDownloadComplete(false)) {
                selected_complete.add(dm);
            } else {
                selected_incomplete.add(dm);
            }
            ++n2;
        }
        List<DownloadManager> all_dms = gm.getDownloadManagers();
        ArrayList<DownloadManager> all_incomplete = new ArrayList<DownloadManager>();
        ArrayList<DownloadManager> all_complete = new ArrayList<DownloadManager>();
        for (DownloadManager dm : all_dms) {
            if (dm.isDownloadComplete(false)) {
                all_complete.add(dm);
                continue;
            }
            all_incomplete.add(dm);
        }
        if (!selected_incomplete.isEmpty()) {
            TorrentUtil.moveSelectedTorrentsTo(gm, all_incomplete, selected_incomplete, iNewPos);
        }
        if (!selected_complete.isEmpty()) {
            TorrentUtil.moveSelectedTorrentsTo(gm, all_complete, selected_complete, iNewPos);
        }
        boolean bForceSort = (sortColumn = tv.getSortColumns()).length != 0 && "#".equals(sortColumn[0].getName());
        tv.columnInvalidate("#");
        tv.refreshTable(bForceSort);
    }

    private static void moveSelectedTorrentsTo(GlobalManager gm, List<DownloadManager> all_dms, List<DownloadManager> selected_dms, int iNewPos) {
        int num_selected = selected_dms.size();
        int num_dms = all_dms.size();
        if (iNewPos > num_dms) {
            iNewPos = num_dms - num_selected + 1;
        }
        if (iNewPos > 1) {
            all_dms.sort(new Comparator<DownloadManager>(){

                @Override
                public int compare(DownloadManager o1, DownloadManager o2) {
                    return o1.getPosition() - o2.getPosition();
                }
            });
            IdentityHashSet<DownloadManager> moving = new IdentityHashSet<DownloadManager>(selected_dms);
            int pos = 1;
            int to_move = iNewPos - 1;
            for (DownloadManager dm : all_dms) {
                if (moving.contains(dm)) continue;
                gm.moveTo(dm, pos++);
                if (--to_move == 0) break;
            }
        }
        for (DownloadManager dm : selected_dms) {
            gm.moveTo(dm, iNewPos++);
            if (iNewPos <= num_dms) continue;
            iNewPos = 1;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static void changeDirSelectedTorrents(DownloadManager[] dms, Shell shell) {
        block16: {
            if (dms.length <= 0) {
                return;
            }
            sDefPath = COConfigurationManager.getStringParameter("Default save path");
            if (sDefPath.length() > 0 && !(f = new File(sDefPath)).exists()) {
                FileUtil.mkdirs(f);
            }
            dDialog = new DirectoryDialog(shell, 131072);
            dDialog.setFilterPath(sDefPath);
            dDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.savepath"));
            sSavePath = dDialog.open();
            if (sSavePath == null) break block16;
            fSavePath = new File(sSavePath);
            i = 0;
            while (i < dms.length) {
                dm = dms[i];
                state = dm.getState();
                if (state == 100) ** GOTO lbl40
                if (state != 70 || dm.isDataAlreadyAllocated()) ** GOTO lbl-1000
                files = dm.getDiskManagerFileInfoSet().getFiles();
                found_file = false;
                var14_17 = files;
                var13_16 = files.length;
                var12_15 = 0;
                while (var12_15 < var13_16) {
                    info = var14_17[var12_15];
                    if (info.getFile(true).exists()) {
                        found_file = true;
                        break;
                    }
                    ++var12_15;
                }
                if (!found_file) {
                    try {
                        dm.moveDataFilesLive(fSavePath);
                    }
                    catch (Throwable e) {
                        Logger.log(new LogAlert((Object)dms[i], true, "Download data move operation failed", e));
                    }
                } else lbl-1000:
                // 2 sources

                {
                    if (!dm.filesExist(true)) {
                        state = 100;
                    }
lbl40:
                    // 4 sources

                    if (state == 100) {
                        dm.setTorrentSaveDir(FileUtil.newFile(sSavePath, new String[0]), false);
                        found = dm.filesExist(true);
                        if (!found && dm.getTorrent() != null && !dm.getTorrent().isSimpleTorrent() && (parentPath = fSavePath.getParent()) != null) {
                            dm.setTorrentSaveDir(FileUtil.newFile(parentPath, new String[0]), false);
                            found = dm.filesExist(true);
                            if (!found) {
                                dm.setTorrentSaveDir(FileUtil.newFile(parentPath, new String[]{fSavePath.getName()}), true);
                                found = dm.filesExist(true);
                                if (!found) {
                                    dm.setTorrentSaveDir(FileUtil.newFile(sSavePath, new String[]{dm.getDisplayName()}), true);
                                    found = dm.filesExist(true);
                                    if (!found) {
                                        dm.setTorrentSaveDir(FileUtil.newFile(sSavePath, new String[0]), false);
                                    }
                                }
                            }
                        }
                        if (found) {
                            dm.stopIt(70, false, false);
                            ManagerUtils.queue(dm, (Composite)shell);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public static void runDataSources(Object[] datasources) {
        int i = datasources.length - 1;
        while (i >= 0) {
            Object ds = PluginCoreUtils.convert(datasources[i], true);
            if (ds instanceof DownloadManager) {
                DownloadManager dm = (DownloadManager)ds;
                ManagerUtils.run(dm);
            } else if (ds instanceof DiskManagerFileInfo) {
                DiskManagerFileInfo info = (DiskManagerFileInfo)ds;
                Utils.launch(info);
            }
            --i;
        }
    }

    public static void hostTorrents(Object[] download_managers) {
        ListenerDMTask task2 = new ListenerDMTask(TorrentUtil.toDMS(download_managers), true, true){

            @Override
            public void run(DownloadManager dm) {
                ManagerUtils.host(CoreFactory.getSingleton(), dm);
            }
        };
        task2.go();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.getMDI().showEntryByID("MyTrackerView");
        }
    }

    public static void publishTorrents(Object[] download_managers) {
        ListenerDMTask task2 = new ListenerDMTask(TorrentUtil.toDMS(download_managers), true, true){

            @Override
            public void run(DownloadManager dm) {
                ManagerUtils.publish(CoreFactory.getSingleton(), dm);
            }
        };
        task2.go();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.getMDI().showEntryByID("MyTrackerView");
        }
    }

    public static void removeDataSources(Object[] datasources) {
        DownloadStub.DownloadStubEx[] stubs;
        DownloadManager[] dms = TorrentUtil.toDMS(datasources);
        TorrentUtil.removeDownloads(dms, null);
        DiskManagerFileInfo[] fileInfos = TorrentUtil.toDMFI(datasources);
        if (fileInfos.length > 0) {
            FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_DELETE, Arrays.asList(fileInfos));
        }
        if ((stubs = TorrentUtil.toDownloadStubs(datasources)).length > 0) {
            TorrentUtil.removeDownloadStubs(stubs, null, false);
        }
    }

    public static Boolean shouldStopGroupTest(Object[] datasources) {
        DownloadManager[] dms = TorrentUtil.toDMS(datasources);
        DiskManagerFileInfo[] dmfi = TorrentUtil.toDMFI(datasources);
        if (dms.length == 0 && dmfi.length == 0) {
            return null;
        }
        Object[] objectArray = dms;
        int n = dms.length;
        int n2 = 0;
        while (n2 < n) {
            boolean stopped;
            DownloadManager dm = objectArray[n2];
            int state = dm.getState();
            boolean bl = stopped = state == 70 || state == 65;
            if (!stopped) {
                return true;
            }
            ++n2;
        }
        objectArray = dmfi;
        n = dmfi.length;
        n2 = 0;
        while (n2 < n) {
            Object fileInfo2 = objectArray[n2];
            if (!fileInfo2.isSkipped()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void stopOrStartDataSources(Object[] datasources, boolean extendedAction) {
        DownloadManager[] dms = TorrentUtil.toDMS(datasources);
        DiskManagerFileInfo[] dmfi = TorrentUtil.toDMFI(datasources);
        if (dms.length == 0 && dmfi.length == 0) {
            return;
        }
        Boolean doStop = TorrentUtil.shouldStopGroupTest(datasources);
        if (doStop == null) {
            doStop = true;
        }
        if (doStop.booleanValue()) {
            TorrentUtil.stopDataSources(datasources, extendedAction);
        } else {
            TorrentUtil.queueDataSources(datasources, extendedAction);
        }
    }

    public static void stopDataSources(Object[] datasources) {
        TorrentUtil.stopDataSources(datasources, false);
    }

    public static void stopDataSources(Object[] datasources, boolean pause) {
        DownloadManager[] dms;
        DownloadManager[] downloadManagerArray = dms = TorrentUtil.toDMS(datasources);
        int n = dms.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager dm = downloadManagerArray[n2];
            if (pause) {
                ManagerUtils.pause(dm, null);
            } else {
                ManagerUtils.stop(dm, null);
            }
            ++n2;
        }
        DiskManagerFileInfo[] fileInfos = TorrentUtil.toDMFI(datasources);
        if (fileInfos.length > 0) {
            FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_SKIPPED, Arrays.asList(fileInfos));
        }
    }

    public static void pauseDataSources(Object[] datasources) {
        DownloadManager[] dms;
        DownloadManager[] downloadManagerArray = dms = TorrentUtil.toDMS(datasources);
        int n = dms.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager dm = downloadManagerArray[n2];
            ManagerUtils.pause(dm, null);
            ++n2;
        }
    }

    public static void queueDataSources(Object[] datasources, boolean extendedAction) {
        DownloadManager[] dms;
        DownloadManager[] downloadManagerArray = dms = TorrentUtil.toDMS(datasources);
        int n = dms.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager dm = downloadManagerArray[n2];
            if (extendedAction) {
                dm.setForceStart(true);
            } else {
                ManagerUtils.queue(dm, null);
            }
            ++n2;
        }
        DiskManagerFileInfo[] fileInfos = TorrentUtil.toDMFI(datasources);
        if (fileInfos.length > 0) {
            FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_NORMAL, Arrays.asList(fileInfos));
            if (extendedAction) {
                DiskManagerFileInfo[] diskManagerFileInfoArray = fileInfos;
                int n3 = fileInfos.length;
                n = 0;
                while (n < n3) {
                    DiskManagerFileInfo fileInfo2 = diskManagerFileInfoArray[n];
                    if (fileInfo2.getDownloadManager().getState() == 70) {
                        ManagerUtils.queue(fileInfo2.getDownloadManager(), null);
                    }
                    ++n;
                }
            }
        }
    }

    public static void resumeTorrents(Object[] download_managers) {
        ListenerDMTask task2 = new ListenerDMTask(TorrentUtil.toDMS(download_managers)){

            @Override
            public void run(DownloadManager dm) {
                ManagerUtils.start(dm);
            }
        };
        task2.go();
    }

    public static void assignToCategory(Object[] download_managers, final Category category) {
        ListenerDMTask task2 = new ListenerDMTask(TorrentUtil.toDMS(download_managers)){

            @Override
            public void run(DownloadManager dm) {
                dm.getDownloadState().setCategory(category);
            }
        };
        task2.go();
    }

    public static void promptUserForComment(DownloadManager[] dms) {
        if (dms.length == 0) {
            return;
        }
        DownloadManager dm = dms[0];
        TorrentUtil.promptUserForComment(dm.getDownloadState().getUserComment(), value_to_set -> {
            ListenerDMTask task2 = new ListenerDMTask(dms, (String)value_to_set){
                private final /* synthetic */ String val$value_to_set;
                {
                    this.val$value_to_set = string;
                    super($anonymous0);
                }

                @Override
                public void run(DownloadManager dm) {
                    dm.getDownloadState().setUserComment(this.val$value_to_set);
                }
            };
            task2.go();
        });
    }

    public static void promptUserForComment(String text, final Consumer<String> consumer) {
        String msg_key_prefix = "MyTorrentsView.menu.edit_comment.enter.";
        SimpleTextEntryWindow text_entry = new SimpleTextEntryWindow();
        text_entry.setTitle(String.valueOf(msg_key_prefix) + "title");
        text_entry.setMessage(String.valueOf(msg_key_prefix) + "message");
        text_entry.setPreenteredText(text, false);
        text_entry.setWidthHint(800);
        text_entry.setLineHeight(10);
        text_entry.setMultiLine(true);
        text_entry.setResizeable(true);
        text_entry.setDetectURLs(true);
        text_entry.setRememberLocationSize("ui.torrent.comment");
        text_entry.prompt(new UIInputReceiverListener(){

            @Override
            public void UIInputReceiverClosed(UIInputReceiver text_entry) {
                if (text_entry.hasSubmittedInput()) {
                    String value = text_entry.getSubmittedInput();
                    String value_to_set = value.length() == 0 ? null : value;
                    consumer.accept(value_to_set);
                }
            }
        });
    }

    public static void promptUserForDescription(final DownloadManager[] dms) {
        if (dms.length == 0) {
            return;
        }
        DownloadManager dm = dms[0];
        String desc = null;
        try {
            desc = PlatformTorrentUtils.getContentDescription(dm.getTorrent());
            if (desc == null) {
                desc = "";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String msg_key_prefix = "MyTorrentsView.menu.edit_description.enter.";
        SimpleTextEntryWindow text_entry = new SimpleTextEntryWindow();
        text_entry.setTitle(String.valueOf(msg_key_prefix) + "title");
        text_entry.setMessage(String.valueOf(msg_key_prefix) + "message");
        text_entry.setPreenteredText(desc, false);
        text_entry.setMultiLine(true);
        text_entry.setResizeable(true);
        text_entry.setWidthHint(500);
        text_entry.setLineHeight(16);
        text_entry.prompt(new UIInputReceiverListener(){

            @Override
            public void UIInputReceiverClosed(UIInputReceiver text_entry) {
                if (text_entry.hasSubmittedInput()) {
                    String value = text_entry.getSubmittedInput();
                    final String value_to_set = value.length() == 0 ? null : value;
                    ListenerDMTask task2 = new ListenerDMTask(dms){

                        @Override
                        public void run(DownloadManager dm) {
                            PlatformTorrentUtils.setContentDescription(dm.getTorrent(), value_to_set);
                        }
                    };
                    task2.go();
                }
            }
        });
    }

    private static DownloadManager[] toDMS(Object[] objects) {
        int count = 0;
        DownloadManager[] result = new DownloadManager[objects.length];
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            SelectedContent sc;
            Object object = objectArray[n2];
            if (object instanceof DownloadManager) {
                DownloadManager dm = (DownloadManager)object;
                result[count++] = dm;
            } else if (object instanceof SelectedContent && (sc = (SelectedContent)object).getFileIndex() == -1 && sc.getDownloadManager() != null) {
                result[count++] = sc.getDownloadManager();
            }
            ++n2;
        }
        DownloadManager[] resultTrim = new DownloadManager[count];
        System.arraycopy(result, 0, resultTrim, 0, count);
        return resultTrim;
    }

    private static DownloadStub.DownloadStubEx[] toDownloadStubs(Object[] objects) {
        ArrayList<DownloadStub.DownloadStubEx> result = new ArrayList<DownloadStub.DownloadStubEx>(objects.length);
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof DownloadStub.DownloadStubEx) {
                result.add((DownloadStub.DownloadStubEx)o);
            }
            ++n2;
        }
        return result.toArray(new DownloadStub.DownloadStubEx[result.size()]);
    }

    private static DiskManagerFileInfo[] toDMFI(Object[] objects) {
        int count = 0;
        DiskManagerFileInfo[] result = new DiskManagerFileInfo[objects.length];
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            DiskManagerFileInfo[] infos;
            DownloadManager dm;
            SelectedContent sc;
            int fileIndex;
            Object object = objectArray[n2];
            if (object instanceof DiskManagerFileInfo) {
                DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)object;
                result[count++] = fileInfo2;
            } else if (object instanceof SelectedContent && (fileIndex = (sc = (SelectedContent)object).getFileIndex()) >= 0 && sc.getDownloadManager() != null && (dm = sc.getDownloadManager()) != null && fileIndex < (infos = dm.getDiskManagerFileInfo()).length) {
                result[count++] = infos[fileIndex];
            }
            ++n2;
        }
        DiskManagerFileInfo[] resultTrim = new DiskManagerFileInfo[count];
        System.arraycopy(result, 0, resultTrim, 0, count);
        return resultTrim;
    }

    public static boolean isFileTorrent(String originatingLocation, File torrentFile, String torrentName, boolean warnOnError) {
        String sFirstChunk = null;
        try {
            sFirstChunk = FileUtil.readFileAsString(torrentFile, 16384).toLowerCase();
            try {
                if (!sFirstChunk.startsWith("d")) {
                    sFirstChunk = FileUtil.readGZippedFileAsString(torrentFile, 16384).toLowerCase();
                }
            }
            catch (Throwable throwable) {}
        }
        catch (IOException e) {
            Debug.out("warning", e);
        }
        if (sFirstChunk == null) {
            sFirstChunk = "";
        }
        if (!sFirstChunk.startsWith("d")) {
            boolean isHTML = sFirstChunk.contains("<html");
            String retry_url = UrlUtils.parseTextForMagnets(torrentName);
            if (retry_url == null) {
                retry_url = UrlUtils.parseTextForMagnets(sFirstChunk, false);
            }
            if (retry_url != null) {
                TorrentOpener.openTorrent(retry_url);
                return false;
            }
            if (warnOnError) {
                String chat_key = null;
                String chat_net = null;
                if (originatingLocation != null && originatingLocation.toLowerCase(Locale.US).startsWith("http")) {
                    try {
                        String net;
                        URL url = new URL(originatingLocation);
                        String host = url.getHost();
                        String interesting = DNSUtils.getInterestingHostSuffix(host);
                        if (interesting != null && ((net = AENetworkClassifier.categoriseAddress(host)) == "Public" && BuddyPluginUtils.isBetaChatAvailable() || net == "I2P" && BuddyPluginUtils.isBetaChatAnonAvailable())) {
                            chat_key = "Torrent Error: " + interesting;
                            chat_net = net;
                        }
                    }
                    catch (Throwable url) {
                        // empty catch block
                    }
                }
                String[] buttons = chat_key == null ? new String[]{MessageText.getString("Button.ok")} : new String[]{MessageText.getString("label.chat"), MessageText.getString("Button.ok")};
                MessageBoxShell boxShell = new MessageBoxShell(MessageText.getString("OpenTorrentWindow.mb.notTorrent.title"), MessageText.getString("OpenTorrentWindow.mb.notTorrent.text", new String[]{torrentName, isHTML ? "" : MessageText.getString("OpenTorrentWindow.mb.notTorrent.cannot.display")}), buttons, buttons.length - 1);
                if (isHTML) {
                    boxShell.setHtml(sFirstChunk);
                }
                final String f_chat_key = chat_key;
                final String f_chat_net = chat_net;
                boxShell.open(new UserPrompterResultListener(){

                    @Override
                    public void prompterClosed(int result) {
                        if (f_chat_key != null && result == 0) {
                            BuddyPluginUtils.createBetaChat(f_chat_net, f_chat_key, new BuddyPluginUtils.CreateChatCallback(){

                                @Override
                                public void complete(BuddyPluginBeta.ChatInstance chat) {
                                    if (chat != null) {
                                        chat.setInteresting(true);
                                    }
                                }
                            });
                        }
                    }
                });
            }
            return false;
        }
        return true;
    }

    public static Map<String, Long> calculateToolbarStates(ISelectedContent[] currentContent, String viewID_unused) {
        TableColumn tc;
        boolean canRun;
        MdiEntrySWT entry;
        MultipleDocumentInterfaceSWT mdi;
        boolean hasRealDM;
        HashMap<String, Long> mapNewToolbarStates = new HashMap<String, Long>();
        String[] itemsNeedingSelection = new String[]{};
        String[] itemsNeedingRealDMSelection = new String[]{"remove", "top", "bottom", "transcode", "startstop"};
        String[] itemsRequiring1DMwithHash = new String[]{"details", "comment", "up", "down"};
        String[] itemsRequiring1DMSelection = new String[]{};
        int numSelection = currentContent.length;
        boolean hasSelection = numSelection > 0;
        boolean has1Selection = numSelection == 1;
        int i = 0;
        while (i < itemsNeedingSelection.length) {
            String itemID = itemsNeedingSelection[i];
            mapNewToolbarStates.put(itemID, hasSelection ? 1L : 0L);
            ++i;
        }
        TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
        boolean bl = hasRealDM = tv != null;
        if (!hasRealDM && numSelection > 0) {
            hasRealDM = true;
            int i2 = 0;
            while (i2 < currentContent.length) {
                ISelectedContent content = currentContent[i2];
                DownloadManager dm = content.getDownloadManager();
                if (dm == null) {
                    hasRealDM = false;
                    break;
                }
                ++i2;
            }
        }
        if (!hasRealDM && (mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT()) != null && (entry = mdi.getCurrentEntry()) != null) {
            if (entry.getDataSource() instanceof DownloadManager) {
                hasRealDM = true;
            } else if (entry instanceof UIPluginView && entry.getDataSource() instanceof DownloadManager) {
                hasRealDM = true;
            }
        }
        boolean canStart = false;
        boolean canStop = false;
        boolean canRemoveFileInfo = false;
        boolean canRunFileInfo = false;
        boolean canCheckExist = false;
        boolean hasDM = false;
        boolean canRecheck = false;
        if (currentContent.length > 0 && hasRealDM) {
            boolean canMoveUp = false;
            boolean canMoveDown = false;
            boolean canDownload = false;
            GlobalManager gm = null;
            int i3 = 0;
            while (i3 < currentContent.length) {
                ISelectedContent content = currentContent[i3];
                DownloadManager dm = content.getDownloadManager();
                if (dm == null) {
                    if (!canDownload && content.getDownloadInfo() != null) {
                        canDownload = true;
                    }
                } else {
                    int state;
                    if (gm == null) {
                        gm = dm.getGlobalManager();
                        canCheckExist = true;
                    }
                    canCheckExist &= (state = dm.getState()) == 100 || state == 70 || state == 75;
                    int fileIndex = content.getFileIndex();
                    if (fileIndex == -1) {
                        if (!canMoveUp && gm.isMoveableUp(dm)) {
                            canMoveUp = true;
                        }
                        if (!canMoveDown && gm.isMoveableDown(dm)) {
                            canMoveDown = true;
                        }
                        hasDM = true;
                        if (!canStart && ManagerUtils.isStartable(dm)) {
                            canStart = true;
                        }
                        if (!canStop && ManagerUtils.isStopable(dm)) {
                            canStop = true;
                        }
                    } else {
                        DiskManagerFileInfoSet fileInfos = dm.getDiskManagerFileInfoSet();
                        if (fileIndex < fileInfos.nbFiles()) {
                            int storageType;
                            DiskManagerFileInfo fileInfo2 = fileInfos.getFiles()[fileIndex];
                            if (!canStart && fileInfo2.isSkipped()) {
                                canStart = true;
                            }
                            if (!canStop && !fileInfo2.isSkipped()) {
                                canStop = true;
                            }
                            if (!(canRemoveFileInfo || fileInfo2.isSkipped() || (storageType = fileInfo2.getStorageType()) != 1 && storageType != 2)) {
                                canRemoveFileInfo = true;
                            }
                            if (!canRunFileInfo && fileInfo2.getAccessMode() == 1 && fileInfo2.getDownloaded() == fileInfo2.getLength() && FileUtil.existsWithTimeout(fileInfo2.getFile(true))) {
                                canRunFileInfo = true;
                            }
                        }
                    }
                    canRecheck = canRecheck || dm.canForceRecheck();
                }
                ++i3;
            }
            boolean canRemove = hasDM || canRemoveFileInfo;
            mapNewToolbarStates.put("remove", canRemove ? 1L : 0L);
            mapNewToolbarStates.put("download", canDownload ? 1L : 0L);
            if (currentContent.length == 1) {
                mapNewToolbarStates.put("up", canMoveUp ? 1L : 0L);
                mapNewToolbarStates.put("down", canMoveDown ? 1L : 0L);
            }
        }
        boolean bl2 = canRun = has1Selection && (hasDM && !canRunFileInfo || !hasDM && canRunFileInfo);
        if (canRun) {
            ISelectedContent content = currentContent[0];
            DownloadManager dm = content.getDownloadManager();
            if (dm == null) {
                canRun = false;
            } else {
                TOTorrent torrent = dm.getTorrent();
                if (torrent == null) {
                    canRun = false;
                } else if (!dm.getAssumedComplete() && torrent.isSimpleTorrent()) {
                    canRun = false;
                }
            }
        }
        mapNewToolbarStates.put("run", canRun ? 1L : 0L);
        mapNewToolbarStates.put("start", canStart ? 1L : 0L);
        mapNewToolbarStates.put("stop", canStop ? 1L : 0L);
        mapNewToolbarStates.put("startstop", canStart || canStop ? 1L : 0L);
        int i4 = 0;
        while (i4 < itemsNeedingRealDMSelection.length) {
            String itemID = itemsNeedingRealDMSelection[i4];
            if (!mapNewToolbarStates.containsKey(itemID)) {
                mapNewToolbarStates.put(itemID, hasSelection && hasDM && hasRealDM ? 1L : 0L);
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < itemsRequiring1DMSelection.length) {
            String itemID = itemsRequiring1DMSelection[i4];
            if (!mapNewToolbarStates.containsKey(itemID)) {
                mapNewToolbarStates.put(itemID, has1Selection && hasDM ? 1L : 0L);
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < itemsRequiring1DMwithHash.length) {
            String itemID = itemsRequiring1DMwithHash[i4];
            if (!mapNewToolbarStates.containsKey(itemID)) {
                mapNewToolbarStates.put(itemID, hasDM ? 1L : 0L);
            }
            ++i4;
        }
        mapNewToolbarStates.put("download", has1Selection && !(currentContent[0] instanceof ISelectedVuzeFileContent) && currentContent[0].getDownloadManager() == null && (currentContent[0].getHash() != null || currentContent[0].getDownloadInfo() != null) ? 1L : 0L);
        if (tv != null && (tc = tv.getTableColumn("#")) != null && !tc.isVisible()) {
            mapNewToolbarStates.put("up", 0L);
            mapNewToolbarStates.put("down", 0L);
        }
        mapNewToolbarStates.put(TU_ITEM_RECHECK, canRecheck ? 1L : 0L);
        mapNewToolbarStates.put(TU_ITEM_CHECK_FILES, canCheckExist ? 1L : 0L);
        boolean ss = COConfigurationManager.getBooleanParameter("Show Side Bar");
        mapNewToolbarStates.put(TU_ITEM_SHOW_SIDEBAR, 1L | (ss ? 2L : 0L));
        mapNewToolbarStates.put(BF_ITEM_BACK, tv != null && tv.canMoveBack() ? 1L : 0L);
        mapNewToolbarStates.put(BF_ITEM_FORWARD, tv != null && tv.canMoveForward() ? 1L : 0L);
        return mapNewToolbarStates;
    }

    public static void removeDownloads(DownloadManager[] dms, AERunnable deleteFailed) {
        TorrentUtil.removeDownloads(dms, deleteFailed, false);
    }

    public static void removeDownloads(final DownloadManager[] dms, final AERunnable deleteFailed, final boolean forcePrompt) {
        TorrentUtils.runTorrentDelete(dms, new Runnable(){

            @Override
            public void run() {
                TorrentUtil.removeDownloadsSupport(dms, deleteFailed, forcePrompt);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void removeDownloadsSupport(final DownloadManager[] dms, final AERunnable deleteFailed, boolean forcePrompt) {
        DownloadManager dm;
        if (dms == null) {
            return;
        }
        boolean can_archive = false;
        int i = 0;
        while (i < dms.length) {
            dm = dms[i];
            if (dm != null && PluginCoreUtils.wrap(dm).canStubbify()) {
                can_archive = true;
            }
            ++i;
        }
        i = 0;
        while (i < dms.length) {
            dm = dms[i];
            if (dm != null) {
                boolean deleteTorrent = COConfigurationManager.getBooleanParameter("def.deletetorrent");
                int confirm = COConfigurationManager.getIntParameter("tb.confirm.delete.content");
                boolean doPrompt = confirm == 0 | forcePrompt;
                if (doPrompt) {
                    String title = MessageText.getString("deletedata.title");
                    String text = MessageText.getString("v3.deleteContent.message", new String[]{dm.getDisplayName()});
                    if (can_archive) {
                        text = String.valueOf(text) + "\n\n" + MessageText.getString("v3.deleteContent.or.archive");
                    }
                    String[] buttons = new String[]{MessageText.getString("Button.cancel"), MessageText.getString("Button.deleteContent.fromComputer"), MessageText.getString("Button.deleteContent.fromLibrary")};
                    int defaultButtonPos = 2;
                    final MessageBoxShell mb = new MessageBoxShell(title, text, buttons, defaultButtonPos);
                    int numLeft = dms.length - i;
                    if (numLeft > 1) {
                        mb.setRemember("na", COConfigurationManager.getBooleanParameter("def.deleteallselected"), MessageText.getString("v3.deleteContent.applyToAll", new String[]{"" + numLeft}));
                        mb.setRememberOnlyIfButton(-3);
                    }
                    mb.setRelatedObject(dm);
                    mb.setLeftImage("image.trash");
                    mb.addCheckBox("deletecontent.also.deletetorrent", 2, deleteTorrent);
                    final int index = i;
                    final DownloadManager[] current_dms = (DownloadManager[])dms.clone();
                    TorrentUtils.startTorrentDelete(current_dms);
                    final boolean[] endDone = new boolean[1];
                    try {
                        mb.open(new UserPrompterResultListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void prompterClosed(int result) {
                                try {
                                    ImageLoader.getInstance().releaseImage("image.trash");
                                    TorrentUtil.removeDownloadsPrompterClosed(dms, index, deleteFailed, result, mb.isRemembered(), mb.getCheckBoxEnabled());
                                }
                                catch (Throwable throwable) {
                                    boolean[] blArray = endDone;
                                    synchronized (endDone) {
                                        if (!endDone[0]) {
                                            TorrentUtils.endTorrentDelete(current_dms);
                                            endDone[0] = true;
                                        }
                                        // ** MonitorExit[var3_3] (shouldn't be in output)
                                        throw throwable;
                                    }
                                }
                                boolean[] blArray = endDone;
                                synchronized (endDone) {
                                    if (!endDone[0]) {
                                        TorrentUtils.endTorrentDelete(current_dms);
                                        endDone[0] = true;
                                    }
                                    // ** MonitorExit[var3_4] (shouldn't be in output)
                                    return;
                                }
                            }
                        });
                        return;
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        boolean[] blArray = endDone;
                        synchronized (endDone) {
                            if (endDone[0]) return;
                            TorrentUtils.endTorrentDelete(dms);
                            endDone[0] = true;
                            // ** MonitorExit[var19_20] (shouldn't be in output)
                            return;
                        }
                    }
                }
                boolean deleteData = confirm == 1;
                TorrentUtil.removeDownloadsPrompterClosed(dms, i, deleteFailed, deleteData ? 1 : 2, true, deleteTorrent);
            }
            ++i;
        }
    }

    private static void removeDownloadsPrompterClosed(final DownloadManager[] dms, final int index, final AERunnable deleteFailed, final int result, final boolean doAll, final boolean deleteTorrent) {
        TorrentUtils.runTorrentDelete(dms, new Runnable(){

            @Override
            public void run() {
                TorrentUtil.removeDownloadsPrompterClosedSupport(dms, index, deleteFailed, result, doAll, deleteTorrent);
            }
        });
    }

    private static void removeDownloadsPrompterClosedSupport(DownloadManager[] dms, int index, AERunnable deleteFailed, int result, boolean doAll, boolean deleteTorrent) {
        if (result == -1) {
            return;
        }
        if (doAll) {
            if (result == 1 || result == 2) {
                int i = index;
                while (i < dms.length) {
                    DownloadManager dm = dms[i];
                    boolean deleteData = result == 2 ? false : !dm.getDownloadState().getFlag(64L);
                    ManagerUtils.asyncStopDelete(dm, 70, deleteTorrent, deleteData, deleteFailed);
                    ++i;
                }
            }
        } else {
            if (result == 1 || result == 2) {
                DownloadManager dm = dms[index];
                boolean deleteData = result == 2 ? false : !dm.getDownloadState().getFlag(64L);
                ManagerUtils.asyncStopDelete(dm, 70, deleteTorrent, deleteData, null);
            }
            dms[index] = null;
            if (index != dms.length - 1) {
                TorrentUtil.removeDownloads(dms, deleteFailed, true);
            }
        }
    }

    public static void removeDownloadStubs(final DownloadStub.DownloadStubEx[] dms, final AERunnable deleteFailed, boolean forcePrompt) {
        if (dms == null) {
            return;
        }
        int i = 0;
        while (i < dms.length) {
            DownloadStub.DownloadStubEx dm = dms[i];
            boolean deleteTorrent = COConfigurationManager.getBooleanParameter("def.deletetorrent");
            int confirm = COConfigurationManager.getIntParameter("tb.confirm.delete.content");
            boolean doPrompt = confirm == 0 | forcePrompt;
            if (doPrompt) {
                String title = MessageText.getString("deletedata.title");
                String text = MessageText.getString("v3.deleteContent.message", new String[]{dm.getName()});
                String[] buttons = new String[]{MessageText.getString("Button.cancel"), MessageText.getString("Button.deleteContent.fromComputer"), MessageText.getString("Button.deleteContent.fromLibrary")};
                int defaultButtonPos = 2;
                final MessageBoxShell mb = new MessageBoxShell(title, text, buttons, defaultButtonPos);
                int numLeft = dms.length - i;
                if (numLeft > 1) {
                    mb.setRemember("na", COConfigurationManager.getBooleanParameter("def.deleteallselected"), MessageText.getString("v3.deleteContent.applyToAll", new String[]{"" + numLeft}));
                    mb.setRememberOnlyIfButton(-3);
                }
                mb.setRelatedObject(dm);
                mb.setLeftImage("image.trash");
                mb.addCheckBox("deletecontent.also.deletetorrent", 2, deleteTorrent);
                final int index = i;
                mb.open(new UserPrompterResultListener(){

                    @Override
                    public void prompterClosed(int result) {
                        ImageLoader.getInstance().releaseImage("image.trash");
                        TorrentUtil.removeDownloadStubsPrompterClosed(dms, index, deleteFailed, result, mb.isRemembered(), mb.getCheckBoxEnabled());
                    }
                });
                return;
            }
            boolean deleteData = confirm == 1;
            TorrentUtil.removeDownloadStubsPrompterClosed(dms, i, deleteFailed, deleteData ? 1 : 2, true, deleteTorrent);
            ++i;
        }
    }

    private static void removeDownloadStubsPrompterClosed(DownloadStub.DownloadStubEx[] dms, int index, AERunnable deleteFailed, int result, boolean doAll, boolean deleteTorrent) {
        if (result == -1) {
            return;
        }
        if (doAll) {
            if (result == 1 || result == 2) {
                int i = index;
                while (i < dms.length) {
                    block11: {
                        DownloadStub.DownloadStubEx dm = dms[i];
                        boolean deleteData = result != 2;
                        try {
                            dm.remove(deleteTorrent, deleteData);
                        }
                        catch (Throwable e) {
                            if (deleteFailed == null) break block11;
                            deleteFailed.runSupport();
                        }
                    }
                    ++i;
                }
            }
        } else {
            if (result == 1 || result == 2) {
                DownloadStub.DownloadStubEx dm = dms[index];
                boolean deleteData = result != 2;
                try {
                    dm.remove(deleteTorrent, deleteData);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            dms[index] = null;
            if (index != dms.length - 1) {
                TorrentUtil.removeDownloadStubs(dms, deleteFailed, true);
            }
        }
    }

    public static boolean isForceStartVisible(DownloadManager[] dms) {
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode > 0) {
            return true;
        }
        if (COConfigurationManager.getBooleanParameter("Always Show Force Start", false)) {
            return true;
        }
        DownloadManager[] downloadManagerArray = dms;
        int n = dms.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager dm = downloadManagerArray[n2];
            TOTorrent torrent = dm.getTorrent();
            if (torrent != null && torrent.getPrivate()) {
                COConfigurationManager.setParameter("Always Show Force Start", true);
                return true;
            }
            ++n2;
        }
        return false;
    }
}

