/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.utils.DragDropUtils;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TrackerChangerWindow {
    public TrackerChangerWindow(final DownloadManager[] dms) {
        final Shell shell = ShellFactory.createMainShell(2144);
        shell.setText(MessageText.getString("TrackerChangerWindow.title"));
        Utils.setShellIcon(shell);
        GridLayout layout = new GridLayout();
        shell.setLayout((Layout)layout);
        Label label = new Label((Composite)shell, 0);
        Messages.setLanguageText((Widget)label, "TrackerChangerWindow.newtracker");
        GridData gridData = new GridData();
        gridData.widthHint = 400;
        label.setLayoutData((Object)gridData);
        final Text url = new Text((Composite)shell, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 400;
        url.setLayoutData((Object)gridData);
        String link = Utils.getLinkFromClipboard(shell.getDisplay());
        if (link != null) {
            url.setText(link);
            url.setSelection(0, link.length());
        }
        Label labelSeparator = new Label((Composite)shell, 258);
        gridData = new GridData(768);
        labelSeparator.setLayoutData((Object)gridData);
        Composite panel = new Composite((Composite)shell, 0);
        gridData = new GridData(768);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        label = new Label(panel, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        Button ok = new Button(panel, 8);
        ok.setText(MessageText.getString("Button.ok"));
        gridData = new GridData();
        gridData.widthHint = 70;
        gridData.horizontalAlignment = 3;
        ok.setLayoutData((Object)gridData);
        shell.setDefaultButton(ok);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                try {
                    String[] _urls = url.getText().split(",");
                    ArrayList<String> urls = new ArrayList<String>();
                    Object[] objectArray = _urls;
                    int n = _urls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String url2 = objectArray[n2];
                        if ((url2 = url2.trim()).length() > 0) {
                            try {
                                new URL(url2);
                                urls.add(0, url2);
                            }
                            catch (Throwable e) {
                                Debug.out("Invalid URL: " + url2);
                            }
                        }
                        ++n2;
                    }
                    objectArray = dms;
                    n = dms.length;
                    n2 = 0;
                    while (n2 < n) {
                        Object dm = objectArray[n2];
                        TOTorrent torrent = dm.getTorrent();
                        if (torrent != null) {
                            for (String url3 : urls) {
                                TorrentUtils.announceGroupsInsertFirst(torrent, url3);
                            }
                            TorrentUtils.writeToFile(torrent);
                            TRTrackerAnnouncer announcer = dm.getTrackerClient();
                            if (announcer != null) {
                                announcer.resetTrackerUrl(false);
                            }
                        }
                        ++n2;
                    }
                    shell.dispose();
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        });
        Button cancel = new Button(panel, 8);
        cancel.setText(MessageText.getString("Button.cancel"));
        gridData = new GridData();
        gridData.widthHint = 70;
        gridData.horizontalAlignment = 3;
        cancel.setLayoutData((Object)gridData);
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                shell.dispose();
            }
        });
        shell.pack();
        Utils.centreWindow(shell);
        DragDropUtils.createURLDropTarget((Composite)shell, url);
        shell.open();
    }
}

