/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerListener;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.common.updater.UIUpdater;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.ListenerNeedingCoreRunning;
import com.biglybt.ui.swt.mainwindow.MenuFactory;
import com.biglybt.ui.swt.uiupdater.UIUpdaterSWT;
import com.biglybt.ui.swt.utils.DragDropUtils;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class TrayWindow
implements GlobalManagerListener,
UIUpdatable {
    private static final String ID = "DownloadBasket/TrayWindow";
    GlobalManager globalManager;
    List managers;
    protected AEMonitor managers_mon = new AEMonitor("DownloadBasket/TrayWindow");
    Display display;
    Shell minimized;
    Label label;
    private Menu menu;
    private Rectangle screen;
    private int xPressed;
    private int yPressed;
    private boolean moving;

    public TrayWindow() {
        this.managers = new ArrayList();
        UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
        Shell mainShell = uif == null ? Utils.findAnyShell() : uif.getMainShell();
        this.display = mainShell.getDisplay();
        this.minimized = ShellFactory.createShell(mainShell, 16384);
        this.minimized.setText(Constants.APP_NAME);
        this.label = new Label((Composite)this.minimized, 0);
        ImageLoader.getInstance().setLabelImage(this.label, "tray");
        final Rectangle bounds = this.label.getImage().getBounds();
        this.label.setSize(bounds.width, bounds.height);
        this.minimized.setSize(bounds.width + 2, bounds.height + 2);
        this.screen = this.display.getClientArea();
        if (!Constants.isOSX) {
            this.minimized.setLocation(this.screen.x + this.screen.width - bounds.width - 2, this.screen.y + this.screen.height - bounds.height - 2);
        } else {
            this.minimized.setLocation(20, 20);
        }
        this.minimized.layout();
        this.minimized.setVisible(false);
        MouseAdapter mListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TrayWindow.this.xPressed = e.x;
                TrayWindow.this.yPressed = e.y;
                TrayWindow.this.moving = true;
            }

            public void mouseUp(MouseEvent e) {
                TrayWindow.this.moving = false;
            }

            public void mouseDoubleClick(MouseEvent e) {
                TrayWindow.this.restore();
            }
        };
        MouseMoveListener mMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (TrayWindow.this.moving) {
                    int dX = TrayWindow.this.xPressed - e.x;
                    int dY = TrayWindow.this.yPressed - e.y;
                    Point currentLoc = TrayWindow.this.minimized.getLocation();
                    int x = currentLoc.x - dX;
                    int y = currentLoc.y - dY;
                    if (x < 10) {
                        x = 0;
                    }
                    if (x > ((TrayWindow)TrayWindow.this).screen.width - (bounds.width + 12)) {
                        x = ((TrayWindow)TrayWindow.this).screen.width - (bounds.width + 2);
                    }
                    if (y < 10) {
                        y = 0;
                    }
                    if (y > ((TrayWindow)TrayWindow.this).screen.height - (bounds.height + 12)) {
                        y = ((TrayWindow)TrayWindow.this).screen.height - (bounds.height + 2);
                    }
                    TrayWindow.this.minimized.setLocation(x, y);
                }
            }
        };
        this.label.addMouseListener((MouseListener)mListener);
        this.label.addMouseMoveListener(mMoveListener);
        this.menu = new Menu((Decorations)this.minimized, 64);
        this.label.setMenu(this.menu);
        MenuItem file_show = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)file_show, "TrayWindow.menu.show");
        this.menu.setDefaultItem(file_show);
        file_show.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TrayWindow.this.restore();
            }
        });
        new MenuItem(this.menu, 2);
        MenuFactory.addCloseDownloadBarsToMenu(this.menu);
        new MenuItem(this.menu, 2);
        MenuItem file_startalldownloads = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)file_startalldownloads, "TrayWindow.menu.startalldownloads");
        file_startalldownloads.addListener(13, (Listener)new ListenerNeedingCoreRunning(){

            @Override
            public void handleEvent(Core core, Event e) {
                TrayWindow.this.globalManager.startAllDownloads();
            }
        });
        MenuItem file_stopalldownloads = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)file_stopalldownloads, "TrayWindow.menu.stopalldownloads");
        file_stopalldownloads.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ManagerUtils.asyncStopAll();
            }
        });
        new MenuItem(this.menu, 2);
        MenuItem file_close = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)file_close, "TrayWindow.menu.close");
        file_close.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                COConfigurationManager.setParameter("Show Download Basket", false);
            }
        });
        MenuItem file_exit = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)file_exit, "TrayWindow.menu.exit");
        file_exit.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UIFunctionsManager.getUIFunctions().dispose(false);
            }
        });
        DragDropUtils.createTorrentDropTarget((Composite)this.minimized, false);
        try {
            CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                @Override
                public void coreRunning(Core core) {
                    TrayWindow.this.globalManager = core.getGlobalManager();
                    TrayWindow.this.globalManager.addListener(TrayWindow.this);
                }
            });
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public void setVisible(boolean visible) {
        if (visible || !COConfigurationManager.getBooleanParameter("Show Download Basket")) {
            this.minimized.setVisible(visible);
            if (!visible) {
                this.moving = false;
            }
        }
        try {
            UIUpdater instance = UIUpdaterSWT.getInstance();
            if (instance != null) {
                if (visible) {
                    instance.addUpdater(this);
                } else {
                    instance.removeUpdater(this);
                }
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public void dispose() {
        if (this.globalManager != null) {
            this.globalManager.removeListener(this);
        }
        this.minimized.dispose();
    }

    public void restore() {
        UIFunctionsSWT functionsSWT;
        if (!COConfigurationManager.getBooleanParameter("Show Download Basket")) {
            this.minimized.setVisible(false);
        }
        if ((functionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null) {
            functionsSWT.bringToFront();
        }
        this.moving = false;
    }

    @Override
    public void updateUI() {
        if (this.minimized.isDisposed() || !this.minimized.isVisible()) {
            return;
        }
        StringBuilder toolTip = new StringBuilder();
        String separator = "";
        try {
            this.managers_mon.enter();
            int i = 0;
            while (i < this.managers.size()) {
                DownloadManager manager = (DownloadManager)this.managers.get(i);
                DownloadManagerStats stats2 = manager.getStats();
                String name = manager.getDisplayName();
                String completed = DisplayFormatters.formatPercentFromThousands(stats2.getPercentDoneExcludingDND());
                toolTip.append(separator);
                toolTip.append(name);
                toolTip.append(" -- C: ");
                toolTip.append(completed);
                toolTip.append(", D : ");
                toolTip.append(DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(stats2.getDataReceiveRate(), stats2.getProtocolReceiveRate()));
                toolTip.append(", U : ");
                toolTip.append(DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(stats2.getDataSendRate(), stats2.getProtocolSendRate()));
                separator = "\n";
                ++i;
            }
        }
        finally {
            this.managers_mon.exit();
        }
    }

    @Override
    public void downloadManagerAdded(DownloadManager created) {
        try {
            this.managers_mon.enter();
            this.managers.add(created);
        }
        finally {
            this.managers_mon.exit();
        }
    }

    @Override
    public void downloadManagerRemoved(DownloadManager removed) {
        try {
            this.managers_mon.enter();
            this.managers.remove(removed);
        }
        finally {
            this.managers_mon.exit();
        }
    }

    @Override
    public void destroyed() {
    }

    @Override
    public void destroyInitiated() {
    }

    @Override
    public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
    }

    public void updateLanguage() {
        MenuFactory.updateMenuText(this.menu);
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    @Override
    public String getUpdateUIName() {
        return ID;
    }
}

