/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.Core;
import com.biglybt.core.CoreComponent;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.update.UpdateInstaller;
import com.biglybt.pif.update.UpdateManager;
import com.biglybt.platform.PlatformManagerFactory;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.UIConst;
import com.biglybt.ui.common.UITemplate;
import com.biglybt.ui.swt.Initializer;
import com.biglybt.ui.swt.UIExitUtilsSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.sharing.ShareUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.eclipse.swt.SWT;

public class UI
extends UITemplate {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static volatile boolean useSystemTheme;
    private static boolean isFirstUI;
    protected final AEMonitor this_mon = new AEMonitor("swt.UI");
    protected List queued_torrents = new ArrayList();
    protected boolean queueTorrents = true;

    static {
        COConfigurationManager.addAndFireParameterListener("Use System Theme", n -> {
            useSystemTheme = COConfigurationManager.getBooleanParameter("Use System Theme");
            if (useSystemTheme && !UI.canUseSystemTheme()) {
                useSystemTheme = false;
                COConfigurationManager.setParameter("Use System Theme", false);
                return;
            }
            try {
                PlatformManagerFactory.getPlatformManager().setUseSystemTheme(useSystemTheme);
            }
            catch (Throwable e) {
                useSystemTheme = false;
                Debug.out(e);
            }
            if (Constants.isOSX) {
                System.setProperty("org.eclipse.swt.display.useSystemTheme", useSystemTheme ? "true" : "false");
            }
        });
    }

    public static boolean canUseSystemTheme() {
        return Constants.isOSX && SWT.getVersion() >= 4924 || Constants.isWindows10OrHigher;
    }

    public static boolean useSystemTheme() {
        return useSystemTheme;
    }

    protected static boolean isURI(String file_name) {
        String file_name_lower = file_name.toLowerCase();
        return file_name_lower.startsWith("http:") || file_name_lower.startsWith("https:") || file_name_lower.startsWith("magnet:") || file_name_lower.startsWith("maggot:") || file_name_lower.startsWith("bc:") || file_name_lower.startsWith("biglybt:") || file_name_lower.startsWith("bctp:") || file_name_lower.startsWith("dht:");
    }

    @Override
    public void init(boolean first, boolean others) {
        super.init(first, others);
        isFirstUI = first;
    }

    @Override
    public void coreCreated(Core core) {
        super.coreCreated(core);
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            this.openQueuedTorrents();
        } else {
            core.addLifecycleListener(new CoreLifecycleAdapter(){

                @Override
                public void componentCreated(Core core, CoreComponent component) {
                    if (component instanceof UIFunctionsSWT) {
                        UI.this.openQueuedTorrents();
                        core.removeLifecycleListener(this);
                    }
                }
            });
        }
    }

    @Override
    public void takeMainThread() {
        new Initializer(this.core, null);
        UIConst.removeUI("swt");
    }

    @Override
    public void buildCommandLine(Options options) {
    }

    @Override
    public String[] processArgs(CommandLine commands, String[] args) {
        UIFunctions uiFunctions;
        boolean showMainWindow;
        boolean bl = showMainWindow = args.length == 0;
        if (commands.hasOption("closedown") || commands.hasOption("shutdown")) {
            UIExitUtilsSWT.setSkipCloseChecksForUpdate(true);
            try {
                UpdateInstaller[] installers;
                UpdateManager um = this.core.getPluginManager().getDefaultPluginInterface().getUpdateManager();
                UpdateInstaller[] updateInstallerArray = installers = um.getInstallers();
                int n = installers.length;
                int n2 = 0;
                while (n2 < n) {
                    UpdateInstaller installer = updateInstallerArray[n2];
                    installer.destroy();
                    ++n2;
                }
            }
            catch (Throwable um) {
                // empty catch block
            }
            UIFunctions uiFunctions2 = UIFunctionsManager.getUIFunctions();
            if (uiFunctions2 != null) {
                uiFunctions2.dispose(false);
            }
            return null;
        }
        if (commands.hasOption("restart")) {
            UIFunctions uiFunctions3 = UIFunctionsManager.getUIFunctions();
            if (uiFunctions3 != null) {
                uiFunctions3.dispose(true);
            }
            return null;
        }
        boolean isOpen = true;
        if (commands.hasOption("share")) {
            showMainWindow = true;
            isOpen = false;
        }
        if (commands.hasOption("open")) {
            showMainWindow = true;
        }
        String save_path = null;
        if (commands.hasOption("savepath")) {
            save_path = commands.getOptionValue("savepath");
            File f = new File(save_path);
            if (f.exists()) {
                if (f.isFile()) {
                    Logger.log(new LogAlert(true, 3, "StartServer: --savepath value ' + f.getAbsolutePath() + ' is a file, ignoring"));
                    save_path = null;
                }
            } else {
                f.mkdirs();
                if (!f.exists()) {
                    Logger.log(new LogAlert(true, 3, "StartServer: --savepath value ' + f.getAbsolutePath() + ' can't be created, ignoring"));
                    save_path = null;
                }
            }
            if (save_path != null) {
                save_path = f.getAbsolutePath();
            }
        }
        String[] rest = commands.getArgs();
        int i = 0;
        while (i < rest.length) {
            boolean isURI;
            String filename = rest[i];
            File file = new File(filename);
            if (!file.exists() && !UI.isURI(filename)) {
                String magnet_uri = UrlUtils.normaliseMagnetURI(filename);
                boolean bl2 = isURI = magnet_uri != null;
                if (isURI) {
                    filename = magnet_uri;
                }
            } else {
                isURI = UI.isURI(filename);
            }
            if (isURI) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "StartServer: args[" + i + "] handling as a URI: " + filename));
                }
            } else {
                try {
                    if (!file.exists()) {
                        throw new Exception("File '" + file + "' not found");
                    }
                    filename = file.getCanonicalPath();
                    Logger.log(new LogEvent(LOGID, "StartServer: file = " + filename));
                }
                catch (Throwable e) {
                    Logger.log(new LogAlert(true, 3, "Failed to access torrent file '" + filename + "'. Ensure sufficient temporary " + "file space available (check browser cache usage)."));
                }
            }
            boolean queued = false;
            try {
                this.this_mon.enter();
                if (this.queueTorrents) {
                    this.queued_torrents.add(new Object[]{filename, isOpen, save_path});
                    queued = true;
                }
            }
            finally {
                this.this_mon.exit();
            }
            if (!queued) {
                this.handleFile(filename, isOpen, save_path);
            }
            ++i;
        }
        if ((showMainWindow || COConfigurationManager.getBooleanParameter("Activate Window On External Download")) && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
            uiFunctions.bringToFront();
        }
        return args;
    }

    protected void handleFile(String file_name, boolean open, String save_path) {
        try {
            if (open) {
                HashMap<String, Object> options = new HashMap<String, Object>();
                if (save_path != null) {
                    options.put("defaultSavePath", save_path);
                }
                TorrentOpener.openTorrent(file_name, options);
            } else {
                File f = new File(file_name);
                if (f.isDirectory()) {
                    ShareUtils.shareDir(file_name);
                } else {
                    ShareUtils.shareFile(file_name);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected void openQueuedTorrents() {
        try {
            this.this_mon.enter();
            if (!this.queueTorrents) {
                return;
            }
            this.queueTorrents = false;
        }
        finally {
            this.this_mon.exit();
        }
        for (Object queued_torrent : this.queued_torrents) {
            Object[] entry = (Object[])queued_torrent;
            String file_name = (String)entry[0];
            boolean open = (Boolean)entry[1];
            String save_path = (String)entry[2];
            this.handleFile(file_name, open, save_path);
        }
        this.queued_torrents = null;
    }

    public static boolean isFirstUI() {
        return isFirstUI;
    }
}

