/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.util.AEThread;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.ui.swt.PasswordWindow;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UIExitUtilsSWT {
    private static boolean skipCloseCheck = false;
    private static boolean skipCloseChecksForUpdate = false;
    private static CopyOnWriteList<canCloseListener> listeners = new CopyOnWriteList();

    public static void addListener(canCloseListener l) {
        listeners.add(l);
    }

    public static void removeListener(canCloseListener l) {
        listeners.remove(l);
    }

    public static void setSkipCloseCheck(boolean b) {
        skipCloseCheck = b;
    }

    public static void setSkipCloseChecksForUpdate(boolean b) {
        skipCloseChecksForUpdate = b;
    }

    public static boolean canClose(GlobalManager globalManager, boolean bForRestart) {
        if (skipCloseCheck) {
            return true;
        }
        if (!skipCloseChecksForUpdate) {
            Shell mainShell = UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell();
            if (mainShell != null && (!mainShell.isVisible() || mainShell.getMinimized()) && COConfigurationManager.getBooleanParameter("Password enabled") && !PasswordWindow.showPasswordWindow(Display.getCurrent())) {
                return false;
            }
            if (COConfigurationManager.getBooleanParameter("confirmationOnExit") && !UIExitUtilsSWT.getExitConfirmation(bForRestart)) {
                return false;
            }
        }
        for (canCloseListener listener : listeners) {
            if (listener.canClose()) continue;
            return false;
        }
        return true;
    }

    private static boolean getExitConfirmation(boolean for_restart) {
        MessageBoxShell mb = new MessageBoxShell(200, for_restart ? "MainWindow.dialog.restartconfirmation" : "MainWindow.dialog.exitconfirmation", null);
        mb.open(null);
        return mb.waitUntilClosed() == 64;
    }

    public static void uiShutdown() {
        if (SystemProperties.isJavaWebStartInstance()) {
            AEThread close = new AEThread("JWS Force Terminate"){

                @Override
                public void runSupport() {
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    SESecurityManager.exitVM(1);
                }
            };
            close.setDaemon(true);
            close.start();
        }
    }

    public static interface canCloseListener {
        public boolean canClose();
    }
}

