/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.activities.ActivitiesEntry;
import com.biglybt.activities.ActivitiesListener;
import com.biglybt.activities.ActivitiesManager;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerListener;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerDiskListener;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.impl.DownloadManagerAdapter;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerAdapter;
import com.biglybt.core.global.GlobalManagerEvent;
import com.biglybt.core.global.GlobalManagerEventListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.platform.PlatformManagerException;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.model.BasicPluginViewModel;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerFactory;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.minibar.DownloadBar;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;

public class UserAlerts {
    private static UserAlerts singleton;
    private final DownloadManagerAdapter download_manager_listener;
    private final DiskManagerListener disk_listener;
    private final DownloadManagerDiskListener dm_disk_listener;
    private final GlobalManagerAdapter globalManagerListener;
    private final GlobalManagerEventListener globalManagerEventListener;
    private final ActivitiesListener activitiesListener;
    private final GlobalManager global_manager;
    private AEMonitor this_mon = new AEMonitor("UserAlerts");
    private boolean startup = true;
    private TrayIcon native_tray_icon;
    private int native_message_count;
    private final LoggerChannel log;
    private long last_error_speech;
    private long last_error_sound;

    public static UserAlerts getSingleton() {
        return singleton;
    }

    public static void destroySingleton() {
        if (singleton != null) {
            singleton.dispose();
            singleton = null;
        }
    }

    public UserAlerts(GlobalManager global_manager) {
        this.global_manager = global_manager;
        singleton = this;
        PluginInterface plugin_interface = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface();
        this.log = plugin_interface.getLogger().getChannel("Alerts");
        UIManager ui_manager = plugin_interface.getUIManager();
        BasicPluginViewModel model = ui_manager.createBasicPluginViewModel("ConfigView.section.interface.alerts");
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        model.attachLoggerChannel(this.log);
        this.download_manager_listener = new DownloadManagerAdapter(){

            @Override
            public void downloadComplete(DownloadManager manager) {
                UserAlerts.this.activityFinished(manager, null);
            }

            @Override
            public void stateChanged(final DownloadManager manager, int state) {
                boolean lowNoise = manager.getDownloadState().getFlag(16L);
                if (lowNoise) {
                    return;
                }
                if (state == 50 || state == 60) {
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            boolean complete = manager.isDownloadComplete(false);
                            if (!complete && COConfigurationManager.getBooleanParameter("Open Details") || complete && COConfigurationManager.getBooleanParameter("Open Seeding Details")) {
                                UIFunctionsManager.getUIFunctions().getMDI().loadEntryByID("DMDetails", false, false, manager);
                            }
                            if (!complete && COConfigurationManager.getBooleanParameter("Open Bar Incomplete") || complete && COConfigurationManager.getBooleanParameter("Open Bar Complete")) {
                                DownloadBar.open(manager, Utils.findAnyShell());
                            }
                        }
                    });
                }
                boolean error_reported = manager.getDownloadState().getFlag(2048L);
                if (state == 100) {
                    if (!error_reported) {
                        manager.getDownloadState().setFlag(2048L, true);
                        UserAlerts.this.reportError(manager);
                    }
                } else if ((state == 50 || state == 60) && error_reported) {
                    manager.getDownloadState().setFlag(2048L, false);
                }
            }
        };
        this.disk_listener = new DiskManagerListener(){

            @Override
            public void stateChanged(DiskManager dm, int oldState, int newState) {
            }

            @Override
            public void filePriorityChanged(DiskManager dm, DiskManagerFileInfo file) {
            }

            @Override
            public void pieceDoneChanged(DiskManager dm, DiskManagerPiece piece) {
            }

            @Override
            public void fileCompleted(DiskManager diskManager, DiskManagerFileInfo file) {
                DownloadManager dm = file.getDownloadManager();
                if (dm != null) {
                    UserAlerts.this.activityFinished(dm, file);
                }
            }
        };
        this.dm_disk_listener = new DownloadManagerDiskListener(){

            @Override
            public void diskManagerAdded(DiskManager dm) {
                dm.addListener(UserAlerts.this.disk_listener);
            }

            @Override
            public void diskManagerRemoved(DiskManager dm) {
                dm.removeListener(UserAlerts.this.disk_listener);
            }
        };
        this.globalManagerListener = new GlobalManagerAdapter(){

            @Override
            public void downloadManagerAdded(DownloadManager manager) {
                boolean bPopup;
                if (!UserAlerts.this.startup && manager.isPersistent() && (bPopup = COConfigurationManager.getBooleanParameter("Popup Download Added")) && !manager.getDownloadState().getFlag(16L)) {
                    String popup_text = MessageText.getString("popup.download.added", new String[]{manager.getDisplayName()});
                    UserAlerts.this.forceNotify(0, null, popup_text, null, new Object[]{manager}, -1);
                }
                manager.addListener(UserAlerts.this.download_manager_listener);
                manager.addDiskListener(UserAlerts.this.dm_disk_listener);
            }

            @Override
            public void downloadManagerRemoved(DownloadManager manager) {
                manager.removeListener(UserAlerts.this.download_manager_listener);
                manager.removeDiskListener(UserAlerts.this.dm_disk_listener);
            }

            @Override
            public void destroyed() {
                UserAlerts.this.tidyUp();
            }
        };
        global_manager.addListener(this.globalManagerListener);
        this.globalManagerEventListener = new GlobalManagerEventListener(){

            @Override
            public void eventOccurred(GlobalManagerEvent event2) {
                if (event2.getEventType() == 2) {
                    Object[] params = (Object[])event2.getEventData();
                    boolean explicit = (Boolean)params[0];
                    boolean cancelled = (Boolean)params[1];
                    UserAlerts.this.checkComplete(event2.getDownload(), explicit, cancelled);
                }
            }
        };
        global_manager.addEventListener(this.globalManagerEventListener);
        this.activitiesListener = new ActivitiesListener(){

            @Override
            public void vuzeNewsEntryChanged(ActivitiesEntry entry) {
            }

            @Override
            public void vuzeNewsEntriesRemoved(ActivitiesEntry[] entries) {
            }

            @Override
            public void vuzeNewsEntriesAdded(ActivitiesEntry[] entries) {
                UserAlerts ua;
                boolean local_added = false;
                ActivitiesEntry[] activitiesEntryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    ActivitiesEntry entry = activitiesEntryArray[n2];
                    if (entry.getTypeID().equals("LOCAL_NEWS_ITEM")) {
                        local_added = true;
                    }
                    ++n2;
                }
                if (local_added && (ua = UserAlerts.getSingleton()) != null) {
                    ua.notificationAdded();
                }
            }
        };
        ActivitiesManager.addListener(this.activitiesListener);
        this.startup = false;
    }

    private void activityFinished(DownloadManager manager, DiskManagerFileInfo dm_file) {
        String native_text;
        String native_enabler;
        String popup_def_text;
        String popup_enabler;
        String speech_text;
        String speech_enabler;
        String sound_file;
        String sound_enabler;
        String item_name;
        Object relatedObject;
        boolean download;
        DownloadManagerState dm_state = manager.getDownloadState();
        if (dm_state.getFlag(16L)) {
            return;
        }
        boolean bl = download = dm_file == null;
        if (download) {
            relatedObject = manager;
            item_name = manager.getDisplayName();
        } else {
            relatedObject = dm_file.getDiskManager();
            item_name = dm_file.getFile(true).getName();
        }
        if (download) {
            sound_enabler = "Play Download Finished";
            sound_file = "Play Download Finished File";
            speech_enabler = "Play Download Finished Announcement";
            speech_text = "Play Download Finished Announcement Text";
            popup_enabler = "Popup Download Finished";
            popup_def_text = "popup.download.finished";
            native_enabler = "Notify Download Finished";
            native_text = "notify.download.finished";
        } else {
            sound_enabler = "Play File Finished";
            sound_file = "Play File Finished File";
            speech_enabler = "Play File Finished Announcement";
            speech_text = "Play File Finished Announcement Text";
            popup_enabler = "Popup File Finished";
            popup_def_text = "popup.file.finished";
            native_enabler = null;
            native_text = null;
        }
        Map dl_file_alerts = dm_state.getMapAttribute("df_alerts");
        String dlf_prefix = download ? "" : String.valueOf(String.valueOf(dm_file.getIndex())) + ".";
        boolean do_popup = COConfigurationManager.getBooleanParameter(popup_enabler) || this.isDLFEnabled(dl_file_alerts, dlf_prefix, popup_enabler);
        boolean do_speech = Constants.isOSX && (COConfigurationManager.getBooleanParameter(speech_enabler) || this.isDLFEnabled(dl_file_alerts, dlf_prefix, speech_enabler));
        boolean do_sound = COConfigurationManager.getBooleanParameter(sound_enabler, false) || this.isDLFEnabled(dl_file_alerts, dlf_prefix, sound_enabler);
        boolean do_native = native_enabler != null && COConfigurationManager.getBooleanParameter(native_enabler);
        this.doStuff(relatedObject, item_name, do_popup, popup_def_text, false, do_native, native_text, do_speech, speech_text, do_sound, sound_file);
    }

    private void checkComplete(DownloadManager manager, boolean explicit, boolean cancelled) {
        DownloadManagerState dm_state = manager.getDownloadState();
        if (cancelled || dm_state.getFlag(16L) && !explicit) {
            return;
        }
        boolean do_popup = COConfigurationManager.getBooleanParameter("Popup Check Complete");
        this.doStuff(manager, manager.getDisplayName(), do_popup, "popup.check.complete", false, false, null, false, null, false, null);
    }

    private void reportError(DownloadManager manager) {
        DownloadManager relatedObject = manager;
        String item_name = manager.getDisplayName();
        String sound_enabler = "Play Download Error";
        String sound_file = "Play Download Error File";
        String speech_enabler = "Play Download Error Announcement";
        String speech_text = "Play Download Error Announcement Text";
        String popup_enabler = "Popup Download Error";
        String popup_def_text = "popup.download.error";
        String native_enabler = "Notify Download Error";
        String native_text = "notify.download.error";
        long now = SystemTime.getMonotonousTime();
        boolean do_popup = COConfigurationManager.getBooleanParameter("Popup Download Error");
        boolean do_speech = Constants.isOSX && COConfigurationManager.getBooleanParameter("Play Download Error Announcement") && (this.last_error_speech == 0L || now - this.last_error_speech > 5000L);
        boolean do_sound = COConfigurationManager.getBooleanParameter("Play Download Error", false) && (this.last_error_sound == 0L || now - this.last_error_sound > 5000L);
        boolean do_native = COConfigurationManager.getBooleanParameter("Notify Download Error");
        if (do_speech) {
            this.last_error_speech = now;
        }
        if (do_sound) {
            this.last_error_sound = now;
        }
        this.doStuff(relatedObject, item_name, do_popup, "popup.download.error", true, do_native, "notify.download.error", do_speech, "Play Download Error Announcement Text", do_sound, "Play Download Error File");
    }

    public void notificationAdded() {
        boolean do_popup = false;
        boolean do_speech = Constants.isOSX && COConfigurationManager.getBooleanParameter("Play Notification Added Announcement");
        boolean do_sound = COConfigurationManager.getBooleanParameter("Play Notification Added", false);
        this.doStuff(null, null, do_popup, null, false, false, null, do_speech, "Play Notification Added Announcement Text", do_sound, "Play Notification Added File");
    }

    private void doStuff(Object relatedObject, String item_name, boolean do_popup, String popup_def_text, boolean popup_is_error, boolean do_native_tray, String native_text, boolean do_speech, final String speech_text, boolean do_sound, String sound_file) {
        try {
            try {
                this.this_mon.enter();
                if (do_popup) {
                    String popup_text = MessageText.getString(popup_def_text, new String[]{item_name});
                    this.forceNotify(popup_is_error ? 2 : 0, null, popup_text, null, new Object[]{relatedObject}, -1);
                }
                if (do_speech) {
                    new AEThread2("SaySound"){

                        @Override
                        public void run() {
                            try {
                                Runtime.getRuntime().exec(new String[]{"say", COConfigurationManager.getStringParameter(speech_text)});
                                Thread.sleep(2500L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
                if (do_sound) {
                    String file = COConfigurationManager.getStringParameter(sound_file);
                    GeneralUtils.playSound(file);
                }
                if (do_native_tray) {
                    this.displayNativeMessage(MessageText.getString(native_text), item_name, popup_is_error);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                this.this_mon.exit();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean displayNativeMessage(String caption, String text, boolean is_error) {
        try {
            block9: {
                this.this_mon.enter();
                if (this.native_tray_icon == null) {
                    try {
                        if (!SystemTray.isSupported()) break block9;
                        SystemTray st = SystemTray.getSystemTray();
                        Image image = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/com/biglybt/ui/icons/a32info.png"));
                        this.native_tray_icon = new TrayIcon(image, "");
                        this.native_tray_icon.setImageAutoSize(true);
                        this.native_tray_icon.setToolTip(MessageText.getString("label.product.alerts"));
                        try {
                            PopupMenu menu = new PopupMenu();
                            this.native_tray_icon.setPopupMenu(menu);
                            MenuItem mi = new MenuItem(MessageText.getString("sharing.progress.hide"));
                            mi.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent event2) {
                                    try {
                                        UserAlerts.this.this_mon.enter();
                                        try {
                                            SystemTray st = SystemTray.getSystemTray();
                                            st.remove(UserAlerts.this.native_tray_icon);
                                            UserAlerts.this.native_tray_icon = null;
                                        }
                                        catch (Throwable throwable) {}
                                    }
                                    finally {
                                        UserAlerts.this.this_mon.exit();
                                    }
                                }
                            });
                            menu.add(mi);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                        st.add(this.native_tray_icon);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
            if (this.native_tray_icon != null) {
                this.native_tray_icon.displayMessage(caption, text, is_error ? TrayIcon.MessageType.ERROR : TrayIcon.MessageType.INFO);
                return true;
            }
            return false;
        }
        finally {
            this.this_mon.exit();
        }
    }

    private boolean isDLFEnabled(Map map, String prefix, String key) {
        if (map == null) {
            return false;
        }
        key = String.valueOf(prefix) + key;
        return map.containsKey(key);
    }

    private void forceNotify(final int iconID, final String title, final String text, final String details, final Object[] relatedObjects, final int timeoutSecs) {
        if (title != null && !title.isEmpty()) {
            this.log.log(title);
        }
        if (text != null && !text.isEmpty()) {
            this.log.log(text);
        }
        if (details != null && !details.isEmpty()) {
            this.log.log(details);
        }
        UIFunctionsManager.execWithUIFunctions(new UIFunctionsManager.UIFCallback(){

            @Override
            public void run(UIFunctions uif) {
                uif.forceNotify(iconID, title, text, details, relatedObjects, timeoutSecs);
            }
        });
    }

    protected void tidyUp() {
        try {
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            Thread[] threadList = new Thread[threadGroup.activeCount()];
            threadGroup.enumerate(threadList);
            int i = 0;
            while (i < threadList.length) {
                if (threadList[i] != null && "Java Sound event dispatcher".equals(threadList[i].getName())) {
                    threadList[i].interrupt();
                }
                ++i;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        if (this.native_tray_icon != null) {
            try {
                SystemTray st = SystemTray.getSystemTray();
                st.remove(this.native_tray_icon);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void requestUserAttention(int type, Object data) {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        if (pm.hasCapability(PlatformManagerCapabilities.RequestUserAttention)) {
            try {
                pm.requestUserAttention(type, data);
            }
            catch (PlatformManagerException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void dispose() {
        if (singleton == this) {
            singleton = null;
        }
        this.global_manager.removeListener(this.globalManagerListener);
        this.global_manager.removeEventListener(this.globalManagerEventListener);
        List<DownloadManager> dms = this.global_manager.getDownloadManagers();
        for (DownloadManager dm : dms) {
            dm.removeListener(this.download_manager_listener);
            dm.removeDiskListener(this.dm_disk_listener);
            DiskManager diskManager = dm.getDiskManager();
            if (diskManager == null) continue;
            diskManager.removeListener(this.disk_listener);
        }
        ActivitiesManager.removeListener(this.activitiesListener);
    }
}

