/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.auth;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.security.SEPasswordListener;
import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.ui.common.RememberedDecisionsManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AuthenticatorWindow
implements SEPasswordListener {
    private static final String CONFIG_PARAM = "swt.auth.persistent.cache";
    protected Map auth_cache = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("AuthWind");

    public AuthenticatorWindow() {
        SESecurityManager.addPasswordListener(this);
        Map cache = COConfigurationManager.getMapParameter(CONFIG_PARAM, new HashMap());
        try {
            for (Map.Entry entry : cache.entrySet()) {
                String key = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                String user = new String((byte[])value.get("user"), "UTF-8");
                char[] pw = new String((byte[])value.get("pw"), "UTF-8").toCharArray();
                this.auth_cache.put(key, new authCache(key, new PasswordAuthentication(user, pw), true));
            }
        }
        catch (Throwable e) {
            COConfigurationManager.setParameter(CONFIG_PARAM, new HashMap());
            Debug.printStackTrace(e);
        }
    }

    protected void saveAuthCache() {
        try {
            this.this_mon.enter();
            HashMap map = new HashMap();
            for (authCache value : this.auth_cache.values()) {
                if (!value.isPersistent()) continue;
                try {
                    HashMap<String, byte[]> entry_map = new HashMap<String, byte[]>();
                    entry_map.put("user", value.getAuth().getUserName().getBytes("UTF-8"));
                    entry_map.put("pw", new String(value.getAuth().getPassword()).getBytes("UTF-8"));
                    map.put(value.getKey(), entry_map);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            COConfigurationManager.setParameter(CONFIG_PARAM, map);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void clearPasswords() {
        try {
            this.this_mon.enter();
            this.auth_cache = new HashMap();
            this.saveAuthCache();
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public PasswordAuthentication getAuthentication(String realm, URL tracker) {
        try {
            this.this_mon.enter();
            PasswordAuthentication passwordAuthentication = this.getAuthentication(realm, tracker.getProtocol(), tracker.getHost(), tracker.getPort());
            return passwordAuthentication;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
        try {
            this.this_mon.enter();
            this.setAuthenticationOutcome(realm, tracker.getProtocol(), tracker.getHost(), tracker.getPort(), success);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void setAuthenticationOutcome(String realm, String protocol, String host, int port, boolean success) {
        try {
            this.this_mon.enter();
            String tracker = String.valueOf(protocol) + "://" + host + ":" + port + "/";
            String auth_key = String.valueOf(realm) + ":" + tracker;
            authCache cache = (authCache)this.auth_cache.get(auth_key);
            if (cache != null) {
                cache.setOutcome(success);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * Exception decompiling
     */
    public PasswordAuthentication getAuthentication(String realm, String protocol, String host, int port) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String[] getAuthenticationDialog(final String realm, final String location) {
        String persist;
        String details;
        boolean is_tracker;
        authDialog[] dialog;
        AESemaphore sem;
        Display display;
        block8: {
            display = Utils.getDisplay();
            if (display.isDisposed()) {
                return null;
            }
            sem = new AESemaphore("SWTAuth");
            dialog = new authDialog[1];
            TOTorrent torrent = TorrentUtils.getTLSTorrent();
            if (torrent == null) {
                is_tracker = false;
                details = TorrentUtils.getTLSDescription();
            } else {
                details = TorrentUtils.getLocalisedName(torrent);
                is_tracker = true;
            }
            try {
                if (display.getThread() != Thread.currentThread()) break block8;
                dialog[0] = new authDialog(sem, display, realm, is_tracker, location, details);
                if (Utils.readAndDispatchLoop(() -> sem.isReleasedForever())) {
                    return null;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return null;
            }
        }
        display.asyncExec((Runnable)new AERunnable(){

            @Override
            public void runSupport() {
                dialog[0] = new authDialog(sem, display, realm, is_tracker, location, details);
            }
        });
        sem.reserve();
        String user = dialog[0].getUsername();
        String pw = dialog[0].getPassword();
        String string = persist = dialog[0].savePassword() ? "true" : "false";
        if (user == null) {
            return null;
        }
        return new String[]{user, pw == null ? "" : pw, persist};
    }

    protected class authCache {
        private String key;
        private PasswordAuthentication auth;
        private boolean persist;
        private int life = 5;
        private boolean succeeded;

        protected authCache(String _key, PasswordAuthentication _auth, boolean _persist) {
            this.key = _key;
            this.auth = _auth;
            this.persist = _persist;
        }

        protected String getKey() {
            return this.key;
        }

        protected boolean isPersistent() {
            return this.persist;
        }

        protected void setOutcome(boolean success) {
            if (success) {
                this.succeeded = true;
            } else {
                if (this.persist) {
                    this.persist = false;
                    AuthenticatorWindow.this.saveAuthCache();
                }
                if (!this.succeeded) {
                    this.auth = null;
                }
            }
        }

        protected PasswordAuthentication getAuth() {
            if (this.succeeded) {
                return this.auth;
            }
            --this.life;
            if (this.life >= 0) {
                return this.auth;
            }
            if (this.persist) {
                this.persist = false;
                AuthenticatorWindow.this.saveAuthCache();
            }
            return null;
        }
    }

    protected static class authDialog {
        private Shell shell;
        private AESemaphore sem;
        private String username;
        private String password;
        private boolean persist;

        protected authDialog(AESemaphore _sem, Display display, String realm, boolean is_tracker, String target, String details) {
            this.sem = _sem;
            if (details == null) {
                details = "";
            }
            if (display.isDisposed()) {
                this.sem.releaseForever();
                return;
            }
            final String ignore_key = "IgnoreAuth:" + realm + ":" + target + ":" + details.hashCode();
            if (RememberedDecisionsManager.getRememberedDecision(ignore_key) == 1) {
                Debug.out("Authentication for " + realm + "/" + target + "/" + details + " ignored as told not to ask again");
                this.sem.releaseForever();
                return;
            }
            String old_ignore_key = "IgnoreAuth:" + realm + ":" + target + ":" + details;
            int old_decision = RememberedDecisionsManager.getRememberedDecision(old_ignore_key);
            if (old_decision >= 0) {
                RememberedDecisionsManager.setRemembered(old_ignore_key, -1);
            }
            if (old_decision == 1) {
                Debug.out("Authentication for " + realm + "/" + target + "/" + details + " ignored as told not to ask again");
                this.sem.releaseForever();
                return;
            }
            this.shell = ShellFactory.createMainShell(67680);
            Utils.setShellIcon(this.shell);
            Messages.setLanguageText((Widget)this.shell, "authenticator.title");
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            this.shell.setLayout((Layout)layout);
            Label realm_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)realm_label, "authenticator.realm");
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            realm_label.setLayoutData((Object)gridData);
            Label realm_value = new Label((Composite)this.shell, 0);
            realm_value.setText(realm.replaceAll("&", "&&"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            realm_value.setLayoutData((Object)gridData);
            Label target_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)target_label, is_tracker ? "authenticator.tracker" : "authenticator.location");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            target_label.setLayoutData((Object)gridData);
            Label target_value = new Label((Composite)this.shell, 0);
            target_value.setText(target.replaceAll("&", "&&"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            target_value.setLayoutData((Object)gridData);
            if (details != null && details.length() > 0) {
                Label details_label = new Label((Composite)this.shell, 0);
                Messages.setLanguageText((Widget)details_label, is_tracker ? "authenticator.torrent" : "label.details");
                gridData = new GridData(1808);
                gridData.horizontalSpan = 1;
                details_label.setLayoutData((Object)gridData);
                Label details_value = new Label((Composite)this.shell, 0);
                details_value.setText(details.replaceAll("&", "&&"));
                gridData = new GridData(1808);
                gridData.horizontalSpan = 2;
                details_value.setLayoutData((Object)gridData);
            }
            Label user_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)user_label, "authenticator.user");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            user_label.setLayoutData((Object)gridData);
            final Text user_value = new Text((Composite)this.shell, 2048);
            user_value.setText("");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            user_value.setLayoutData((Object)gridData);
            user_value.addListener(24, new Listener(){

                public void handleEvent(Event event2) {
                    username = user_value.getText();
                }
            });
            Label password_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)password_label, "authenticator.password");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            password_label.setLayoutData((Object)gridData);
            final Text password_value = new Text((Composite)this.shell, 2048);
            password_value.setEchoChar('*');
            password_value.setText("");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            password_value.setLayoutData((Object)gridData);
            password_value.addListener(24, new Listener(){

                public void handleEvent(Event event2) {
                    password = password_value.getText();
                }
            });
            Label blank_label = new Label((Composite)this.shell, 0);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            blank_label.setLayoutData((Object)gridData);
            final Button checkBox = new Button((Composite)this.shell, 32);
            checkBox.setText(MessageText.getString("authenticator.savepassword"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            checkBox.setLayoutData((Object)gridData);
            checkBox.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    persist = checkBox.getSelection();
                }
            });
            final Button dontAsk = new Button((Composite)this.shell, 32);
            dontAsk.setText(MessageText.getString("general.dont.ask.again"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            dontAsk.setLayoutData((Object)gridData);
            dontAsk.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    RememberedDecisionsManager.setRemembered(ignore_key, dontAsk.getSelection() ? 1 : 0);
                }
            });
            Label labelSeparator = new Label((Composite)this.shell, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            labelSeparator.setLayoutData((Object)gridData);
            new Label((Composite)this.shell, 0);
            Button bOk = new Button((Composite)this.shell, 8);
            Messages.setLanguageText((Widget)bOk, "Button.ok");
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            bOk.setLayoutData((Object)gridData);
            bOk.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.close(true);
                }
            });
            Button bCancel = new Button((Composite)this.shell, 8);
            Messages.setLanguageText((Widget)bCancel, "Button.cancel");
            gridData = new GridData(128);
            gridData.grabExcessHorizontalSpace = false;
            gridData.widthHint = 70;
            bCancel.setLayoutData((Object)gridData);
            bCancel.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.close(false);
                }
            });
            this.shell.setDefaultButton(bOk);
            this.shell.addListener(31, new Listener(){

                public void handleEvent(Event e) {
                    if (e.character == '\u001b') {
                        this.close(false);
                    }
                }
            });
            this.shell.pack();
            Utils.centreWindow(this.shell);
            this.shell.open();
        }

        protected void close(boolean ok) {
            if (ok) {
                if (this.username == null) {
                    this.username = "";
                }
                if (this.password == null) {
                    this.password = "";
                }
            } else {
                this.username = null;
                this.password = null;
            }
            this.shell.dispose();
            this.sem.releaseForever();
        }

        protected String getUsername() {
            return this.username;
        }

        protected String getPassword() {
            return this.password;
        }

        protected boolean savePassword() {
            return this.persist;
        }
    }
}

