/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.dlhistory;

import com.biglybt.core.history.DownloadHistory;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.debug.ObfuscateCellText;

public class ColumnDLHistoryName
implements TableCellRefreshListener,
TableColumnExtraInfoListener,
ObfuscateCellText {
    public static String COLUMN_ID = "name";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnDLHistoryName(TableColumn column) {
        column.setWidth(400);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        DownloadHistory dl = (DownloadHistory)cell.getDataSource();
        String name = null;
        if (dl != null) {
            name = dl.getName();
        }
        if (name == null) {
            name = "";
        }
        if (!cell.setSortValue((Comparable)((Object)name)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(name);
    }

    @Override
    public String getObfuscatedText(TableCell cell) {
        DownloadHistory dl = (DownloadHistory)cell.getDataSource();
        if (dl == null) {
            return "";
        }
        return ByteFormatter.encodeString(dl.getTorrentHash());
    }
}

