/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.searchsubs;

import com.biglybt.core.subs.util.SearchSubsResultBase;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.ui.common.table.TableColumnCore;

public class ColumnSearchSubResultAge
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "age";

    public ColumnSearchSubResultAge(TableColumn column) {
        column.initialize(3, -2, 50);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(3);
        if (column instanceof TableColumnCore) {
            ((TableColumnCore)column).setUseCoreDataSource(true);
        }
    }

    @Override
    public void refresh(TableCell cell) {
        SearchSubsResultBase rc = (SearchSubsResultBase)cell.getDataSource();
        if (rc == null) {
            return;
        }
        long time = rc.getTime();
        long age_secs = (SystemTime.getCurrentTime() - time) / 1000L;
        if (cell.setSortValue(age_secs)) {
            if (time <= 0L) {
                cell.setText("--");
            } else {
                cell.setToolTip(time <= 0L ? "--" : String.valueOf(TimeFormatter.format2(age_secs, false)) + "\n" + DisplayFormatters.formatCustomDateOnly(time));
                cell.setText(age_secs < 0L ? "--" : TimeFormatter.format3(age_secs));
            }
        }
    }
}

