/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.searchsubs;

import com.biglybt.core.subs.util.SearchSubsResultBase;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnSearchSubResultType
implements TableCellSWTPaintListener,
TableCellAddedListener,
TableCellRefreshListener {
    public static final String COLUMN_ID = "type";
    private static final int WIDTH = 45;
    private static Image imgVideo;
    private static Image imgAudio;
    private static Image imgGame;
    private static Image imgOther;

    public ColumnSearchSubResultType(TableColumn column) {
        column.initialize(3, -2, 45);
        column.addListeners(this);
        column.setRefreshInterval(-3);
        column.setType(2);
        imgVideo = ImageLoader.getInstance().getImage("column.image.ct_video");
        imgAudio = ImageLoader.getInstance().getImage("column.image.ct_audio");
        imgGame = ImageLoader.getInstance().getImage("column.image.ct_game");
        imgOther = ImageLoader.getInstance().getImage("column.image.ct_other");
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        Image img;
        SearchSubsResultBase entry = (SearchSubsResultBase)cell.getDataSource();
        Rectangle cellBounds = cell.getBounds();
        if (entry == null) {
            img = imgOther;
        } else {
            int ct = entry.getContentType();
            switch (ct) {
                case 0: {
                    img = imgOther;
                    break;
                }
                case 1: {
                    img = imgVideo;
                    break;
                }
                case 2: {
                    img = imgAudio;
                    break;
                }
                case 3: {
                    img = imgGame;
                    break;
                }
                default: {
                    img = imgOther;
                }
            }
        }
        if (img != null && !img.isDisposed()) {
            Rectangle imgBounds = img.getBounds();
            gc.drawImage(img, cellBounds.x + (cellBounds.width - imgBounds.width) / 2, cellBounds.y + (cellBounds.height - imgBounds.height) / 2);
        }
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    @Override
    public void refresh(TableCell cell) {
        SearchSubsResultBase entry = (SearchSubsResultBase)cell.getDataSource();
        if (entry != null) {
            cell.setSortValue(entry.getContentType());
        }
    }
}

