/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.subscriptions;

import com.biglybt.core.subs.util.SubscriptionResultFilterable;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnSubResultNew
implements TableCellSWTPaintListener,
TableCellAddedListener,
TableCellRefreshListener,
TableCellMouseListener {
    public static final String COLUMN_ID = "new";
    private static final int WIDTH = 38;
    private static Image imgNew;
    private static Image imgOld;

    public ColumnSubResultNew(TableColumn column) {
        column.initialize(3, -2, 38);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(2);
        imgNew = ImageLoader.getInstance().getImage("image.activity.unread");
        imgOld = ImageLoader.getInstance().getImage("image.activity.read");
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        Image img;
        SubscriptionResultFilterable entry = (SubscriptionResultFilterable)cell.getDataSource();
        Rectangle cellBounds = cell.getBounds();
        Image image = img = entry == null || entry.getRead() ? imgOld : imgNew;
        if (img != null && !img.isDisposed()) {
            Rectangle imgBounds = img.getBounds();
            gc.drawImage(img, cellBounds.x + (cellBounds.width - imgBounds.width) / 2, cellBounds.y + (cellBounds.height - imgBounds.height) / 2);
        }
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
        if (cell instanceof TableCellSWT) {
            ((TableCellSWT)cell).setCursorID(21);
        }
    }

    @Override
    public void refresh(TableCell cell) {
        SubscriptionResultFilterable entry = (SubscriptionResultFilterable)cell.getDataSource();
        if (entry != null) {
            boolean unread = !entry.getRead();
            long sortVal = (unread ? 2L : 1L) << 61;
            if (cell.isSecondarySortEnabled()) {
                sortVal -= (SystemTime.getCurrentTime() - entry.getTime()) / 1000L;
            }
            cell.setSortValue(sortVal);
        }
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        SubscriptionResultFilterable entry;
        if (event2.eventType == 0 && event2.button == 1 && (entry = (SubscriptionResultFilterable)event2.cell.getDataSource()) != null) {
            entry.setRead(!entry.getRead());
            event2.cell.invalidate();
        }
    }
}

