/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.subscriptions;

import com.biglybt.core.subs.Subscription;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.utils.TableColumnCreator;
import com.biglybt.ui.swt.views.tableitems.ColumnDateSizer;

public class ColumnSubscriptionLastChecked
extends ColumnDateSizer {
    public static String COLUMN_ID = "last-checked";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential", "time"});
        info.setProficiency((byte)1);
    }

    public ColumnSubscriptionLastChecked(String sTableID) {
        super(Subscription.class, COLUMN_ID, TableColumnCreator.DATE_COLUMN_WIDTH, sTableID);
        this.setRefreshInterval(-2);
        this.setPosition(-1);
        this.setMinWidth(100);
        this.setMultiline(false);
        this.setShowTime(true);
    }

    @Override
    public void refresh(TableCell cell, long timestamp) {
        timestamp = 0L;
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub != null) {
            timestamp = sub.getHistory().getLastScanTime();
        }
        if (!cell.setSortValue(timestamp) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        if (sub.isSearchTemplate()) {
            cell.setText("");
        } else if (timestamp <= 0L) {
            cell.setText("--");
        } else {
            super.refresh(cell, timestamp);
        }
    }
}

