/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.subscriptions;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionManagerFactory;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class ColumnSubscriptionMaxResults
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static String COLUMN_ID = "max-results";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"settings"});
        info.setProficiency((byte)1);
    }

    public ColumnSubscriptionMaxResults(String sTableID) {
        super(COLUMN_ID, -1, 100, sTableID);
        this.setRefreshInterval(-2);
        this.setAlignment(2);
    }

    @Override
    public void refresh(TableCell cell) {
        boolean is_st;
        int maxResults = 0;
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub != null) {
            maxResults = sub.getHistory().getMaxNonDeletedResults();
        }
        if (maxResults < 0) {
            maxResults = SubscriptionManagerFactory.getSingleton().getMaxNonDeletedResults();
        }
        if (!cell.setSortValue((is_st = sub.isSearchTemplate()) ? -1 : maxResults) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        if (is_st) {
            cell.setText("");
        } else if (maxResults == 0) {
            cell.setText(MessageText.getString("ConfigView.unlimited"));
        } else {
            cell.setText("" + maxResults);
        }
    }
}

