/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.subscriptions;

import com.biglybt.core.subs.Subscription;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class ColumnSubscriptionNbResults
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static String COLUMN_ID = "nb-results";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnSubscriptionNbResults(String sTableID) {
        super(COLUMN_ID, -2, 100, sTableID);
        this.setRefreshInterval(-2);
        this.setAlignment(2);
    }

    @Override
    public void refresh(TableCell cell) {
        int nbResults = 0;
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub != null) {
            nbResults = sub.getHistory().getNumUnread() + sub.getHistory().getNumRead();
        }
        if (!cell.setSortValue(nbResults) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        if (sub.isSearchTemplate()) {
            cell.setText("");
        } else {
            cell.setText("" + nbResults);
        }
    }
}

