/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.subscriptions;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.metasearch.impl.plugin.PluginEngine;
import com.biglybt.core.metasearch.impl.web.WebEngine;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.protocol.azplug.AZPluginConnection;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import java.net.URL;
import java.util.Locale;

public class ColumnSubscriptionProtocol
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static String COLUMN_ID = "protocol";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)1);
    }

    public ColumnSubscriptionProtocol(String sTableID) {
        super(COLUMN_ID, -1, 60, sTableID);
        this.setRefreshInterval(-2);
        this.setAlignment(1);
    }

    @Override
    public void refresh(TableCell cell) {
        String str;
        block13: {
            str = "";
            Subscription sub = (Subscription)cell.getDataSource();
            if (sub != null) {
                if (sub.isSearchTemplate() || sub.isSubscriptionTemplate()) {
                    str = MessageText.getString(sub.isSearchTemplate() ? "Button.search" : "subs.prop.template").toLowerCase(Locale.US);
                } else {
                    try {
                        Engine engine = sub.getEngine();
                        if (engine instanceof WebEngine) {
                            String url_str = ((WebEngine)engine).getSearchUrl();
                            try {
                                URL url = new URL(url_str);
                                str = url.getProtocol();
                                if (!str.equals("azplug")) break block13;
                                try {
                                    AZPluginConnection pc = (AZPluginConnection)url.openConnection();
                                    String pn = pc.getPluginName();
                                    if (pn != null) {
                                        str = pn.toLowerCase();
                                    }
                                    break block13;
                                }
                                catch (Throwable throwable) {
                                }
                            }
                            catch (Throwable e) {
                                str = url_str;
                            }
                            break block13;
                        }
                        str = engine instanceof PluginEngine ? ((PluginEngine)engine).getName().toLowerCase() : engine.getName();
                    }
                    catch (Throwable e) {
                        str = Debug.getNestedExceptionMessage(e);
                    }
                }
            }
        }
        if (!cell.setSortValue((Comparable)((Object)str)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(str);
    }
}

