/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.subscriptions;

import com.biglybt.core.subs.Subscription;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class ColumnSubscriptionSubscribers
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static String COLUMN_ID = "nb-subscribers";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)1);
    }

    public ColumnSubscriptionSubscribers(String sTableID) {
        super(COLUMN_ID, -1, 100, sTableID);
        this.setRefreshInterval(-2);
        this.setAlignment(2);
    }

    @Override
    public void refresh(TableCell cell) {
        int nbSubsribers = 0;
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub != null) {
            nbSubsribers = (int)sub.getCachedPopularity();
        }
        if (!cell.setSortValue(nbSubsribers) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        if (nbSubsribers < 0) {
            cell.setText("");
        } else {
            cell.setText("" + nbSubsribers);
        }
    }
}

