/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.tag;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagFeatureLimits;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;

public class ColumnTagLimits
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "tag.limit";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"settings"});
        info.setProficiency((byte)1);
    }

    public ColumnTagLimits(TableColumn column) {
        column.setWidth(200);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        TagFeatureLimits tfl;
        int max;
        Tag tag = (Tag)cell.getDataSource();
        String tag_limits = "";
        if (tag instanceof TagFeatureLimits && (max = (tfl = (TagFeatureLimits)((Object)tag)).getMaximumTaggables()) > 0) {
            tag_limits = String.valueOf(max);
            String policy = null;
            switch (tfl.getRemovalStrategy()) {
                case 0: {
                    policy = "label.none.assigned";
                    break;
                }
                case 1: {
                    policy = "MyTorrentsView.menu.archive";
                    break;
                }
                case 2: {
                    policy = "Button.deleteContent.fromLibrary";
                    break;
                }
                case 3: {
                    policy = "Button.deleteContent.fromComputer";
                    break;
                }
                case 4: {
                    policy = "label.move.to.old.tag";
                }
            }
            if (policy != null) {
                tag_limits = String.valueOf(tag_limits) + "; " + MessageText.getString(policy);
            }
            String order = null;
            switch (tfl.getOrdering()) {
                case 0: {
                    order = "label.time.added.to.vuze";
                    break;
                }
                case 1: {
                    order = "label.time.added.to.tag";
                }
            }
            if (order != null) {
                tag_limits = String.valueOf(tag_limits) + "; " + MessageText.getString(order);
            }
        }
        if (!cell.setSortValue((Comparable)((Object)tag_limits)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(tag_limits);
    }
}

