/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.tag;

import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagFeatureRateLimit;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;

public class ColumnTagMaxSR
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "max_sr";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"sharing"});
        info.setProficiency((byte)1);
    }

    public ColumnTagMaxSR(TableColumn column) {
        column.setWidth(60);
        column.setRefreshInterval(-2);
        column.setAlignment(2);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        TagFeatureRateLimit rl;
        int sr;
        Tag tag = (Tag)cell.getDataSource();
        if (tag instanceof TagFeatureRateLimit && (sr = (rl = (TagFeatureRateLimit)((Object)tag)).getTagMaxShareRatio()) >= 0) {
            if (!cell.setSortValue(sr) && cell.isValid()) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            cell.setText(sr == 0 ? "" : DisplayFormatters.formatDecimal((double)sr / 1000.0, 3));
        }
    }
}

