/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.torrent;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerEnhancer;
import com.biglybt.core.download.EnhancedDownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.columns.torrent.ColumnTorrentFileProgress;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.skin.SWTSkinFactory;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.views.ViewUtils;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ColumnProgressETA
extends CoreTableColumnSWT
implements TableCellAddedListener,
TableCellMouseListener,
TableCellRefreshListener,
TableCellSWTPaintListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "ProgressETA";
    public static final long SHOW_ETA_AFTER_MS = 30000L;
    private static final String CFG_SHOWETA = "ColumnProgressETA.showETA";
    private static final String CFG_SHOWSPEED = "ColumnProgressETA.showSpeed";
    private static final String CFG_SHOW3D = "ColumnProgressETA.show3D";
    private static final int borderWidth = 1;
    private static final int COLUMN_WIDTH = 200;
    private static final Object CLICK_KEY = new Object();
    private static Font fontText = null;
    private static int textHeightPX = 0;
    private static Font fontSecondLine = null;
    private static int secondLineHeightPX = 0;
    private final MyParameterListener myParameterListener;
    private boolean showETA;
    private boolean showSpeed;
    private boolean show3D;
    Display display;
    private Color cBase;
    private final int COLOR_DL = 0;
    private final int COLOR_CD = 1;
    private final int COLOR_QU = 2;
    private final int COLOR_OFF = 3;
    private final int COLOR_LS = 4;
    private final int[] COLOR_MENU_ORDER;
    private Color[] cDefaults;
    private Color[] cExplicits;
    private Color cBorder;
    private Color cText;
    private Color cTextDrop;
    private Color cLinks;
    private ViewUtils.CustomDateFormat cdf;
    private ColumnTorrentFileProgress fileProgress;
    private boolean progress_eta_absolute;

    public ColumnProgressETA(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 200, sTableID);
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 3;
        this.COLOR_MENU_ORDER = nArray;
        this.cDefaults = new Color[5];
        this.cExplicits = new Color[5];
        this.addDataSourceType(DiskManagerFileInfo.class);
        this.initializeAsGraphic(200);
        this.setAlignment(1);
        this.setMinWidth(100);
        this.myParameterListener = new MyParameterListener();
        COConfigurationManager.addWeakParameterListener(this.myParameterListener, false, "mtv.progress_eta.show_absolute");
        this.display = Utils.getDisplay();
        SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
        this.cBase = skinProperties.getColor("color.progress.bar");
        if (this.cBase == null) {
            this.cBase = Colors.white;
        }
        this.cBorder = skinProperties.getColor("color.progress.border");
        if (this.cBorder == null) {
            this.cBorder = Colors.grey;
        }
        this.cText = skinProperties.getColor("color.progress.text");
        if (this.cText == null) {
            this.cText = Colors.black;
        }
        this.cTextDrop = skinProperties.getColor("color.progress.text.drop");
        this.cLinks = skinProperties.getColor("color.links");
        if (this.cLinks == null) {
            this.cLinks = Colors.blue;
        }
        this.cDefaults[3] = skinProperties.getColor("color.progress.bg.inactive");
        if (this.cDefaults[3] == null) {
            this.cDefaults[3] = Colors.light_grey;
        }
        this.cDefaults[2] = this.cDefaults[3];
        this.cDefaults[0] = skinProperties.getColor("color.progress.bg.dl");
        if (this.cDefaults[0] == null) {
            this.cDefaults[0] = Colors.blues[9];
        }
        this.cDefaults[1] = skinProperties.getColor("color.progress.bg.cd");
        if (this.cDefaults[1] == null) {
            this.cDefaults[1] = Colors.green;
        }
        this.cDefaults[4] = skinProperties.getColor("color.progress.bg.lightseeding");
        if (this.cDefaults[4] == null) {
            this.cDefaults[4] = Colors.light_grey;
        }
        int i = 0;
        while (i < this.cExplicits.length) {
            COConfigurationManager.addWeakParameterListener(this.myParameterListener, false, "ColumnProgressETA.color." + i);
            ++i;
        }
        this.cdf = ViewUtils.addCustomDateFormat(this);
        this.fileProgress = new ColumnTorrentFileProgress(this.display);
        TableContextMenuItem menuShowETA = this.addContextMenuItem(CFG_SHOWETA, 1);
        menuShowETA.setStyle(2);
        menuShowETA.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(ColumnProgressETA.this.showETA);
            }
        });
        menuShowETA.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                ColumnProgressETA.this.showETA = (Boolean)menu.getData();
                ColumnProgressETA.this.setUserData(ColumnProgressETA.CFG_SHOWETA, ColumnProgressETA.this.showETA ? 1 : 0);
                ColumnProgressETA.this.invalidateCells();
            }
        });
        TableContextMenuItem menuShowSpeed = this.addContextMenuItem(CFG_SHOWSPEED, 1);
        menuShowSpeed.setStyle(2);
        menuShowSpeed.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(ColumnProgressETA.this.showSpeed);
            }
        });
        menuShowSpeed.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                ColumnProgressETA.this.showSpeed = (Boolean)menu.getData();
                ColumnProgressETA.this.setUserData(ColumnProgressETA.CFG_SHOWSPEED, ColumnProgressETA.this.showSpeed ? 1 : 0);
                ColumnProgressETA.this.invalidateCells();
            }
        });
        TableContextMenuItem menuShow3D = this.addContextMenuItem(CFG_SHOW3D, 1);
        menuShow3D.setStyle(2);
        menuShow3D.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(ColumnProgressETA.this.show3D);
            }
        });
        menuShow3D.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                ColumnProgressETA.this.show3D = (Boolean)menu.getData();
                ColumnProgressETA.this.setUserData(ColumnProgressETA.CFG_SHOW3D, ColumnProgressETA.this.show3D ? 1 : 0);
                ColumnProgressETA.this.invalidateCells();
            }
        });
        TableContextMenuItem menuSetColours = this.addContextMenuItem("ColumnProgressETA.setColours", 1);
        menuSetColours.setStyle(5);
        menuSetColours.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.removeAllChildItems();
                PluginInterface pi = PluginInitializer.getDefaultInterface();
                UIManager uim = pi.getUIManager();
                MenuManager menuManager = uim.getMenuManager();
                int[] nArray = ColumnProgressETA.this.COLOR_MENU_ORDER;
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int i;
                    final int f_i = i = nArray[n2];
                    MenuItem item = menuManager.addMenuItem(menu, "!" + MessageText.getString("ColumnProgressETA.color." + i) + "...!");
                    item.addMultiListener(new MenuItemListener(){

                        @Override
                        public void selected(MenuItem menu, Object target) {
                            RGB result;
                            Color c = ColumnProgressETA.this.cExplicits[f_i];
                            if (c == null) {
                                c = ColumnProgressETA.this.cDefaults[f_i];
                            }
                            if ((result = Utils.showColorDialog((this).ColumnProgressETA.this.display.getActiveShell(), c == null ? null : c.getRGB())) != null) {
                                COConfigurationManager.setRGBParameter("ColumnProgressETA.color." + f_i, new int[]{result.red, result.green, result.blue}, null);
                            }
                        }
                    });
                    ++n2;
                }
                MenuItem itemSep = menuManager.addMenuItem(menu, "sep");
                itemSep.setStyle(4);
                MenuItem itemReset = menuManager.addMenuItem(menu, "Button.reset");
                itemReset.addMultiListener(new MenuItemListener(){

                    @Override
                    public void selected(MenuItem menu, Object target) {
                        int i = 0;
                        while (i < ColumnProgressETA.this.cExplicits.length) {
                            COConfigurationManager.setRGBParameter("ColumnProgressETA.color." + i, null, null);
                            ++i;
                        }
                    }
                });
            }
        });
        this.myParameterListener.parameterChanged(null);
    }

    @Override
    public void remove() {
        super.remove();
        COConfigurationManager.removeWeakParameterListener(this.myParameterListener, "mtv.progress_eta.show_absolute");
        int i = 0;
        while (i < this.cExplicits.length) {
            COConfigurationManager.removeWeakParameterListener(this.myParameterListener, "ColumnProgressETA.color." + i);
            ++i;
        }
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content", "essential", "time"});
        info.setProficiency((byte)0);
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.setMarginHeight(1);
        cell.setMarginWidth(2);
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        String url;
        Object ds = event2.cell.getDataSource();
        if (ds instanceof DiskManagerFileInfo) {
            this.fileProgress.fileInfoMouseTrigger(event2);
            return;
        }
        DownloadManager dm = (DownloadManager)ds;
        if (dm == null) {
            return;
        }
        String clickable = (String)dm.getUserData(CLICK_KEY);
        if (clickable == null) {
            return;
        }
        event2.skipCoreFunctionality = true;
        if (event2.eventType == 1 && (url = UrlUtils.getURL(clickable)) != null) {
            Utils.launch(url);
        }
    }

    @Override
    public void refresh(TableCell cell) {
        Object ds = cell.getDataSource();
        long percentDone = this.getPercentDone(ds);
        long sortValue = 0L;
        if (ds instanceof DownloadManager) {
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            int hashCode = Math.abs(DisplayFormatters.formatDownloadStatus(dm).hashCode());
            long completedTime = dm.getDownloadState().getLongParameter("stats.download.completed.time");
            sortValue = completedTime <= 0L || !dm.isDownloadComplete(false) ? (percentDone << 31) + (long)hashCode : (completedTime / 1000L << 31) + (long)hashCode;
        } else if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            int st = fileInfo2.getStorageType();
            if ((st == 2 || st == 4) && fileInfo2.isSkipped()) {
                sortValue = 1L;
            } else if (fileInfo2.isSkipped()) {
                sortValue = 2L;
            } else if (fileInfo2.getPriority() > 0) {
                int pri = fileInfo2.getPriority();
                sortValue = 4L;
                if (pri > 1) {
                    sortValue += (long)pri;
                }
            } else {
                sortValue = 3L;
            }
            sortValue = (long)(fileInfo2.getDownloadManager().getState() * 10000) + percentDone + sortValue;
        }
        long eta = this.showETA ? this.getETA(cell) : 0L;
        long speed = this.showSpeed ? this.getSpeed(ds) : 0L;
        Comparable old = cell.getSortValue();
        boolean sortChanged = cell.setSortValue(sortValue);
        if (sortChanged && old != null && !(old instanceof String)) {
            UIFunctionsManagerSWT.getUIFunctionsSWT().refreshIconBar();
        }
        long lastETA = 0L;
        long lastSpeed = 0L;
        TableRow row = cell.getTableRow();
        if (row != null) {
            Object data;
            if (this.showETA) {
                data = row.getData("lastETA");
                if (data instanceof Number) {
                    lastETA = ((Number)data).longValue();
                }
                row.setData("lastETA", new Long(eta));
            }
            if (this.showSpeed) {
                data = row.getData("lastSpeed");
                if (data instanceof Number) {
                    lastSpeed = ((Number)data).longValue();
                }
                row.setData("lastSpeed", new Long(speed));
            }
        }
        if (!(sortChanged || lastETA == eta && lastSpeed == speed)) {
            cell.invalidate();
        }
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        long lSpeed;
        int substate;
        Color fgSecondLine;
        int alignSecondLine;
        Rectangle boundsSecondLine;
        boolean showSecondLine;
        Object ds = cell.getDataSource();
        if (ds instanceof DiskManagerFileInfo) {
            TableRowCore row = cell.getTableRowCore();
            if (row != null) {
                this.fileProgress.fillInfoProgressETA(row, gc, (DiskManagerFileInfo)ds, cell.getBounds());
            }
            return;
        }
        if (!(ds instanceof DownloadManager)) {
            return;
        }
        String tooltip = null;
        DownloadManager dm = (DownloadManager)ds;
        int dm_state = dm.getState();
        if (dm_state == 75) {
            tooltip = MessageText.getString("ManagerItem.queued.tooltip");
        }
        int percentDone = this.getPercentDone(ds);
        long eta = this.showETA ? this.getETA(cell) : 0L;
        Color fgFirst = gc.getForeground();
        int minCellWidth = 14;
        int minProgressHeight = 18;
        int secondLineHeight = 16;
        int minTwoLineHeight = 34;
        int maxTextHeightPX = 20;
        Rectangle cellBounds = cell.getBounds();
        --cellBounds.width;
        if (cellBounds.width < 14) {
            return;
        }
        Rectangle boundsProgressBar = cell.getBounds();
        --boundsProgressBar.width;
        int cellLineCount = cell.getMaxLines();
        if (cellLineCount > 1 || cellBounds.height >= 34) {
            showSecondLine = true;
            boundsProgressBar.height -= 16;
            boundsSecondLine = new Rectangle(boundsProgressBar.x, boundsProgressBar.y + boundsProgressBar.height + 1, boundsProgressBar.width, 16);
            alignSecondLine = 0x1000000;
            fgSecondLine = fgFirst;
        } else {
            showSecondLine = false;
            boundsSecondLine = boundsProgressBar;
            alignSecondLine = 131072;
            fgSecondLine = this.cText;
        }
        int fillWidth = percentDone * cellBounds.width / 1000;
        Rectangle pctFillRect = new Rectangle(cellBounds.x, cellBounds.y, fillWidth, cellBounds.height);
        pctFillRect.intersect(boundsProgressBar);
        Rectangle pctFillRectNot = new Rectangle(pctFillRect.x + pctFillRect.width, pctFillRect.y, boundsProgressBar.width - pctFillRect.width, pctFillRect.height);
        gc.setBackground(this.cBase);
        gc.fillRectangle(boundsProgressBar);
        int cBGIndex = dm_state == 50 || dm_state == 60 ? (percentDone == 1000 || dm.isDownloadComplete(false) ? 1 : 0) : (dm_state == 75 ? ((substate = dm.getSubState()) == 60 ? 4 : 2) : 3);
        Color cBG = this.cExplicits[cBGIndex];
        boolean bgIsCustom = true;
        if (cBG == null) {
            cBG = this.cDefaults[cBGIndex];
            bgIsCustom = false;
        }
        gc.setBackground(cBG);
        gc.fillRectangle(pctFillRect);
        if (this.show3D) {
            int edgeHeight = boundsProgressBar.height > 40 ? 5 : 3;
            Color highlight = Colors.getInstance().getLighterColor(cBG, 50);
            Color lowlight = Colors.getInstance().getLighterColor(cBG, -40);
            gc.setForeground(highlight);
            gc.fillGradientRectangle(pctFillRect.x, pctFillRect.y, pctFillRect.width, edgeHeight, true);
            gc.setForeground(cBG);
            gc.setBackground(lowlight);
            gc.fillGradientRectangle(pctFillRect.x, pctFillRect.y + pctFillRect.height - edgeHeight, pctFillRect.width, edgeHeight, true);
        }
        gc.setBackground(this.cBase);
        int originalWidth = gc.getLineWidth();
        gc.setForeground(this.cBorder);
        gc.setLineWidth(1);
        gc.drawRectangle(boundsProgressBar.x, boundsProgressBar.y, boundsProgressBar.width - 1, boundsProgressBar.height - 1);
        gc.setLineWidth(originalWidth);
        String sStatusLine = null;
        if (dm.isUnauthorisedOnTracker()) {
            sStatusLine = dm.getTrackerStatus();
        } else if (this.showETA && eta > 0L) {
            String sETA = this.cdf.formatETA(eta, this.progress_eta_absolute);
            sStatusLine = MessageText.getString("MyTorrents.column.ColumnProgressETA.2ndLine", new String[]{sETA});
        } else {
            sStatusLine = DisplayFormatters.formatDownloadStatus(dm).toUpperCase();
        }
        boolean haveLink = false;
        if (sStatusLine != null && sStatusLine.contains("http://") || sStatusLine.contains("https://")) {
            dm.setUserData(CLICK_KEY, sStatusLine);
            haveLink = true;
            if (showSecondLine) {
                fgSecondLine = this.cLinks;
            }
        } else {
            dm.setUserData(CLICK_KEY, null);
        }
        cell.setCursorID(haveLink ? 21 : 0);
        String sSpeed = "";
        if (this.showSpeed && (lSpeed = this.getSpeed(ds)) > 0L) {
            sSpeed = " (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(lSpeed, true) + ")";
        }
        String sPercent = DisplayFormatters.formatPercentFromThousands(percentDone);
        int xOffset = 3;
        int yOffset = boundsProgressBar.height > 30 ? 2 : 1;
        int textWidthPX = boundsProgressBar.width - 6;
        int newTextHeightPX = Math.min(showSecondLine ? 20 : 16, boundsProgressBar.height - 2 * yOffset);
        yOffset = (boundsProgressBar.height - newTextHeightPX + 1) / 2;
        if (fontText == null || newTextHeightPX != textHeightPX) {
            if (fontText != null) {
                fontText.dispose();
            }
            textHeightPX = newTextHeightPX;
            fontText = FontUtils.getFontWithHeight(gc.getFont(), textHeightPX, -1);
        }
        boolean wantShadow = this.cTextDrop != null && this.show3D;
        Rectangle area = new Rectangle(boundsProgressBar.x + 3 + (wantShadow ? 1 : 0), boundsProgressBar.y + yOffset + (wantShadow ? 1 : 0), textWidthPX, textHeightPX);
        gc.setTextAntialias(1);
        gc.setFont(fontText);
        GCStringPrinter sp = new GCStringPrinter(gc, String.valueOf(sPercent) + sSpeed, area, true, false, 16384);
        if (wantShadow) {
            gc.setForeground(this.cTextDrop);
            sp.printString();
            --area.x;
            --area.y;
        }
        Color cFirstLine = this.cText;
        if (bgIsCustom && !Colors.isColorContrastOk(this.cText, cBG)) {
            cFirstLine = Colors.isColorContrastOk(Colors.white, cBG) ? Colors.white : Colors.black;
        }
        gc.setForeground(cFirstLine);
        if (bgIsCustom && cFirstLine == Colors.white && Colors.isColorContrastOk(Colors.black, this.cBase)) {
            Rectangle old = gc.getClipping();
            Utils.setClipping(gc, pctFillRect);
            sp.printString();
            Utils.setClipping(gc, pctFillRectNot);
            gc.setForeground(Colors.black);
            sp.printString();
            Utils.setClipping(gc, old);
        } else {
            sp.printString();
        }
        if (sStatusLine != null) {
            boolean fit;
            if (showSecondLine) {
                int newHeight = boundsSecondLine.height;
                if (fontSecondLine == null || newHeight != secondLineHeightPX) {
                    if (fontSecondLine != null) {
                        fontSecondLine.dispose();
                    }
                    secondLineHeightPX = newHeight;
                    fontSecondLine = FontUtils.getFontWithHeight(gc.getFont(), secondLineHeightPX, -1);
                }
            } else {
                Point pctExtent = sp.getCalculatedSize();
                boundsSecondLine = area;
                boundsSecondLine.x += pctExtent.x + 3;
                boundsSecondLine.width -= pctExtent.x + 3;
                if (wantShadow) {
                    ++boundsSecondLine.x;
                    ++boundsSecondLine.y;
                }
                if (fontSecondLine != null) {
                    fontSecondLine.dispose();
                    fontSecondLine = null;
                }
                secondLineHeightPX = -1;
            }
            gc.setFont(showSecondLine ? fontSecondLine : fontText);
            GCStringPrinter sp2 = new GCStringPrinter(gc, sStatusLine, boundsSecondLine, true, false, alignSecondLine);
            if (!showSecondLine && wantShadow) {
                gc.setForeground(this.cTextDrop);
                sp2.printString();
                --boundsSecondLine.x;
                --boundsSecondLine.y;
            }
            Color cSecondLine = showSecondLine ? fgSecondLine : cFirstLine;
            gc.setForeground(cSecondLine);
            if (bgIsCustom && cSecondLine == Colors.white && Colors.isColorContrastOk(Colors.black, this.cBase)) {
                Rectangle old = gc.getClipping();
                Utils.setClipping(gc, pctFillRect);
                sp2.printString();
                Utils.setClipping(gc, pctFillRectNot);
                gc.setForeground(Colors.black);
                fit = sp2.printString();
                Utils.setClipping(gc, old);
            } else {
                fit = sp2.printString();
            }
            if (!fit) {
                tooltip = tooltip == null ? sStatusLine : String.valueOf(sStatusLine) + ": " + tooltip;
            }
        }
        cell.setToolTip(tooltip);
        gc.setFont(null);
    }

    private int getPercentDone(Object ds) {
        if (ds instanceof DownloadManager) {
            return ((DownloadManager)ds).getStats().getPercentDoneExcludingDND();
        }
        if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            long length = fileInfo2.getLength();
            if (length == 0L) {
                return 1000;
            }
            return (int)(fileInfo2.getDownloaded() * 1000L / length);
        }
        return 0;
    }

    private long getETA(TableCell cell) {
        Object ds = cell.getDataSource();
        if (ds instanceof DiskManagerFileInfo) {
            return 0L;
        }
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long diff = SystemTime.getCurrentTime() - dm.getStats().getTimeStarted();
        if (diff > 30000L) {
            return dm.getStats().getSmoothedETA();
        }
        return 0L;
    }

    private int getState(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm == null) {
            return 100;
        }
        return dm.getState();
    }

    private long getSpeed(Object ds) {
        if (!(ds instanceof DownloadManager)) {
            return 0L;
        }
        return ((DownloadManager)ds).getStats().getDataReceiveRate();
    }

    public EnhancedDownloadManager getEDM(DownloadManager dm) {
        DownloadManagerEnhancer dmEnhancer = DownloadManagerEnhancer.getSingleton();
        if (dmEnhancer == null) {
            return null;
        }
        return dmEnhancer.getEnhancedDownload(dm);
    }

    private void log(TableCell cell, String s) {
        System.out.println(String.valueOf(((TableRowCore)cell.getTableRow()).getIndex()) + ":" + System.currentTimeMillis() + ": " + s);
    }

    @Override
    public void postConfigLoad() {
        super.postConfigLoad();
        Object oShowETA = this.getUserData(CFG_SHOWETA);
        if (oShowETA == null) {
            this.showETA = false;
        } else if (oShowETA instanceof Number) {
            this.showETA = ((Number)oShowETA).intValue() == 1;
        }
        Object oShowSpeed = this.getUserData(CFG_SHOWSPEED);
        if (oShowSpeed == null) {
            this.showSpeed = false;
        } else if (oShowSpeed instanceof Number) {
            this.showSpeed = ((Number)oShowSpeed).intValue() == 1;
        }
        Object oShow3D = this.getUserData(CFG_SHOW3D);
        if (oShow3D == null) {
            this.show3D = false;
        } else if (oShow3D instanceof Number) {
            this.show3D = ((Number)oShow3D).intValue() == 1;
        }
        this.cdf.update();
    }

    private class MyParameterListener
    implements ParameterListener {
        private MyParameterListener() {
        }

        @Override
        public void parameterChanged(String unused) {
            ColumnProgressETA.this.progress_eta_absolute = COConfigurationManager.getBooleanParameter("mtv.progress_eta.show_absolute", false);
            int i = 0;
            while (i < ColumnProgressETA.this.cExplicits.length) {
                int[] rgb = COConfigurationManager.getRGBParameter("ColumnProgressETA.color." + i);
                ((ColumnProgressETA)ColumnProgressETA.this).cExplicits[i] = rgb != null && rgb.length == 3 ? ColorCache.getColor((Device)ColumnProgressETA.this.display, rgb) : null;
                ++i;
            }
            ColumnProgressETA.this.invalidateCells();
        }
    }
}

