/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.vuzeactivity;

import com.biglybt.activities.ActivitiesEntry;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnActivityNew
extends CoreTableColumnSWT
implements TableCellSWTPaintListener,
TableCellAddedListener,
TableCellRefreshListener,
TableCellMouseListener {
    public static final String COLUMN_ID = "activityNew";
    private static final int WIDTH = 38;
    private static Image imgNew;
    private static Image imgOld;

    public ColumnActivityNew(String tableID) {
        super(COLUMN_ID, tableID);
        this.initializeAsGraphic(38);
        this.setAlignment(3);
        imgNew = ImageLoader.getInstance().getImage("image.activity.unread");
        imgOld = ImageLoader.getInstance().getImage("image.activity.read");
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        Image img;
        ActivitiesEntry entry = (ActivitiesEntry)cell.getDataSource();
        Rectangle cellBounds = cell.getBounds();
        Image image = img = entry.getReadOn() <= 0L ? imgNew : imgOld;
        if (img != null && !img.isDisposed()) {
            Rectangle imgBounds = img.getBounds();
            gc.drawImage(img, cellBounds.x + (cellBounds.width - imgBounds.width) / 2, cellBounds.y + (cellBounds.height - imgBounds.height) / 2);
        }
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    @Override
    public void refresh(TableCell cell) {
        int sortVal;
        ActivitiesEntry entry = (ActivitiesEntry)cell.getDataSource();
        boolean isRead = entry.getReadOn() > 0L;
        int n = sortVal = isRead ? 1 : 0;
        if (cell.setSortValue(sortVal)) {
            cell.invalidate();
        }
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        ActivitiesEntry entry;
        if (event2.eventType == 0 && event2.button == 1 && (entry = (ActivitiesEntry)event2.cell.getDataSource()).canFlipRead()) {
            entry.setRead(!entry.isRead());
            event2.cell.invalidate();
        }
    }
}

