/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.components.graphics;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.graphics.Graphic;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.utils.ColorCache;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class BackGroundGraphic
implements Graphic {
    protected Canvas drawCanvas;
    protected Image bufferBackground;
    private Color lightGrey;
    private Color lightGrey2;
    protected Color colorWhite;
    protected Color colorBlack;
    protected Color colorGrey;
    protected AEMonitor this_mon = new AEMonitor("BackGroundGraphic");
    private boolean isSIIECSensitive;

    protected void setSIIECSensitive(boolean b) {
        this.isSIIECSensitive = b;
    }

    @Override
    public void initialize(Canvas canvas) {
        this.drawCanvas = canvas;
        if (Utils.isDarkAppearanceNative()) {
            this.lightGrey = ColorCache.getColor((Device)canvas.getDisplay(), 5, 5, 5);
            this.lightGrey2 = ColorCache.getColor((Device)canvas.getDisplay(), 12, 12, 12);
            this.colorWhite = ColorCache.getColor((Device)canvas.getDisplay(), 110, 110, 110);
            this.colorBlack = ColorCache.getColor((Device)canvas.getDisplay(), 160, 160, 160);
            this.colorGrey = Colors.light_grey;
        } else {
            this.lightGrey = ColorCache.getColor((Device)canvas.getDisplay(), 250, 250, 250);
            this.lightGrey2 = ColorCache.getColor((Device)canvas.getDisplay(), 233, 233, 233);
            this.colorWhite = Colors.white;
            this.colorBlack = Colors.black;
            this.colorGrey = Colors.grey;
        }
        Menu menu = new Menu((Control)canvas);
        final MenuItem mi_binary = new MenuItem(menu, 32);
        mi_binary.setText(MessageText.getString("label.binary.scale.basis"));
        mi_binary.setSelection(COConfigurationManager.getBooleanParameter("ui.scaled.graphics.binary.based"));
        mi_binary.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                COConfigurationManager.setParameter("ui.scaled.graphics.binary.based", mi_binary.getSelection());
            }
        });
        if (this.isSIIECSensitive) {
            final MenuItem mi_iec = new MenuItem(menu, 32);
            mi_iec.setText(MessageText.getString("ConfigView.section.style.useSIUnits"));
            mi_iec.setSelection(COConfigurationManager.getBooleanParameter("config.style.useSIUnits"));
            mi_iec.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    COConfigurationManager.setParameter("config.style.useSIUnits", mi_iec.getSelection());
                }
            });
        }
        this.addMenuItems(menu);
        canvas.setMenu(menu);
    }

    protected void addMenuItems(Menu menu) {
    }

    @Override
    public void refresh(boolean force) {
    }

    protected void drawBackGround(boolean sizeChanged) {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed()) {
            return;
        }
        if (sizeChanged || this.bufferBackground == null) {
            Rectangle bounds = this.drawCanvas.getClientArea();
            if (bounds.height < 1 || bounds.width < 1) {
                return;
            }
            if (this.bufferBackground != null && !this.bufferBackground.isDisposed()) {
                this.bufferBackground.dispose();
            }
            if (bounds.width > 10000 || bounds.height > 10000) {
                return;
            }
            this.bufferBackground = new Image((Device)this.drawCanvas.getDisplay(), bounds);
            Color[] colors = new Color[]{this.colorWhite, this.lightGrey, this.lightGrey2, this.lightGrey};
            GC gcBuffer = new GC((Drawable)this.bufferBackground);
            int i = 0;
            while (i < bounds.height - 2) {
                gcBuffer.setForeground(colors[i % 4]);
                gcBuffer.drawLine(1, i + 1, bounds.width - 1, i + 1);
                ++i;
            }
            gcBuffer.setForeground(this.colorBlack);
            gcBuffer.drawLine(bounds.width - 70, 0, bounds.width - 70, bounds.height - 1);
            gcBuffer.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
            gcBuffer.dispose();
        }
    }

    public void dispose() {
        if (this.bufferBackground != null && !this.bufferBackground.isDisposed()) {
            this.bufferBackground.dispose();
        }
    }
}

