/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.components.graphics;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.graphics.Scale;
import com.biglybt.ui.swt.components.graphics.ScaledGraphic;
import com.biglybt.ui.swt.components.graphics.ValueFormater;
import com.biglybt.ui.swt.components.graphics.ValueSource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MultiPlotGraphic
extends ScaledGraphic
implements ParameterListener {
    private static final int DEFAULT_ENTRIES = 2000;
    private ValueSource[] value_sources;
    private int internalLoop;
    private int graphicsUpdate;
    private Point oldSize;
    private Image bufferImage;
    private int nbValues = 0;
    private int maxEntries = 2000;
    private int[][] all_values;
    private int currentPosition = 0;
    private boolean update_outstanding = false;
    private int update_period_millis;
    private TimerEventPeriodic update_event;
    private boolean maintain_history;
    private SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm", Locale.US);
    private long[] explicitTimes;

    public static MultiPlotGraphic getInstance(ValueSource[] sources, ValueFormater formatter) {
        return new MultiPlotGraphic(new Scale(), sources, formatter, 2000);
    }

    public static MultiPlotGraphic getInstance(int num_entries, ValueSource[] sources, ValueFormater formatter) {
        return new MultiPlotGraphic(new Scale(), sources, formatter, num_entries);
    }

    private MultiPlotGraphic(Scale scale, ValueSource[] sources, ValueFormater formater, int num_entries) {
        super(scale, formater);
        this.value_sources = sources;
        this.maxEntries = num_entries;
        this.init(null, null);
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Graphics Update", "Stats Graph Dividers"}, this);
    }

    private void init(int[][] history, long[] times) {
        this.nbValues = 0;
        this.all_values = new int[this.value_sources.length][this.maxEntries];
        this.currentPosition = 0;
        if (history != null) {
            if (history.length != this.value_sources.length) {
                Debug.out("Incompatible history records, ignored");
            } else {
                if (history.length > 0) {
                    int offset;
                    int history_entries = history[0].length;
                    int i = offset = Math.max(history_entries - this.maxEntries, 0);
                    while (i < history_entries) {
                        int j = 0;
                        while (j < history.length) {
                            this.all_values[j][this.nbValues] = history[j][i];
                            ++j;
                        }
                        ++this.nbValues;
                        ++i;
                    }
                }
                this.currentPosition = this.nbValues % this.maxEntries;
            }
        }
        this.explicitTimes = times;
        this.update_outstanding = true;
    }

    public int[][] getHistory() {
        int[][] result = new int[this.all_values.length][this.nbValues];
        int offset = this.nbValues == this.maxEntries ? this.currentPosition : 0;
        int i = 0;
        while (i < this.nbValues) {
            int j = 0;
            while (j < result.length) {
                result[j][i] = this.all_values[j][(i + offset) % this.maxEntries];
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public void initialize(Canvas canvas) {
        this.initialize(canvas, true);
    }

    public void initialize(Canvas canvas, boolean is_active) {
        super.initialize(canvas);
        this.drawCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (MultiPlotGraphic.this.bufferImage == null || MultiPlotGraphic.this.bufferImage.isDisposed()) {
                    MultiPlotGraphic.this.drawChart(true);
                }
                if (MultiPlotGraphic.this.bufferImage != null && !MultiPlotGraphic.this.bufferImage.isDisposed()) {
                    Rectangle bounds = MultiPlotGraphic.this.bufferImage.getBounds();
                    if (bounds.width >= e.width + e.x && bounds.height >= e.height + e.y) {
                        e.gc.drawImage(MultiPlotGraphic.this.bufferImage, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
                    }
                }
            }
        });
        this.drawCanvas.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                MultiPlotGraphic.this.drawChart(true);
            }
        });
        this.setActive(is_active);
    }

    @Override
    protected void addMenuItems(Menu menu) {
        new MenuItem(menu, 2);
        MenuItem mi_reset = new MenuItem(menu, 8);
        mi_reset.setText(MessageText.getString("label.clear.history"));
        mi_reset.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    MultiPlotGraphic.this.this_mon.enter();
                    MultiPlotGraphic.this.nbValues = 0;
                    MultiPlotGraphic.this.currentPosition = 0;
                    int i = 0;
                    while (i < MultiPlotGraphic.this.all_values.length) {
                        ((MultiPlotGraphic)MultiPlotGraphic.this).all_values[i] = new int[MultiPlotGraphic.this.all_values[i].length];
                        ++i;
                    }
                }
                finally {
                    MultiPlotGraphic.this.this_mon.exit();
                }
                MultiPlotGraphic.this.refresh(true);
            }
        });
    }

    public void setActive(boolean active) {
        this.setActive(active, 1000);
    }

    public void setActive(boolean active, int period_millis) {
        this.update_period_millis = period_millis;
        if (active) {
            if (this.update_event != null) {
                return;
            }
            this.update_event = SimpleTimer.addPeriodicEvent("MPG:updater", period_millis, new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent event2) {
                    if (!MultiPlotGraphic.this.maintain_history && MultiPlotGraphic.this.drawCanvas.isDisposed()) {
                        if (MultiPlotGraphic.this.update_event != null) {
                            MultiPlotGraphic.this.update_event.cancel();
                            MultiPlotGraphic.this.update_event = null;
                        }
                    } else {
                        int[] new_values = new int[MultiPlotGraphic.this.value_sources.length];
                        int i = 0;
                        while (i < new_values.length) {
                            new_values[i] = MultiPlotGraphic.this.value_sources[i].getValue();
                            ++i;
                        }
                        MultiPlotGraphic.this.addIntsValue(new_values);
                    }
                }
            });
        } else if (this.update_event != null) {
            this.update_event.cancel();
            this.update_event = null;
        }
    }

    public void reset(int[][] history) {
        this.reset(history, null);
    }

    public void reset(int[][] history, long[] times) {
        this.init(history, times);
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                MultiPlotGraphic.this.refresh(true);
            }
        });
    }

    public int[] getAverage(int num_entries) {
        try {
            int j;
            this.this_mon.enter();
            long[] averages = new long[this.all_values.length];
            if (this.nbValues < num_entries) {
                num_entries = this.nbValues;
            }
            if (num_entries > 0) {
                int start = this.currentPosition - num_entries;
                if (start < 0) {
                    start = this.nbValues < this.maxEntries ? 0 : (start += this.maxEntries);
                }
                int i = start;
                while (i < start + num_entries) {
                    int pos = i % this.maxEntries;
                    int j2 = 0;
                    while (j2 < averages.length) {
                        int n = j2;
                        averages[n] = averages[n] + (long)this.all_values[j2][pos];
                        ++j2;
                    }
                    ++i;
                }
                j = 0;
                while (j < averages.length) {
                    int n = j++;
                    averages[n] = averages[n] / (long)num_entries;
                }
            }
            int[] i_averages = new int[averages.length];
            j = 0;
            while (j < averages.length) {
                i_averages[j] = (int)averages[j];
                ++j;
            }
            int[] nArray = i_averages;
            return nArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void addIntsValue(int[] new_values) {
        try {
            this.this_mon.enter();
            if (this.all_values.length < new_values.length) {
                int[][] new_all_values = new int[new_values.length][];
                System.arraycopy(this.all_values, 0, new_all_values, 0, this.all_values.length);
                int i = this.all_values.length;
                while (i < new_all_values.length) {
                    new_all_values[i] = new int[this.maxEntries];
                    ++i;
                }
                this.all_values = new_all_values;
            }
            int i = 0;
            while (i < new_values.length) {
                this.all_values[i][this.currentPosition] = new_values[i];
                ++i;
            }
            ++this.currentPosition;
            if (this.nbValues < this.maxEntries) {
                ++this.nbValues;
            }
            this.currentPosition %= this.maxEntries;
        }
        finally {
            this.this_mon.exit();
        }
        if (this.update_outstanding) {
            this.update_outstanding = false;
            Utils.execSWTThread(new Runnable(){

                @Override
                public void run() {
                    MultiPlotGraphic.this.refresh(true);
                }
            });
        }
    }

    @Override
    public void refresh(boolean force) {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed()) {
            return;
        }
        Rectangle bounds = this.drawCanvas.getClientArea();
        if (bounds.height < 1 || bounds.width < 1 || bounds.width > 10000 || bounds.height > 10000) {
            return;
        }
        if (bounds.width > this.maxEntries) {
            try {
                this.this_mon.enter();
                boolean cycled = this.nbValues == this.maxEntries;
                while (this.maxEntries < bounds.width) {
                    this.maxEntries += 100;
                }
                int i = 0;
                while (i < this.all_values.length) {
                    int[] oldValues = this.all_values[i];
                    int[] newValues = new int[this.maxEntries];
                    if (cycled) {
                        int pos = this.currentPosition;
                        int j = 0;
                        while (j < this.nbValues) {
                            newValues[j] = oldValues[pos++];
                            if (pos == this.nbValues) {
                                pos = 0;
                            }
                            ++j;
                        }
                    } else {
                        System.arraycopy(oldValues, 0, newValues, 0, this.nbValues);
                    }
                    this.all_values[i] = newValues;
                    ++i;
                }
                this.currentPosition = this.nbValues;
            }
            finally {
                this.this_mon.exit();
            }
        }
        boolean sizeChanged = this.oldSize == null || this.oldSize.x != bounds.width || this.oldSize.y != bounds.height;
        this.oldSize = new Point(bounds.width, bounds.height);
        ++this.internalLoop;
        if (this.internalLoop > this.graphicsUpdate) {
            this.internalLoop = 0;
        }
        if (this.internalLoop == 0 || sizeChanged || force) {
            this.drawChart(sizeChanged);
            if (force) {
                this.drawChart(true);
            }
        }
        this.drawCanvas.redraw();
        this.drawCanvas.update();
    }

    public int getVisibleEntryCount() {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed()) {
            return 0;
        }
        return Math.max(0, this.drawCanvas.getClientArea().width - 71);
    }

    protected void drawChart(boolean sizeChanged) {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed() || !this.drawCanvas.isVisible()) {
            return;
        }
        GC gcImage = null;
        try {
            this.this_mon.enter();
            this.drawScale(sizeChanged);
            if (this.bufferScale == null || this.bufferScale.isDisposed()) {
                return;
            }
            Rectangle bounds = this.drawCanvas.getClientArea();
            if (bounds.isEmpty()) {
                return;
            }
            try {
                if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
                    this.bufferImage.dispose();
                }
                this.bufferImage = new Image((Device)this.drawCanvas.getDisplay(), bounds);
                gcImage = new GC((Drawable)this.bufferImage);
                gcImage.drawImage(this.bufferScale, 0, 0);
                gcImage.setAntialias(1);
                gcImage.setTextAntialias(1);
                HashSet<ValueSource> invisible_sources = new HashSet<ValueSource>();
                int i = 0;
                while (i < this.value_sources.length) {
                    ValueSource source = this.value_sources[i];
                    if ((source.getStyle() & 0x10) != 0) {
                        invisible_sources.add(source);
                    }
                    ++i;
                }
                int[] oldTargetValues = new int[this.all_values.length];
                int[] maxs = new int[this.all_values.length];
                long now = SystemTime.getCurrentTime();
                int next_secs = 60;
                int last_xpos = -1;
                int x = 0;
                while (x < bounds.width - 71) {
                    boolean has_value;
                    int position = this.currentPosition - x - 1;
                    if (position < 0 && (position += this.maxEntries) < 0) {
                        position = 0;
                    }
                    boolean bl = has_value = this.nbValues >= this.maxEntries || position < this.nbValues;
                    if (has_value) {
                        if (this.explicitTimes == null) {
                            int this_age = x * this.update_period_millis / 1000;
                            if (this_age >= next_secs) {
                                next_secs += 60;
                                long time = now - (long)(this_age * 1000);
                                String str = this.timeFormatter.format(new Date(time));
                                Point p = gcImage.stringExtent(str);
                                int xDraw = bounds.width - 71 - x;
                                int xPos = xDraw - p.x / 2;
                                if (xPos >= 0 && (last_xpos < 0 || xPos + p.x < last_xpos)) {
                                    gcImage.setForeground(this.colorGrey);
                                    gcImage.drawText(str, xPos, 0, true);
                                    last_xpos = xPos;
                                }
                            }
                        } else {
                            String str;
                            long time = this.explicitTimes[x];
                            if (time > 0L && (str = this.formater.formatTime(time)) != null && !str.isEmpty()) {
                                Point p = gcImage.stringExtent(str);
                                int xDraw = bounds.width - 71 - x;
                                int xPos = xDraw - p.x / 2;
                                if (xPos >= 0) {
                                    gcImage.setForeground(this.colorGrey);
                                    gcImage.drawText(str, xPos, 0, true);
                                }
                            }
                        }
                    }
                    int chartIdx = 0;
                    while (chartIdx < this.all_values.length) {
                        int value;
                        ValueSource source = this.value_sources[chartIdx];
                        if (!invisible_sources.contains(source) && (value = this.all_values[chartIdx][position]) > maxs[chartIdx]) {
                            maxs[chartIdx] = value;
                        }
                        ++chartIdx;
                    }
                    ++x;
                }
                HashSet<ValueSource> bold_sources = new HashSet<ValueSource>();
                HashSet<ValueSource> dotted_sources = new HashSet<ValueSource>();
                int max = 0;
                int i2 = 0;
                while (i2 < maxs.length) {
                    ValueSource source = this.value_sources[i2];
                    if (!invisible_sources.contains(source)) {
                        if ((source.getStyle() & 8) != 0) {
                            bold_sources.add(source);
                        }
                        if ((source.getStyle() & 0x20) != 0) {
                            dotted_sources.add(source);
                        }
                        if (!source.isTrimmable()) {
                            max = Math.max(max, maxs[i2]);
                        }
                    }
                    ++i2;
                }
                int max_primary = max;
                int i3 = 0;
                while (i3 < maxs.length) {
                    int m;
                    ValueSource source = this.value_sources[i3];
                    if (!invisible_sources.contains(source) && source.isTrimmable() && max < (m = maxs[i3])) {
                        if (m <= 2 * max_primary) {
                            max = m;
                        } else {
                            max = 2 * max_primary;
                            break;
                        }
                    }
                    ++i3;
                }
                int kInB = DisplayFormatters.getKinB();
                if (max > 5 * kInB) {
                    max = (max + kInB - 1) / kInB * kInB;
                }
                this.scale.setMax(max);
                int[] prev_x = new int[this.value_sources.length];
                int[] prev_y = new int[this.value_sources.length];
                int bounds_width_adj = bounds.width - 71;
                int cycles = bold_sources.size() == 0 ? 2 : 3;
                int x2 = 0;
                while (x2 < bounds_width_adj) {
                    int position = this.currentPosition - x2 - 1;
                    if (position < 0 && (position += this.maxEntries) < 0) {
                        position = 0;
                    }
                    int xDraw = bounds_width_adj - x2;
                    int order = 0;
                    while (order < cycles) {
                        int chartIdx = 0;
                        while (chartIdx < this.all_values.length) {
                            boolean is_bold;
                            ValueSource source = this.value_sources[chartIdx];
                            if (!(invisible_sources.contains(source) || (is_bold = bold_sources.contains(source)) && order != 2)) {
                                boolean is_dotted = dotted_sources.contains(source);
                                if (source.isTrimmable() == (order == 0) && order < 2 || is_bold && order == 2) {
                                    Color line_color = source.getLineColor();
                                    int targetValue = this.all_values[chartIdx][position];
                                    int oldTargetValue = oldTargetValues[chartIdx];
                                    if (x2 > 0) {
                                        int trimmed;
                                        if (is_dotted) {
                                            trimmed = 2;
                                        } else {
                                            trimmed = 0;
                                            if (targetValue > max) {
                                                targetValue = max;
                                                ++trimmed;
                                            }
                                            if (oldTargetValue > max) {
                                                oldTargetValue = max;
                                                ++trimmed;
                                            }
                                        }
                                        boolean force_draw = trimmed == 2 && position % 4 == 0 || xDraw == 1;
                                        int h1 = bounds.height - this.scale.getScaledValue(targetValue) - 2;
                                        if (x2 == 1) {
                                            int h2 = bounds.height - this.scale.getScaledValue(oldTargetValue) - 2;
                                            prev_x[chartIdx] = xDraw + 1;
                                            prev_y[chartIdx] = h2;
                                        }
                                        if (trimmed < 2 || force_draw) {
                                            if (h1 != prev_y[chartIdx] || force_draw) {
                                                gcImage.setAlpha(source.getAlpha());
                                                gcImage.setLineWidth(trimmed == 2 ? 3 : (is_bold ? 4 : 2));
                                                gcImage.setForeground(line_color);
                                                gcImage.drawLine(xDraw + 1, prev_y[chartIdx], prev_x[chartIdx], prev_y[chartIdx]);
                                                gcImage.drawLine(xDraw, h1, xDraw + 1, prev_y[chartIdx]);
                                                prev_x[chartIdx] = xDraw;
                                                prev_y[chartIdx] = h1;
                                            }
                                        } else {
                                            prev_x[chartIdx] = xDraw;
                                            prev_y[chartIdx] = h1;
                                        }
                                    }
                                    oldTargetValues[chartIdx] = this.all_values[chartIdx][position];
                                }
                            }
                            ++chartIdx;
                        }
                        ++order;
                    }
                    ++x2;
                }
                if (this.nbValues > 0) {
                    int order = 0;
                    while (order < cycles) {
                        int chartIdx = 0;
                        while (chartIdx < this.all_values.length) {
                            boolean is_bold;
                            ValueSource source = this.value_sources[chartIdx];
                            if (!invisible_sources.contains(source) && (!(is_bold = bold_sources.contains(source)) || order == 2) && (source.isTrimmable() == (order == 0) && order < 2 || is_bold && order == 2)) {
                                boolean show_label;
                                int style = source.getStyle();
                                boolean bl = show_label = (style & 0x40) == 0;
                                if (!bold_sources.isEmpty()) {
                                    show_label = is_bold;
                                }
                                if (show_label) {
                                    int y;
                                    int x3;
                                    int average_val = this.computeAverage(chartIdx, this.currentPosition - 6);
                                    int average_mod = average_val;
                                    if (average_mod > max) {
                                        average_mod = max;
                                    }
                                    int height = bounds.height - this.scale.getScaledValue(average_mod) - 2;
                                    gcImage.setAlpha(255);
                                    gcImage.setForeground(source.getLineColor());
                                    gcImage.drawText(this.formater.format(average_val), bounds.width - 65, height - 12, 1);
                                    Color bg = gcImage.getBackground();
                                    if ((style & 2) != 0) {
                                        x3 = bounds.width - 72;
                                        y = height - 12;
                                        gcImage.setBackground(source.getLineColor());
                                        gcImage.fillPolygon(new int[]{x3, y, x3 + 7, y, x3 + 3, y + 7});
                                        gcImage.setBackground(bg);
                                    } else if ((style & 1) != 0) {
                                        x3 = bounds.width - 72;
                                        y = height - 12;
                                        gcImage.setBackground(source.getLineColor());
                                        gcImage.fillPolygon(new int[]{x3, y + 7, x3 + 7, y + 7, x3 + 3, y});
                                        gcImage.setBackground(bg);
                                    } else if ((style & 0x80) != 0) {
                                        x3 = bounds.width - 72;
                                        y = height - 12;
                                        gcImage.setBackground(source.getLineColor());
                                        gcImage.fillOval(x3, y, 5, 5);
                                        gcImage.setBackground(bg);
                                    }
                                }
                            }
                            ++chartIdx;
                        }
                        ++order;
                    }
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        finally {
            if (gcImage != null) {
                gcImage.dispose();
            }
            this.this_mon.exit();
        }
    }

    private int computeAverage(int line_index, int position) {
        long sum = 0L;
        int i = -5;
        while (i < 6) {
            int pos = position + i;
            if ((pos %= this.maxEntries) < 0) {
                pos += this.maxEntries;
            }
            sum += (long)this.all_values[line_index][pos];
            ++i;
        }
        return (int)(sum / 11L);
    }

    @Override
    public void parameterChanged(String parameter) {
        this.graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
        boolean update_dividers = COConfigurationManager.getBooleanParameter("Stats Graph Dividers");
        int update_divider_width = update_dividers ? 60 : 0;
        this.setUpdateDividerWidth(update_divider_width);
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean _maintain_history) {
        this.maintain_history = _maintain_history;
        super.dispose();
        if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
            this.bufferImage.dispose();
        }
        if (this.update_event != null && !this.maintain_history) {
            this.update_event.cancel();
            this.update_event = null;
        }
        COConfigurationManager.removeParameterListener("Graphics Update", this);
        COConfigurationManager.removeParameterListener("Stats Graph Dividers", this);
    }
}

