/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.impl.ConfigurationDefaults;
import com.biglybt.core.internat.MessageText;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.config.SwtConfigParameterValueProcessor;
import com.biglybt.ui.swt.config.SwtParameterValueProcessor;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.utils.FontUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BaseSwtStringParameter<PARAMTYPE extends BaseSwtStringParameter<PARAMTYPE>>
extends BaseSwtParameter<PARAMTYPE, String> {
    protected final Text inputField;
    private Composite ourParent;
    private Label lblSuffix;
    private char[] validChars;
    private boolean validCharsCaseSensitive;
    private Listener verifyListener;

    public BaseSwtStringParameter(Composite composite, String paramID, String labelKey, String suffixKey, SwtParameterValueProcessor<PARAMTYPE, String> valueProcessor) {
        super(paramID);
        Composite parent;
        this.createStandardLabel(composite, labelKey);
        if (suffixKey == null) {
            parent = composite;
        } else {
            this.ourParent = parent = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            parent.setLayout((Layout)gridLayout);
            if (this.doGridData(composite)) {
                parent.setLayoutData((Object)new GridData(768));
            }
        }
        this.inputField = new Textbox(parent);
        this.setMainControl((Control)this.inputField);
        if (this.doGridData(composite)) {
            GridData gridData = new GridData(768);
            this.inputField.setLayoutData((Object)gridData);
        }
        if (suffixKey != null) {
            this.lblSuffix = new Label(parent, 64);
            Messages.setLanguageText((Widget)this.lblSuffix, suffixKey);
            this.lblSuffix.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 768));
            ClipboardCopy.addCopyToClipMenu((Control)this.lblSuffix);
        }
        if (valueProcessor != null) {
            this.setValueProcessor(valueProcessor);
        } else if (paramID != null) {
            this.setConfigValueProcessor(String.class);
        } else {
            this.refreshControl();
        }
        this.rebuildVerifyListener();
        this.inputField.addListener(24, event2 -> this.validate(this.inputField.getText()));
        this.inputField.addListener(16, e -> this.setValue(this.inputField.getText()));
    }

    private void rebuildVerifyListener() {
        boolean addVerifyListener;
        boolean bl = addVerifyListener = this.validChars != null;
        if (!addVerifyListener && this.valueProcessor instanceof SwtConfigParameterValueProcessor) {
            List verifiers = ConfigurationDefaults.getInstance().getVerifiers(this.paramID);
            boolean bl2 = addVerifyListener = verifiers != null && verifiers.size() > 0;
        }
        if (addVerifyListener) {
            if (this.verifyListener == null) {
                this.verifyListener = e -> {
                    if (this.valueProcessor instanceof SwtConfigParameterValueProcessor) {
                        e.doit = COConfigurationManager.verifyParameter(this.paramID, e.text);
                        if (!e.doit) {
                            return;
                        }
                    }
                    if (this.validChars == null || e.text == null) {
                        return;
                    }
                    int len = e.text.length();
                    int i = 0;
                    while (i < len) {
                        char c = e.text.charAt(i);
                        if (Arrays.binarySearch(this.validChars, c) < 0 || !this.validCharsCaseSensitive && Arrays.binarySearch(this.validChars, Character.toLowerCase(c)) < 0) {
                            e.doit = false;
                            break;
                        }
                        ++i;
                    }
                };
            }
            this.inputField.addListener(25, this.verifyListener);
        } else if (this.verifyListener != null) {
            this.inputField.removeListener(25, this.verifyListener);
            this.verifyListener = null;
        }
    }

    public void setValidChars(String validChars, boolean caseSensitive) {
        this.validCharsCaseSensitive = caseSensitive;
        if (validChars == null) {
            this.validChars = null;
            this.rebuildVerifyListener();
            return;
        }
        if (caseSensitive) {
            validChars = validChars.toLowerCase();
        }
        this.validChars = new char[validChars.length()];
        validChars.getChars(0, validChars.length(), this.validChars, 0);
        Arrays.sort(this.validChars);
        this.rebuildVerifyListener();
    }

    @Override
    public void refreshControl() {
        super.refreshControl();
        Utils.execSWTThread(() -> {
            this.refreshSuffixControl((Control)this.lblSuffix);
            String value = (String)this.getValue();
            if (value == null) {
                return;
            }
            if (!this.inputField.isDisposed() && !this.inputField.getText().equals(value)) {
                this.inputField.setText(value);
            }
        });
    }

    @Override
    public Control[] getControls() {
        if (this.lblSuffix == null) {
            return super.getControls();
        }
        ArrayList<Control> list = new ArrayList<Control>(Arrays.asList(super.getControls()));
        list.add((Control)this.lblSuffix);
        if (this.ourParent != null) {
            list.add((Control)this.ourParent);
        }
        return list.toArray(new Control[0]);
    }

    public void setWidthInCharacters(int i) {
        Object data = this.inputField.getLayoutData();
        if (data instanceof GridData) {
            ((GridData)data).widthHint = (int)Math.ceil((double)i * FontUtils.getCharacterWidth(this.inputField.getFont()));
            ((GridData)data).horizontalAlignment = 1;
            ((GridData)data).grabExcessHorizontalSpace = false;
            this.inputField.setLayoutData(data);
        }
    }

    public void setTextLimit(int textLimit) {
        Utils.execSWTThread(() -> {
            if (this.inputField.isDisposed()) {
                return;
            }
            this.inputField.setTextLimit(textLimit);
        });
    }

    public void setHintKey(String hintKey) {
        Utils.execSWTThread(() -> {
            if (this.inputField.isDisposed()) {
                return;
            }
            this.inputField.setMessage(hintKey == null ? "" : MessageText.getString(hintKey));
        });
    }

    private static class Textbox
    extends Text {
        public Textbox(Composite parent) {
            super(parent, 2048);
        }

        public void checkSubclass() {
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            Object ld;
            if (hHint == 0 && !this.isVisible()) {
                return new Point(0, 0);
            }
            Point pt = super.computeSize(wHint, hHint, changed);
            if (wHint == -1 && (ld = this.getLayoutData()) instanceof GridData && ((GridData)ld).grabExcessHorizontalSpace) {
                pt.x = 10;
            }
            return pt;
        }
    }
}

