/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.config.SwtParameterValueProcessor;
import com.biglybt.ui.swt.config.actionperformer.IAdditionalActionPerformer;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class BooleanSwtParameter
extends BaseSwtParameter<BooleanSwtParameter, Boolean> {
    private final Label lblSuffix;
    private Label cbText;
    private BaseSwtParameter.IndentPaintListener indentPaintListener;
    final Button checkBox;
    final List<IAdditionalActionPerformer<Object>> performers = new ArrayList<IAdditionalActionPerformer<Object>>();
    boolean performingActionsPerformers = false;

    public BooleanSwtParameter(Composite parent, BooleanParameterImpl paramInfo) {
        this(parent, paramInfo.getConfigKeyName(), paramInfo.getLabelKey(), paramInfo.getSuffixLabelKey(), null);
        this.setPluginParameter(paramInfo);
    }

    public BooleanSwtParameter(Composite parent, String paramID, String labelKey, String suffixLabelKey, SwtParameterValueProcessor<BooleanSwtParameter, Boolean> valueProcessor) {
        super(paramID);
        GridData gridData;
        Composite ourParent;
        boolean parentIsGridLayout = parent.getLayout() instanceof GridLayout;
        int parentColumns = parentIsGridLayout ? ((GridLayout)parent.getLayout()).numColumns : 1;
        boolean toolong = false;
        String text = null;
        if (labelKey != null) {
            text = MessageText.getString(labelKey);
            boolean bl = toolong = text.indexOf(10) > 0 || text.indexOf(9) > 0 || text.length() > 100;
        }
        if (suffixLabelKey == null && !toolong) {
            ourParent = parent;
        } else {
            ourParent = new Composite(parent, 0);
            GridLayout ourParentGridLayout = new GridLayout();
            ourParentGridLayout.verticalSpacing = 0;
            ourParentGridLayout.horizontalSpacing = 0;
            ourParentGridLayout.marginWidth = 0;
            ourParentGridLayout.marginHeight = 0;
            ourParentGridLayout.numColumns = 2;
            ourParent.setLayout((Layout)ourParentGridLayout);
            if (parentIsGridLayout) {
                gridData = new GridData(768);
                gridData.horizontalSpan = parentColumns > 1 ? 2 : 1;
                ourParent.setLayoutData((Object)gridData);
            }
        }
        if (text != null) {
            int numExtraIndent = 0;
            while (text.startsWith("\t")) {
                text = text.substring(1);
                ++numExtraIndent;
            }
            if (toolong) {
                GridData gridData2;
                this.checkBox = new Button(ourParent, 32);
                if (this.doGridData(ourParent)) {
                    gridData2 = new GridData();
                    if (Constants.isUnix) {
                        gridData2.horizontalIndent = 4;
                    }
                    this.checkBox.setLayoutData((Object)gridData2);
                } else {
                    this.checkBox.setLayoutData((Object)new RowData());
                }
                this.cbText = new Label(ourParent, 64);
                Messages.setLanguageText((Widget)this.cbText, labelKey);
                if (this.doGridData(ourParent)) {
                    gridData2 = Utils.getWrappableLabelGridData(1, 768);
                    gridData2.horizontalIndent = Constants.isOSX ? -4 : 3;
                    this.cbText.setLayoutData((Object)gridData2);
                }
                this.cbText.addListener(3, event2 -> {
                    if (event2.button == 1) {
                        this.checkBox.forceFocus();
                    }
                });
                this.cbText.addListener(4, event2 -> {
                    if (event2.button == 1) {
                        this.setValue((Boolean)this.getValue() == false);
                    }
                });
                ourParent.addListener(9, event2 -> {
                    if (this.checkBox.isDisposed() || event2.gc == null) {
                        return;
                    }
                    if (this.checkBox.isFocusControl()) {
                        event2.gc.setLineStyle(3);
                        event2.gc.setLineDash(new int[]{1, 1});
                        event2.gc.setForeground(this.cbText.getForeground());
                        Point size = this.cbText.getSize();
                        Point location = this.cbText.getLocation();
                        event2.gc.drawRectangle(location.x - 1, 0, size.x + 1, size.y + 1);
                    }
                });
                this.setRelatedControl((Control)this.cbText);
                this.checkBox.addListener(15, event2 -> ourParent.redraw());
                this.checkBox.addListener(16, event2 -> ourParent.redraw());
            } else {
                this.checkBox = new Button(ourParent, 32);
                this.setRelatedControl((Control)this.checkBox);
                if (numExtraIndent > 0) {
                    this.checkBox.setText(text);
                } else {
                    Messages.setLanguageText((Widget)this.checkBox, labelKey);
                }
                if (this.doGridData(ourParent)) {
                    GridData gridData3 = new GridData();
                    gridData3.horizontalSpan = 2;
                    this.checkBox.setLayoutData((Object)gridData3);
                } else {
                    this.checkBox.setLayoutData((Object)new RowData());
                }
            }
            if (numExtraIndent > 0) {
                this.setIndent(this.getIndent() + numExtraIndent, this.isIndentFancy());
            }
        } else {
            this.checkBox = new Button(ourParent, 32);
            this.setRelatedControl((Control)this.checkBox);
            if (this.doGridData(ourParent)) {
                gridData = new GridData();
                gridData.horizontalSpan = 2;
                this.checkBox.setLayoutData((Object)gridData);
            } else {
                this.checkBox.setLayoutData((Object)new RowData());
            }
        }
        this.setMainControl((Control)this.checkBox);
        if (suffixLabelKey != null) {
            this.lblSuffix = new Label(ourParent, 64);
            Messages.setLanguageText((Widget)this.lblSuffix, suffixLabelKey);
            GridData gridData4 = Utils.getWrappableLabelGridData(2, 768);
            gridData4.horizontalIndent = Constants.isOSX ? 45 : 40;
            this.lblSuffix.setLayoutData((Object)gridData4);
            ClipboardCopy.addCopyToClipMenu((Control)this.lblSuffix);
            this.indentPaintListener = new BaseSwtParameter.IndentPaintListener((Control)this.lblSuffix, 40);
        } else {
            this.lblSuffix = null;
        }
        if (valueProcessor != null) {
            this.setValueProcessor(valueProcessor);
        } else if (paramID != null) {
            this.setConfigValueProcessor(Boolean.class);
        }
        this.checkBox.addListener(13, event2 -> this.setValue(this.checkBox.getSelection()));
    }

    @Override
    public void setLayoutData(Object layoutData) {
        if (this.cbText == null) {
            super.setLayoutData(layoutData);
        } else {
            this.cbText.getParent().setLayoutData(layoutData);
        }
    }

    @Override
    public void setValueProcessor(SwtParameterValueProcessor<BooleanSwtParameter, Boolean> valueProcessor) {
        super.setValueProcessor(valueProcessor);
        this.triggerActionPerformers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerActionPerformers() {
        if (this.performers.size() == 0) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Boolean selected = (Boolean)this.getValue();
        if (selected == null) {
            return;
        }
        List<IAdditionalActionPerformer<Object>> list = this.performers;
        synchronized (list) {
            if (this.performingActionsPerformers) {
                this.debug("Prevent cyclical performAction");
                return;
            }
            try {
                this.performingActionsPerformers = true;
                for (IAdditionalActionPerformer<Object> performer : this.performers) {
                    try {
                        performer.valueChanged(selected);
                        performer.performAction();
                    }
                    catch (Throwable t) {
                        Debug.out(t);
                    }
                }
            }
            finally {
                this.performingActionsPerformers = false;
            }
        }
    }

    public void setAdditionalActionPerformer(IAdditionalActionPerformer actionPerformer) {
        this.performers.add(actionPerformer);
        Boolean selected = (Boolean)this.getValue();
        if (selected != null) {
            actionPerformer.valueChanged(selected);
        }
        if (this.isEnabled()) {
            actionPerformer.performAction();
        }
    }

    public List<IAdditionalActionPerformer<Object>> getAdditionalActionPerformers() {
        return this.performers;
    }

    @Override
    public Control[] getControls() {
        ArrayList<Control> list = new ArrayList<Control>(Arrays.asList(super.getControls()));
        if (this.cbText != null) {
            list.add((Control)this.cbText);
        }
        if (this.lblSuffix != null) {
            list.add((Control)this.lblSuffix);
            list.add(0, (Control)this.lblSuffix.getParent());
        }
        return list.toArray(new Control[0]);
    }

    public boolean isSelected() {
        Boolean value = (Boolean)this.getValue();
        return value == null ? false : value;
    }

    public void setSelected(boolean _selected) {
        this.setValue(_selected);
    }

    @Override
    protected void triggerSubClassChangeListeners() {
        this.triggerActionPerformers();
    }

    @Override
    public void refreshControl() {
        super.refreshControl();
        Utils.execSWTThread(() -> {
            if (this.checkBox.isDisposed()) {
                return;
            }
            this.refreshSuffixControl((Control)this.lblSuffix);
            Boolean selected = (Boolean)this.getValue();
            if (selected == null) {
                this.checkBox.setGrayed(true);
                this.checkBox.setSelection(true);
            } else {
                this.checkBox.setGrayed(false);
                if (this.checkBox.getSelection() != selected.booleanValue()) {
                    this.checkBox.setSelection(selected.booleanValue());
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.performers.clear();
        if (this.indentPaintListener != null) {
            this.indentPaintListener.dispose();
            this.indentPaintListener = null;
        }
        super.dispose();
    }

    public static interface ValueProcessor
    extends SwtParameterValueProcessor<BooleanSwtParameter, Boolean> {
    }
}

