/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.core.internat.MessageText;
import com.biglybt.pifimpl.local.ui.config.DirectoryParameterImpl;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtStringParameter;
import com.biglybt.ui.swt.config.SwtParameterValueProcessor;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DirectorySwtParameter
extends BaseSwtStringParameter<DirectorySwtParameter> {
    private final Button browse;
    private final Composite area = this.getMainControl().getParent();
    protected String keyDialogTitle = null;
    protected String keyDialogMessage = null;

    public DirectorySwtParameter(Composite composite, DirectoryParameterImpl param) {
        this(composite, param.getConfigKeyName(), param.getLabelKey(), null);
        this.keyDialogTitle = param.getKeyDialogTitle();
        this.keyDialogMessage = param.getKeyDialogMessage();
    }

    public DirectorySwtParameter(Composite composite, String paramID, String labelKey, SwtParameterValueProcessor<DirectorySwtParameter, String> valueProcessor) {
        super(new Composite(composite, 0), paramID, labelKey, null, valueProcessor);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.area.setLayout((Layout)layout);
        if (this.doGridData(composite)) {
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.area.setLayoutData((Object)gridData);
            gridData = new GridData(768);
            gridData.widthHint = 150;
            this.inputField.setLayoutData((Object)gridData);
        }
        this.browse = new Button(this.area, 8);
        ImageLoader.getInstance().setButtonImage(this.browse, "openFolderButton");
        Utils.setTT((Control)this.browse, MessageText.getString("Button.browse"));
        this.browse.addListener(13, event2 -> {
            String path = this.openDialog(composite.getShell(), (String)this.getValue());
            if (path != null) {
                this.setValue(path);
            }
        });
    }

    @Override
    public void setLayoutData(Object layoutData) {
    }

    @Override
    public Control[] getControls() {
        ArrayList<Control> list = new ArrayList<Control>(Arrays.asList(super.getControls()));
        list.add((Control)this.browse);
        list.add((Control)this.area);
        return list.toArray(new Control[0]);
    }

    @Override
    protected void addLabelContextMenus(Control curControl, Menu menu) {
        super.addLabelContextMenus(curControl, menu);
        String value = (String)this.getValue();
        if (value == null || value.isEmpty()) {
            return;
        }
        File file = new File(value);
        if (file.exists() || file.getParentFile() != null && file.getParentFile().exists()) {
            MenuItem itemShowInExplorer = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemShowInExplorer, "MyTorrentsView.menu.explore");
            itemShowInExplorer.addListener(13, event2 -> {
                String curVal = (String)this.getValue();
                if (curVal != null && !curVal.isEmpty()) {
                    ManagerUtils.open(new File(curVal));
                }
            });
        }
    }

    private String openDialog(Shell shell, String old_value) {
        DirectoryDialog dialog = new DirectoryDialog(shell, 65536);
        if (this.keyDialogMessage != null) {
            dialog.setMessage(MessageText.getString(this.keyDialogMessage));
        }
        if (this.keyDialogTitle != null) {
            dialog.setText(MessageText.getString(this.keyDialogTitle));
        }
        dialog.setFilterPath(old_value);
        return dialog.open();
    }

    public void setKeyDialogTitle(String keyDialogTitle) {
        this.keyDialogTitle = keyDialogTitle;
    }

    public void setKeyDialogMessage(String keyDialogMessage) {
        this.keyDialogMessage = keyDialogMessage;
    }
}

