/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.config.SwtParameterValueProcessor;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.utils.FontUtils;
import java.io.File;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class IconSwtParameter
extends BaseSwtParameter<IconSwtParameter, String> {
    private final Button iconChooser;
    private Image img;
    private String imgResource;

    public IconSwtParameter(Composite composite, String configID, String labelKey, SwtParameterValueProcessor<IconSwtParameter, String> valueProcessor) {
        super(configID);
        this.createStandardLabel(composite, labelKey);
        this.iconChooser = new Button(composite, 8);
        this.setMainControl((Control)this.iconChooser);
        if (this.doGridData(composite)) {
            GridData gridData = new GridData();
            gridData.horizontalSpan = labelKey == null ? 2 : 1;
            this.iconChooser.setLayoutData((Object)gridData);
        }
        if (valueProcessor != null) {
            this.setValueProcessor(valueProcessor);
        } else if (this.paramID != null) {
            this.setConfigValueProcessor(String.class);
        }
        this.iconChooser.addListener(12, e -> this.releaseImage());
        this.iconChooser.addListener(13, e -> {
            String newFile;
            File f;
            FileDialog dialog = new FileDialog(this.iconChooser.getShell(), 65536);
            dialog.setFilterExtensions(new String[]{"*.jpg;*.jpeg;*.png;*.gif;*.tiff;*.ico;*.bmp", "*.*"});
            dialog.setFilterNames(new String[]{"Images (gif, jpg, png, tiff, ico, bmp", "All"});
            String file = (String)this.getValue();
            if (file != null && (f = new File(file)).exists()) {
                dialog.setFilterPath(f.getParent());
                dialog.setFileName(f.getName());
            }
            if ((newFile = dialog.open()) == null) {
                return;
            }
            this.setValue(newFile);
        });
        Menu menu = new Menu((Control)this.iconChooser);
        this.iconChooser.setMenu(menu);
        final MenuItem mi = new MenuItem(menu, 8);
        mi.setText(MessageText.getString("menu.reset.icon"));
        mi.addListener(13, e -> this.resetToDefault());
        try {
            menu.addMenuListener(MenuListener.menuShownAdapter(e -> mi.setEnabled(!this.isDefaultValue())));
        }
        catch (Throwable e2) {
            menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    mi.setEnabled(!IconSwtParameter.this.isDefaultValue());
                }
            });
        }
    }

    private void releaseImage() {
        if (this.imgResource != null) {
            ImageLoader.getInstance().releaseImage(this.imgResource);
            this.imgResource = null;
        }
        if (this.img != null && !this.img.isDisposed()) {
            if (!this.iconChooser.isDisposed()) {
                this.iconChooser.setImage(null);
                Utils.setTT((Control)this.iconChooser, "");
            }
            this.img.dispose();
            this.img = null;
        }
    }

    private void updateButtonIcon(String file) {
        this.releaseImage();
        int h = FontUtils.getFontHeightInPX(this.iconChooser.getFont());
        int w = (int)((double)h * 1.5);
        if (file == null) {
            this.img = new Image((Device)this.iconChooser.getDisplay(), w, h);
            GC gc = new GC((Drawable)this.img);
            Color color = this.iconChooser.getBackground();
            gc.setBackground(color);
            gc.fillRectangle(0, 0, w, h);
            new GCStringPrinter(gc, "-", new Rectangle(0, 0, w, h), 0, 0x1000000).printString();
            gc.dispose();
            this.iconChooser.setImage(this.img);
            Utils.setTT((Control)this.iconChooser, "");
        } else {
            try {
                File f = new File(file);
                ImageLoader.getInstance().getFileImage(f, new Point(w, h), (image, key, returnedImmediately) -> {
                    this.iconChooser.setImage(image);
                    if (image != null) {
                        this.imgResource = key;
                        Utils.setTT((Control)this.iconChooser, f.getAbsolutePath());
                    } else {
                        Utils.setTT((Control)this.iconChooser, "");
                    }
                    if (!returnedImmediately) {
                        Utils.relayout((Control)this.iconChooser);
                    }
                });
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        Utils.relayout((Control)this.iconChooser);
    }

    @Override
    public void refreshControl() {
        super.refreshControl();
        Utils.execSWTThread(() -> this.updateButtonIcon((String)this.getValue()));
    }
}

