/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.config.ActionParameter;
import com.biglybt.pif.ui.config.HyperlinkParameter;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.HyperlinkParameterImpl;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class LinkSwtParameter
extends BaseSwtParameter<LinkSwtParameter, Object> {
    Label link_label;
    private String url;

    public LinkSwtParameter(Composite parent, HyperlinkParameterImpl pluginParam) {
        this(parent, pluginParam.getLinkTextKey(), pluginParam.getLabelKey(), pluginParam.getHyperlink());
        this.setPluginParameter(pluginParam);
    }

    public LinkSwtParameter(Composite parent, ActionParameterImpl pluginParam) {
        this(parent, pluginParam.getActionResource(), pluginParam.getLabelKey(), null);
        this.setPluginParameter(pluginParam);
        this.addChangeListener(p -> {
            try {
                ((ActionParameterImpl)this.pluginParam).parameterChanged("");
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        });
    }

    public LinkSwtParameter(Composite composite, String name_resource, String labelKey, String url) {
        super(name_resource);
        if (labelKey != null) {
            Label label = new Label(composite, 0);
            Messages.setLanguageText((Widget)label, labelKey);
            this.setRelatedControl((Control)label);
        }
        this.link_label = new Label(composite, 64);
        this.setMainControl((Control)this.link_label);
        this.url = url;
        Messages.setLanguageText((Widget)this.link_label, name_resource);
        Display display = this.link_label.getDisplay();
        this.link_label.setCursor(display.getSystemCursor(21));
        Utils.setLinkForeground((Control)this.link_label);
        this.link_label.addListener(4, e -> {
            if (e.button == 1) {
                this.triggerChangeListeners(false);
            } else {
                e.doit = true;
            }
        });
        this.link_label.addListener(8, e -> this.triggerChangeListeners(false));
        this.link_label.setData((Object)url);
        ClipboardCopy.addCopyToClipMenu((Control)this.link_label);
        if (this.doGridData(composite) && labelKey == null) {
            GridLayout parentLayout = (GridLayout)composite.getLayout();
            if (parentLayout.numColumns >= 2) {
                GridData gridData = Utils.getWrappableLabelGridData(2, 768);
                this.link_label.setLayoutData((Object)gridData);
            } else {
                this.link_label.setLayoutData((Object)new GridData());
            }
        }
        if (url != null) {
            Utils.setTT((Control)this.link_label, url);
        }
    }

    @Override
    protected void triggerSubClassChangeListeners() {
        if (this.url != null) {
            Utils.launch(this.url);
        }
    }

    @Override
    public void refreshControl() {
        super.refreshControl();
        if (this.pluginParam == null) {
            return;
        }
        Utils.execSWTThread(() -> {
            if (this.link_label.isDisposed()) {
                return;
            }
            if (this.pluginParam instanceof HyperlinkParameterImpl) {
                this.url = ((HyperlinkParameter)this.pluginParam).getHyperlink();
                Utils.setTT((Control)this.link_label, this.url);
                Messages.setLanguageText((Widget)this.link_label, ((HyperlinkParameterImpl)this.pluginParam).getLinkTextKey());
            } else if (this.pluginParam instanceof ActionParameter) {
                Messages.setLanguageText((Widget)this.link_label, ((ActionParameter)this.pluginParam).getActionResource());
            }
        });
    }
}

