/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.impl.ConfigurationDefaults;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.config.SwtConfigParameterValueProcessor;
import com.biglybt.ui.swt.config.SwtParameterValueProcessor;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class StringAreaSwtParameter
extends BaseSwtParameter<StringAreaSwtParameter, String> {
    private final Text inputField;
    private Label lblSuffix;
    private Label lblSuffixGap;

    public StringAreaSwtParameter(Composite curComposite, StringParameterImpl pluginParam) {
        this(curComposite, pluginParam.getConfigKeyName(), pluginParam.getLabelKey(), pluginParam.getSuffixLabelKey(), pluginParam.getMultiLine(), null);
        this.setPluginParameter(pluginParam);
    }

    public StringAreaSwtParameter(Composite composite, String configID, String labelKey, String suffixKey, int numLinesToShow, SwtParameterValueProcessor<StringAreaSwtParameter, String> valueProcessor) {
        super(configID);
        List verifiers;
        this.createStandardLabel(composite, labelKey);
        this.inputField = new Text(composite, 2626){

            public void checkSubclass() {
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Object ld;
                if (hHint == 0 && !this.isVisible()) {
                    return new Point(0, 0);
                }
                Point pt = super.computeSize(wHint, hHint, changed);
                if (wHint == -1 && (ld = this.getLayoutData()) instanceof GridData && ((GridData)ld).grabExcessHorizontalSpace) {
                    pt.x = 10;
                }
                return pt;
            }
        };
        this.setMainControl((Control)this.inputField);
        if (suffixKey != null) {
            this.lblSuffixGap = new Label(composite, 0);
            this.lblSuffix = new Label(composite, 64);
            Messages.setLanguageText((Widget)this.lblSuffix, suffixKey);
            this.lblSuffix.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 768));
            ClipboardCopy.addCopyToClipMenu((Control)this.lblSuffix);
        }
        if (this.doGridData(composite)) {
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = labelKey == null ? 2 : 1;
            gridData.heightHint = this.getPreferredHeight(numLinesToShow);
            this.inputField.setLayoutData((Object)gridData);
        }
        if (valueProcessor != null) {
            this.setValueProcessor(valueProcessor);
        } else if (this.paramID != null) {
            this.setConfigValueProcessor(String.class);
        }
        if (valueProcessor instanceof SwtConfigParameterValueProcessor && (verifiers = ConfigurationDefaults.getInstance().getVerifiers(this.paramID)) != null && verifiers.size() > 0) {
            this.inputField.addListener(25, e -> {
                boolean bl = e.doit = COConfigurationManager.verifyParameter(configID, e.text);
            });
        }
        this.inputField.addListener(16, e -> this.setValue(this.inputField.getText()));
        this.inputField.addListener(1, event2 -> {
            int key = event2.character;
            if (key <= 26 && key > 0) {
                key += 96;
            }
            if (key == 97 && event2.stateMask == SWT.MOD1) {
                event2.doit = false;
                this.inputField.selectAll();
            }
        });
    }

    public int getPreferredHeight(int line_count) {
        return this.inputField.getLineHeight() * line_count;
    }

    @Override
    public Control[] getControls() {
        if (this.lblSuffix == null) {
            return super.getControls();
        }
        ArrayList<Control> list = new ArrayList<Control>(Arrays.asList(super.getControls()));
        list.add((Control)this.lblSuffix);
        list.add((Control)this.lblSuffixGap);
        return list.toArray(new Control[0]);
    }

    @Override
    public void refreshControl() {
        super.refreshControl();
        Utils.execSWTThread(() -> {
            this.refreshSuffixControl((Control)this.lblSuffix);
            String value = (String)this.getValue();
            if (value == null) {
                return;
            }
            if (!this.inputField.isDisposed() && !this.inputField.getText().equals(value)) {
                this.inputField.setText(value);
            }
        });
    }
}

