/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.config.SwtParameter;
import com.biglybt.ui.swt.config.SwtParameterValueProcessor;
import java.util.Arrays;

public class SwtConfigParameterValueProcessor<PARAMTYPE extends SwtParameter<VALUETYPE>, VALUETYPE>
implements SwtParameterValueProcessor<PARAMTYPE, VALUETYPE>,
ParameterListener {
    private static final int CHANGINGCOUNT_BREAKER = 5;
    private final Class<VALUETYPE> valueType;
    private final SwtParameter owner;
    private int changingCount = 0;
    private boolean changedExternally = false;
    private static final Class<?>[] VALID_CLASSES = new Class[]{String.class, Integer.class, Boolean.class, byte[].class, Float.class};

    protected SwtConfigParameterValueProcessor(SwtParameter owner, String configID, Class<VALUETYPE> valueType) {
        this.owner = owner;
        boolean ok = false;
        Class<?>[] classArray = VALID_CLASSES;
        int n = VALID_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> validClass = classArray[n2];
            if (validClass.equals(valueType)) {
                ok = true;
                break;
            }
            ++n2;
        }
        if (!ok) {
            Debug.out("Invalid valueType of " + valueType + "; Must be one of " + Arrays.toString(VALID_CLASSES));
            this.valueType = null;
            return;
        }
        this.valueType = valueType;
        COConfigurationManager.addWeakParameterListener(this, false, configID);
    }

    @Override
    public void parameterChanged(String parameterName) {
        try {
            if (this.owner.isDisposed()) {
                COConfigurationManager.removeParameterListener(parameterName, this);
                return;
            }
            this.owner.informChanged();
        }
        catch (Exception e) {
            Debug.out("parameterChanged trigger from SwtConfigParameterValueProcessor " + parameterName, e);
        }
    }

    @Override
    public VALUETYPE getValue(PARAMTYPE p) {
        String key = p.getParamID();
        if (String.class.equals(this.valueType)) {
            return (VALUETYPE)COConfigurationManager.getStringParameter(key);
        }
        if (Integer.class.equals(this.valueType)) {
            return (VALUETYPE)Integer.valueOf(COConfigurationManager.getIntParameter(key));
        }
        if (Float.class.equals(this.valueType)) {
            return (VALUETYPE)Float.valueOf(COConfigurationManager.getFloatParameter(key));
        }
        if (Boolean.class.equals(this.valueType)) {
            return (VALUETYPE)Boolean.valueOf(COConfigurationManager.getBooleanParameter(key));
        }
        if (Long.class.equals(this.valueType)) {
            return (VALUETYPE)Long.valueOf(COConfigurationManager.getLongParameter(key));
        }
        if (byte[].class.equals(this.valueType)) {
            return (VALUETYPE)COConfigurationManager.getByteParameter(key);
        }
        return null;
    }

    @Override
    public boolean setValue(PARAMTYPE p, VALUETYPE value) {
        boolean changed = false;
        if (this.changingCount == 0) {
            this.changedExternally = false;
        }
        ++this.changingCount;
        try {
            String key = p.getParamID();
            VALUETYPE oldValue = this.getValue(p);
            if (oldValue == value || oldValue != null && value != null && oldValue.equals(value)) {
                if (COConfigurationManager.doesParameterNonDefaultExist(key) || COConfigurationManager.doesParameterDefaultExist(key)) {
                    this.changedExternally = true;
                    return false;
                }
                this.owner.debug("WARNING. setValue: writing default value to config. Already has non-default value? " + COConfigurationManager.doesParameterNonDefaultExist(key) + ".  Has a default defined? " + COConfigurationManager.doesParameterDefaultExist(key));
            }
            if (this.changingCount > 5) {
                Debug.out("Preventing StackOverflow on setting " + key + " to " + value + " (was " + oldValue + ") via " + Debug.getCompressedStackTrace());
                this.changingCount = 1;
            } else if (!this.changedExternally) {
                if (String.class.equals(this.valueType)) {
                    changed = COConfigurationManager.setParameter(key, (String)value);
                } else if (Integer.class.equals(this.valueType)) {
                    changed = COConfigurationManager.setParameter(key, (Integer)value);
                } else if (Float.class.equals(this.valueType)) {
                    changed = COConfigurationManager.setParameter(key, ((Float)value).floatValue());
                } else if (Boolean.class.equals(this.valueType)) {
                    changed = COConfigurationManager.setParameter(key, (Boolean)value);
                } else if (Long.class.equals(this.valueType)) {
                    changed = COConfigurationManager.setParameter(key, (Long)value);
                } else if (byte[].class.equals(this.valueType)) {
                    changed = COConfigurationManager.setParameter(key, (byte[])value);
                }
                this.changedExternally = true;
            }
        }
        finally {
            --this.changingCount;
        }
        return changed;
    }

    @Override
    public boolean isDefaultValue(PARAMTYPE p) {
        return !COConfigurationManager.doesParameterNonDefaultExist(p.getParamID());
    }

    @Override
    public VALUETYPE getDefaultValue(PARAMTYPE p) {
        return (VALUETYPE)COConfigurationManager.getDefault(p.getParamID());
    }

    @Override
    public boolean resetToDefault(PARAMTYPE p) {
        return COConfigurationManager.removeParameter(p.getParamID());
    }

    @Override
    public void dispose(PARAMTYPE p) {
        COConfigurationManager.removeParameterListener(p.getParamID(), this);
    }
}

