/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config.wizard;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.config.wizard.ConfigureWizard;
import com.biglybt.ui.swt.config.wizard.WelcomePanel;
import com.biglybt.ui.swt.wizard.AbstractWizardPanel;
import com.biglybt.ui.swt.wizard.IWizardPanel;
import java.util.Locale;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class LanguagePanel
extends AbstractWizardPanel<ConfigureWizard> {
    public LanguagePanel(ConfigureWizard wizard, IWizardPanel<ConfigureWizard> previousPanel) {
        super(wizard, previousPanel);
    }

    @Override
    public void show() {
        ((ConfigureWizard)this.wizard).setTitleAsResourceID("configureWizard.welcome.title");
        Composite rootPanel = ((ConfigureWizard)this.wizard).getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        final Label lblChoose = new Label(rootPanel, 64);
        this.setChooseLabel(lblChoose);
        GridData gridData = new GridData(768);
        lblChoose.setLayoutData((Object)gridData);
        final List lstLanguage = new List(rootPanel, 2564);
        gridData = new GridData(1808);
        gridData.heightHint = 350;
        lstLanguage.setLayoutData((Object)gridData);
        final Locale[] locales = MessageText.getLocales(true);
        int iUsingLocale = -1;
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            lstLanguage.add(this.buildName(locale));
            if (MessageText.isCurrentLocale(locale)) {
                iUsingLocale = i;
            }
            ++i;
        }
        lstLanguage.select(iUsingLocale);
        lstLanguage.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = lstLanguage.getSelectionIndex();
                if (index >= 0 && index < locales.length) {
                    COConfigurationManager.setParameter("locale", locales[index].toString());
                    MessageText.loadBundle();
                    DisplayFormatters.setUnits();
                    DisplayFormatters.loadMessages();
                    Shell shell = ((ConfigureWizard)LanguagePanel.this.wizard).getWizardWindow();
                    Messages.updateLanguageForControl((Widget)shell);
                    LanguagePanel.this.setChooseLabel(lblChoose);
                    shell.layout(true, true);
                    lstLanguage.setRedraw(false);
                    int i = 0;
                    while (i < locales.length) {
                        lstLanguage.setItem(i, LanguagePanel.this.buildName(locales[i]));
                        ++i;
                    }
                    lstLanguage.setRedraw(true);
                    try {
                        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                        if (uiFunctions != null) {
                            uiFunctions.refreshLanguage();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        FontData[] fontData = lstLanguage.getFont().getFontData();
        int i2 = 0;
        while (i2 < fontData.length) {
            if (fontData[i2].getHeight() < 10) {
                fontData[i2].setHeight(10);
            }
            ++i2;
        }
        final Font font = new Font((Device)rootPanel.getDisplay(), fontData);
        lstLanguage.setFont(font);
        lstLanguage.getShell().addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                lstLanguage.showSelection();
            }
        });
        lstLanguage.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (font != null && !font.isDisposed()) {
                    font.dispose();
                }
            }
        });
    }

    private void setChooseLabel(Label lblChoose) {
        String sDefChooseString;
        String sLocaleChooseString = MessageText.getString("ConfigureWizard.language.choose");
        if (sLocaleChooseString.equals(sDefChooseString = MessageText.getDefaultLocaleString("ConfigureWizard.language.choose"))) {
            lblChoose.setText(sLocaleChooseString);
        } else {
            lblChoose.setText(String.valueOf(sLocaleChooseString) + "\n" + sDefChooseString);
        }
    }

    private String buildName(Locale locale) {
        StringBuilder sName = new StringBuilder();
        String sName1 = locale.getDisplayLanguage(locale);
        String sName2 = locale.getDisplayLanguage();
        sName.append(sName1);
        if (!sName1.equals(sName2)) {
            sName.append("/").append(sName2);
        }
        sName1 = locale.getDisplayCountry(locale);
        sName2 = locale.getDisplayCountry();
        if (sName1.length() > 0 || sName2.length() > 0) {
            sName.append(" (");
            if (sName1.length() > 0) {
                sName.append(sName1);
            }
            if (sName2.length() > 0 && !sName1.equals(sName2)) {
                sName.append("/").append(sName2);
            }
            sName1 = locale.getDisplayVariant(locale);
            sName2 = locale.getDisplayVariant();
            if (sName1.length() > 0 || sName2.length() > 0) {
                sName.append(", ");
                if (sName1.length() > 0) {
                    sName.append(sName1);
                }
                if (sName2.length() > 0 && !sName1.equals(sName2)) {
                    sName.append("/").append(sName2);
                }
            }
            sName.append(")");
        }
        return sName.toString();
    }

    @Override
    public boolean isNextEnabled() {
        return true;
    }

    @Override
    public IWizardPanel<ConfigureWizard> getNextPanel() {
        return new WelcomePanel((ConfigureWizard)this.wizard, this);
    }
}

